<?php
/**
 * This file is loaded automatically by the app/webroot/index.php file after core.php
 *
 * This file should load/create any application wide configuration settings, such as
 * Caching, Logging, loading additional configuration files.
 *
 * You should also use this file to include any files that provide global functions/constants
 * that your application uses.
 *
 * CakePHP(tm) : Rapid Development Framework (http://cakephp.org)
 * Copyright (c) Cake Software Foundation, Inc. (http://cakefoundation.org)
 *
 * Licensed under The MIT License
 * For full copyright and license information, please see the LICENSE.txt
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright     Copyright (c) Cake Software Foundation, Inc. (http://cakefoundation.org)
 * @link          http://cakephp.org CakePHP(tm) Project
 * @package       app.Config
 * @since         CakePHP(tm) v 0.10.8.2117
 * @license       http://www.opensource.org/licenses/mit-license.php MIT License
 */

App::uses('DotEnv2', 'Lib');

(new DotEnv2( ROOT . DS . APP_DIR . '/.env.trockee_petits'))->load();
//debug(getenv('StripeTestSecret'));exit;
Configure::write('Stripe.TestSecret', getenv('StripeTestSecret'));
Configure::write('Stripe.LiveSecret', getenv('StripeLiveSecret'));

Configure::write('Stripe.mode', getenv('Stripe_mode'));
Configure::write('Stripe.currency', 'eur');
Configure::write('Stripe.pointPrice',getenv('Stripe_pointPrice'));
Configure::write('Stripe.pointPricePer20',getenv('Stripe_pointPricePer20'));
Configure::write('Stripe.pointPricePer50',getenv('Stripe_pointPricePer50'));

Configure::write('Config.languages', array(
	'fr' => 'fra',
	'en' => 'ang',
	'de' => 'deu',
	'es' => 'spa',
	//'it' => 'ita'
));

Configure::write('Config.languages.home', array(
	'en' => 'ang',
	'de' => 'deu',
	'es' => 'spa',
	//'it' => 'ita'
));

Configure::write('Config.langnames', array(
	'fr' => __("Francais"),
	'en' => __("Anglais"),
	'de' => __("Allemand"),
	'es' => __("Espagnol"),
	//'it' => 'ita'
));
Configure::write('Config.langflags', array(
	'fr' => "France.png",
	'en' => "United_Kingdom.png",
	'de' => "Germany.png",
	'es' => "Spain.png",
	//'it' => 'ita'
));

Configure::write('lbdp.email',
	array('hellolabraderie@gmail.com')
);
Configure::write('Admin.emails',
	array('ph.bouille@gmail.com','dguillerm@gmail.com')
	//array('dguillerm@gmail.com')
);
Configure::write('Admin.passadclient','13sdf6sz4fzfsd1f316dfgsg1s3dg2465df6g54');

Configure::write('Admin.userstofilter',array(
		array('User.email != ' => "dguillerm@gmail.com"),
		array('User.email != ' => "ph.bouille@gmail.com")
	)
);

Configure::write('Admin.users',array(
	array(
		'email' => 'dguillerm@gmail.com',
		'username' => 'David.Guillerm',
		'nom' => 'Guillerm',
		'prenom' => 'David',
		'city_id' => 7901,
		'role' => 'admin',
		'password' => 'f47aabda730117a7a40f1df640209f46bc0b599b',
		'activated' => 1,
		'monnaie_start' => 15
	),
	array(
		'email' => 'ph.bouille@gmail.com',
		'username' => 'Philippe.Bouillé',
		'nom' => 'Bouillé',
		'prenom' => 'Philippe',
		'city_id' => 7762,
		'role' => 'admin',
		'password' => 'dec791f02c2c5c1dce4743f82720233710edc7f2',
		'activated' => 1,
		'monnaie_start' => 15
	)
));

Configure::write('Admin.lbdp',array(
	array(
		'email' => 'wolf.sarah22@gmail.com',
		'username' => 'La Braderie des petits',
		'nom' => 'des petits',
		'prenom' => 'La braderie',
		'city_id' => 18722,
		'role' => 'admin',
		'password' => 'f41cf4f99bfca1cfd3cc528d155da2ec2580aed8',
		'activated' => 1,
		'monnaie_start' => 0
	),
));
Configure::write('UserIdLBDP', 3);


Configure::write('Admin.categories',array(
  array("Garde d'enfants",'baby_sitting.png'),
  array('Bricolage','bricolage.png'),
  array('Cours particuliers','cours_particuliers.png'),
  array('Covoiturage','covoiturage.png'),
  array('Déménagement','demenagement.png'),
  array('Festivités','festivites.png'),
  array('Garde animaux','garde_animaux.png'),
  array('Numérique','numerique2.png'),
  array('Jardinage','jardinage.png'),
  array('Loisirs','loisirs.png'),
  array('Art & Musique','art_musique.jpg'),
  array('Autre ...','autres.png'),
  array('Bien-Être','sante_bienetre.png'),
  array('Livres','livres.png'),
  array('Sport','sport.jpg'),
  array('Science & Technique','sciencetechnique.jpg'),
));
//Configure::write('Common.max_moderate_flags',5);

Configure::write('Common',array(
	'apikey' => '8393c27d-68cc-4e71-a72c-e7d56ff113c1',
	'captchasecretkey' => '6LcvKJEUAAAAAKBis1zZ5x9j21HLauqzYIhfM5mt', 
	'captchasitekey' => '6LcvKJEUAAAAAP93cbP9eT0uac7WglPXqlL3TWpu', 
	'frais_de_port' => getenv('Stripe_frais_de_port'),
	'poids' => ['0 à 3kg','3 à 6 kg','6 à 9 kg'],
	'max_moderate_flags' => 5,
	'usernoimage'=> '/img/user.png',
	'sitename'=> 'Trockee.com',
	'sitename_title'=> 'Trockee',
	'echangestype' => array('O'=>__("Offre"),'D'=>__("Demande")),
	'echangestype_str' => array('O'=>__("offres"),'D'=>__("demandes")),
	'echangestype_str_full' => array('O'=>__("les offres"),'D'=>__("les demandes")),
	'monnaie' => array(
		'name' => "CELT",
		'values' => array(
			'O' => array(
				'0' => 0,
				'0.5' => 0.5,
				'1' => 1,
				'1.5' => 1.5,
				'2' => 2,
			),
			'D' => array(
				'0' => 0,
				'0.5' => 0.5,
				'1' => 1,
				'1.5' => 1.5,
				'2' => 2,
				'4' => 4,
				'8' => 8,
				-99 => 'Échange direct',
				-100 => 'Corporate'
			)
		),
		'classique' => array(
			'0' => 0,
			'1' => 1,
			'2' => 2,
			'3' => 3,
			'4' => 4,
			'5' => 5,
			'6' => 6,
			'7' => 7,
			'8' => 8,
			'9' => 9,
			'10' => 10,
		),
		'nom' => __("heure(s)"),
		'credit_initial' => 15,
	),
  // Voir vdmv.posts.css pour les couleurs des labels
	'tag_types' =>
		array(
			'0' => array('value'=>0,'name'=>__("Utilisateur"),'csstag' => 'user'),
			'10' => array('value'=>10,'name'=>__("Community Manager"),'csstag' => 'cm'),
			'20' => array('value'=>20,'name'=>__("Mairie"),'csstag' => 'mairie'),
			'30' => array('value'=>30,'name'=>__("Association"),'csstag' => 'asso')
	),
// Liste des extensions autorisée
	'postExt'=> array(
		'png'=>'png','jpg'=>'jpg','jpeg'=>'jpeg','gif'=>'gif','bmp'=>'bmp'
	),
	// Add #NOTEMPTY to Force default value if not set with client
	'ClientfieldsToCheck' => array('logo','topimage','bottomimage','baseline','titre1','texte1','titre2','texte2','texte3#NOTEMPTY',
									'ccmpart1#NOTEMPTY','ccmpart2#NOTEMPTY','ccmpart3#NOTEMPTY','ccmpart4#NOTEMPTY','ccmpart5#NOTEMPTY',
									'ccmpart6#NOTEMPTY',
									'video1','video2','image1','image2','image3','urlccm','cgu_pdf','pdc_pdf',
									'charte_pdf','notice_pdf','noticeadmin_pdf','doctech_pdf','cgv_pdf','marques_pdf','grille_pdf'),
	'ClientDefaults' => array(
		//'urlccm' => '',	
		'logo' => 'logo4mail.jpg',
		'topimage' => "",'bottomimage' => "",
		'cgu_pdf' => "",
		'pdc_pdf' => "",
		'charte_pdf' => "",
		'baseline' => __("Echangez vos services, compétences,
		talents et passions, avec vos collègues !"),
		'image1' => 'slide1.jpg',
		'image2' => 'slide2.jpg',
		'image3' => 'slide3.jpg',
		'video1' => 'https://www.youtube.com/embed/a4r6dWkcSJU',
		'titre1' => __("Bienvenue sur la plateforme de votre entreprise !"),
		'texte1' => __("Sur TIMEBANKPRO, vous pouvez échanger vos services, compétences et talents, avec vos collègues. Cela vous permet de découvrir de nouveaux domaines, qu'ils soient professionnels ou extra-professionnels, et de passer un bon moment ensemble."),
		'titre2' => __("Une inscription donne le droit à 15 CELTs"),
		'texte2' => __("15 CELTs = 15 heures de services
1 CELT = 1 heure
Les échanges de services se règlent une fois le service rendu en utilisant le CELT, la monnaie collaborative de la plateforme.
La valeur d'un service en CELT est déterminée par la durée passée: 1 heure de service = 1 CELT, peu importe le service et la personne. TIMEBANKPRO est une \"banque du temps\" basée sur un principe d'égalité.
Les offreurs de services sont rétribués en CELT par ceux qui reçoivent le service, et donc, il n'est pas nécessaire d'échanger directement ni immédiatement un service contre un autre."),
		// Partie En savoir Plus
		'texte3' => "Proposer une offre ou demander une aide s'effectue très simplement sur la page d'accueil en cliquant sur la carte « Je propose » ou « Je demande ». 
Les échanges se règlent une fois la prestation effectuée en utilisant la monnaie virtuelle de la plateforme. 
Si l’administrateur de votre plateforme n’a pas activé le paiement des services avec la monnaie virtuelle, les indications relatives à son usage ne s’appliquent évidemment pas. 
Les projets ne font pas appel à la monnaie virtuelle.",
		'texte3_ang' => "Proposing an offer or asking for help is very easy done by clicking on the « I offer » or « I request » card. 
Exchanges are settled once the service has been delivered using the virtual currency of the platform. 
If the administrator of your platform has not activated the payment of services with virtual currency, the indications relating to its use obviously do not apply.
Projects do not use virtual currency.",
		'texte3_spa' => "Proponer una oferta o solicitar asistencia es muy simple haciendo clic en la ficha « Propongo » o « Solicito ». 
Los intercambios se liquidan una vez que el servicio se ha realizado utilizando la moneda virtual de la plataforma. 
Si el administrador de su plataforma no ha activado el pago de servicios con moneda virtual, las indicaciones relacionadas con su uso obviamente no se aplican. 
Los proyectos no usan moneda virtual.",
		'texte3_deu' => "Proposer une offre ou demander une aide s'effectue très simplement sur la page d'accueil en cliquant sur la carte « Je propose » ou « Je demande ». 
Les échanges se règlent une fois la prestation effectuée en utilisant la monnaie virtuelle de la plateforme. 
Si l’administrateur de votre plateforme n’a pas activé le paiement des services avec la monnaie virtuelle, les indications relatives à son usage ne s’appliquent évidemment pas. 
Les projets ne font pas appel à la monnaie virtuelle.",

		'video2' => 'https://www.youtube.com/embed/a4r6dWkcSJU',
		// Partie demander de l'aide
		'ccmpart1' => "Je propose une offre en cliquant sur la carte « Je propose »",
		'ccmpart2' => "Une personne intéressée me contacte en cliquant sur la carte de mon offre",
		'ccmpart3' => "Je fais bénéficier la personne de mon offre, puis la personne règle mon offre avec la monnaie virtuelle, et laisse un avis",
		'ccmpart4' => "Je demande de l'aide en cliquant sur la carte « Je demande »",
		'ccmpart5' => "Je suis contacté par une personne qui propose une aide correspondant à ma demande",
		'ccmpart6' => "Je bénéficie de l'aide, puis je règle la personne avec la monnaie virtuelle, et je laisse un avis sur l'aide que j’ai reçue",

		'ccmpart1_ang' => "I propose an offer by clicking on the « I offer » card",
		'ccmpart2_ang' => "An interested person contacts me by clicking on my offer's card",
		'ccmpart3_ang' => "The person benefits from my offer, then pays my offer with the virtual currency, and leaves a review on my service",
		'ccmpart4_ang' => "I ask for help by clicking on the « I request » card",
		'ccmpart5_ang' => "I am contacted by a person who offers help corresponding to my request",
		'ccmpart6_ang' => "I benefit from the help, then I pay the person with the virtual currency, and I leave a review on the help that I received",

		'ccmpart1_spa' => "Propongo una oferta haciendo clic en la ficha « Propongo »",
		'ccmpart2_spa' => "Una persona interesada me contacta haciendo clic en la ficha de mi oferta",
		'ccmpart3_spa' => "Hago que la persona se beneficie de mi oferta, luego la persona liquida mi oferta con la moneda virtual y deja un aviso",
		'ccmpart4_spa' => "Pido ayuda haciendo clic en la ficha « Solicito »",
		'ccmpart5_spa' => "Me contacta una persona que ofrece la ayuda correspondiente a mi solicitud",
		'ccmpart6_spa' => "Me beneficio de la ayuda, luego le pago a la persona con la moneda virtual y dejo un aviso sobre la ayuda que recibí",

		'ccmpart1_deu' => "Je propose une offre en cliquant sur la carte « Je propose »",
		'ccmpart2_deu' => "Une personne intéressée me contacte en cliquant sur la carte de mon offre",
		'ccmpart3_deu' => "Je fais bénéficier la personne de mon offre, puis la personne règle mon offre avec la monnaie virtuelle, et laisse un avis",
		'ccmpart4_deu' => "Je demande de l'aide en cliquant sur la carte « Je demande »",
		'ccmpart5_deu' => "Je suis contacté par une personne qui propose une aide correspondant à ma demande",
		'ccmpart6_deu' => "Je bénéficie de l'aide, puis je règle la personne avec la monnaie virtuelle, et je laisse un avis sur l'aide que j’ai reçue",

	),
	'VideoUrlId' => array(
		'ang' => 'Gh28nWtQ3ag',
		'fra' => '5S79VPWA8q8',
		'spa' => 'ujwzp1-f77A',
		'deu' => 'qR9RQYxIteY',
	)
));

configure::write('PostConfig',array(
		'title_for_layout' => __("Les échanges de compétences ou connaissances"),
		'section_titre_bouton_ecrire' => __("Ecrire une annonce"),
		'section_titre_bouton_ecrire_O' => __("Je propose une compétence ou connaissance"),
		'section_titre_bouton_ecrire_D' => __("Je demande une compétence ou connaissance"),
		'section_titre_bouton_ecrire_Ochange' => __("Je change mon offre"),
		'section_titre_bouton_ecrire_Dchange' => __("Je change ma demande"),
		'section_titre_bouton_ecrire_Ochange_admin' => __("Je change l'offre"),
		'section_titre_bouton_ecrire_Dchange_admin' => __("Je change la demande"),
		'section_controller' => 'posts',
		'section_action' => 'ajout_annonce',

		'section_titre_bouton_recherche' => __("Recherche"),
		'section_controller_recherche' => 'posts',
		'section_action_recherche' => 'recherche_echanges',

		'section_titre_bouton_abonnement' => __("M'abonner aux annonces"),
		'section_titre_bouton_desabonnement' => __("Me désabonner des annonces"),
		'section_controller_abonnement' => 'follows',
		//'section_action_abonnement' => 'abonnement',
		//'section_action_desabonnement' => 'desabonnement',
));

configure::write('badWords',array(
		'abruti', 		// Idiot (masculine)
		'abrutie', 		// Idiot (feminine)
		'baise',		// !@#$%^&*
		'baisé',		// Fucked
		'baiser',		// To !@#$%^&*
		'batard',		// !@#$%^&*
		'bite',			// Dick
		'bougnoul',		// Sandnigger
		'branleur',		// Wanker
		'burne',		// Testicle
		'chier',		// To !@#$%^&*
		'cocu',			// Cuckold
		'con','cons',			// Idiot
		'connard','connards',		// Idiot
		'connasse',		// Stupid and annoying girl
		'conne',		// Idiot (feminine)
		'couille',		// Ball (testicle)
		'couillon',		// Stupid (masculine)
		'couillonne',	// Stupid (feminine)
		'crevard',		// Backstabber or Hobo, depending on the context
		'cul',			// !@#$%^&*
		'encule',		// Mother- !@#$%^&* (masculine)
		'enculé',		// Mother- !@#$%^&* (masculine)
		'enculee',		// Mother- !@#$%^&* (feminine)
		'enculée',		// Mother- !@#$%^&* (feminine)
		'enculer',		// To !@#$%^&* in the !@#$%^&*
		'enfoire',		// !@#$%^&* (masculine)
		'enfoiré',		// !@#$%^&* (masculine)
		'fion',			// !@#$%^&*
		'foutre',		// Cum
		'merde',		// !@#$%^&*
		'negre',		// !@#$%^&* (masculine)
		'nègre',		// !@#$%^&* (masculine)
		'negresse',		// !@#$%^&* (feminine)
		'négresse',		// !@#$%^&* (feminine)
		'nique',		// !@#$%^&*
		'niquer',		// To !@#$%^&*
		'partouze',		// Sex orgy
		'pd',			// Fag
		'pede',			// Fag
		'pédé',			// Fag
		'petasse',		// Slut/Show-off (feminine)
		'pétasse',		// Slut/Show-off (feminine)
		'pine',			// Dick
		'pouffe',		// Show-off (feminine)
		'pouffiasse',	// Show-off (feminine)
		'putain',		// Slut
		'pute',			// Slut
		'salaud',		// !@#$%^&*/backstabber (masculine)
		'salop',		// !@#$%^&*/backstabber (masculine)
		'salopard',		// !@#$%^&*/backstabber (masculine)
		'salope',		// Slut (feminine)
		'sodomie',		// Sodomy
		'sucer',		// To suck
		'sexe',
		'tapette',		// Fag
		'tare',			// Insane
		'taré',			// Insane
		'vagin',		// Vagina
		'zob',			// Dick
		'juif','juifs','révisionniste','révisionnistes','front national','anarchiste','anal','anus','masturber',
		'masturbation','éjaculer'
));


// Setup a 'default' cache configuration for use in the application.
Cache::config('default', array('engine' => 'File'));

/**
 * The settings below can be used to set additional paths to models, views and controllers.
 *
 * App::build(array(
 *     'Model'                     => array('/path/to/models/', '/next/path/to/models/'),
 *     'Model/Behavior'            => array('/path/to/behaviors/', '/next/path/to/behaviors/'),
 *     'Model/Datasource'          => array('/path/to/datasources/', '/next/path/to/datasources/'),
 *     'Model/Datasource/Database' => array('/path/to/databases/', '/next/path/to/database/'),
 *     'Model/Datasource/Session'  => array('/path/to/sessions/', '/next/path/to/sessions/'),
 *     'Controller'                => array('/path/to/controllers/', '/next/path/to/controllers/'),
 *     'Controller/Component'      => array('/path/to/components/', '/next/path/to/components/'),
 *     'Controller/Component/Auth' => array('/path/to/auths/', '/next/path/to/auths/'),
 *     'Controller/Component/Acl'  => array('/path/to/acls/', '/next/path/to/acls/'),
 *     'View'                      => array('/path/to/views/', '/next/path/to/views/'),
 *     'View/Helper'               => array('/path/to/helpers/', '/next/path/to/helpers/'),
 *     'Console'                   => array('/path/to/consoles/', '/next/path/to/consoles/'),
 *     'Console/Command'           => array('/path/to/commands/', '/next/path/to/commands/'),
 *     'Console/Command/Task'      => array('/path/to/tasks/', '/next/path/to/tasks/'),
 *     'Lib'                       => array('/path/to/libs/', '/next/path/to/libs/'),
 *     'Locale'                    => array('/path/to/locales/', '/next/path/to/locales/'),
 *     'Vendor'                    => array('/path/to/vendors/', '/next/path/to/vendors/'),
 *     'Plugin'                    => array('/path/to/plugins/', '/next/path/to/plugins/'),
 * ));
 */

/**
 * Custom Inflector rules can be set to correctly pluralize or singularize table, model, controller names or whatever other
 * string is passed to the inflection functions
 *
 * Inflector::rules('singular', array('rules' => array(), 'irregular' => array(), 'uninflected' => array()));
 * Inflector::rules('plural', array('rules' => array(), 'irregular' => array(), 'uninflected' => array()));
 */

/**
 * Plugins need to be loaded manually, you can either load them one by one or all of them in a single call
 * Uncomment one of the lines below, as you need. Make sure you read the documentation on CakePlugin to use more
 * advanced ways of loading plugins
 *
 * CakePlugin::loadAll(); // Loads all plugins at once
 * CakePlugin::load('DebugKit'); // Loads a single plugin named DebugKit
 */

/**
 * To prefer app translation over plugin translation, you can set
 *
 * Configure::write('I18n.preferApp', true);
 */

/**
 * You can attach event listeners to the request lifecycle as Dispatcher Filter. By default CakePHP bundles two filters:
 *
 * - AssetDispatcher filter will serve your asset files (css, images, js, etc) from your themes and plugins
 * - CacheDispatcher filter will read the Cache.check configure variable and try to serve cached content generated from controllers
 *
 * Feel free to remove or add filters as you see fit for your application. A few examples:
 *
 * Configure::write('Dispatcher.filters', array(
 *		'MyCacheFilter', //  will use MyCacheFilter class from the Routing/Filter package in your app.
 *		'MyCacheFilter' => array('prefix' => 'my_cache_'), //  will use MyCacheFilter class from the Routing/Filter package in your app with settings array.
 *		'MyPlugin.MyFilter', // will use MyFilter class from the Routing/Filter package in MyPlugin plugin.
 *		array('callable' => $aFunction, 'on' => 'before', 'priority' => 9), // A valid PHP callback type to be called on beforeDispatch
 *		array('callable' => $anotherMethod, 'on' => 'after'), // A valid PHP callback type to be called on afterDispatch
 *
 * ));
 */
Configure::write('Dispatcher.filters', array(
	'AssetDispatcher',
	'CacheDispatcher'
));

/**
 * Configures default file logging options
 */
App::uses('CakeLog', 'Log');
CakeLog::config('debug', array(
	'engine' => 'File',
	'types' => array('notice', 'info', 'debug'),
	'file' => 'debug',
));
CakeLog::config('error', array(
	'engine' => 'File',
	'types' => array('warning', 'error', 'critical', 'alert', 'emergency'),
	'file' => 'error',
));
