<?php
/**
 * Routes configuration
 *
 * In this file, you set up routes to your controllers and their actions.
 * Routes are very important mechanism that allows you to freely connect
 * different URLs to chosen controllers and their actions (functions).
 *
 * CakePHP(tm) : Rapid Development Framework (http://cakephp.org)
 * Copyright (c) Cake Software Foundation, Inc. (http://cakefoundation.org)
 *
 * Licensed under The MIT License
 * For full copyright and license information, please see the LICENSE.txt
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright     Copyright (c) Cake Software Foundation, Inc. (http://cakefoundation.org)
 * @link          http://cakephp.org CakePHP(tm) Project
 * @package       app.Config
 * @since         CakePHP(tm) v 0.2.9
 * @license       http://www.opensource.org/licenses/mit-license.php MIT License
 */
App::uses('SubdomainRoute', 'Routing/Route');

/**
 * Here, we are connecting '/' (base path) to controller called 'Pages',
 * its action called 'display', and we pass a param to select the view file
 * to use (in this case, /app/View/Pages/home.ctp)...
 */
	//Router::connect('/', array('controller' => 'pages', 'action' => 'display', 'home'));
	Router::connect('/', array('controller' => 'pages', 'action' => 'display', 'accueil'));
	Router::connect('/inscription', array('controller' => 'users', 'action' => 'add'));
	Router::connect('/verificationCode/*', array('controller' => 'users', 'action' => 'verify_code'));
	//Router::connect('/administration', array('controller' => 'admins', 'action' => 'admin'));
	Router::connect('/admin', array('controller' => 'pages', 'action' => 'display', 'accueil'));
	Router::connect('/Identification', array('controller' => 'users', 'action' => 'login'));
	Router::connect('/compte_cree', array('controller' => 'pages', 'action' => 'display', 'user_created'));
	Router::connect('/MonCompte', array('controller' => 'users', 'action' => 'myaccount'));
	Router::connect('/brochure', array('controller' => 'pages', 'action' => 'brochure'));
	Router::connect('/team', array('controller' => 'pages', 'action' => 'team'));
	Router::connect('/getfile/*', array('controller' => 'pages', 'action' => 'getfile'));
	//Router::connect('/DL/*', array('controller' => 'pages', 'action' => 'downloadpdf'));
	Router::connect('/ldp', array('controller' => 'pages', 'action' => 'ldp'));
	


	Router::connect('/Panier', array('controller' => 'carts', 'action' => 'view'));
	Router::connect('/PaiementValide/*', array('controller' => 'stripe', 'action' => 'validatecart'));
	
	Router::connect('/Vente', array('controller' => 'pages', 'action' => 'vente'));


	Router::connect('/Contact', array('controller' => 'pages', 'action' => 'display','contact'));
	Router::connect('/FonctionnementDuService', array('controller' => 'pages', 'action' => 'display','aide'));
	//Router::connect('/Aide', array('controller' => 'pages', 'action' => 'display','aide'));
	Router::connect('/BlogEtPresse', array('controller' => 'pages', 'action' => 'display','blogpresse'));
	Router::connect('/MotDePasse', array('controller' => 'users', 'action' => 'change_password'));
	Router::connect('/MaVille', array('controller' => 'pages', 'action' => 'gomaville'));
	Router::connect('/MonProfil', array('controller' => 'users', 'action' => 'profil'));
	Router::connect('/Repertoire', array('controller' => 'users', 'action' => 'repertoire'));
	Router::connect('/Invitation', array('controller' => 'pages', 'action' => 'display','inviter'));
	Router::connect('/InvitationProjet', array('controller' => 'challenges', 'action' => 'invite'));
	Router::connect('/Quitter', array('controller' => 'users', 'action' => 'logout'));
	Router::connect('/Messagerie', array('controller' => 'pms', 'action' => 'index'));
	Router::connect('/SupprimerMonCompte', array('controller' => 'users', 'action' => 'confirm_suppressioncompte'));
	Router::connect('/MesOffresDemandes', array('controller' => 'posts', 'action' => 'listmyposts'));
	Router::connect('/Message', array('controller' => 'pages', 'action' => 'message'));
	Router::connect('/EffacerRecherche', array('controller' => 'pages', 'action' => 'cleancookie'));

	Router::connect('/Echanges', array('controller' => 'pages', 'action' => 'display2','echanges'));
	Router::connect('/Temoignages', array('controller' => 'pages', 'action' => 'display2','temoignages'));
	Router::connect('/CGU', array('controller' => 'pages', 'action' => 'display','cgu'));
	Router::connect('/EnSavoirPlus', array('controller' => 'pages', 'action' => 'display','ccm'));
	Router::connect('/Presse', array('controller' => 'pages', 'action' => 'display','presse'));
	Router::connect('/Confidentialite', array('controller' => 'pages', 'action' => 'display','confidentialite'));
	Router::connect('/PbActivation', array('controller' => 'pages', 'action' => 'display','msgactivation'));

	Router::connect('/CompteGratuitExpire', array('controller' => 'users', 'action' => 'paidexpiration','free1m_expired','15'));
	Router::connect('/Compte1anExpire', array('controller' => 'users', 'action' => 'paidexpiration','paid_expired','15'));

	Router::connect('/MesDemandes', array('controller' => 'posts', 'action' => 'listmyposts','D'));
	Router::connect('/MesOffres', array('controller' => 'posts', 'action' => 'listmyposts','O'));
	Router::connect('/MesFavoris', array('controller' => 'posts', 'action' => 'listmyfavorites'));
	
	Router::connect('/Message/*', array('controller' => 'challenges', 'action' => 'only_flash'));
	Router::connect('/MyProjects', array('controller' => 'challenges', 'action' => 'listmyprojects'));
	Router::connect('/ValidateParticipant/*', array('controller' => 'challenges', 'action' => 'validateparticipant'));


	Router::connect('/mdrelais', array('controller' => 'mondialrelay', 'action' => 'index'));


	Router::connect(
		'/Contacter-:id',
		array('controller' => 'users', 'action' => 'contactmember'),
		array(
	        'pass' => array('id'),
			'id' => '[0-9]+'
	    )
	);
	Router::connect(
		'/Contacter-:id-:post_b64',
		array('controller' => 'users', 'action' => 'contactmember'),
		array(
	        'pass' => array('id','post_b64'),
			'id' => '[0-9]+',
			'post_id' => '*+'
	    )
	);
	Router::connect(
		'/Profil-:id',
		array('controller' => 'users', 'action' => 'viewprofil'),
		array(
	        'pass' => array('id'),
	        'id' => '[0-9]+'
	    )
	);
	Router::connect('/AjoutOffre', array('controller' => 'posts', 'action' => 'ajout_annonce','O'));
	Router::connect('/AjoutDemande', array('controller' => 'posts', 'action' => 'ajout_annonce','D'));

	Router::connect(
		'/Annonce-:id',
		array('controller' => 'pages', 'action' => 'index'),
		array(
	        'pass' => array('id'),
	        'id' => '[0-9]+'
	    )
	);



	Router::connect(
		'/Annonces/*',
		array('controller' => 'users', 'action' => 'seemessages')
	);

	Router::connect(
		'/ReglerOffre/*',
		array('controller' => 'users', 'action' => 'regler_echange')
	);
	Router::connect(
		'/Repondre/*',
		array('controller' => 'pms', 'action' => 'repondre')
	);

	Router::connect(
		'/Catalogue-:catid-:posttype',
		array('controller' => 'posts', 'action' => 'catalogue_category'),
		array(
	        'pass' => array('catid','posttype'),
	        'catid' => '[0-9]+','posttype' => '[A-Z]'
	    )
	);

	Router::connect(
		'/Catalogue-:catid',
		array('controller' => 'posts', 'action' => 'catalogue'),
		array(
					'pass' => array('catid'),
					'catid' => '[A-Z]'
			)
	);
	Router::connect('/Accueil', array('controller' => 'pages', 'action' => 'display2'));


/**
 * ...and connect the rest of 'Pages' controller's URLs.
 */
	//Router::connect('/pages/*', array('controller' => 'pages', 'action' => 'display'));

/**
 * Load all plugin routes. See the CakePlugin documentation on
 * how to customize the loading of plugin routes.
 */
	CakePlugin::routes();

/**
 * Load the CakePHP default routes. Only remove this if you do not want to use
 * the built-in default routes.
 */
	require CAKE . 'Config' . DS . 'routes.php';
