<?php
App::uses('SimpleImage', 'Lib');

// app/Controller/UsersController.php
class AdminsController extends AppController
{

    public $uses = array();

    public function beforeFilter()
    {
        parent::beforeFilter();
        $this->theme = 'Admin';
        $this->verif_admin();
    }

    // Fonction d'administration
    public function admin()
    {
        // On verifie si le user est bien admin
        $this->verif_admin();

    }

    public function prepare_mail_relance()
    {
        $this->User->contain();
        $allusers = $this->User->find('all', array(
            'conditions' => array('activated' => 0),
            'fields' => array('email', 'codeactivation'),
        ));
        //debug(count($allusers));
        //debug($allusers);
        $this->set('allusers', $allusers);
    }

    public function index() {
        $this->redirect(array('controller' => 'admins', 'action' => 'admin'));
    }

    public function check_activated($what) {
        if (!Configure::read('Common.client.'.$what)) {
            $this->Session->setFlash(__("fonction non disponible ou non activée."), 'msg_alert');
            $this->redirect(array('controller' => 'admins', 'action' => 'admin'));
        }
        return true;  
    }

    public function valide_relance()
    {
        $this->User->contain();
        $allusers = $this->User->find('all', array(
            'conditions' => array('activated' => 0),
            'fields' => array('email', 'codeactivation', 'prenom'),
        ));

        $title = "Petit rappel pour activer votre compte ".Configure::read('Common.client.name').".".Configure::read('Common.sitename_title')." !";
        $glb_header = "vdmv_header_global";
        $glb_template = "relance";

        foreach ($allusers as $curuser) {
            $message = $curuser['User']['codeactivation'];
            $this->send_global_email(
                $title,
                $message,
                $curuser['User'],
                $glb_template,
                $glb_header
            );
        }
        $this->Session->setFlash(__("les mails de relance ont bien été envoyés."), 'msg_success');
        $this->redirect(array('controller' => 'admins', 'action' => 'admin'));
    }

    public function admin_bassins()
    {

    }

    public function CreateBassinVie()
    {
        if ($this->request->is('post')) {
            $this->loadModel('Bv');
            //debug($this->data);exit;
            $this->Bv->create();
            if ($this->Bv->save(array('Bv' => $this->data['Admin']))) {
                $this->Session->setFlash(__("Création du bassin ok"), 'msg_success');
            } else {
                $this->Session->setFlash(__("Erreur lors de la création du bassin"), 'msg_alert');
            }
            $this->redirect(array('controller' => 'admins', 'action' => 'admin_bassins'));
        }
    }

    public function getUsersInBassin($bassin_id)
    {
        $this->loadModel('BvsCity');
        $this->BvsCity->contain();
        $allcities_bv = $this->BvsCity->find('all', array(
            'conditions' => array('BvsCity.bv_id' => $bassin_id),
        ));
        $allcities = array();
        foreach ($allcities_bv as $curbv) {
            $allcities[$curbv['BvsCity']['city_id']] = $curbv['BvsCity']['city_id'];
        }
        // recherche des users
        $this->loadModel('User');
        $this->User->contain();
        $all_users = $this->User->find('list', array(
            'conditions' => array(
                'User.city_id' => $allcities,
            ),
        ));
        return $all_users;
    }

    public function get_countries()
    {
        $this->loadModel('Country');
        $this->Country->contain();
        $ret = $this->Country->find('all');
        $this->autoRender = false;
        return json_encode($ret);
    }

    public function get_bassin_cities($bv_id)
    {
        $this->loadModel('Bv');
        $this->loadModel('City');
        //$this->BvCity->contain('City');
        $this->Bv->contain('City');
        $ret = $this->Bv->find('first', array(
            'conditions' => array('id' => $bv_id),
            'contain' => array(
                'City' => array(
                    'fields' => array('ville_nom_reel', 'id'),
                ),
            ),
        ));
        $allusers = $this->getUsersInBassin($bv_id);
        $transactions = $this->getTransactionUsers($allusers);
        $toreturn = array(
            'cities' => $ret,
            'users' => $allusers,
            'transactions' => $transactions,
        );
        $this->autoRender = false;
        return json_encode($toreturn);
    }

    public function setCreditDefaut($value)
    {
        $this->loadModel('User');
        $this->loadModel('Client');
        $currentClient = $this->getClientData();
        $this->Client->id = $currentClient['id'];
        $this->Client->savefield('monnaie_default', $value);
        $this->User->updateAll(
            array('User.monnaiestart' => $value),
            array('User.client_id' => $currentClient['id'])
        );
        $this->autoRender = false;
        return json_encode("Done");
    }

    public function setMinimumDefalut($value)
    {
        $this->autoRender = false;
        $this->loadModel('Client');
        $currentClient = $this->getClientData();
        $this->Client->id = $currentClient['id'];
        $this->Client->savefield('monnaie_minimum', $value);
        return json_encode("Done");
    }

    public function setValEuros($value)
    {
        $this->autoRender = false;
        $this->loadModel('Client');
        $currentClient = $this->getClientData();
        $this->Client->id = $currentClient['id'];
        $this->Client->savefield('monnaie_valeuros', $value);
        return json_encode("Done");
    }

    public function setMonnaieName($value)
    {
        $this->autoRender = false;
        $this->loadModel('Client');
        $currentClient = $this->getClientData();
        $this->Client->id = $currentClient['id'];
        $this->Client->savefield('monnaie_name', trim($value));
        return json_encode("Done");
    }
    

    public function getMonnaieUser($user_id)
    {
        $ret = $this->getUserReserveMonnaie($user_id);
        $this->autoRender = false;
        return json_encode($ret);
    }

    public function setGameDefault($what,$value)
    {
        $this->autoRender = false;
        $this->loadModel('Client');
        $currentClient = $this->getClientData();
        $this->Client->id = $currentClient['id'];
        $this->Client->savefield($what, trim($value));
        return json_encode("Done");
    }

    

    public function addTransaction()
    {
        //debug($this->data);
        $this->loadModel('Transaction');
        $userreseau = Configure::read('Reseau.user_id');
        $userid = $this->data['userid'];
        $montant = $this->data['valmonnaie'];
        $message = $this->data['message'];
        $tosave = array();
        if ($montant < 0) {
            $tosave = array(
                'user_id' => $userid,
                'to_userid' => $userreseau,
                'amount' => abs($montant),
                'message' => $message,
            );
        } else {
            $tosave = array(
                'user_id' => $userreseau,
                'to_userid' => $userid,
                'amount' => abs($montant),
                'message' => $message,
            );
        }
        $this->Transaction->create();
        $retsv = $this->Transaction->save(array('Transaction' => $tosave));
        $this->autoRender = false;
        return json_encode($retsv);
    }

    public function checkAndAddCityBv($cid, $bvid)
    {
        //$chk = $this->check_google_city($city2add,'remoteyes');
        $message = $cid;
        $this->loadModel('BvsCity');
        // On verifie si pas déjà dans le BV
        $ret = $this->BvsCity->findByBvIdAndCityId($bvid, $cid);
        if (!$ret) {
            $this->BvsCity->create();
            $array = array('BvsCity' => array('bv_id' => $bvid, 'city_id' => $cid));
            $this->BvsCity->save($array);
            $message = $chk;
        }
        $this->autoRender = false;
        return json_encode($message);
    }

    public function remove_bassin_cities($city_id, $bvid)
    {
        $this->loadModel('BvsCity');
        $ret = $this->BvsCity->findByBvIdAndCityId($bvid, $city_id);
        if ($ret) {
            $this->BvsCity->contain();
            $this->BvsCity->delete($ret['BvsCity']['id'], false);
        }
        $this->autoRender = false;
        return json_encode("done");
    }

    public function remove_bassin($bassin_id)
    {
        // Verification
        $this->loadModel('Bv');
        $this->Bv->contain();
        $chk = $this->Bv->findById($bassin_id);
        if ($chk) {
            // Suppression de tous les villes associées
            $this->loadModel('BvsCity');
            $this->BvsCity->deleteAll(array('BvsCity.bv_id' => $bassin_id), false);
            $ret = $this->Bv->delete($bassin_id, false);
        }
        $this->autoRender = false;
        $ret = __("Votre message a été supprimé");
        return json_encode($ret);
    }

    public function admin_categories()
    {
        $this->loadModel('Category');
        $ret = $this->Category->find('all',array('order'=>array('Category.name')));
        $this->set('all_cat', $ret);
    }



    public function CreateEditCategorie($catid=null)
    {
        if ($this->request->is('post')) {
            $this->loadModel('Category');
            $tmpdata = $this->data;
            //debug($tmpdata);exit;
            if ($tmpdata['Admin']['image2upload'] != '') {
                // Copie de l'umage en lieu sur..
                $ext = pathinfo($tmpdata['Admin']['image2upload']['name'], PATHINFO_EXTENSION);
                //debug($ext);exit;
                if ($ext != "") {
                    $tmpdata['Admin']['image'] = "autres.png";
                    // Un nom d'image en timestamp
                    $img = time();
                    $source = WWW_ROOT . DIRECTORY_SEPARATOR . 'img/categories/' . $img;
                    $filename = $source . '.' . $ext;
                    move_uploaded_file($tmpdata['Admin']['image2upload']['tmp_name'], $filename);
                    $image = new SimpleImage();
                    $image->load($filename);
                    $image->resizeToWidth(600);
                    $image->save($filename);
                    $tmpdata['Admin']['image'] = $img . '.' . $ext;
                }
            }
            if (isset($tmpdata['Admin']['categorie_id'])) {
                $this->Category->id=$tmpdata['Admin']['categorie_id'];
                // -------- Message aux admins ---------------------
                //$sujet = Configure::read('Common.sitename') . ' : ' . __("Modification d'une catégorie !");
                //configure::write('debug',2);debug($tmpdata['Admin']);exit;
                //$msgmail = __("Une catégorie a été modifiée sur ") . Configure::read('Common.sitename') . ' : '.$tmpdata['Admin']['name'];
                //$msgmail .= "\n".__("Plateforme")." : " . Configure::read('Common.client.name');
                //$this->send_global_email($sujet, $msgmail);
            } else {
                $this->Category->create();
                // -------- Message aux admins ---------------------
                //$sujet = Configure::read('Common.sitename') . ' : ' . __("Ajout d'une catégorie !");
                //configure::write('debug',2);debug($tmpdata['Admin']);exit;
                //$msgmail = __("Une catégorie a été ajoutée sur ") . Configure::read('Common.sitename') . ' : '.$tmpdata['Admin']['name'];
                //$msgmail .= "\n".__("Plateforme")." : " . Configure::read('Common.client.name');
                //$this->send_global_email($sujet, $msgmail);
            }
            if ($this->Category->save(array('Category' => $tmpdata['Admin']))) {
                $this->Session->setFlash(__("Création de la catégorie ok"), 'msg_success');
            } else {
                $this->Session->setFlash(__("Erreur lors de la création de la catégorie"), 'msg_alert');
            }
            $this->redirect(array('controller' => 'admins', 'action' => 'admin_categories'));
        }
        if ($catid!=null) {
            // Check if user can edit this category
            $cl  = $this->getClientData();
            $clid = $cl['id'];
            $this->loadModel('Category');
            $chkcat = $this->Category->findByIdAndClientId($catid,$clid);
            if (!$chkcat) $this->redirect(array('controller'=>'admins','action'=>'admin_categories'));
            $this->set('Categorie',$chkcat['Category']);
            $all_categories = $this->Category->find('list',array('order'=>array('Category.name')));
            $this->set('all_categories',$all_categories);            
        }
    }

    public function remove_category($cat_id)
    {
        $this->loadModel('Category');
        // TODO check if authorized
        $cl  = $this->getClientData();
        $clid = $cl['id'];
        $this->loadModel('Category');
        $chkcat = $this->Category->findByIdAndClientId($cat_id,$clid);
        if (!$chkcat) $this->redirect(array('controller'=>'admins','action'=>'admin_categories'));

        $ret = $this->Category->findById($cat_id);
        if ($ret) {
            $this->Category->contain();
            $this->Category->delete($ret['Category']['id'], false);
        }
        //$this->autoRender = false;
        //return json_encode("done");
        $this->redirect(array('controller'=>'admins','action'=>'admin_categories'));
    }


    public function admin_posts()
    {
        $this->loadModel('Category');
        $allcats = $this->Category->find('all', array(
            'conditions' => array(),
            'fields' => array('Category.id', 'Category.name'),
            'order' => array('Category.name'),
        ));
        $listcat = array();
        foreach ($allcats as $curcat) {
            $listcat[$curcat['Category']['id']] = $curcat['Category']['name'];
        }
        //debug($listcat);exit;
        $this->set('listcat', $listcat);
    }

    public function admin_avis()
    {

    }

    public function modify_avis()
    {
        $this->autoRender = false;
        if ($this->data) {
            $this->loadModel('Transaction');
            $chk = $this->Transaction->findById($this->data['idx']);
            if ($chk) {
                $this->Transaction->id = $this->data['idx'];
                $ret = $this->Transaction->savefield('message', $this->data['msg']);
                // -------- Message aux admins ---------------------
                //$sujet = Configure::read('Common.sitename') . ' : ' . __("modification d'un avis par un admin sur le site !");
                //$msgmail = __("Un avis a été modifié sur ") . Configure::read('Common.sitename') . ' : ';
                //$msgmail .= "\nDe ".$chk['User']['nom'] . " " . $chk['User']['prenom'] ;
                //$msgmail .= "\nVers ".$chk['UserTo']['nom'] . " " . $chk['UserTo']['prenom'] ;
                //$msgmail .= "\n".$this->data['msg'];
                //$msgmail .= "\nPlateforme : " . Configure::read('Common.client.name');
                //$this->send_global_email($sujet, $msgmail);
                // --------------------------------------------------
            }
        }
        return json_encode(array('msg' => 'OK'));
    }

    public function load_last_posts($numpage = null,$keyword="")
    {
        $this->loadModel('Post');
        $this->autoRender = false;
        $posts_paginate = array(
            'limit' => 20,
            //'conditions' => array(
            //    'OR' => array(
            //        array('Post.type'=>'O'),
            //        array('Post.type'=>'D')
            //    )
            //),
            //'order'=> array('Post.modified'=> 'asc', 'Post.id' => 'asc'),
            'fields' => array(
                'User.*', 'City.*', 'Category.*', 'Post.*',
            ),
        );
        $this->Paginator->settings = $posts_paginate;
        if ($numpage != null) {
            $this->Paginator->settings['Post']['page'] = $numpage;
        }

        //debug($posts_paginate);exit;

        $this->Paginator->settings = $posts_paginate;
        if ($numpage != null) {
            $this->Paginator->settings['Post']['page'] = $numpage;
        }
        $this->Paginator->settings['Post']['order'] = array('Post.modified' => 'desc', 'Post.id' => 'desc');
        
        if ($keyword=="") {
            $this->Paginator->settings['Post']['conditions'] = array(
                'OR' => array(
                    array('Post.type' => 'O'),
                    array('Post.type' => 'D'),
                ),
            );
        } else {
            $this->Paginator->settings['Post']['conditions'] = array(
                'OR' => array(
                    array('Post.type' => 'O'),
                    array('Post.type' => 'D'),
                ),
                'OR' => array(
                    array('Post.titre LIKE' => "%$keyword%"),
                    array('Post.message LIKE' => "%$keyword%")
                ),
            );
        }

//debug($this->Paginator->settings);exit;
        $ret = array(
            'allposts' => $this->Paginator->paginate('Post'),
            'paginator' => $this->params['paging'],
        );

        //debug($this->params['paging']['Post']['count']);
        //debug($this->params['paging']);
        //debug($ret);exit;
        return json_encode($ret);
    }

    public function load_last_msgs($numpage = null)
    {
        $this->loadModel('Pm');

        $this->autoRender = false;

        //$posts_paginate = array(
        //    'limit' => 50,
        //);
        //$this->Paginator->settings = $posts_paginate;
        if ($numpage != null) {
            $this->Paginator->settings['Pm']['page'] = $numpage;
        }
        $this->Paginator->settings['Pm']['order'] = array('Pm.created' => 'desc', 'Pm.id' => 'desc');
        $this->Paginator->settings['Pm']['limit'] = 20;
        //debug($this->Paginator->settings);
        $ret = array(
            'allmsgs' => $this->Paginator->paginate('Pm'),
            'paginator' => $this->params['paging'],
        );
        //debug($ret);
        return json_encode($ret);
    }

    public function load_last_avis()
    {
        $this->loadModel('Transaction');
        $ret = $this->Transaction->find('all', array(
            'conditions' => array(
                'Transaction.message != ' => null,
                'Transaction.user_id != ' => 0,
                'Transaction.to_userid != ' => 0,
                //'OR'=> array(
                //    array('Post.type' => 'O'),
                //    array('Post.type' => 'D')
                //)
            ),
            'limit' => 50,
            'order' => array('Transaction.id DESC'),
        ));
        //debug($ret);
        $this->autoRender = false;
        return json_encode($ret);
    }

    public function remove_avis($avis_id)
    {
        $this->loadModel('Transaction');
        $this->Transaction->delete(array('Transaction.id' => $avis_id), false);
        $this->autoRender = false;
        $ret = __("L'avis a été supprimé");
        return json_encode($ret);
    }

    public function remove_post($post_id)
    {
        // Verification
        $this->loadModel('Post');
        //$this->Post->contain();
        $chkpost = $this->Post->findById($post_id);
        $this->Post->delete(array('Post.id' => $post_id), false);
        $this->autoRender = false;
        $ret = __("Votre message a été supprimé");
        // -------- Message aux admins ---------------------
        //$sujet = Configure::read('Common.sitename') . ' : ' . __("suppression d'une annonce par un admin sur le site !");
        //$msgmail = __("Une annonce a été supprimée sur") . Configure::read('Common.sitename') . ' : ';
        //$msgmail .= "\n".__("Annonce de ").$chkpost['User']['nom'] . " " . $chkpost['User']['prenom'] . " (" . $chkpost['User']['email'] . ") de " . $chkpost['City']['ville_nom_reel'];
        //$msgmail .= "\n".__("Titre annonce ").$chkpost['Post']['titre'];
        //$msgmail .= "\n".__("Plateforme : ") . Configure::read('Common.client.name');
        //$this->send_global_email($sujet, $msgmail);
        // --------------------------------------------------
        return json_encode($ret);
    }

    public function admin_newsletters()
    {
        $this->verif_admin(true); // Only full admin
    }

    public function gestionnewsletters()
    {
        if ($this->data) {
            $theData = $this->data;
            //debug($this->data);    exit;
            $aqui = $theData['Admin']['aqui'];
            $filenewsletter = "";
            // Vérifier si un fichier image est associé
            if ($theData['Admin']['news_file']['name'] != '') {
                $file = $theData['Admin']['news_file'];
                // Copie de l'image en lieu sur..
                $ext = pathinfo($file['name'], PATHINFO_EXTENSION);
                //debug($ext);
                if ($ext != "") {
                    // Un nom d'image en timestamp
                    $timestamp = time();
                    $source = WWW_ROOT . DIRECTORY_SEPARATOR . 'img/newsletters_upload/' . $timestamp;
                    $filename = $source . '.' . $ext;
                    move_uploaded_file($file['tmp_name'], $filename);
                    $image = new SimpleImage();
                    $image->load($filename);
                    $image->resizeToWidth(600);
                    $image->save($filename);
                    $filenewsletter = 'img/newsletters_upload/' . $timestamp . '.' . $ext;
                }
            }
            $theData['Admin']['filenewsletter'] = $filenewsletter;
            //debug($theData);    exit;
            $chk = 0;
            if ($theData['Admin']['ShowForCity'] == 'true') {
                $chk = 1;
                $this->animationSendMessageVille($theData, $aqui);
            }
            if ($theData['Admin']['ShowForCountry'] == 'true') {
                $chk = 1;
                $this->animationSendMessageCountry($theData, $aqui);
            }            
            if ($theData['Admin']['ShowForAll'] == 'true') {
                $chk = 1;
                $this->animationSendMessageAll($theData, $aqui);
            }
            if ($chk == 0) {
                $this->Session->setFlash(__("tu n'a pas sélectionné de ville/pays"), 'msg_alert');
                $this->redirect(array('controller' => 'admins', 'action' => 'admin_newsletters'));
            } else {
                $this->Session->setFlash(__("Message envoyé"), 'msg_alert');
                $this->redirect(array('controller' => 'admins', 'action' => 'admin_newsletters'));
            }
        }
    }

    public function send_message_all_users($message, $all_users, $aqui)
    {
        //Configure::write('debug', 2 );
        $glb_template = "push_mail";
        $glb_header = null;

        $type_mail = $message['type_mail'];
        if ($type_mail == "newsletter") {
            $title = $message['titre_news_letter'];
            $glb_template = "newsletter_email";
            $glb_header = "newsletter_header";
        } else {
            $title = $message['titre_pushmail'];
        }
        //debug($title);debug($message);exit;
        //debug($all_users);exit;
        //debug($this->Userinfo);exit;
        if ($aqui != 'all') {
            $this->send_global_email(
                $title,
                $message,
                $this->Userinfo,
                $glb_template,
                $glb_header
            );
        } else {
            foreach ($all_users as $curuser) {
                $userArray = $curuser['User'];
                if ($userArray['email'] != "") {
                    //debug("envoi à ".$userEmail);
                    $this->send_global_email(
                        $title,
                        $message,
                        $userArray,
                        $glb_template,
                        $glb_header
                    );
                }
            }
        }

        //debug($message);exit;

    }

    public function animationSendMessageVille($data, $aqui)
    {
        $this->loadModel('User');
        $city_id = $data['Pages']['ville_id'];
        $this->User->contain();
        //debug($data);
        $all_users = $this->User->find('all', array(
            'conditions' => array('User.city_id' => $city_id, 'User.activated' => 1),
            'fields' => array('User.email', 'User.prenom'),
        ));
        //debug($all_users );
        $this->send_message_all_users($data['Admin'], $all_users, $aqui);
        $this->set('jsonData', 'fait');
        $this->layout = "empty";
        $this->render('/Elements/json_output');
    }


    public function animationSendMessageCountry($data, $aqui)
    {
        $this->loadModel('City');
        list($dm, $b_id) = explode("string:", $data['Admin']['CountrySelId']);
        $allcities = $this->City->find('list', array(
            'conditions' => array('country_id' => $b_id),
            'fields' => array('id'),
        ));
        // Recherche les users de cette ville
        $this->loadModel('User');
        $this->User->contain();
        $all_users = $this->User->find('all', array(
            'conditions' => array('User.city_id' => $allcities),
            'fields' => array('User.email', 'User.prenom'),
        ));
        $this->send_message_all_users($data['Admin'], $all_users, $aqui);
        $this->set('jsonData', 'fait');
        $this->layout = "empty";
        $this->render('/Elements/json_output');
    }

    public function animationSendMessageAll($data, $aqui)
    {
        // Recherche les users 
        $this->loadModel('User');
        $this->User->contain();
        $all_users = $this->User->find('all', array(
            'conditions' => array(),
            'fields' => array('User.email', 'User.prenom'),
        ));

        //debug($all_users);exit;
        $this->send_message_all_users($data['Admin'], $all_users, $aqui);
        $this->set('jsonData', 'fait');
        $this->layout = "empty";
        $this->render('/Elements/json_output');
    }



    public function rechercheUser($recherche)
    {
        if ($recherche) {
            //debug($recherche);
            $this->loadModel('User');
            $last_users = $this->User->find('all', array(
                'conditions' => array(
                    'AND'=>Configure::read('Admin.userstofilter'),
                    'OR' => array(
                        array('User.nom LIKE' => "%$recherche%"),
                        array('User.prenom LIKE' => "%$recherche%"),
                        array('User.email LIKE' => "%$recherche%"),
                    ),
                ),
                'fields' => array('User.id', 'User.nom', 'User.prenom','User.vacation', 'User.created', 'User.email', 'User.type', 'User.role', 'User.activated', 'City.ville_nom_reel', 'City.ville_departement'),
                'order' => array('User.id DESC'),
                'limit' => 100,
            ));
        }

        $this->autoRender = false;
        return json_encode($last_users);
    }

    public function admin_stats()
    {
        // récupération des derniers utilisateurs
        $this->loadModel('User');
        $last_users = $this->User->find('all', array(
            'conditions' => array(
                'AND'=>Configure::read('Admin.userstofilter')
            ),
            'joins' => array(
                array(
                    'table' => 'countries',
                    'alias' => 'Country',
                    'type' => 'INNER',
                    'conditions' => array(
                        'City.country_id = Country.id'
                    )
                )
            ),
            'fields' => array('User.id', 'User.nom', 'User.prenom', 'User.vacation','User.created', 'User.role', 'User.type', 'User.email', 'User.activated', 'City.ville_nom_reel', 'City.country_id','Country.name'),
            'order' => array('User.id DESC'),
            'limit' => 20,
        ));
        //debug($last_users);exit;
        $this->set('last_users', $last_users);
        $this->set('allTags', Configure::read('Common.tag_types'));
    }

    public function admin_pms()
    {
        $this->verif_admin(true); // Only full admin
    }

    public function load_stats()
    {
        $this->loadModel('User');
        $this->User->contain('City');
        $all_users = $this->User->find('all', array(
            'joins' => array(
                array(
                    'table' => 'countries',
                    'alias' => 'Country',
                    'type' => 'INNER',
                    'conditions' => array(
                        'City.country_id = Country.id'
                    )
                )
            ),
            'fields' => array('City.ville_nom_reel', 'City.id', 'User.role','Country.name','Country.id'),
            'group' => array('City.id'),
            'order' => array('City.ville_nom_reel ASC'),
        ));
        $this->User->contain('City');
        $all_users_countries = $this->User->find('all', array(
            'joins' => array(
                array(
                    'table' => 'countries',
                    'alias' => 'Country',
                    'type' => 'INNER',
                    'conditions' => array(
                        'City.country_id = Country.id'
                    )
                )
            ),
            'fields' => array('Country.name','Country.id','COUNT(User.id) AS nb_users'),
            'group' => array('Country.id'),
            'order' => array('Country.id'),
        ));
        // Remove 2 for france , philippe and me
        debug( $this->User->find('all'));exit;
        $all_users_countries[0][0]['nb_users']--; // David
        $all_users_countries[0][0]['nb_users']--; // Philippe
        //debug($all_users_countries);exit;
        // Récupération du nombre de membres par ville
        $mb_array = array();
        $dep_array = array();
        $totalCount = 0;
        //debug($all_users);
        foreach ($all_users as $curlocation) {
            $curcity_id = $curlocation['City']['id'];
            $members = $this->User->find('count', array(
                'conditions' => array(
                    'city_id' => $curcity_id,
                    'AND'=>Configure::read('Admin.userstofilter')
                ),
            ));
            //if (($members > 0) && ($curlocation['City']['ville_departement'] != 100) && ($curlocation['City']['ville_departement'] != 0)) {
            if (($members > 0)) {    
                $mb_array[$curcity_id] = array(
                    'city' => $curlocation['City']['ville_nom_reel'],
                    'city_id' => $curlocation['City']['id'],
                    'nb' => $members,
                    'country' => $curlocation['Country']['name'],
                    'country_id' => $curlocation['Country']['id']
                    //'dep' => $curlocation['City']['ville_departement'],
                );
                //if (!isset($dep_array[$curlocation['City']['ville_departement']])) {
                //    $dep_array[$curlocation['City']['ville_departement']] = $curlocation['City']['ville_departement'];
                //}
                $totalCount += $members;
            }
        }
        sort($mb_array);
        $final = array(
            'stats_ville' => $mb_array,
            'list_dep' => $dep_array,
            'totalCount' => $totalCount,
            'userscountries' => $all_users_countries
        );
        $this->set('jsonData', $final);
        $this->layout = "empty";
        $this->render('/Elements/json_output');
    }

    public function adminMembresVilles($city_id)
    {
        $this->loadModel('User');
        $all_users = $this->User->find('all', array(
            'conditions' => array(
                'city_id' => $city_id,
            ),
            'order' => array('User.id DESC'),
        ));
        $this->set('all_users', $all_users);
        $current_ville = $all_users[0]['City']['ville_nom_reel'];
        $this->set('current_ville', $current_ville);
    }

    public function supprimercompte($cid)
    {
        $this->loadModel('User');
        $this->loadModel('Invitation');
        $this->loadModel('Post');
        $this->loadModel('Pm');
        $this->User->contain();
        $user = $this->User->findById($cid);
        if ($user) {
            foreach (Configure::read('Admin.users') as $chkuser) {
                if ($user['User']['email'] == $chkuser['email']) {
                    $this->Session->setFlash(__("Compte non trouvé ou impossible à supprimer"), 'msg_alert');
                    $this->redirect($this->referer());
                }
            }
            $uid = $user['User']['id'];
            $this->Invitation->deleteAll(array('Invitation.user_id' => $uid), false);
            $this->Post->deleteAll(array('Post.user_id' => $uid), false);
            $this->Pm->deleteAll(array('Pm.id_expediteur' => $uid), false);
            $this->Pm->deleteAll(array('Pm.id_destinataire' => $uid), false);
            $this->User->delete($uid);
            // -------- Message aux admins ---------------------
            //$sujet = Configure::read('Common.sitename') . ' : ' . __("suppression d'un compte par un admin sur le site !");
            //$msgmail = __("Un compte a été supprimé sur ") . Configure::read('Common.sitename') . ' : ';
            //$msgmail .= $user['User']['nom'] . " " . $user['User']['prenom'] . " (" . $user['User']['email'] . ")";
            //$msgmail .= "\n".__("Plateforme : ") . Configure::read('Common.client.name');
            //$this->send_global_email($sujet, $msgmail);
            // --------------------------------------------------
            $this->Session->setFlash(__("Le compte a été supprimé ainsi que toutes les datas le concernant"), 'msg_success');
            $this->redirect($this->referer());
        } else {
            $this->Session->setFlash(__("Compte non trouvé ou impossible à supprimer"), 'msg_alert');
            $this->redirect($this->referer());
        }
    }

    public function change_category()
    {
        if ($this->data) {
            //debug($this->data);exit;
            $this->loadModel('Post');
            $chk = $this->Post->findById($this->data['Admins']['postid']);
            if ($chk) {
                $this->Post->id = $this->data['Admins']['postid'];
                $this->Post->savefield('category_id', $this->data['Admins']['newcat']);
                $this->Session->setFlash(__("Catégorie changée !"), 'msg_success');
            } else {
                $this->Session->setFlash(__("Vous n'avez pas les droits"), 'msg_success');
            }
            $this->redirect($this->referer());
        }
    }

    public function toggle_administrator_entreprise($user_id)
    {
        $this->loadModel('User');
        $chk = $this->User->findById($user_id);
        if ($chk) {
            $this->User->id = $chk['User']['id'];
            if ($chk['User']['role'] == "adminentreprise") {
                $this->User->saveField('role', null);
                $msg = null;
            } else {
                $this->User->saveField('role', "adminentreprise");
                $msg = "adminentreprise";
            }
        }
        $this->autoRender = false;
        return json_encode($msg);
    }

    public function getAllTags()
    {
        $alltags = Configure::read('Common.tag_types');
        $this->autoRender = false;
        return json_encode($alltags);
    }

    public function setUserTag($userid, $tagvalue)
    {
        $this->loadModel('User');
        $chk = $this->User->findById($userid);
        if ($chk) {
            $this->User->id = $userid;
            $this->User->saveField('type', $tagvalue);
        }
        $this->autoRender = false;
        return json_encode("done");
    }

    public function getTransactionUsers($array_users = null,$postdata = null)
    {
        
        $this->loadModel('Transaction');
        if ($array_users == null) {
            //$conditions=null;
            $conditions = array(
                //'Transaction.user_id != ' => Configure::read('Reseau.user_id'),
                //'Transaction.to_userid != ' => Configure::read('Reseau.user_id')
                //'User.role not like ' => "%admin%"
                'AND' => array(
                    array('Transaction.user_id != ' => 0),
                    array('Transaction.to_userid != ' => 0)
                )
            );
            $conditions_all = array();
            if (isset($postdata['Admins']) && trim($postdata['Admins']['search_keyword'])!="")  {
                $recherche = strtolower($postdata['Admins']['search_keyword']);
                $conditions_all = array(
                    'OR' => array(
                        array('LOWER(Transaction.message) LIKE ' => "%$recherche%"),
                        array('LOWER(Transaction.post_titre) LIKE ' => "%$recherche%"),
                        array('LOWER(User.email) LIKE ' => "%$recherche%"),
                        array('LOWER(User.nom) LIKE ' => "%$recherche%"),
                        array('LOWER(User.prenom) LIKE ' => "%$recherche%"),
                    ),
                    //'Transaction.user_id != ' => Configure::read('Reseau.user_id'),
                    //'Transaction.to_userid != ' => Configure::read('Reseau.user_id')
                );
                //debug($conditions_all);exit;
            }
        } else {
            $conditions = array(
                'OR' => array(
                    array('Transaction.user_id' => $array_users),
                    array('Transaction.to_userid' => $array_users),
                ),
                //'Transaction.user_id != ' => Configure::read('Reseau.user_id'),
                //'Transaction.to_userid != ' => Configure::read('Reseau.user_id')
            );
            $conditions_all = $conditions;
        }

        $sum = $this->Transaction->find('all', array(
            'conditions' => $conditions,
            // 'joins' => array(
            //     array(
            //         'table' => 'users',
            //         'alias' => 'UserJoin',
            //         'type' => 'INNER',
            //         'conditions' => array(
            //             'User.role not like ' => "%admin%"
            //         )
            //     )
            // ),
            'fields' => array('sum(Transaction.amount) as total_sum'),
        ));
        //debug($sum);//exit;
        $this->set('total_echanges_heures', $sum[0][0]['total_sum']);
        $all_echanges = $this->Transaction->find('all', array(
            'conditions' => $conditions_all,
            'fields' => array('User.nom', 'User.prenom', 'User.id','User.email','Transaction.id', 'Transaction.user_id','Transaction.to_userid', 'Transaction.created', 'Transaction.message','Transaction.post_titre','Transaction.post_category', 'Transaction.done','UserTo.nom', 'UserTo.id', 'UserTo.prenom', 'Transaction.amount','Post.titre','Post.id','Post.image'),
            'order' => 'Transaction.id DESC',
        ));
        //debug($all_echanges );exit;
        return array('sum' => $sum, 'echanges' => $all_echanges);
    }

    public function getClientDataJson()
    {
        $this->autoRender = false;
        $ret = $this->getClientData();
        return json_encode($ret);
    }

    public function admin_monnaie()
    {
        //$flag = file_get_contents(WWW_ROOT."files/monnaie_national.txt");
        //$this->set('flag',$flag);
        $this->loadModel('Client');
        $currentClient = $this->getClientData();
        $this->set('monnaie_minimum', $currentClient['monnaie_minimum']);
        // Recherche des transactions
        if ($this->request->is('post')) {
            $transactions = $this->getTransactionUsers(null,$this->data);
        } else {
            $transactions = $this->getTransactionUsers();
        }
        $sum = $transactions['sum'];
        $this->set('total_echanges_heures', $sum[0][0]['total_sum']);
        $all_echanges = $transactions['echanges'];
        $this->set('all_echanges', $all_echanges);
        $this->loadModel('Transaction');
        $this->Transaction->contain();
        $ret_buyers = $this->Transaction->find('all', array(
            'conditions' => array(
                //'amount != ' => 0
            ),
            'joins' => array(
                array(
                    'table' => 'users',
                    'alias' => 'UserJoin',
                    'type' => 'INNER',
                    'conditions' => array(
                        'UserJoin.id = Transaction.user_id'
                    )
                )
            ),
            'fields' => array('UserJoin.nom','UserJoin.prenom','UserJoin.id','COUNT(UserJoin.id) AS nb_transactions'),
            'group' => array('UserJoin.id'),
            'order' => array('nb_transactions DESC'),
            'limit' => 30
        ));
        $ret_solders = $this->Transaction->find('all', array(
            'conditions' => array(
                //'amount != ' => 0
            ),
            'joins' => array(
                array(
                    'table' => 'users',
                    'alias' => 'UserJoin',
                    'type' => 'INNER',
                    'conditions' => array(
                        'UserJoin.id = Transaction.to_userid'
                    )
                )
            ),
            'fields' => array('UserJoin.nom','UserJoin.prenom','UserJoin.id','COUNT(UserJoin.id) AS nb_transactions'),
            'group' => array('UserJoin.id'),
            'order' => array('nb_transactions DESC'),
            'limit' => 30
        ));
        $this->set('ret_buyers', $ret_buyers);
        $this->set('ret_solders', $ret_solders);
        $this->set('priceperpoint', $this->getPricePoint());
        $this->set('priceperpoint_ID', Configure::read('Stripe.pointPrice'));

        //debug($ret_buyers);
        //debug($ret_solders);
        //exit;
    }

    public function admin_ventes() {
        $this->loadModel('Vente');
        if ($this->data) {
            $recherche = strtolower($this->data['Admins']['search_keyword']);
            $conditions_all = array(
                'OR' => array(
                    array('LOWER(Vente.name) LIKE ' => "%$recherche%"),
                    array('LOWER(User.nom) LIKE ' => "%$recherche%"),
                    array('LOWER(User.prenom) LIKE ' => "%$recherche%"),
                    array('LOWER(User.email) LIKE ' => "%$recherche%"),
                )
            );
            $ventes = $this->Vente->find('all',array(
                'conditions' => $conditions_all,
                'order' => array('Vente.id Desc'),            
            ));
        } else {
            $ventes = $this->Vente->find('all',array(
                //'fields' => array('name'),
                'order' => array('Vente.id Desc'),            
            ));
        }


        
        $this->set('all_ventes',$ventes);
    }

    public function admin_extract_ventes() {
        $this->loadModel('Vente');
        $this->autoRender = false;
        $chk = $this->Vente->find('all',array(
            'order' => array('Vente.id Desc'),
            'conditions' => array(
            )
        ));
        $mn = $this->ClientData['monnaie_name'];
        $pds = Configure::read('Common.poids');
        //debug($chk);
        if ($chk) {
            $result = __("Entrée").";".__("Date").";".__("De").";".__("Email").";".__("Poids colis").";".__("Bordereau envoyé").";".__("Colis reçu ?").";".$mn." ".__("attribués")."\n";
            foreach ($chk as $curvente) { 
                $result .= $curvente['Vente']['name'].";";
                $result .= date("d/m/Y",strtotime($curvente['Vente']['created'])).";";
                $result .=  $curvente['User']['prenom']." ".$curvente['User']['nom'].";";               
                $result .= $curvente['User']['email'] .";";
                $result .= $pds[$curvente['Vente']['poids_id']] .";";
                
                $status = __("Non");
                if ($curvente['Vente']['sent']==1) {
                    $status = __("Oui");
                }
                $result .=  $status.";";

                $status = __("Non");
                if ($curvente['Vente']['received']==1) {
                    $status = __("Oui");
                }
                $result .=  $status.";";

                $status = __("Non");
                if ($curvente['Vente']['points_given']==1) {
                    $status = __("Oui");
                }
                $result .=  $status.";";
                $result .= "\n";
            }
            $this->response->body($result);
            $this->response->type('csv');   
            $this->response->download('ListeVentes.csv');
            //debug($chk);exit;
            return $this->response;
        } else {
            $this->Session->setFlash(__("Pas de ventes trouvées."), 'msg_alert');
            $this->redirect($this->referer());
        }        
    }





    public function admin_gamification()
    {
        $this->verif_admin(true); // Only full admin
    }
    

    public function admin_messagerie() {
        //$this->loadModel('Client');
        //$currentClient = $this->getClientData();
    }

    public function admin_counters() {
        $this->loadModel('Challenge');
        $challenges = $this->Challenge->find('all',array(
            'fields' => array('name'),
            'order' => array('Challenge.id Desc'),
            'contain' => array(
                'Project' => array(
                    'fields' => array('id')
                )
            )
        ));
        $this->set('challenges',$challenges);
        //debug($challenges); exit;
    }

    public function getCounters($yearuser=null)
    {
        $this->autoRender = false;
        $this->loadModel('Post');
        $this->loadModel('Transaction');
        $this->loadModel('User');
        // Recherche de la date du jour
        
        if ($yearuser==null) {
            $yearstart = date('Y');
        } else {
            $yearstart = $yearuser;
        }
       
        $startdate = strtotime("-52 weeks");
        $all_weeks = array();

        $monthstart = "01";
        $monthend = "12";
        $finaldata = array('membres'=>array(),'labels'=>array(),'posts_O'=>array(),'posts_D'=>array(),'avis'=>array(),'messages'=>array(),'nbmonnaies'=>array());

        $start = strtotime("$yearstart-$monthstart-01");
        $end = strtotime("$yearstart-$monthend-01");

        while ($start <= $end) {
            //debug(date('F Y', $start));
            $curmonth = date('m', $start);
            $curyear = date('Y', $start);
            $ymstr = date('F Y', $start);
            $start = strtotime("+1 month", $start);
            //debug($curyear." ".$curmonth);
            /*$data_O = $this->Post->find('count', array(
                'conditions' => array('Post.type' => 'O'),
            ));
            $data_D = $this->Post->find('count', array(
                'conditions' => array('Post.type' => 'D'),
            ));
            $data_H = $this->Transaction->find('all', array(
                'fields' => array('sum(Transaction.amount) as total_sum'),
            ));
            $data_M = $this->User->find('count', array(
                'conditions' => array(
                    'User.activated' => '1',
                    'AND'=>Configure::read('Admin.userstofilter')
                ),
            ));
            $data_AV = $this->Transaction->find('count', array(
                'conditions' => array('Transaction.message != ' => ""),
            ));
            $data_MSG = $this->Pm->find('count', array(
                'conditions' => array(),
            ));
            $data_total = array(
                'membres' => $data_M,
                'offres' => $data_O,
                'demandes' => $data_D,
                'celts' => $data_H[0][0]['total_sum'],
                'avis' => $data_AV,
                'messages' => $data_MSG,
            );*/

            $data_membres = $this->User->find('count', array(
                'conditions' => array(
                    'MONTH(User.created)' => $curmonth,
                    'YEAR(User.created)' => $curyear,
                    'User.activated' => 1,
                    'AND'=>Configure::read('Admin.userstofilter')
                ),
            ));

            $data_posts_O = $this->Post->find('count', array(
                'conditions' => array(
                    'MONTH(Post.created)' => $curmonth,
                    'YEAR(Post.created)' => $curyear,
                    'Post.type' => 'O',
                ),
            ));
            $data_posts_D = $this->Post->find('count', array(
                'conditions' => array(
                    'MONTH(Post.created)' => $curmonth,
                    'YEAR(Post.created)' => $curyear,
                    'Post.type' => 'D',
                ),
            ));
            $data_avis = $this->Transaction->find('count', array(
                'conditions' => array(
                    'MONTH(Transaction.created)' => $curmonth,
                    'YEAR(Transaction.created)' => $curyear,
                    'Transaction.message != ' => "",
                ),
            ));
            $data_messages = $this->Pm->find('count', array(
                'conditions' => array(
                    'MONTH(Pm.created)' => $curmonth,
                    'YEAR(Pm.created)' => $curyear,
                ),
            ));
            $data_celts = $this->Transaction->find('all', array(
                'conditions' => array(
                    'MONTH(Transaction.created)' => $curmonth,
                    'YEAR(Transaction.created)' => $curyear,
                    'AND' => array(
                        array('Transaction.user_id != ' => 0),
                        array('Transaction.to_userid != ' => 0)
                    )
                ),
                'fields' => array('sum(Transaction.amount) as total_sum'),
            ));
            array_push($finaldata['membres'],$data_membres);
            array_push($finaldata['labels'],$ymstr);
            array_push($finaldata['posts_O'],$data_posts_O);
            array_push($finaldata['posts_D'],$data_posts_D);
            array_push($finaldata['avis'],$data_avis);
            array_push($finaldata['messages'],$data_messages);
            array_push($finaldata['nbmonnaies'],$data_celts[0][0]['total_sum']);
            //array_push($finaldata, array('membres' => $data_membres, 'month' => $ymstr, 'posts_O' => $data_posts_O, 'posts_D' => $data_posts_D, 'avis' => $data_avis, 'messages' => $data_messages, 'nbmonnaies' => $data_celts[0][0]['total_sum']));
        }
        //$finaldata = array_reverse($finaldata);
       // $this->set('finaldata', $finaldata);
        //$this->set('totaux', $data_total);
        //debug($finaldata);exit;
        return json_encode($finaldata);
    }

    public function switch_offre_demande($post_id)
    {
        $this->loadModel('Post');
        $this->Post->contain();
        $chk = $this->Post->findById($post_id);
        if ($chk) {
            $this->Post->id = $chk['Post']['id'];
            $new_type = "O";
            if ($chk['Post']['type'] == "O") {$new_type = "D";}
            $this->Post->saveField('type', $new_type);
            $this->redirect($this->referer());
        }
    }


    public function admin_emails()
    {
        $this->loadModel('Mail');
        $this->Mail->contain();
        $allEmails = $this->Mail->find('all');
        $this->set('allEmails', $allEmails);
    }
    public function add_email()
    {
        if ($this->request->is('post')) {
            $this->loadModel('Mail');
            $this->Mail->save($this->data);
            $this->redirect($this->referer());
        }
    }
    public function remove_email($id)
    {
        $this->loadModel('Mail');
        $this->Mail->delete($id);
        $this->redirect($this->referer());
    }

    public function phpinfo() {
        //phpinfo();
    }
    public function admin_charte() {
        $ClientInfos = $this->getClientData();
        //debug(Configure::read('Common.ClientDefaults'));exit;
        if ($this->request->is('post')) {
            //debug($this->data);exit;
            $reqdata = $this->data;
            $typef = $reqdata['Admin']['typef'];
            $uniquestr = md5($ClientInfos['id']);
            if ($reqdata['Admin'][$typef]['name'] != '') {
                $ext = pathinfo($reqdata['Admin'][$typef]['name'], PATHINFO_EXTENSION);
                if (($ext != "") and (strtolower($ext) == 'pdf')) {
                    $filen = $typef.'.'. $uniquestr . '.pdf';
                    $source = WWW_ROOT . DIRECTORY_SEPARATOR . 'files/'.$filen;
                    $filename = $source;//debug($filename);exit;
                    $error = $reqdata['Admin'][$typef]['error'];
                    if (($error == 1)) {
                        $this->Session->setFlash(__("Erreur sur le fichier."), 'msg_alert');
                        $this->redirect(array('controller' => 'admins', 'action' => 'admin_accueil'));
                    }
                    move_uploaded_file($reqdata['Admin'][$typef]['tmp_name'], $filename);
                    //$this->Client->id = $ClientInfos['id'];
                    //$this->Client->saveField($typef, 'files/'.$filen);
                }
            }
            // Check files for each lang
            foreach ($this->alllang as $key => $lgname) {
                $lfield = "${typef}_".$lgname;
                if ($reqdata['Admin'][$lfield]['name'] != '') {
                    $ext = pathinfo($reqdata['Admin'][$lfield]['name'], PATHINFO_EXTENSION);
                    if (($ext != "") and (strtolower($ext) == 'pdf')) {
                        $filen = $lfield.'.'. $uniquestr . '.pdf';
                        $source = WWW_ROOT . DIRECTORY_SEPARATOR . 'files/'.$filen;
                        //debug($source);
                        $filename = $source;//debug($filename);exit;
                        $error = $reqdata['Admin'][$lfield]['error'];
                        //debug($reqdata['Admin'][$lfield]);
                        if (($error == 1)) {
                            $this->Session->setFlash(__("Erreur sur le fichier."), 'msg_alert');
                            $this->redirect(array('controller' => 'admins', 'action' => 'admin_accueil'));
                        }
                        move_uploaded_file($reqdata['Admin'][$lfield]['tmp_name'], $filename);
                    }
                }
            }
            //exit;
            $this->redirect(array('controller'=>'admins','action'=>'admin_charte'));
        }


    }

    public function admin_file($typef=null)
    {
        // Check if admin is authorized or not
        // The user arrives here only if admin or adminentreprise
        $error = 0;
        if ($this->Userinfo['role'] == "adminentreprise") {
            if ($typef!="charte_pdf") { // Only charte authoriszed for adminentreprise
                $error=1;
            }
        }
        if ($error == 1) {
            $this->Session->setFlash(__("Page non autorisée"), 'msg_alert');
            $this->redirect(array('controller' => 'admins', 'action' => 'admin_accueil'));
        }
        $ClientInfos = $this->getClientData();
        //debug($ClientInfos);exit;
        //debug($this->ClientDefaults);exit;
        //$this->set('TBPROClientDefault',Configure::read('Common.ClientDefaults'));
        //debug(Configure::read('Common.ClientDefaults'));exit;
        if ($this->request->is('post')) {
            $reqdata = $this->data;
            $typef = $reqdata['Admin']['typef'];
            $uniquestr = md5($ClientInfos['id']);
            if ($reqdata['Admin'][$typef]['name'] != '') {
                $ext = pathinfo($reqdata['Admin'][$typef]['name'], PATHINFO_EXTENSION);
                if (($ext != "") and (strtolower($ext) == 'pdf')) {
                    $filen = $typef.'.'. $uniquestr . '.pdf';
                    $source = WWW_ROOT . DIRECTORY_SEPARATOR . 'files/'.$filen;
                    $filename = $source;//debug($filename);exit;
                    $error = $reqdata['Admin'][$typef]['error'];
                    if (($error == 1)) {
                        $this->Session->setFlash(__("Erreur sur le fichier."), 'msg_alert');
                        $this->redirect(array('controller' => 'admins', 'action' => 'admin_accueil'));
                    }
                    move_uploaded_file($reqdata['Admin'][$typef]['tmp_name'], $filename);
                    //$this->Client->id = $ClientInfos['id'];
                    //$this->Client->saveField($typef, 'files/'.$filen);
                }
            }
            // Check files for each lang
            foreach ($this->alllang as $key => $lgname) {
                $lfield = "${typef}_".$lgname;
                if ($reqdata['Admin'][$lfield]['name'] != '') {
                    $ext = pathinfo($reqdata['Admin'][$lfield]['name'], PATHINFO_EXTENSION);
                    if (($ext != "") and (strtolower($ext) == 'pdf')) {
                        $filen = $lfield.'.'. $uniquestr . '.pdf';
                        $source = WWW_ROOT . DIRECTORY_SEPARATOR . 'files/'.$filen;
                        //debug($source);
                        $filename = $source;//debug($filename);exit;
                        $error = $reqdata['Admin'][$lfield]['error'];
                        //debug($reqdata['Admin'][$lfield]);
                        if (($error == 1)) {
                            $this->Session->setFlash(__("Erreur sur le fichier."), 'msg_alert');
                            $this->redirect(array('controller' => 'admins', 'action' => 'admin_accueil'));
                        }
                        move_uploaded_file($reqdata['Admin'][$lfield]['tmp_name'], $filename);
                    }
                }
            }
            //exit;
            $this->redirect(array('controller'=>'admins','action'=>'admin_file',$typef));
        }
        
        if ($typef == "cgu_pdf") $this->render('admin_cgu');
        if ($typef == "pdc_pdf") $this->render('admin_pdc');
        //if ($typef == "charte_pdf") $this->render('admin_charte');
        if ($typef == "notice_pdf") $this->render('admin_notice');
        if ($typef == "noticeadmin_pdf") $this->render('admin_noticeadmin');
        if ($typef == "doctech_pdf") $this->render('admin_doctech');
        if ($typef == "cgv_pdf") $this->render('admin_cgv');
        if ($typef == "marques_pdf") $this->render('admin_marques');
        if ($typef == "grille_pdf") $this->render('admin_grille');

    }


    public function admin_accueil() {
        $ClientInfos = $this->getClientData();
        $this->loadModel('Client');
        $this->set('TBPROClientDefault',Configure::read('Common.ClientDefaults'));
        if ($this->request->is('post')) {
            $this->Client->id = $ClientInfos['id'];
            $reqdata = $this->data;//debug($ClientInfos);debug($reqdata);exit;
            // -----------------------------------------------------
            // Manage topimage
            // -----------------------------------------------------
            if ($reqdata['Admin']['topimage_file']['name'] != '') {
                $newtopimage = $this->create_file($this->genidx('topimage'.$ClientInfos['id']),$reqdata['Admin'],'clients','topimage_file');
                if ($newtopimage) $this->Client->saveField('topimage', $newtopimage); 
            }
            // -----------------------------------------------------
            // Manage bottomimage
            // -----------------------------------------------------
            if ($reqdata['Admin']['bottomimage_file']['name'] != '') {
                $bottomimage = $this->create_file($this->genidx('bottomimage'.$ClientInfos['id']),$reqdata['Admin'],'clients','bottomimage_file');
                if ($bottomimage) $this->Client->saveField('bottomimage', $bottomimage); 
            }
            // -----------------------------------------------------
            // Manage Logo
            // -----------------------------------------------------
            if ($reqdata['Admin']['logo_file']['name'] != '') {
                // Copie de l'umage en lieu sur..
                $ext = pathinfo($reqdata['Admin']['logo_file']['name'], PATHINFO_EXTENSION);
                if ($ext != "") {
                    $img = 'logo.' . Date('U') . '.'. $ClientInfos['id']. '.' . $ext;
                    $source = WWW_ROOT . DIRECTORY_SEPARATOR . 'img/clients/'.$img;
                    $filename = $source ;
                    $error = $reqdata['Admin']['logo_file']['error'];
                    if (($error == 1)) {
                        $this->Session->setFlash(__("Erreur. L'image est trop grosse, veuillez la réduire"), 'msg_alert');
                        $this->redirect(array('controller' => 'admins', 'action' => 'admin_accueil'));
                    }
                    move_uploaded_file($reqdata['Admin']['logo_file']['tmp_name'], $filename);
                    //$image = new SimpleImage();
                    //$image->load($filename);
                    //$image->resize(96,96);
                    //$image->save($filename);
                    if (!empty($ClientInfos['logo'])) {
                        if (file_exists(WWW_ROOT . DIRECTORY_SEPARATOR . 'img/clients/'.$ClientInfos['logo'])) unlink(WWW_ROOT . DIRECTORY_SEPARATOR . 'img/clients/'.$ClientInfos['logo']);
                    }
                    $this->Client->id = $ClientInfos['id'];
                    $this->Client->saveField('logo', 'clients/'.$img);
                }
            }
            // -----------------------------------------------------
            // Manage CSS file
            // -----------------------------------------------------
            if ($reqdata['Admin']['css_file']['name'] != '') {
                // Copie de l'umage en lieu sur..
                $ext = pathinfo($reqdata['Admin']['css_file']['name'], PATHINFO_EXTENSION);
                if ($ext != "") {
                    $img = $ClientInfos['subdomain']. '.css';
                    $source = WWW_ROOT . DIRECTORY_SEPARATOR . 'css/clients/'.$img;
                    $filename = $source ;
                    $error = $reqdata['Admin']['css_file']['error'];
                    if (($error == 1)) {
                        $this->Session->setFlash(__("Erreur sur le fichier"), 'msg_alert');
                        $this->redirect(array('controller' => 'admins', 'action' => 'admin_accueil'));
                    }
                    move_uploaded_file($reqdata['Admin']['css_file']['tmp_name'], $filename);
                }
            }
            for ($idx=1; $idx <= 3; $idx++) { 
                $strimg = 'image'.$idx.'_file';
                if ($reqdata['Admin'][$strimg]['name'] != '') {
                    $ext = pathinfo($reqdata['Admin'][$strimg]['name'], PATHINFO_EXTENSION);
                    if ($ext != "") {
                        $img = 'image'.$idx.'.'. Date('U') . '.'. $ClientInfos['id']. '.' . $ext;
                        $filename = WWW_ROOT . DIRECTORY_SEPARATOR . 'img/clients/'.$img;
                        move_uploaded_file($reqdata['Admin'][$strimg]['tmp_name'], $filename);
                        $image = new SimpleImage();
                        $image->load($filename);
                        //$image->resizeToWidth(600);
                        //$image->resizeToHeight(400);
                        $image->resize(600,400);
                        $image->save($filename);

                        if (!empty($ClientInfos['image'.$idx])) {
                            if (file_exists(WWW_ROOT . DIRECTORY_SEPARATOR . 'img/clients/'.$ClientInfos['image'.$idx])) unlink(WWW_ROOT . DIRECTORY_SEPARATOR . 'img/clients/'.$ClientInfos['image'.$idx]);
                        }
                        $this->Client->id = $ClientInfos['id'];
                        $this->Client->saveField('image'.$idx, 'clients/'.$img);
                    }
                }
            }
            //debug($reqdata['Admin']);//exit;
            $this->Client->id = $ClientInfos['id'];
            $this->Client->saveField('baseline', $reqdata['Admin']['baseline']);
            $this->Client->saveField('titre1', $reqdata['Admin']['titre1']);
            $this->Client->saveField('texte1', $reqdata['Admin']['texte1']);
            $this->Client->saveField('titre2', $reqdata['Admin']['titre2']);
            $this->Client->saveField('texte2', $reqdata['Admin']['texte2']);
            $this->Client->saveField('video1', $reqdata['Admin']['video1']);
            $this->Client->saveField('texte3', $reqdata['Admin']['texte3']);
            $this->Client->saveField('video2', $reqdata['Admin']['video2']);
            $this->Client->saveField('img_footer_url', $reqdata['Admin']['img_footer_url']);
            for ($i=1; $i <= 6 ; $i++) { 
                $this->Client->saveField('ccmpart'.$i, $reqdata['Admin']['ccmpart'.$i]);
            }

            //debug($reqdata['Admin']);
            //debug(Configure::read('Common.ClientfieldsToCheck'));
            foreach (Configure::read('Common.ClientfieldsToCheck') as $tmpvalue) {
                list($value) = explode("#",$tmpvalue); // second part is not used in save
                foreach ($this->alllang as $key => $lgname) {
                    $lfield = "${value}_".$lgname;
                    //debug($lfield);
                    //debug($reqdata['Admin'][$lfield]);
                    $filepath = APP."Clients/home_".$this->CID."_${value}.${lgname}.lang";
                    if (isset($reqdata['Admin'][$lfield])) {
                        if (!empty(trim($reqdata['Admin'][$lfield]))) {
                            file_put_contents($filepath,$reqdata['Admin'][$lfield]);
                        } else {
                            if (file_exists($filepath)) unlink($filepath);
                        }
                    }
                    // Delete if FRA = empty
                    //if (isset($reqdata['Admin'][$lfield]) and empty(trim($reqdata['Admin'][$value]))) {
                    //   unlink($filepath);
                    //}
                }
            }
            //$this->Client->saveField('urlccm', $reqdata['Admin']['urlccm']);
            $this->redirect(array('controller' => 'admins', 'action' => 'admin_accueil'));
        }

    }
    
    public function admin_priority() {
        $cfgclient = $this->getClientData();
        $this->set('defval',$cfgclient['priority']);
        $this->set('radiooptions',array('O' => 'Offres', 'D' => 'Demandes'));
    }
    public function setPriority($priority="O") {
        $this->loadModel('Client');
        $ClientInfos = $this->getClientData();
        $this->Client->id = $ClientInfos['id'];
        if (($priority == "O") or ($priority == "D")) {
            $this->Client->saveField('priority',$priority);
        }
        $this->autoRender = false;
        return "done";
    }   

    public function toggleActivated($what,$value) {
        $this->loadModel('Client');
        $ClientInfos = $this->getClientData();
        $this->Client->id = $ClientInfos['id'];
        if (($value == true) or ($value == false)) {
            $valact=true;
            if ($value=="false") $valact=false;
            $this->Client->saveField($what.'_activated',$valact);
        }
        $this->autoRender = false;
        return "done";
    }

    public function toggleOrderDone($tid) {
        $this->loadModel('Transaction');
        $this->autoRender = false;
        $this->Transaction->contain();
        // Find the first transaction
        $res = $this->Transaction->findById($tid);
        if ($res) {
            $this->Transaction->updateAll(
                array('Transaction.done' => !$res['Transaction']['done']),
                array('Transaction.message' => $res['Transaction']['message'])
            );
            return "done";
        } 
        return "done";
    }

    public function toggleField($field,$vid) {
        $this->loadModel('Vente');
        $this->autoRender = false;
        $this->Vente->contain();
        // Find the first transaction
        $res = $this->Vente->findById($vid,array($field));
        $this->Vente->id = $vid;
        $this->Vente->saveField($field,!$res['Vente'][$field]); 
        return "done";
    }


    public function admin_extract() {

    }

    public function admin_extract_go() {
        $this->loadModel('User');
        $this->loadModel('Transaction');
        $this->autoRender = false;
        $this->User->contain();
        $chk = $this->User->find('all',array(
            'conditions' => array(
                'AND' => array(
                    array('User.email NOT LIKE' => '%dguillerm%@gmail.com'),
                    array('User.email NOT LIKE' => '%ph.bouille%@gmail.com')
                )
            ),
        ));
        if ($chk) {
            $result = "";
            foreach ($chk as $curemail) {
                $this->Transaction->contain();
                $buyed = $this->Transaction->find('count',array(
                    'conditions' => array(
                        'Transaction.user_id' => $curemail['User']['id']
                    )
                ));
                $sold = $this->Transaction->find('count',array(
                    'conditions' => array(
                        'Transaction.to_userid' => $curemail['User']['id']
                    )
                ));
                //debug($sold);//exit;
                $result .= $curemail['User']['email'].";";
                $result .= $curemail['User']['nom'].";";
                $result .= $curemail['User']['prenom'].";";
                $result .= $sold." ".__("ventes").";";
                $result .= $buyed." ".__("achats").";\n";
            }
            //exit;
            $this->response->body($result);
            $this->response->type('csv');   
            $this->response->download('MailExtract.csv');
            //debug($chk);exit;
            return $this->response;
        } else {
            $this->Session->setFlash(__("Pas d'emails trouvé."), 'msg_alert');
            $this->redirect($this->referer());
        }
        //debug($chk);
    }

    public function admin_extract_echanges() {
        $this->loadModel('Transaction');
        $this->autoRender = false;
        $chk = $this->Transaction->find('all',array(
            'conditions' => array(
                //'AND' => array(
                //    array('User.email NOT LIKE' => '%dguillerm%@gmail.com'),
                //    array('User.email NOT LIKE' => '%ph.bouille%@gmail.com')
                //)
            )
        ));
        //debug($chk);
        if ($chk) {
            $result = __("Commande").";".__("Statut").";".__("Date").";".__("De").";".__("Email").";".__("Vers").";".__("Montant").";".__("Titre")."\n";
            foreach ($chk as $curtransaction) { 
                $result .= $curtransaction['Transaction']['message'].";";
                $status = __("Traitée");
                if ($curtransaction['Transaction']['done']==0) {
                    $status = __("A traiter");
                }
                $result .=  $status.";";
                $result .= date("d/m/Y",strtotime($curtransaction['Transaction']['created'])).";";

                if ($curtransaction['Transaction']['user_id']==-1) 
                    $result .=  __("Administrateur");
                elseif (is_null($curtransaction['User']['id']) && $curtransaction['Transaction']['user_id'] != 0 )
                    $result .=  __("Utilisateur inconnu");
                elseif ($curtransaction['User']['id'] == 0) 
                    $result .=  __("Compte Braderie");
                else 
                    $result .=  $curtransaction['User']['prenom']." ".$curtransaction['User']['nom'];                
                $result .= ";";

                $result .= $curtransaction['User']['email'] .";";

                if (is_null($curtransaction['UserTo']['id']) && $curtransaction['Transaction']['to_userid'] != 0)
                    $result .=  __("Utilisateur inconnu");
                elseif ($curtransaction['UserTo']['id']== 0) 
                    $result .=  __("Compte Braderie");
                else 
                    $result .=  $curtransaction['UserTo']['prenom']." ".$curtransaction['UserTo']['nom'];
                $result .= ";";


                $result .= $curtransaction['Transaction']['amount'].";";
                $result .= $curtransaction['Transaction']['post_titre'].";";  
                $result .= "\n";
            }
            $this->response->body($result);
            $this->response->type('csv');   
            $this->response->download('EchangesExtract.csv');
            //debug($chk);exit;
            return $this->response;
        } else {
            $this->Session->setFlash(__("Pas d'échanges trouvés."), 'msg_alert');
            $this->redirect($this->referer());
        }        
    }

    public function cities_search($search)
    {
        $this->loadModel('City');
        $this->City->contain('Country');
        $ret_city = $this->City->find('all', array(
            'conditions' => array(
                'OR' => array(
                    array('ville_nom LIKE ' => "$search%"),
                    array('ville_nom_reel LIKE ' => "$search%"),
                    array('ville_code_postal LIKE ' => "$search%"),
                ),
            ),
            'order' => array('ville_nom_reel ASC'),
            'limit' => 12,
            'fiselds' => array('City.id', 'ville_nom_reel', 'ville_nom','Country.shortname'),
        ));
        //debug($ret_city);
        $array_cities_final = array();
        foreach ($ret_city as $curcity) {
            array_push($array_cities_final, array(
                'id' => $curcity['City']['id'],
                'nom' => $curcity['City']['ville_nom_reel'],
                'country' => $curcity['Country']['shortname'],
                //'cp' => $curcity['City']['ville_code_postal'],
            ));
        }
        $this->autoRender = false;
        return json_encode($array_cities_final);
    }


    public function admin_challenges()
    {
        if ($this->request->is('post')) {
            //debug($this->data);exit;  
            $tmpdata = $this->data;
            // Save the icon to client table
            if ($tmpdata['Admin']['icone_challenge'] != '') {
                // Copie de l'umage en lieu sur..
                $ext = pathinfo($tmpdata['Admin']['icone_challenge']['name'], PATHINFO_EXTENSION);
                //debug($ext);exit;
                if ($ext != "") {
                    $img = time();
                    $source = WWW_ROOT . DIRECTORY_SEPARATOR . 'img/challenges/' . $img;
                    $filename = $source . '.' . $ext;
                    move_uploaded_file($tmpdata['Admin']['icone_challenge']['tmp_name'], $filename);
                    /*$image = new SimpleImage();
                    $image->load($filename);
                    //$image->resizeToWidth(600);
                    $image->save($filename,IMAGETYPE_PNG);*/
                    $this->loadModel('Client');
                    //debug($img. '.' . $ext);exit;
                    $cl  = $this->getClientData();
                    $clid = $cl['id'];
                    $this->Client->id = $clid;
                    $this->Client->saveField('icone_challenge',$img. '.' . $ext); 
                    $this->redirect(array('controller' => 'admins', 'action' => 'admin_challenges'));  // Mandatory                     
                }
            }
        }
    }


    public function admin_challenges_create()
    {
        $this->check_activated('challenges_activated');
        $this->loadModel('Challenge');
        $ret = $this->Challenge->find('all');
        $this->set('all_challenges', $ret);
    }

    public function admin_challenge_categories($challidx=null)
    {
        if ($challidx==null) $this->redirect(array('controller'=>'admins','action'=>'admin_challenges_create'));
        $this->loadModel('Challenge');
        $ret = $this->Challenge->findByIdx($challidx);
        $this->set('all_cat', $ret['Challengescategory']);
        $this->set('challenge_idx',$challidx);
    }

    private function isCategoryOwner($challidx,$catid) {
        // Check if user can edit this category
        $this->loadModel('Challengescategory');
        $this->loadModel('Challenge');
        $cchall = $this->Challenge->findByIdx($challidx);
        // Check if Category belong to a challenge from user client
        $chkcategory = $this->Challengescategory->findByIdAndChallengeId($catid,$cchall['Challenge']['id']);
        //debug($challidx);debug($catid);
        //debug($chkcategory);exit;
        if (!$chkcategory) $this->redirect(array('controller'=>'admins','action'=>'admin_challenge_categories'));            
        // Check if user can modify this category
        $cl  = $this->getClientData();
        $clid = $cl['id'];
        $this->loadModel('Challenge');
        $chkchall = $this->Challenge->findByIdxAndClientId($challidx,$clid);
        if (!$chkchall) $this->redirect(array('controller'=>'admins','action'=>'admin_challenge_categories'));
        return  $chkcategory;               
    }

    public function admin_projects() {
        $this->loadModel('Project');
        $this->Project->contain('Challenge');
        $allprojects = $this->Project->find('all',array(
            'conditions' => array(
            ),
            'fields' => array('id','user_id','idx','name','description','image','logo','selected'),
            'contain' => array(
                'Challenge' => array(
                    'fields' => array('id','idx','name','image')
                ),
                'User' => array(
                    'fields' => array('id','nom','prenom','city_id'),
                    'City' => array(
                        'fields' => 'ville_nom_reel'
                    )
                )
            )
        ));
        $this->set('count_projects',count($allprojects));
        $this->set('allprojects',$allprojects);
        //debug($allprojects);exit;
    }

    public function admin_lang() {
        $this->verif_admin(true); // Only full admin
        $langs_client = unserialize($this->getClientData('langs'));
        
        //debug($langs_client);
        if ($this->request->is('post')) {
            $lng_validated  = false;
            // set all false
            foreach ($langs_client as $key => $value) {
                $langs_client[$key] = false;
            }
            if ($this->data['selectedlangs']!='') {
                foreach ($this->data['selectedlangs'] as $curl) {
                    $langs_client[$curl] = true;
                    $lng_validated  = true;
                }
            } else {
                $langs_client['fr'] = true; // Force FR if no lang selected
            }
            $this->Client->id = $this->CID;
            $this->Client->saveField('langs',serialize($langs_client));
        }
        $alllng = Configure::read('Config.languages');
        unset($alllng['home']);
        $allnames = Configure::read('Config.langnames');
        // Create array for form cakephp
        $finallang = array();
        $finallang_selected = array();
        foreach ($alllng as $name => $value) {
            $finallang[$name] = $allnames[$name];
            if ($langs_client[$name]) {
                array_push($finallang_selected,$name);
            }
        }
        $this->set('finallang',$finallang);
        $this->set('finallang_selected',$finallang_selected);
        //debug($finallang);debug($finallang_selected);exit;
        
    }

    public function admin_typesite() {

    }


    public function admin_criteres()
    {
        $this->loadModel('Critere');
        $ret = $this->Critere->find('all',array(
            'order'=>array('Critere.porder'),
            'contain' => array(
                'Tag' => array('order'=>array('porder','name'))
            )
        ));
        //debug($ret);exit;
        $this->set('all_criteres', $ret);
    }

    public function CreateEditCritere()
    {
        $this->loadModel('Critere');
        //debug($this->data);exit;
        if (isset($this->data['Critere']['id'])) {
            $this->Critere->id = $this->data['Critere']['id'];
        } else {
            $this->Critere->create();
        }
        if ($this->Critere->save($this->data)) {
            $this->Session->setFlash(__("Création du critère ok"), 'msg_success');
        } else {
            $this->Session->setFlash(__("Erreur lors de la création du critère"), 'msg_alert');
        }
        $this->redirect(array('controller' => 'admins', 'action' => 'admin_criteres'));

    }

    public function CreateEditTag()
    {
        $this->loadModel('Tag');
        $this->loadModel('CritereTag');
        //debug($this->data);exit;
        
        if (isset($this->data['Tag']['id'])) {
            $this->Tag->id = $this->data['Tag']['id'];
        } else {
            $this->Tag->create();
        }
        if ($this->Tag->save($this->data)) {
            if (isset($this->data['Tag']['id'])) {
                // modification
                $this->Session->setFlash(__("Modification de l'item ok"), 'msg_success');
            } else {
                // Creation
                $this->CritereTag->create();
                $this->CritereTag->save(
                    array('CritereTag' => array(
                        'tag_id' => $this->Tag->id,
                        'critere_id' => $this->data['Tag']['critere_id']
                        )
                        )
                    );
                $this->Session->setFlash(__("Création de l'item ok"), 'msg_success');
            }
        } else {
            $this->Session->setFlash(__("Erreur lors de la création de l'item"), 'msg_alert');
        }
        $this->redirect(array('controller' => 'admins', 'action' => 'admin_criteres'));

    }

}
