<?php

/**
 * Application level Controller
 *
 * This file is application-wide controller file. You can put all
 * application-wide controller-related methods here.
 *
 * CakePHP(tm) : Rapid Development Framework (http://cakephp.org)
 * Copyright (c) Cake Software Foundation, Inc. (http://cakefoundation.org)
 *
 * Licensed under The MIT License
 * For full copyright and license information, please see the LICENSE.txt
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright     Copyright (c) Cake Software Foundation, Inc. (http://cakefoundation.org)
 * @link          http://cakephp.org CakePHP(tm) Project
 * @package       app.Controller
 * @since         CakePHP(tm) v 0.2.9
 * @license       http://www.opensource.org/licenses/mit-license.php MIT License
 */

App::uses('Controller', 'Controller');
App::uses('CakeEmail', 'Network/Email');

require_once('vendor/autoload.php');

/**
 * Application Controller
 *
 * Add your application-wide methods in the class below, your controllers
 * will inherit them.
 *
 * @package        app.Controller
 * @link        http://book.cakephp.org/2.0/en/controllers.html#the-app-controller
 */
class AppController extends Controller
{

    public $components = array(
        'Stripe','Flash', 'Session', 'Cookie', 'Paginator','RequestHandler',
        'Auth' => array(
            'loginRedirect' => array('controller' => 'pages', 'action' => 'display', 'accueil'),
            //'loginRedirect' => array('controller' => 'users', 'action' => 'index'),
            'logoutRedirect' => array('controller' => 'pages', 'action' => 'display', 'accueil'),
            'authError' => '',
            'authenticate' => array(
                'Form' => array(
                    'fields' => array('username' => 'email'),
                    //'passwordHasher' => 'Blowfish'
                    //'passwordHasher' => array(
                    //        'className' => 'Simple',
                    //        'hashType' => 'sha256'
                    //    )
                ),
            ),
            //'authorize' => array('Controller')
        ),
    );

	public function beforeRender() {
		parent::beforeRender();
		$this->is_mobile = false;
		if ($this->RequestHandler->isMobile()) {
			$this->is_mobile = true;
        }
        $this->set('is_mobile',$this->is_mobile);
	}

    public function h($text, $double = true, $charset = null)
    {
        if (is_string($text)) {
            //optimize for strings
        } elseif (is_array($text)) {
            $texts = array();
            foreach ($text as $k => $t) {
                $texts[$k] = $this->h($t, $double, $charset);
            }
            return $texts;
        } elseif (is_object($text)) {
            if (method_exists($text, '__toString')) {
                $text = (string) $text;
            } else {
                $text = '(object)' . get_class($text);
            }
        } elseif (is_bool($text)) {
            return $text;
        }

        static $defaultCharset = false;
        if ($defaultCharset === false) {
            $defaultCharset = Configure::read('App.encoding');
            if ($defaultCharset === null) {
                $defaultCharset = 'UTF-8';
            }
        }
        if (is_string($double)) {
            $charset = $double;
        }
        //return htmlspecialchars($text, ENT_QUOTES, ($charset) ? $charset : $defaultCharset, $double);
        return htmlspecialchars($text, ENT_NOQUOTES, 'UTF-8');
    }

    public function HV($thedata)
    {
        $tmp = $thedata;
        foreach ($tmp as $k => $v) {
            //$tmp[$k] = h($v);
            //debug($v);
            //debug(h($v));
            //debug($this->h($v));
            //$tmp[$k] = htmlentities($v, ENT_QUOTES, 'UTF-8');
            $tmp[$k] = $this->h($v);
        }
        return $tmp;
    }

    public function multiexplode ($delimiters,$string) {
        $ready = str_replace($delimiters, $delimiters[0], $string);
        $launch = explode($delimiters[0], $ready);
        return  $launch;
    }

    public function getClientData($field2get=null)
    {
        if ($field2get == null) return Configure::read('Common.client');
        return Configure::read('Common.client.'.$field2get);
    }


    function check_language_browser($langues) {
        
        // Langue accepted
        if (isset($_SERVER['HTTP_ACCEPT_LANGUAGE'])) {
            $languageaccept = explode(',',$_SERVER['HTTP_ACCEPT_LANGUAGE']);
            //debug($languageaccept);
            $langue_code_full = $languageaccept[0];
            $langue_code_separate = explode('-',$langue_code_full);
            // debug($langue_code_separate);
            $langue_code = $langue_code_separate[0];
            //debug($langue_code);
            //debug($langues);
            if (!isset($langues[$langue_code])) {
                $langue_code = 'fr';
            }
            //debug("Init langue : ".$langue_code);
            return($langue_code);
       } else {
            return('fr');
       }
    }
    
    function genidx($str) {
        return md5($str.Configure::read('Common.apikey'));
    }

    public function check_file_extension($ext) {
        if ((strtolower($ext) == "png") || (strtolower($ext) == "jpg") || (strtolower($ext) == "jpeg") || (strtolower($ext) == "pdf")) {
            return true;
        }
        $this->Session->setFlash(__("Erreur sur le format du fichier"), 'msg_alert');
        $this->redirect($this->referer());
        return false;
    }


    public function getImageOrientation($filename) {
        $deg = 0;
        //debug(function_exists('exif_read_data'));exit;
        if (function_exists('exif_read_data')) {
          $exif = exif_read_data($filename);
          if($exif && isset($exif['Orientation'])) {
            $orientation = $exif['Orientation'];
            if($orientation != 1){
              //$img = imagecreatefromjpeg($filename);
              
              switch ($orientation) {
                case 3:
                  $deg = 180;
                  break;
                case 6:
                  $deg = 270;
                  break;
                case 8:
                  $deg = 90;
                  break;
              }
              //if ($deg) {
              //  $img = imagerotate($img, $deg, 0);        
              //}
              // then rewrite the rotated image back to the disk as $filename 
              //imagejpeg($img, $filename, 95);
            } // if there is some rotation necessary
          } // if have the exif orientation info
        } // if function exists   
        return $deg;   
      }

    /**
     * easy image resize function
     * @param  $file - file name to resize
     * @param  $string - The image data, as a string
     * @param  $width - new image width
     * @param  $height - new image height
     * @param  $proportional - keep image proportional, default is no
     * @param  $output - name of the new file (include path if needed)
     * @param  $delete_original - if true the original image will be deleted
     * @param  $use_linux_commands - if set to true will use "rm" to delete the image, if false will use PHP unlink
     * @param  $quality - enter 1-100 (100 is best quality) default is 100
     * @param  $grayscale - if true, image will be grayscale (default is false)
     * @return boolean|resource
     */
    public function smart_resize_image($file,
        $string = null,
        $width = 0,
        $height = 0,
        $proportional = false,
        $output = 'file',
        $delete_original = true,
        $use_linux_commands = false,
        $quality = 100,
        $grayscale = false
        ) {

        if ($height <= 0 && $width <= 0) {
            return false;
        }

        if ($file === null && $string === null) {
            return false;
        }

        # Setting defaults and meta
        $info = $file !== null ? getimagesize($file) : getimagesizefromstring($string);
        $image = '';
        $final_width = 0;
        $final_height = 0;
        list($width_old, $height_old) = $info;
        $cropHeight = $cropWidth = 0;


        # Calculating proportionality
        if ($proportional) {
            if ($width == 0) {
                $factor = $height / $height_old;
            } elseif ($height == 0) {
                $factor = $width / $width_old;
            } else {
                $factor = min($width / $width_old, $height / $height_old);
            }

            $final_width = round($width_old * $factor);
            $final_height = round($height_old * $factor);
        } else {
            $final_width = ($width <= 0) ? $width_old : $width;
            $final_height = ($height <= 0) ? $height_old : $height;
            $widthX = $width_old / $width;
            $heightX = $height_old / $height;

            $x = min($widthX, $heightX);
            $cropWidth = ($width_old - $width * $x) / 2;
            $cropHeight = ($height_old - $height * $x) / 2;
        }

        # Loading image to memory according to type
        switch ($info[2]) {
            case IMAGETYPE_JPEG:$file !== null ? $image = imagecreatefromjpeg($file) : $image = imagecreatefromstring($string);
                break;
            case IMAGETYPE_GIF:$file !== null ? $image = imagecreatefromgif($file) : $image = imagecreatefromstring($string);
                break;
            case IMAGETYPE_PNG:$file !== null ? $image = imagecreatefrompng($file) : $image = imagecreatefromstring($string);
                break;
            default:return false;
        }

        $chkdeg = false;
        if ($info[2]==IMAGETYPE_JPEG) { // Only available exif for JPG
            $chkdeg = $this->getImageOrientation($file);
            if ($chkdeg) {
                $image = imagerotate($image, $chkdeg, 0);
                $cropped = imagecropauto($image , IMG_CROP_THRESHOLD, null, 0);
                if ($cropped !== false) { // in case a new image resource was returned
                    imagedestroy($image);    // we destroy the original image
                    $image = $cropped;       // and assign the cropped image to $im
                }
                $currentwidth = imagesx($image);
                $currentheight = imagesy($image);
                // Need to create a $width/height image
                // scale the current image height $height
                $scalingFactor = $height / $currentheight;
                // When having the scaling factor just calculate the new width of the image:
                $newImageHeight = $height;
                $newImageWidth = $currentwidth * $scalingFactor;
                //debug("$newImageWidth x $newImageHeight");
                // scale the image
                $newimg = imagescale($image,$newImageWidth,$newImageHeight);
                //create an image $width x $height
                $boximg = imagecreatetruecolor($width, $height);
                // sets background to red
                $color = imagecolorallocate($boximg, 255, 255, 255);
                imagefill($boximg, 0, 0, $color);
                $posx = $width/2 - $newImageWidth/2;
                imagecopy($boximg, $newimg, $posx, 0, 0, 0, $newImageWidth, $newImageHeight);
                $image = $boximg;
                //exit;

                //$final_width = $height;
                //$final_height = -1; // This makes work !, but errors on below function
                //debug($cropped);
                //debug($final_width);
                //debug($final_height);
                //exit;
                //Configure::write('debug',0); // Avoid break on dev 
            }
        }


        # Making the image grayscale, if needed
        if ($grayscale) {
            imagefilter($image, IMG_FILTER_GRAYSCALE);
        }
        if (!$chkdeg) {
            # This is the resizing/resampling/transparency-preserving magic
            $image_resized = imagecreatetruecolor($final_width, $final_height);
            if (($info[2] == IMAGETYPE_GIF) || ($info[2] == IMAGETYPE_PNG)) {
                $transparency = imagecolortransparent($image);
                $palletsize = imagecolorstotal($image);

                if ($transparency >= 0 && $transparency < $palletsize) {
                    $transparent_color = imagecolorsforindex($image, $transparency);
                    $transparency = imagecolorallocate($image_resized, $transparent_color['red'], $transparent_color['green'], $transparent_color['blue']);
                    imagefill($image_resized, 0, 0, $transparency);
                    imagecolortransparent($image_resized, $transparency);
                } elseif ($info[2] == IMAGETYPE_PNG) {
                    imagealphablending($image_resized, false);
                    $color = imagecolorallocatealpha($image_resized, 0, 0, 0, 127);
                    imagefill($image_resized, 0, 0, $color);
                    imagesavealpha($image_resized, true);
                }
            }
            imagecopyresampled($image_resized, $image, 0, 0, $cropWidth, $cropHeight, $final_width, $final_height, $width_old - 2 * $cropWidth, $height_old - 2 * $cropHeight);
        } else {
            $image_resized = $boximg;
        }
        # Taking care of original, if needed
        if ($delete_original) {
            if ($use_linux_commands) {
                exec('rm ' . $file);
            } else {
                @unlink($file);
            }
        }
        //$image_resized = $boximg;
        # Preparing a method of providing result
        switch (strtolower($output)) {
            case 'browser':
                $mime = image_type_to_mime_type($info[2]);
                header("Content-type: $mime");
                $output = null;
                break;
            case 'file':
                $output = $file;
                break;
            case 'return':
                return $image_resized;
                break;
            default:
                break;
        }
      

        
        # Writing image according to type to the output destination and image quality
        switch ($info[2]) {
            case IMAGETYPE_GIF:imagegif($image_resized, $output);
                break;
            case IMAGETYPE_JPEG:imagejpeg($image_resized, $output, $quality);
                break;
            case IMAGETYPE_PNG:
                $quality = 9 - (int) ((0.9 * $quality) / 10.0);
                imagepng($image_resized, $output, $quality);
                break;
            default:return false;
        }

        // Check image rotation
       

        return true;
    }


    public function create_file($uniqid,$formdata,$directory,$field,$resize=false) {
        //debug($formdata);exit;
        if ($formdata[$field]['name'] != '') {
            // Copie de l'umage en lieu sur..
            $ext = pathinfo($formdata[$field]['name'], PATHINFO_EXTENSION);
            //debug($formdata);debug($ext);//exit;
            if ($this->check_file_extension($ext)) {
                //$formdata[$dbfield] = "autres.png";
                // Un nom d'image en timestamp
                $img = $uniqid;
                $source = WWW_ROOT . DIRECTORY_SEPARATOR . 'img/'.$directory.'/' . $img;
                $filename = $source . '.' . $ext;
                move_uploaded_file($formdata[$field]['tmp_name'], $filename);
                //debug($resize);//exit;
                if ($resize) {
                    $this->smart_resize_image($filename, null, 600, 450, false, $filename, false, false, 100);
                }
                //debug($filename);exit;
                $newfilename4db = $img . '.' . $ext;
                //debug($newfilename4db);exit;
                return $newfilename4db;
            }
        }
        return null;
    }

    public function beforeFilter()
    {


        $this->Cookie->key = 'qSI23983z6e62qs*&sXOw!adreghlkdfmlgkpoekgs4352345345%@34SAv!@*(XSL#$%)asGb$@11~_+!@#HKis~#^';
        //$this->Cookie->httpOnly = true;

        $this->Cookie->time = 3600*24*30;

        //$this->AllCountriesList = $this->get_all_countries_as_list();
        //Switch vers ville plus bas

        //$this->loadModel('Cart');		
		$this->set('cartCountProduct',$this->getCount());
        $this->set('cartProducts',$this->readProduct());
        $action = $this->request->params['action'];
        if ($action != "add_client") {
            //Configure::write('debug',2);
            // Get URL and check if it is a client
            $url = Router::fullbaseUrl();
            if (strstr($_SERVER['REQUEST_URI'],'phcompany')) {
                $url =  $_SERVER['REQUEST_URI']; // Env sur C9.io
            }
            if (strstr($_SERVER['REQUEST_URI'],'davcompany')) {
                $url =  $_SERVER['REQUEST_URI']; // Env sur C9.io
            }
            //debug($_SERVER['REQUEST_URI']);exit;
            //debug($_SERVER['REQUEST_URI']);
            //$subdomainarr = explode('/',$_SERVER['REQUEST_URI']);
            //$subdomain = $subdomainarr[1];
            //Configure::write('Common.subdomain',$subdomain);
            //debug(Configure::read('Common.ClientDefaults'));exit;
            $ClientDefaults = Configure::read('Common.ClientDefaults');//debug($ClientDefaults);
            $this->loadModel('Client');
            $allClients = $this->Client->find('all');
            $clientfound = false; //debug($url);exit;
            foreach ($allClients as $curClient) {
                $cldomain = $curClient['Client']['subdomain'];
                $monnaie_name_custom = false;
                //debug($curClient);
                //debug($url);debug($cldomain);
                if (strstr($url, $cldomain)) {
                    // -----------------------------------------------------------
                    // CLIENT FOUND
                    // -----------------------------------------------------------
                    //debug($curClient['Client']);
                    if (!empty($curClient['Client']['monnaie_name'])) {
                        configure::write('Common.monnaie.name',trim($curClient['Client']['monnaie_name']));
                        $monnaie_name_custom = true;
                    }   
                    $clientfound = true;
                    if ($_SERVER['HTTP_HOST']=="lbdp") {
                        Configure::write('Common.topurl', 'http://lbdp/trockee.com');
                    } else {
                        Configure::write('Common.topurl', 'https://' . $cldomain . '.trockee.com');
                    }
                    Configure::write('Common.client', $curClient['Client']);//debug($curClient['Client']);
                    Configure::write('Common.logoBL',"TrockeeBL.png");
                    Configure::write('Common.logoBL_size',300);
                    Configure::write('Common.logo4mail',"logo4mail.jpg");
                    Configure::write('Reseau', array(
                        'city_id' => 100000,
                        'user_id' => 0,
                        )
                    );
                    
                    // For requests
                    $this->CID = $curClient['Client']['id'];
                    $alllang = Configure::read('Config.languages.home');
                    //debug($alllang);exit;
                    // ---------------------------------------------------------------------
                    $langs_client = unserialize($this->getClientData('langs'));
                    if ((!$langs_client)) { // No lang specific for client, so set all
                        foreach (Configure::read('Config.languages') as $curl => $dummy) {
                            $langs_client[$curl] = true;
                        }
                        unset($langs_client['home']);
                        $this->Client->id = $this->CID;
                        $this->Client->saveField('langs',serialize($langs_client));
                    } else {
                        // readjust the lang variable for admin panel
                        foreach ($alllang as $clang => $value) {
                            if (!$langs_client[$clang]) {
                                unset($alllang[$clang]);
                            }
                        }
                    }
                    $this->set('langs_client',$langs_client);
                    $this->set('alllang',$alllang);
                    $this->alllang = $alllang;
                    // ---------------------------------------------------------------------
                    // Set the current lang
                    // ---------------------------------------------------------------------
                    if ($this->Cookie->check('Config.language')) {
                        $curlang = $this->Cookie->read('Config.language');
                    } else {
                        $langue_code = $this->check_language_browser(Configure::read('Config.languages'));
                        $curlang = Configure::read('Config.languages')[$langue_code];
                    }
                    //debug($langs_client);
                    //debug($curlang);exit;
                    // check now if user curlang is available on the website
                    //debug($alllang);
                    $foundlng = false;
                    $idx=0;
                    $firstlng = "fra"; // by default
                    foreach ($langs_client as $shortlng => $activated) {
                        $vallng = Configure::read('Config.languages.'.$shortlng);
                        if ($activated) {
                            if ($vallng==$curlang) {
                                $foundlng = true;
                            }
                        }
                        if ($idx==0) $firstlng = $vallng;
                        $idx++;
                    }
                    if (!$foundlng) {
                        // not found so set lang to the first one
                        $curlang = $firstlng;
                    }
                    //debug($curlang);exit;
                    if ($curlang=="") $curlang="fra";
                    //debug($curlang);exit;
                    Configure::write('Config.language',$curlang);
                    $this->set('lang',$curlang);
                    foreach (Configure::read('Config.languages') as $curcode => $value) {
                        if ($value==$curlang) {
                            Configure::write('Config.lang_code',$curcode); // for google place
                        }
                    }
                    $this->set('VideoYoutubeId',Configure::read('Common.VideoUrlId.'.$curlang));
                    //debug($this->params);exit;
                    if (isset($this->params) && isset($this->params['catid'])) {
                        $this->AllCountriesList = $this->get_all_cities_as_list($this->params['catid']);
                    } else {
                        $this->AllCountriesList = $this->get_all_cities_as_list();
                    }
                    
                    $this->set('AllCountries', $this->AllCountriesList);

                    $this->loadModel('Category');
                    $this->Category->contain();
                    $all_categories = $this->Category->find('all', array(
                        'conditions' => array(),
                        'order' => 'Category.id',
                        'fields' => array('id','name')
                    ));
                    $this->set('global_categories', $all_categories);
                    $uniquestr = md5($curClient['Client']['id']);
                    // check defaults
                    //debug(Configure::read('Common.ClientfieldsToCheck'));
                    foreach (Configure::read('Common.ClientfieldsToCheck') as $tmpvalue) {
                        $value = $tmpvalue;
                        $mustNotEmpty = false;
                        if (strstr($tmpvalue,"#")) {
                            list($value,$mustNotEmpty) = explode("#",$tmpvalue);
                        }
                        
                        //debug($value);
                        //debug(Configure::read('Common.client.'.$value));
                            
                        if (($mustNotEmpty == "NOTEMPTY") && empty(Configure::read('Common.client.'.$value))) {
                            // Keep default values
                            $ClientDefaults[$value.'_fra']=$ClientDefaults[$value];
                            foreach ($this->alllang as $key => $lgname) {
                                $lfield = "${value}_".$lgname;
                                $ClientDefaults[$lfield]=$ClientDefaults[$lfield];                                    
                            }
                        } else {
                            $ClientDefaults[$value]=Configure::read('Common.client.'.$value);
                            $ClientDefaults[$value.'_fra']=Configure::read('Common.client.'.$value);
                        }

                        if ($monnaie_name_custom) {
                            $ClientDefaults[$value]=str_replace("CELT", $curClient['Client']['monnaie_name'], $ClientDefaults[$value]);
                            $ClientDefaults[$value.'_fra']=str_replace("CELT", $curClient['Client']['monnaie_name'], $ClientDefaults[$value.'_fra']);
                        }
                        if (strstr($value,'pdf')) {
                            $filen = $value.'.'. $uniquestr . '.pdf';
                            $pdfpath = WWW_ROOT . DIRECTORY_SEPARATOR . 'files/'.$filen;
                            if(file_exists($pdfpath)) {
                                $ClientDefaults[$value.'_fra'] = $filen;
                            }
                        }
                        // Scan lang files                            
                        foreach ($this->alllang as $key => $lgname) {
                            $lfield = "${value}_".$lgname;
                            //debug($lfield);
                            // for pdf files
                            if (strstr($lfield,'pdf')) {
                                $filen = $lfield.'.'. $uniquestr . '.pdf';
                                //$pdfpath = WWW_ROOT . DIRECTORY_SEPARATOR .$filen;
                                $pdfpath = WWW_ROOT . DIRECTORY_SEPARATOR . 'files/'.$filen;
                                //debug($pdfpath);
                                if(!file_exists($pdfpath)) {
                                    // If not present take french one (with files dir mentionned)
                                    $filen = $ClientDefaults[$value];
                                }
                                $ClientDefaults[$lfield]=$filen;
                            } else {
                                // For custom title, videos, etc..
                                $filepath = APP."Clients/home_".$this->CID."_${value}.${lgname}.lang";
                                if(file_exists($filepath)) {
                                    $tmp = file_get_contents($filepath);
                                    if (trim($tmp)!="") {
                                        $ClientDefaults[$lfield]=$tmp;
                                        if ($monnaie_name_custom) {
                                            $ClientDefaults[$lfield]=str_replace("CELT", $curClient['Client']['monnaie_name'], $ClientDefaults[$lfield]);
                                        }
                                    }
                                } else {
                                    //$ClientDefaults[$lfield]=$ClientDefaults[$value.'_fra'];
                                    if (($mustNotEmpty == "NOTEMPTY") && empty(Configure::read('Common.client.'.$lfield))) {
                                        // Keep written value above
                                    } else {
                                        $ClientDefaults[$lfield]="";
                                    }
                                    
                                }
                            }
                        }
                    }
                    break;
                    //exit;
                    //debug("Client is ".$curClient['Client']['name']);                    
                }
            }
            $this->set('ClientDefaults', $ClientDefaults);
            $this->ClientDefaults = $ClientDefaults;
            //debug($ClientDefaults);exit;
            if (!$clientfound) {
                Configure::write('Common.topurl', 'https://www.trockee.com');
                if ((!strstr($url, "files")) && (!strstr($url, "tbprodev"))) {
                    $this->layout = "landing_page";
                }

                if ($this->Cookie->check('Config.language')) {
                    $curlang = $this->Cookie->read('Config.language');
                    Configure::write('Config.language',$curlang);
                } else {
                    $langue_code = $this->check_language_browser(Configure::read('Config.languages'));
                    $curlang = Configure::read('Config.languages')[$langue_code];
                    Configure::write('Config.language',$curlang);
                }
            
                if ($curlang=="") $curlang="fra";
        
                //$this->set('lng','Lang='.$curlang);
                $this->set('lang',$curlang);
                $this->lang = $curlang;
                foreach (Configure::read('Config.languages') as $curcode => $value) {
                    if ($value==$curlang) {
                        Configure::write('Config.lang_code',$curcode);
                    }
                }
                $this->set('VideoYoutubeId',Configure::read('Common.VideoUrlId.'.$curlang));
                $langs_client = Configure::read('Config.languages');
                $this->set('langs_client',$langs_client);
            } else {     
                //$this->disableCache();
                //debug($this->Auth);exit;
                // Definition User info pour chaque controller
                //debug($this->isConnected());exit;
                $chkuserconnected = $this->isConnected();
                $this->set('Userinfo', $chkuserconnected);
                $this->Userinfo = $chkuserconnected;
                $this->ClientData = $this->getClientData();
                $this->set('ClientData',$this->ClientData);
                //Configure::write('debug', 2 );
                //debug($this->Userinfo);
                if ($this->Userinfo) {
                    // Verification is message non lue dans msg privée
                    $nbmsgnotread = "";
                    $messagerie_activated = $this->getClientData('messagerie_activated');
                    if ($messagerie_activated) {
                        $this->loadModel('Pm');
                        $nbnotread = $this->Pm->findAllByIdDestinataireAndLu($this->Userinfo['id'], 0);
                        if (count($nbnotread) > 0) {
                            $nbnotreadval = count($nbnotread);
                            $nbmsgnotread = "&nbsp;<span class='badge alert-danger'>$nbnotreadval</span>";
                        }
                    }
                    $this->set('nbmsgnotread', $nbmsgnotread);

                }
                $this->infosloc = $this->getCurrentlocation();
                $this->set('current_location', $this->infosloc);
                $notconnecteddisplay_activated = $this->getClientData('notconnecteddisplay_activated');
                $charte_activated = $this->getClientData('charte_activated');
                $monnaie_temps_activated = $this->getClientData('monnaie_temps_activated');
                $this->monnaie_temps_activated = $monnaie_temps_activated;
                // Overwrite button config
                configure::write('PostConfig',array(
                    'title_for_layout' => __("Les objets et services"),
                    'section_titre_bouton_ecrire' => __("Ecrire une annonce"),
                    'section_titre_bouton_ecrire_O' => __("Entrer une nouvelle annonce"),
                    'section_titre_bouton_ecrire_D' => __("Je demande un objet ou service"),
                ));

                $this->set('monnaie_temps_activated',$monnaie_temps_activated);
                $this->set('skills_activated',true);
                $this->set('notconnecteddisplay_activated',$notconnecteddisplay_activated);
                $this->set('charte_activated',$charte_activated);
                $this->set('topimage',$this->getClientData('topimage'));
                $this->set('bottomimage',$this->getClientData('bottomimage'));
                $this->set('img_footer_url',$this->getClientData('img_footer_url'));
               
            
                //$this->session = $this->Session->read('choixUser');//exit;
            }
        }
        //$this->calculate_game_podium();
    }

    public function isAuthorized($user)
    {
        // Admin peut accéder à toute action
        if (isset($user['role']) && (($user['role'] === 'admin') || ($user['role'] === 'adminentreprise'))) {
            return true;
        }
        // Refus par défaut
        return false;
    }


    public function isConnected() {
        //debug($this->Auth->loggedIn());
        //debug($this->Cookie->read('remember_me_cookie'));
        $cookie = $this->Cookie->read('remember_me_cookie');
        $this->loadModel('User');

        if ($cookie) {
            $user = $this->User->find('first', array(
                'conditions' => array(
                    'User.email' => $cookie['email'],
                    'User.password' => $cookie['password']
                )
            ));
            if (!$user) { // cookie present but user doesn't exists
                $this->Cookie->delete('remember_me_cookie');
                $this->redirect('/');
            }
            if ($user && !$this->Auth->login($user['User'])) {
                $this->redirect('/users/logout'); // destroy session & cookie
            }
            $thearray = $user['User'];
            $thearray['City'] = $user['City'];
            //debug( $thearray);exit;
            return $thearray;
        }


        // if ($this->Auth->loggedIn()) {
        //     $this->loadModel('User');
        //     $this->User->contain('City','City.Country');
        //     $userarray = $this->User->findByEmail($this->Auth->user('email'),array('*'));
        //     //debug($this->Auth->user());debug($this->Auth->user('password'));exit;
        //     //debug($userarray);exit;
        //     $thearray = $userarray['User'];
        //     $thearray['City'] = $userarray['City'];
        //     //debug( $thearray);
        //     return $thearray;
        // } else {
        //     //debug("User not connected ...");
        // }
        // //exit;
    }


    public function verif_admin($onlyfulladmin=false)
    {
        if ($this->Userinfo['role'] == 'admin') {return true;}
        if ($onlyfulladmin) {
            $this->redirect(array('controller' => 'pages', 'action' => 'display', 'accueil'));
        }
        if ($this->Userinfo['role'] == 'adminentreprise') {return true;}
        $this->redirect(array('controller' => 'pages', 'action' => 'display', 'accueil'));
    }

    public function isCorrectWords($text)
    {
        //$bad = Configure::read('badWords');
        //debug($bad_words);
        //$bad = explode(" | ",$bad_words);
        //debug($bad);
        //$b = '/\b' . implode('[sx]*\b|\b', $bad) . '\b[sx]*/i';
        //debug($b);
        //debug(preg_match($b, $text));
        //if (preg_match($b, $text)) {
            //debug($text);
            //echo $text ." - Contain Bad words!";
            // - other function here
        //    return false;
        //} else {
            //echo $text ." - Not containing bad words :D";
            # - other function here
            //debug("OK $text");
        //    return true;
        //}
        return true;
    }

    public function fixIncorrectword($text)
    {
        //$bad = Configure::read('badWords');
        //$b = '/\b' . implode('[sx]*\b|\b', $bad) . '\b[sx]*/i';
        //debug($b);
        //debug(preg_replace($b,"****",$text));
        //return preg_replace($b, "****", $text);
        return $text;
    }

    public function setUserCookieRecherche()
    {
        //$this->Session->delete('rechercheFromUser'); // Clear previous search
        if ($this->data) {
            //debug($this->data);exit;
            // recherche des data
            $sess_data = $this->Cookie->read('choixUser');
            //debug($sess_data);
            if ($sess_data != null) {
                $result = $sess_data;
                //debug($result);
                //$result = array_uintersect($sess_data, $this->data);
                // parse all keys

                foreach ($this->data as $curkey => $curdata) {
                    //debug($curkey);
                    //debug($curdata);
                    if (is_array($curdata)) {
                        foreach ($curdata as $key => $value) {
                            if ($value != '') {
                                $result[$curkey][$key] = $value;
                                if ($key == 'ville') {
                                    // clear Departement and Bassin
                                    $result['Pages']['departement_id'] = '';
                                    $result['Pages']['departement_code'] = '';
                                    $result['Pages']['departement'] = '';
                                    $result['Pages']['bassinvie'] = '';
                                    $result['Pages']['bassinvie_id'] = '';
                                }
                                if ($key == 'departement_id') {
                                    // clear Departement and Bassin
                                    $result['Pages']['ville_id'] = '';
                                    $result['Pages']['ville'] = '';
                                    $result['Pages']['villeReseau'] = '';
                                    $result['Pages']['bassinvie'] = '';
                                    $result['Pages']['bassinvie_id'] = '';
                                }
                                if ($key == 'bassinvie') {
                                    // clear Departement and Bassin
                                    $result['Pages']['departement_id'] = '';
                                    $result['Pages']['departement_code'] = '';
                                    $result['Pages']['departement'] = '';
                                    $result['Pages']['ville_id'] = '';
                                    $result['Pages']['ville'] = '';
                                }
                            }
                        }
                    } else {
                        //if ($value!='') $result[$curkey][$key] = $value;
                    }
                }
                //debug($result);
            } else {
                $result = $this->data;
            }
            if (isset($this->data['recherche_user'])) {
                $result['recherche_user'] = $this->data['recherche_user'];
            }
            if (isset($this->data['User']['recherche'])) {
                $result['recherche_user'] = $this->data['User']['recherche'];
            }
            if (isset($this->data['Pages']['category_id'])) {
                $result['Pages']['category_id'] = $this->data['Pages']['category_id'];
            }
            if (isset($this->data['Pages']['country_id'])) {
                $result['Pages']['country_id'] = $this->data['Pages']['country_id'];
            }
            if (isset($this->data['Pages']['ville_id'])) {
                $result['Pages']['ville_id'] = $this->data['Pages']['ville_id'];
            }
            //debug($result);
            // Sauver en session
            $this->Cookie->write('choixUser', $result);
        }
    }

    public function clearUserCityLocation()
    {
        $this->Cookie->delete('choixUser');
    }

    public function get_users_conditions()
    {
        // Recupérer le choix user : ville, departement, bassin de vie
        $infoskeep = $this->Cookie->read('choixUser');
        //debug($infoskeep);exit;
        if (!isset($infoskeep['Pages'])) {
            return null;
        }
        $infos = $infoskeep['Pages'];
        //debug($infos);exit;
        if (isset($infos['ville_id']) && $infos['ville_id'] != '') {
            // Récupération des users de cette ville
            $this->loadModel('User');
            $allusers = $this->User->find('list', array(
                'conditions' => array('city_id' => $infos['ville_id']),
            ));
            $conditions = array('User.id' => $allusers);
        } else {
            $conditions = null;
        }
        if (isset($infos['country_id']) && $infos['country_id'] != '') {
            // Récupération des users de ce pays
            $conditions['City.country_id'] = $infos['country_id'];            
        }
        // Cas de recherche de nom dans le répertoire
        if (isset($infoskeep['User'])) {
            if (isset($infoskeep['User']['recherche'])) {
                $cr = $infoskeep['User']['recherche'];
                // Recherche non vide
                $condrecherche = array(
                    'OR' => array(
                        'User.nom LIKE' => "%$cr%",
                        'User.prenom LIKE' => "%$cr%",
                    ),
                );
                $newcondition = array(
                    'AND' => array(
                        $conditions,
                        $condrecherche,

                    ),
                );
                $conditions = $newcondition;
            }
        }
        //debug($newcondition);
        //debug($conditions);
        //exit;

        return $conditions;
    }

    public function get_conditions_city_reseau()
    {
        $infos = $this->Cookie->read('choixUser');
        if (!isset($infos['Pages'])) {
            return null;
        }
        $infos = $infos['Pages']; //debug($infos);exit;
        if (isset($infos['ville_id']) && $infos['ville_id'] != '') {
            $conditions = array('all_cities' => $infos['ville_id']);
        } else {
            $conditions = null;
        }
        return $conditions;

    }

    public function get_conditions($table = null)
    {
        // Recupérer le choix user : ville, departement, bassin de vie
        $infos = $this->Cookie->read('choixUser');
        //debug($infos);
        if (!isset($infos['Pages'])) {
            return null;
        }
        $infos = $infos['Pages']; //debug($infos);
        if (isset($infos['ville_id']) && $infos['ville_id'] != '') {
            // Récupération des users de cette ville
            $this->loadModel('User');
            $allusers = $this->User->find('list', array(
                'conditions' => array('User.city_id' => $infos['ville_id']),
            ));
            $conditions = array('user_id' => $allusers);
        }  else {
            $conditions = null;
        }
        //debug($conditions);exit;
        return $conditions;
    }

    public function loadPostsUser($user_id, $post_type = null, $nodisplaymessage = null, $nb = 8)
    {
        $this->loadModel('Post');
        $conditions = array('Post.user_id' => $user_id);
        if ($post_type != null) {
            $conditions = array('Post.user_id' => $user_id, 'Post.type' => $post_type);
        }
        $posts_paginate = array(
            'limit' => $nb,
            'conditions' => $conditions,
            'contain' => array(
                'Category' => array('fields' => array('name', 'image')),
                'User' => array('fields' => array('id', 'nom', 'prenom', 'photo', 'city_id', 'type')),
                'User.TransactionDebit' => array(
                    'fields' => array('Sum(amount) as amount_debit'),
                ),
                'Transaction.User' => array(),
                'Transaction.Post' => array(),
                'City' => array('fields' => array('ville_nom_reel', 'id')),
            ),
            'joins' => array(
				array(
					'table' => 'cities',
					'alias' => 'CityJoin',
					'type' => 'INNER',
					'conditions' => array(
						'CityJoin.id = User.city_id'
					)
				)
			),
            'order' => array('Post.id' => 'DESC'),
            'fields' => array('Post.*','CityJoin.ville_nom_reel'),
        );
        //debug($posts_paginate);
        $this->Paginator->settings = $posts_paginate;
        $all_posts = $this->Paginator->paginate('Post');
        //debug($all_posts);exit;
        if (empty($all_posts) and ($nodisplaymessage == null)) {
            $this->Session->setFlash(__("Pas de messages trouvés pour votre critère de recherche"), 'msg_alert');
        }

        return $all_posts;
    }

    public function set_post_pages_variables($cfg, $flagbis = null)
    {

        $this->set('titre_section', $cfg['title_for_layout']);

        $this->set('title_for_layout', $cfg['title_for_layout']);
        $this->set('section_titre_bouton_ecrire', $cfg['section_titre_bouton_ecrire']);
        $this->set('section_controller', $cfg['section_controller']);
        $this->set('section_action', $cfg['section_action']);

        $this->set('section_titre_bouton_recherche', $cfg['section_titre_bouton_recherche']);
        $this->set('section_controller_recherche', $cfg['section_controller_recherche']);
        $this->set('section_action_recherche', $cfg['section_action_recherche']);

        $this->set('section_titre_bouton_abonnement', $cfg['section_titre_bouton_abonnement']);
        $this->set('section_titre_bouton_desabonnement', $cfg['section_titre_bouton_desabonnement']);
        $this->set('section_controller_abonnement', $cfg['section_controller_abonnement']);
        if ($flagbis == null) {
            $this->set('controller2load_bis', 'posts');
        }
    }

    //public function getPosts($type, $limit = 5, $catid = '', $recherche_user = null)
    public function getPosts($type, $limit = 5, $datasearch=null)
    {



        //debug($datasearch);exit;
        $catid = null;
        if (isset($datasearch['cat_id'])) {
            $catid = $datasearch['cat_id'];
        }
        if (isset($datasearch['Pages']['category_id'])) {
            $catid = $datasearch['Pages']['category_id'];
        }
        $recherche_user = null;
        if (isset($datasearch['recherche_user'])) {
            $recherche_user = $datasearch['recherche_user'];
        }
        $countryid = null;
        if (isset($datasearch['Pages']['country_id'])) {
            $countryid = $datasearch['Pages']['country_id'];
        }
        $cityid = null;
        if (isset($datasearch['Pages']['ville_id'])) {
            $cityid = $datasearch['Pages']['ville_id'];
        }
        $tags = null;
        if (isset($datasearch['Post']['Tags'])) {
            $tags = array_keys($datasearch['Post']['Tags']);
        }
        $this->loadModel('Post');
        $cnt_posts = 0;
        //debug($tags);exit;
        //debug($catid);
        // --------------------------------------------
        // Selection par ville/ Bassin de vie etc..
        // --------------------------------------------
        if ($type != 'all') { 
            $conditions = $this->get_conditions('Post');
            $condition_reseau = $this->get_conditions_city_reseau();
            //debug($condition_reseau);exit;
            $condrecherche = array();
            if ($recherche_user != null) {
                $condrecherche = array(
                    'titre LIKE' => "%$recherche_user%",
                    'message LIKE' => "%$recherche_user%",
                );
            }
            //debug($conditions);exit;
            if ($conditions != null) {
                $curuser_id = 0; // for like search
                if (isset($this->Userinfo['id'])) {
                    $curuser_id = $this->Userinfo['id'];
                }

                $newconditions = array(
                    'OR' => array(
                        array('Post.city_id' => Configure::read('Reseau.city_id')),
                        array(
                            'AND' => array(
                                'Post.user_id' => Configure::read('Reseau.user_id'),
                                'Post.city_id' => $condition_reseau['all_cities'],
                            ),
                        ),
                        $conditions,
                    ),
                );
                // Ne pas changer de place
                if ($recherche_user != null) {
                    $newconditions = array(
                        'AND' => array(
                            $newconditions,
                            'OR' => $condrecherche,
                        ),
                    );
                }
                //debug($category_recherche_id);//exit;
                $newconditions['Post.type'] = $type;                
                if ($catid != '') {
                    $newconditions['Category.id'] = $catid;
                }
                // Do not display user post in vacation
                $newconditions['User.vacation']=0;
                $newconditions['Post.paused']=false;
                $newconditions['Post.sold']=false;
                if ($countryid!=null) {
                    $newconditions['City.country_id'] = $countryid;
                }
                if ($cityid!=null) {
                    $newconditions['City.id'] = $cityid;
                }
                //$newconditions['Post.cnt_flag <'] = Configure::read('Common.max_moderate_flags');
                //debug($newconditions);exit;
                $posts_paginate = array(
                    'conditions' => array($newconditions),
                    'limit' => $limit,
                    'order' => array('Post.id DESC'),
                    'fields' => array(
                        'City.country_id','User.id', 'User.nom', 'User.prenom', 'CityJoin.ville_nom_reel','City.ville_nom_reel', 'Post.titre', 'Post.type', 'Post.created', 'Post.monnaievalue', 'Post.message', 'Post.image','Post.paused','Post.reserved', 'Post.sold','Category.name', 'Category.id', 'Category.image',
                    ),
					'joins' => array(
						array(
							'table' => 'cities',
							'alias' => 'CityJoin',
							'type' => 'INNER',
							'conditions' => array(
								'CityJoin.id = User.city_id'
							)
						)
					)
                );
                //debug($posts_paginate);
                $this->Paginator->settings = $posts_paginate;
                $all_posts = $this->Paginator->paginate('Post');
                debug($all_posts);exit;
                // Check number of posts
                $post_req = array('conditions' => array($newconditions));
                $cnt_posts = $this->Post->find('count', $post_req);
            } else {
                // Rien trouvé, donc pas de sélection utilisateur dans le menu de recherche
                // donc on affiche ce qui est demandé
                //debug($conditions);exit;
                $conditions = array(
                    'Post.type' => $type,
                );
                if ($catid != null) {
                    $conditions = array(
                        'Post.type' => $type,
                        'Post.category_id' => $catid,
                    );
                }
                if ($recherche_user != null) {
                    $conditions['OR'] = $condrecherche;
                }
                // Do not display user post in vacation
                $conditions['User.vacation']=0;
                $conditions['Post.paused']=false;
                $conditions['Post.sold']=false;
                if ($countryid!=null) {
                    $conditions['City.country_id'] = $countryid;
                }
                // Tags
                if($tags!=null) {
                    //debug($tags);
                    $this->loadModel('PostTag');
                    
                    // Pour chaque tags, récupérer son critère
                    $this->loadModel('CritereTag');                    
                    $crits = $this->CritereTag->find('all',array(
                        'conditions' => array(
                            'CritereTag.tag_id IN' => $tags
                        )
                    ));
                    // regroupage des tags par critere
                    $tagsbycritere=Hash::combine($crits, '{n}.CritereTag.tag_id', '{n}.CritereTag.tag_id','{n}.Critere.id');                    
                    //debug($crits);
                    //debug($tagsbycritere);

                    // Parcours des tagsbycritere pour filtrage
                    $postslist = array();
                    foreach ($tagsbycritere as $crit_id => $alltags) {
                        if ($catid!=null) {
                            $tagcond = array(
                                'PostTag.tag_id IN' => $alltags,
                                'Post.category_id' => $catid                            
                            );
                        } else {
                            $tagcond = array(
                                'PostTag.tag_id IN' => $alltags,                            
                            );
                        }
                        $chk = $this->PostTag->find('all',array(
                            'conditions' => $tagcond,
                            'fields' => array('Post.id','Post.category_id','PostTag.tag_id'),
                        ));
                        if (!$chk) { // Pas de post pour ce critère , donc on va pas plus loin
                            $postslist = array();
                            break;
                        }
                        //debug("CHK crit ".$crit_id);
                        //debug($chk);
                        // Ici les post avec un des tags du critère
                        $result_posts_ids=Hash::combine($chk, '{n}.PostTag.tag_id', '{n}.PostTag.tag_id','{n}.Post.id');                    
                        //debug($result_posts_ids);
                        if (empty($postslist)) {
                            // Premier scan, donc on mets tous les posts
                            foreach ($result_posts_ids as $key=>$cur) {                            
                                array_push($postslist,$key);
                            }
                        } else {
                            // On regarde si les post id son trouvés
                            $idx_tmp = 0;
                            $tmp2_post_lists = array();
                            foreach ($result_posts_ids as $tmp_key=>$tmp_id) {                            
                                array_push($tmp2_post_lists,$tmp_key);
                            }
                            //debug($postslist);
                            //debug($tmp2_post_lists);
                            $postslist = array_intersect($postslist, $tmp2_post_lists);
                            //debug($postslist);
                            if (empty($postslist)) { // Pas de post pour ce critère , donc on va pas plus loin
                                break;
                            }
                        }
                        
                        //debug($tmp_post_lists);
                    }


                    /*$chk = $this->PostTag->find('all',array(
                        'conditions' => $tagcond,
                        'fields' => array('Post.id','Post.category_id','PostTag.tag_id','CritereTagJoin.critere_id'),
                        'joins' => array(
                            array(
                                'table' => 'criteres_tags',
                                'alias' => 'CritereTagJoin',
                                'type' => 'INNER',
                                'conditions' => array(
                                    'CritereTagJoin.id = PostTag.tag_id'
                                )
                            )
                        )
                    ));*/
                    //debug($chk);exit;
                    // OK utiliser un hash maintenant ?
                    // Grouper par post
                    //$result=Hash::combine($chk, '{n}.PostTag.tag_id', '{n}.PostTag.tag_id','{n}.Post.id');                    
                    // Selectionner ceux qui ont le nombre de tags mini
                    //$postslist = array();
                    /*foreach ($result as $key=>$cur) {
                       if (count($cur)>=count($tags)) {
                        array_push($postslist,$key);
                       }
                    }*/
                    //$uniq_postslist=Hash::combine($postslist, null,'{n}');
                    //debug($postslist);
                    //debug($uniq_postslist);exit;
                    // Attention a rajouter la condition initiale
                    $conditions['Post.id IN']=$postslist;
                } 


                if ($tags==null || ($tags!=null && !empty($postslist))) {
                
                    $posts_paginate = array(
                        'conditions' => $conditions,
                        'limit' => $limit,
                        'order' => array('Post.id' => 'desc'),
                        'fields' => array(
                            'City.country_id','User.id', 'User.nom', 'User.prenom', 'CityJoin.ville_nom_reel','City.ville_nom_reel', 'Post.titre', 'Post.created', 'Post.monnaievalue', 'Post.message', 'Post.image','Post.paused','Post.reserved', 'Post.sold', 'Category.id', 'Category.name', 'Category.image',
                        ),
                        'joins' => array(
                            array(
                                'table' => 'cities',
                                'alias' => 'CityJoin',
                                'type' => 'INNER',
                                'conditions' => array(
                                    'CityJoin.id = User.city_id'
                                )
                            )
                        )
                    );
                    $this->Paginator->settings = $posts_paginate;
                    $all_posts = $this->Paginator->paginate('Post');

                    //debug($all_posts);exit;
                    //$post_req = array('conditions' => array($conditions));
                    //$cnt_posts = $this->Post->find('count', $post_req);
                    $cnt_posts = count($all_posts);

                } else {
                    $all_posts = array();
                    $cnt_posts = 0;
                }
            }
        } else {
            // Affichage dans la page d'accueil (scrolling des annonces melangées
            $conditions = array(
                'category_id != ' => null,
                'Post.titre NOT IN' => Configure::read('badWords'),
                'User.vacation' => 0,
                'Post.paused' => false,
                'Post.sold' => false
            );       
            $this->Post->contain('User', 'City', 'Category', 'Transaction');
            $all_posts = $this->Post->find('all', array(
                'conditions' => $conditions,
                'limit' => $limit,
                'order' => array('Post.id DESC'),
                'fields' => array(
                    'User.id', 'User.nom', 'User.prenom','CityJoin.ville_nom_reel', 'City.ville_nom_reel', 'Post.titre', 'Post.created', 'Post.monnaievalue', 'Post.message','Post.paused','Post.reserved', 'Post.sold', 'Category.id', 'Category.image',
                ),
				'joins' => array(
					array(
						'table' => 'cities',
						'alias' => 'CityJoin',
						'type' => 'INNER',
						'conditions' => array(
							'CityJoin.id = User.city_id'
						)
					)
				)

            ));
            //debug($all_posts);exit;
            //$post_req = array('conditions' => array($newconditions)));
            //$cnt_posts = $this->Post->find('count',$post_req);

        }

        //debug($catid);
        //debug($conditions);
        $inc = 0;
        foreach ($all_posts as $curmsg) {
            if (!$this->isCorrectWords($curmsg['Post']['titre'])) {
                //unset($all_posts[$inc]);
                $all_posts[$inc]['Post']['titre'] = $this->fixIncorrectword($curmsg['Post']['titre']);
            }
            if (!$this->isCorrectWords($curmsg['Post']['message'])) {
                //unset($all_posts[$inc]);
                $all_posts[$inc]['Post']['message'] = $this->fixIncorrectword($curmsg['Post']['message']);
            }
            $inc++;
        }
        return array('all_posts' => $all_posts, 'count' => $cnt_posts);
    }

    public function loadPosts($rechercheuser = null, $category_recherche_id = null, $post_type = null)
    {
        $this->loadModel('Post');
        // Get the conditions for the search
        $conditions = $this->get_conditions('Post');
        $condition_reseau = $this->get_conditions_city_reseau();
        if (!$condition_reseau) {
            //$condition_reseau['all_cities']=0;
        }
        //debug($condition_reseau);
        //debug($conditions);exit;
        //debug($category_recherche_id);
        if ($conditions != null) {
            $curuser_id = 0; // for like search
            if (isset($this->Userinfo['id'])) {
                $curuser_id = $this->Userinfo['id'];
            }
            $newconditions = array(
                'OR' => array(
                    array('Post.city_id' => Configure::read('Reseau.city_id')),
                    array(
                        'AND' => array(
                            'Post.user_id' => Configure::read('Reseau.user_id'),
                            'Post.city_id' => $condition_reseau['all_cities'],
                        ),
                    ),
                    $conditions,
                ),
            );
            $newconditions['Post.cnt_flag <'] = Configure::read('Common.max_moderate_flags');
            if ($rechercheuser != null) {
                $newconditions['OR'] = array(
                    'titre LIKE' => "%$rechercheuser%",
                    'message LIKE' => "%$rechercheuser%",
                );
                if ($category_recherche_id != '') {
                    $newconditions['Category.id'] = $category_recherche_id;
                }
            }
            if (trim($rechercheuser) == "" and ($category_recherche_id != "")) {
                $newconditions['Category.id'] = $category_recherche_id;
            }
            if ($post_type != null) {
                $newconditions['Post.type'] = $post_type;
            }
            //debug($conditions);exit;
            //debug($newconditions);
            //$conditions_moderate = array('Moderate.city_id'=>$conditions['Post.city_id']);
            //debug($conditions_moderate);
            $posts_paginate = array(
                'limit' => 8,
                'conditions' => $newconditions,
                'contain' => array(
                    'Category' => array('fields' => array('name')),
                    'User' => array('fields' => array('id', 'nom', 'prenom', 'photo', 'city_id', 'type')),
                    'User.TransactionDebit' => array(
                        'fields' => array('Sum(amount) as amount_debit'),
                    ),
                    'User.TransactionCredit' => array(
                        'fields' => array('Sum(amount) as amount_credit'),
                    ),
                    'Comment.User' => array('fields' => array('User.id', 'User.nom', 'User.prenom', 'User.photo', 'User.type')),
                    'Comment.City' => array('fields' => array('ville_nom_reel')),
                    'Comment' => array('conditions' => array('Comment.cnt_flag <' => Configure::read('Common.max_moderate_flags'))),
                    'City' => array('fields' => array('ville_nom_reel')),
                    'City.Follow' => array(
                        'conditions' => array(
                            'user_id' => $curuser_id, // Si non vide => Le user est abonné
                        ),
                    ),
                    'Like' => array( // non vide si like déjà fait par le user.
                        'conditions' => array('user_id' => $curuser_id),
                        'fields' => array('id', 'user_id', 'post_id', 'comment_id'),
                    ),
                ),
                'order' => array('Post.id' => 'DESC'),
            );
            //debug($posts_paginate);
            $this->Paginator->settings = $posts_paginate;
            $all_posts = $this->Paginator->paginate('Post');
            //debug($all_posts);exit;
            if (empty($all_posts)) {
                $this->Session->setFlash(__("Pas de messages trouvés pour votre critère de recherche"), 'msg_alert');
            }
            //debug($all_posts);exit;
            return $all_posts;
        } else {
            $this->Session->setFlash(__("Pas de messages trouvés pour votre critère de recherche"), 'msg_alert');
            $this->redirect(array('controller' => 'pages', 'action' => 'display2'));
        }
    }

    public function getCurrentlocation()
    {
        $infos = $this->Cookie->read('choixUser');
        if (isset($infos['Pages'])) {
            $infos = $infos['Pages'];
            //debug($infos);exit;
            //if (isset($infos['country_id']) and $infos['country_id']) {
                //return $this->AllCountriesList[$infos['country_id']];
            //}
            if (isset($infos['ville_id']) and $infos['ville_id']) {
                return $this->AllCountriesList[$infos['ville_id']];
            }
            if (isset($infos['ville']) and $infos['ville']) {return $infos['ville'];}
            if (isset($infos['departement']) and $infos['departement']) {return $infos['departement'];}
            if (isset($infos['bassinvie']) and $infos['bassinvie']) {return $infos['bassinvie'];}
            // Si on arrive ici, la session est perdue
        }
        return false;
    }
    public function getCurrentCategory($what = null)
    {
        $infos = $this->Cookie->read('choixUser');
        //debug($infos);exit;
        if (!isset($infos['Pages'])) {return "";}
        $infos = $infos['Pages'];
        if (isset($infos['category_id']) and $infos['category_id'] == '') {return "";}
        if (isset($infos['category_id']) and $infos['category_id'] == 9999) {return "";}
        if (isset($infos['category_id']) and $infos['category_id'] != '') {
            $this->loadModel('Category');
            $rt = $this->Category->findById($infos['category_id'], array('name', 'id'));
            if ($what != null) {return $rt['Category'][$what];}
            return $rt['Category']['name'];
        }
        // Si on arrive ici, la session est perdue
        return false;
    }

    public function get_all_categories_as_list()
    {
        $this->loadModel('Category');
        $allcats = $this->Category->find('all', array(
            'conditions' => array(),
            'order' => array('Category.name'),
            'fields' => array('Category.id', 'Category.name'),
        ));
        $arrcat = array();
        foreach ($allcats as $curcat) {
            $arrcat[$curcat['Category']['id']] = html_entity_decode($curcat['Category']['name']);
        }
        return $arrcat;
    }
    public function get_all_countries_as_list()
    {
        $this->loadModel('Country');
        $allcats = $this->Country->find('all', array(
            'conditions' => array(),
            'order' => array('Country.name'),
            'fields' => array('Country.id', 'Country.name'),
        ));
        $arrcat = array();
        foreach ($allcats as $curcat) {
            $arrcat[$curcat['Country']['id']] = __($curcat['Country']['name']);
        }
        return $arrcat;
    }

    public function get_all_cities_as_list($typedemande=null)
    {
        //debug($this->action);exit;
        //debug(Configure::read('Common.client'));
        if ($this->action=="repertoire") {
            $this->loadModel('User');
            $this->User->contain('City');
            $allcats = $this->User->find('all', array(
                'conditions' => Configure::read('Admin.userstofilter'),
                'order' => array('City.ville_nom_reel'),
                'fields' => array('City.id', 'City.ville_nom_reel'),
                'group' => array('City.ville_nom_reel')
            ));
        } else {
            $this->loadModel('Post');
            $this->Post->contain('City','User');
            $cond = array();
            if ($typedemande!=null) {
                $cond = array('Post.type' => $typedemande);
            }
            $allcats = $this->Post->find('all', array(
                'conditions' => array(
                    $cond,
                    Configure::read('Admin.userstofilter')
                ),
                'order' => array('City.ville_nom_reel'),
                'fields' => array('City.id', 'City.ville_nom_reel'),
                'group' => array('City.ville_nom_reel')
            ));
        }
        
        //debug($allcats);exit;
        $arrcat = array();
        foreach ($allcats as $curcat) {
            $arrcat[$curcat['City']['id']] = $curcat['City']['ville_nom_reel'];
        }
        //debug($arrcat);exit;
        return $arrcat;
    }

    public function send_global_email($sujet, $message, $userArray = null, $template = null, $layout = null)
    {

        if (strstr($_SERVER['SERVER_ADDR'], "172.17.0")) {
            return true;
        }
        // for local development, do not send mail
        //debug($message);debug($sujet);debug($layout);exit;
        //Configure::write('debug', 02);
        $destinataire = $userArray['email'];
        //$destinataire = "dguillerm@gmail.com";
        //debug($userArray);
        //debug($message);debug($sujet);
        //debug($destinataire);exit;
        if (trim($sujet) != "") {
            $Email = new CakeEmail();
            $Email->from(array('contact@' . Configure::read('Common.sitename') => Configure::read('Common.sitename')));
            if ($destinataire == null) {
                $Email->to(Configure::read('Admin.emails'));
            } else {
                $Email->to(array($destinataire));
            }
            $Email->emailFormat('html');
            $Email->subject($sujet);
            $the_layout = 'vdmv_header';
            if ($layout != null) {$the_layout = $layout;}
            if ($template == null) {
                $Email->template('general_email', $the_layout);
            } else {
                $Email->template($template, $the_layout);
            }
            //debug($userArray);
            if (!isset($userArray['prenom'])) $userArray['prenom'] ="";
            $Email->viewVars(array('message' => $message, 'prenom' => $userArray['prenom'],'chdata' => $userArray));
            //debug($Email);exit;
            //debug("Envoi à $destinataire");
            $Email->send(); //exit;
        }
    }


    public function getUserReserveMonnaie($user_id)
    {
        $ret = $this->User->find('first', array(
            'conditions' => array('id' => $user_id),
            'contain' => array(
                'TransactionDebit' => array(
                    'fields' => array('Sum(amount) as amount_debit'),
                ),
                'TransactionCredit' => array(
                    'fields' => array('Sum(amount) as amount_credit'),
                ),
            ),
        ));
        $credit = 0;
        $debit = 0;
        if (!empty($ret['TransactionCredit'])) {
            foreach ($ret['TransactionCredit'] as $curcredit) {$credit += $curcredit['TransactionCredit'][0]['amount_credit'];}
        }
        if (!empty($ret['TransactionDebit'])) {
            foreach ($ret['TransactionDebit'] as $curdebit) {$debit += $curdebit['TransactionDebit'][0]['amount_debit'];}
        }
        $reserve = $credit - $debit + $ret['User']['monnaiestart'];
        return $reserve;
    }

    public function nicetime($date)
    {
        if (empty($date)) {
            return "No date provided";
        }
        $periods = array("seconde", "minute", "heure", "jour", "semaine", "mois", "année", "decennie");
        $lengths = array("60", "60", "24", "7", "4.35", "12", "10");
        $now = time();
        $unix_date = strtotime($date);

        // check validity of date
        if (empty($unix_date)) {
            return "Bad date";
        }

        // is it future date or past date
        if ($now > $unix_date) {
            $difference = $now - $unix_date;
            $tense = "ago";

        } else {
            $difference = $unix_date - $now;
            $tense = "from now";
        }

        for ($j = 0; $difference >= $lengths[$j] && $j < count($lengths) - 1; $j++) {
            $difference /= $lengths[$j];
        }

        $difference = round($difference);

        if ($difference != 1) {
            if ($periods[$j] != "mois") {$periods[$j] .= "s";}
        }

        return __("il y a")." $difference $periods[$j]";
    }
    public function getUserMonnaieTransaction() {
        $this->loadModel('Transaction');
        $uid = $this->Userinfo['id'];
        $tr = $this->Transaction->find('all', array(
            'conditions' => array(
                'OR' => array(
                    array('Transaction.user_id' => $uid),
                    array('Transaction.to_userid' => $uid),
                ),
                'Transaction.amount != ' => 0,
            ),
            'order' => array('Transaction.id DESC'),
        ));
        Configure::write('debug', 0);
        $depenses = $this->Transaction->find('first', array(
            'conditions' => array(
                array('Transaction.user_id' => $uid),
            ),
            'fields' => array('SUM(Transaction.amount) as depenses'),
        ));
        $gains = $this->Transaction->find('first', array(
            'conditions' => array(
                array('Transaction.to_userid' => $uid),
            ),
            'fields' => array('SUM(Transaction.amount) as gains'),
        ));
        $userstart = $this->Userinfo['monnaiestart'];
        //$solde = intval($userstart)+intval($gains[0]['gains'])-intval($depenses[0]['depenses']);
        $solde = $this->getUserReserveMonnaie($uid);
        $totaux = array(
            'alltr' => $tr,
            'userstart' => $userstart,
            'solde' => $solde,
            'gains' => round($gains[0]['gains']),
            'depenses' => round($depenses[0]['depenses']),
        );
        return $totaux;
    }
    
    public function calculate_game_podium() {
        configure::write('debug',2);
        $monnaie_activated = $this->getClientData('monnaie_activated');
        if (!$monnaie_activated) return null;
        $game_activated = $this->getClientData('game_activated');
        if (!$game_activated) return null;
        $this->loadModel('Transaction');
        $this->Transaction->contain('User');
        $chk = $this->Transaction->find('all',array(
            'conditions' => array(
                'User.vacation' => false                
            ),
            'fields' => array(
                'SUM(amount) as total',
                'User.vacation','User.id'
            ),
            'group' => array('User.id')
        ));
        debug($chk);exit;

    }


    public function getAllCriteres() {
        $this->loadModel('Critere');
        $criteres = $this->Critere->find('all',array(
                'order'=>array('Critere.porder'),
                'contain' => array(
                    'Tag' => array('order'=>array('porder','name'))
                )
            )
        );
        //debug($criteres);exit;
        return $criteres;
    }



    /*
	 * add a product to cart
	 */
	public function addProduct($productId) {
		$allProducts = $this->readProduct();
		if (null!=$allProducts) {
			if (!array_key_exists($productId, $allProducts)) {
			//	$allProducts[$productId]++;
			//} else {
				$allProducts[$productId] = 1;
			}
		} else {
			$allProducts[$productId] = 1;
		}
		
		$this->saveProduct($allProducts);
	}
	
	/*
	 * get total count of products
	 */
	public function getCount() {
		$allProducts = $this->readProduct();
		if (count($allProducts)<1) {
			//debug($allProducts);exit;
			return 0;
		}
		
		$count = 0;
		foreach ($allProducts as $product) {
			$count=$count+$product;
		}
		
		return $count;
	}

	/*
	 * save data to session
	 */
	public function saveProduct($data) {
		return $this->Cookie->write('cart',$data,false, 7200);
	}

	/*
	 * read cart data from session
	 */
	public function readProduct() {
		return $this->Cookie->read('cart');
	}

    public function deleteCart() {
        return $this->Cookie->delete('cart');
    }

    // Stripe 
    public function getPricePoint() {
        $pricebypoint_stripe = $this->Stripe->getPrice([
          'price_id' => Configure::read('Stripe.pointPrice')
        ]);
        $priceperpoint = $pricebypoint_stripe['response']['unit_amount']/100;
        return $priceperpoint;
    }

}
