<?php

class CartsController extends AppController {

	public $uses = array('Product','Cart');
	
	public function beforeFilter()
	{
			parent::beforeFilter();
			$this->set('page', '');
			$this->set('bodyclass', '');
			$this->set('controller2load', 'stripe');
	}

	public function add() {
		$this->autoRender = false;
		if ($this->request->is('post')) {
			$this->addProduct($this->request->data['Cart']['product_id']);
		}
		$this->redirect($this->referer());
		//echo $this->Cart->getCount();
	}
	
	public function view($justpaid=false) {
		$carts = $this->readProduct();
		$products = array();
		if (null!=$carts) {
			$this->Post->contain();
			foreach ($carts as $productId => $count) {				
				$product = $this->Post->read(null,$productId);
				$product['Post']['count'] = $count;
				$products[]=$product;
			}
		} 
		$userinfo = $this->isConnected();
    $user_id = $userinfo['id'];
		$compte_monnaie = $this->getUserReserveMonnaie($user_id);
		//debug($compte_monnaie);exit;
		$this->set('solde',$compte_monnaie);
		$this->set(compact('products'));
		$this->set('priceperpoint',$this->getPricePoint());
		$this->set('justpaid',$justpaid);
	}
	
	public function payer_panier() {
		$carts = $this->readProduct();
		$this->loadModel('Post');
		$total_amount = 0;
		$allannonces = array();
		foreach ($carts as $product_id => $count) {
			//debug($product_id);
			$this->Post->contain();
			$chk = $this->Post->findByIdAndSold($product_id,0);
			//debug($chk);
			if ($chk) {
				$total_amount += $chk['Post']['monnaievalue'];
				array_push($allannonces,$chk['Post']);
			}
		}
		if ($total_amount>0) {
			// Ajouter les frais de port
			// Débiter l'utilisateur et créditer user reseau
			$lbdpid = Configure::read('UserIdLBDP');
			$fromid = $this->Userinfo['id'];
			$commande_id = "commande_".$fromid."_".time();
			$ma_reserve = $this->getUserReserveMonnaie($fromid);
			if ($ma_reserve < $total_amount) {
					$this->Session->setFlash(__("Le solde de votre compte ne permet pas de régler votre panier"), 'msg_alert');
					$this->redirect(array('controller' => 'pages', 'action' => 'message'));
			}
			$this->loadModel('Transaction');
			// Loop again on post to create transaction for each
			$mail_str_annonces = "";
			foreach ($allannonces as $curpost) {
				$this->Transaction->create();
				$tosave = array(
					'Transaction' => array(
							'user_id' => $fromid,
							'to_userid' => $lbdpid,
							'post_id' => $curpost['id'],
							'post_titre' => $curpost['titre'],
							'post_category' => 0,
							'amount' => $curpost['monnaievalue'],
							'message' => $commande_id,
							'closed' => 0,
					),
				);
				$curtrans = $this->Transaction->save($tosave);
				$mail_str_annonces.= __("Nom de l'article")." : ".$curpost['titre']."<br>";
				$mail_str_annonces.= __("Montant en")." ".$this->ClientData['monnaie_name']." : ".$curpost['monnaievalue']."<br><br>";


				$this->Post->id = $curpost['id'];
				$this->Post->savefield('sold',true);
				$this->Post->savefield('reserved',false);
			}
			// Ajout des frais de port dans une autre transaction
			$tosavefdp = array(
				'Transaction' => array(
						'user_id' => $fromid,
						'to_userid' => $lbdpid,
						'post_id' => $curpost['id'],
						'post_titre' => __("Frais de port"),
						'post_category' => 0,
						'amount' => Configure::read('Common.frais_de_port'),
						'message' => $commande_id,
						'closed' => 0,
				),
			);
			$this->Transaction->create();
			$this->Transaction->save($tosavefdp);


			$this->deleteCart();
			$sujet = __("Votre commande à ").$this->ClientData['name'];
			$msgmail = __("Nous vous confirmons votre commande, que nous traitons dans les meilleurs délais.")."<br>";
			$msgmail.= "<br>".__("Date")." : ".date('d/m/y')."<br>";
			$msgmail.= __("Référence commande")." : ".$curtrans['Transaction']['message']."<br>";
			$msgmail.= __("Article(s) :")."<br><br>";
			$msgmail.= $mail_str_annonces;
			$msgmail.= "<br><br>".__("Frais de port : montant en ")." ".$this->ClientData['monnaie_name']." : ".Configure::read('Common.frais_de_port')."<br><br>";

			$arraymailto = array(
					'email' => $this->Userinfo['email'],
					'nom' => $this->Userinfo['nom'],
					'prenom' => $this->Userinfo['prenom'],
			);
			$this->send_global_email($sujet, $msgmail,$arraymailto,'buyed_product');
			$this->Session->setFlash(__("Le paiement du panier a été enregistré, merci !<br>Un email de confirmation de votre commande vous a été envoyé"), 'msg_success');
			$this->redirect(array('action'=>'view',true));

		}

		$this->redirect(array('action'=>'view'));
	}

	public function payer_panier_OLD() {
		if ($this->request->is('post')) {
			if (!empty($this->request->data)) {
				$this->loadModel('Post');
				$total_amount = 0;
				$allannonces = array();
				foreach ($this->request->data['Cart']['product_id'] as $product_id) {
					//debug($product_id);
					$this->Post->contain();
					$chk = $this->Post->findByIdAndSold($product_id,0);
					//debug($chk);
					if ($chk) {
						$total_amount += $chk['Post']['monnaievalue'];
						array_push($allannonces,$chk['Post']);
					}
				}

				if ($total_amount>0) {
					// Débiter l'utilisateur et créditer user reseau
					$lbdpid = Configure::read('UserIdLBDP');
					$fromid = $this->Userinfo['id'];
					$commande_id = "commande_".$fromid."_".time();
					$ma_reserve = $this->getUserReserveMonnaie($fromid);
					if ($ma_reserve <= $total_amount) {
							$this->Session->setFlash(__("Le solde de votre compte ne permet pas de régler votre panier"), 'msg_alert');
							$this->redirect(array('controller' => 'pages', 'action' => 'message'));
					}
					$this->loadModel('Transaction');
					// Loop again on post to create transaction for each
					foreach ($allannonces as $curpost) {
						$this->Transaction->create();
						$tosave = array(
							'Transaction' => array(
									'user_id' => $fromid,
									'to_userid' => $lbdpid,
									'post_id' => $curpost['id'],
									'post_titre' => $curpost['titre'],
									'post_category' => 0,
									'amount' => $curpost['monnaievalue'],
									'message' => $commande_id,
									'closed' => 0,
							),
						);
						$this->Transaction->save($tosave);
						$this->Post->id = $curpost['id'];
            $this->Post->savefield('sold',true);
            $this->Post->savefield('reserved',false);
					}
					$this->deleteCart();
					$this->Session->setFlash(__("Le paiement du panier a été enregistré, merci !"), 'msg_success');
				}
			}
			//exit;
		}
		$this->redirect(array('action'=>'view'));
	}

	public function update() {
		if ($this->request->is('post')) {
			if (!empty($this->request->data)) {
				$cart = array();
				foreach ($this->request->data['Cart']['count'] as $index=>$count) {
					if ($count>0) {
						$productId = $this->request->data['Cart']['product_id'][$index];
						$cart[$productId] = $count;
					}
				}
				$this->saveProduct($cart);
			}
		}
		$this->redirect(array('action'=>'view'));
	}

	public function thankspaiement() {

	}

	public function remove_product($id) {
		$cart = $this->readProduct();
		unset($cart[$id]);
		$this->saveProduct($cart);
		$this->redirect(array('action'=>'view'));
	}
	


}