<?php
App::uses('SimpleImage', 'Lib');
// app/Controller/ChallengesController.php
class ChallengesController extends AppController
{
    public $projectType;
    public $projectOpenmode;

    public function beforeFilter()
    {
        parent::beforeFilter();
        $this->set('page', '');
        $this->set('bodyclass', '');
        //$this->set('controller2load', "posts");
        $this->set('projectTypeAddProject',$this->projectTypeAddProject);
        $this->set('PRJ_options',$this->projectType);
        $this->set('PRJopenmode_options',$this->projectOpenmode);
    }

    public function index()
    {
        $this->redirect('/');
    }

    public function only_flash() {
    }

    public function downloadpdf($filen) {
        $this->layout = 'empty';
        $this->autoRender=false;
        $pdfpath = APP."/Clients/".$filen;
        //debug($pdfpath);exit;
        if(file_exists($pdfpath)){
            $this->response->file(
                $pdfpath,
                array('download' => true, 'name' => "$filen")
            );
            return $this->response;            
        }else{
            exit;
            
        }
    }
    
    private function check_get_project_owner($pidx) {
        if (($this->Userinfo['role'] == 'admin') || ($this->Userinfo['role'] == "adminentreprise")) {
            $chk = $this->Project->findByIdx($pidx);
        } else {
            $chk = $this->Project->findByUserIdAndIdx($this->Userinfo['id'], $pidx);
        }
        if (!$chk) {
            $this->Session->setFlash(__("Erreur de droits sur le projet !"), 'msg_alert');
            $this->redirect(array('controller'=>'challenges','action'=>'only_flash'));
        }
        return $chk;
    }


    public function edit_project($pidx) {
        // https://stackoverflow.com/questions/6848042/cakephp-automatically-populate-form-fields-from-model
        // $this->data = $this->Model->find('first',array(...));   
        $this->set('redirectpage', 'myprojects'); // To not redirect in case of admin edit his project
        if (($this->Userinfo['role'] == "admin") || ($this->Userinfo['role'] == "adminentreprise")) {
            //debug($chkpost);
            if (!strstr($this->referer(),'MyProjects')) {                
                $this->set('admin', 'yes'); // To not redirect in case of admin edit his project
                $this->set('redirectpage', 'admin');
            }           
        }
        $this->loadModel('Project');
        $this->loadModel('Challenge');
        $chk = $this->check_get_project_owner($pidx);
        // find the category for the challenge
        $this->Challenge->contain('Challengescategory');
        $chall = $this->Challenge->findByIdx($chk['Challenge']['idx']);
        if ((!$chall['Challenge']['hasprojects']) && ($this->Userinfo['role'] != "admin") && ($this->Userinfo['role'] != "adminentreprise")) {
            $this->Session->setFlash(__("La phase de dépôt de projet est terminée. Pour modifier votre projet, merci d'envoyer une demande par email à notre adresse de contact."), 'msg_alert');
            $this->redirect(array('controller' => 'challenges', 'action' => 'listmyprojects'));
        }
        //debug($chall);
        $chk['Challengescategory'] = $chall['Challengescategory'];
        // Create the selected category
        $selected = array();
        foreach ($chk['Projectcategory'] as $curcat) {
            array_push($selected,$curcat['challengescategory_id']);
        }
        $this->set('selected',$selected);
        $this->data = $chk;
        //debug($this->data);
        //debug($this->referer());exit;
        $this->set('editmode',true);        
        $this->set('challenge',$chk);// to be compliant with add_project page
        $this->set('homepage_challenge',$chk['Challenge']);
        $this->render('add_project');
        
    }

    public function add_project($challenge_idx=null) {
        $this->set('bodyclass', '');
        $this->set('page', 'add_project');
        $this->set('action', '');        
        $this->set('title_for_layout', __("Ajout d'un projet"));
        if ($this->request->is('post') || $this->request->is('put')) {
            //debug($this->data);//exit;
            if ($this->data) {
                // Les champs ont été renseignés
                $data = $this->data['Project'];
                //debug($data);exit;
                
                // On vérifie si le user Id est valide
                if ($data['challenge_id'] > 0) {
                    $challenge_id=$data['challenge_id'];
                    if (isset($data['idx'])) {
                        $challenge_id=$data['id'];
                    };
                    $this->loadModel('Project');
                    $this->loadModel('Projectcategory');
                    if (isset($data['post_update'])) {
                        $this->Project->id = $data['id'];
                        $idm = $this->Project->id;
                    } else {
                        $this->Project->create();
                    }
                    //debug($data);exit;
                    if ($this->Project->save($this->HV($data))) {
                        $idm = $this->Project->id;
                        
                        /*if (empty($data['Projectcategory'])) {
                            $this->Session->setFlash(__("Vous n'avez pas défini de catégories !"), 'msg_alert');
                            $this->redirect($this->referer());
                        }*/
                        if (!empty($data['Projectcategory'])) {
                            $this->Projectcategory->deleteAll(array('project_id'=>$idm),false);
                            foreach ($data['Projectcategory'] as $curcat) {
                                $this->Projectcategory->create();
                                $this->Projectcategory->save(array('project_id'=>$idm,'challengescategory_id'=>$curcat));
                            }
                        }
                        // Save project IDX
                        if (!isset($data['post_update'])) {
                            $this->Project->saveField('idx', $this->genidx('project'.$idm));
                        }
                        //if (!isset($data['post_update'])) {
                            // Vérifier si un fichier image est associé
                            $newimage = $this->create_file($this->genidx('project_image_form'.$idm),$data,'challenges','image_form',true);
                            //debug($newimage);//exit;
                            $newlogo = $this->create_file($this->genidx('project_logo_form'.$idm),$data,'challenges','logo_form');
                            $newfileaddon = $this->create_file($this->genidx('project_fileaddon_form'.$idm),$data,'../../Clients','fileaddon_form');
                        //}
                        if (!isset($data['post_update'])) {
                            //debug($newimage);exit;
                            if ($newimage) {
                                $this->Project->saveField('image', $newimage);
                            } else {
                                // If no image, set the first categorie image found
                                $this->loadModel('Project');
                                //$this->Project->contain('Challengescategory');
                                //$ret = $this->Challenge->findById($challenge_id);
                                $ret = $this->Project->find('first',array(
                                    'conditions' => array(
                                        'Project.id' => $idm
                                    ),
                                    'contain' => array(
                                        'Projectcategory' => array(
                                            'Challengescategory' => array(

                                            )
                                        )
                                    )
                                ));
                                //debug($ret);exit;
                                if (!empty($data['Projectcategory'])) {
                                    $this->Project->saveField('image', $ret['Projectcategory'][0]['Challengescategory']['image']);
                                }
                            }
                        } else {
                            if ($newimage) {
                                $this->Project->saveField('image', $newimage);
                            }
                        }
                        if ($newlogo) $this->Project->saveField('logo', $newlogo);
                        if ($newfileaddon) $this->Project->saveField('fileaddon', $newfileaddon);
                        
                        $this->Project->contain('Challenge');
                        $curproject = $this->Project->findById($idm,array('Project.name','Challenge.name'));
                        // Get user id infos                    
                        $this->loadModel('User');
                        $this->User->contain('City');
                        $chkuser = $this->User->findById($this->Userinfo['id'],array('User.prenom','User.nom','City.ville_nom_reel'));
                        $msgmail = __("Un nouveau projet a été posté sur le site");
                        $sujet = __("Nouveau message posté sur le réseau ") . Configure::read('Common.sitename');
                        if (isset($data['post_update'])) {
                            $msgmail = __("Un projet a été modifié sur le site");
                            $sujet = __("Un message a été modifié sur le réseau ") . Configure::read('Common.sitename');
                        }
                        $msgmail .= "<br>De : " . $chkuser['User']['prenom'] . " " . $chkuser['User']['nom'] . "<br>";
                        $msgmail .= "Ville : " . $chkuser['City']['ville_nom_reel'] . "<br>";
                        $msgmail .= "Challenge : " . $curproject['Challenge']['name']. "<br>";
                        $msgmail .= "Projet : " . $curproject['Project']['name'] . "<br>";
                        $this->send_global_email($sujet, $msgmail);

                        if ((($this->Userinfo['role'] == "admin") || ($this->Userinfo['role'] == "adminentreprise")) && isset($data['post_update']) && $data['redirectpage']=="admin") {
                            $this->Session->setFlash(__("Votre correction a bien été prise en compte."), 'msg_success');
                            $this->redirect(array('controller' => 'admins', 'action' => 'admin_projects'));
                        } else {
                            if (isset($data['post_update'])) {
                                $this->Session->setFlash(__("Ton projet a été modifié."), 'msg_success');
                                $this->redirect(array('controller' => 'challenges', 'action' => 'listmyprojects'));
                            } else {
                                $msg = __("Ton projet a été enregistré, merci !");
                                $msg.= "<br><br>";
                                $msg.= "<h5 class='msgprojectcreated'>".__("Attention: as tu réfléchi à protéger ton projet au niveau de la protection intellectuelle ?")."</h5>";
                                $msg.= "<h6 class='msgprojectcreated'>".__("Cela pourrait être pertinent de déposer une \"enveloppe Soleau\", cela ne coûte que 15 Euros.")." <br>".__("Plus de renseignements ici:");
                                $msg.= " <a target='_blank' href='https://www.inpi.fr/fr/services-et-prestations/e-soleau'>https://www.inpi.fr/fr/services-et-prestations/e-soleau</a></h6>";
                                $msg.= __("Note : Tu peux désormais modifier un projet en cliquant sur ton Prénom dans le menu, puis en cliquant sur 'Mes projets'");
                                $this->Session->setFlash($msg , 'msg_success');
                                $pp=$this->Project->findById($idm,array('idx'));
                                $this->redirect(array('controller' => 'challenges', 'action' => 'invite',$pp['Project']['idx']));
                            }
                        }
                    } else {
                        $this->Session->setFlash(__("Erreur lors de votre projet, merci de nous contacter"), 'msg_alert');
                        $this->redirect('/');
                    }
                } else {
                    $this->Session->setFlash(__("!! Erreur sur le challenge..."), 'msg_alert');
                    $this->redirect('/');
                }
            }
        } else {
            $this->set('openmode_value','OPEN');
            $this->set('selected',array(''));
            if ($challenge_idx==null) {
                $this->redirect('/');
            }
        }

        $challenge = $this->Challenge->find('first',array(
            'conditions' => array(
                'Challenge.idx' => $challenge_idx
            ),
            'contain' => array(
                'Challengescategory' => array(
                    'order' => array('Challengescategory.id asc')
                )
            )
        ));        
        
        
        $this->set('challenge',$challenge);
        $this->set('homepage_challenge',$challenge['Challenge']);
        //debug($challenge_idx);
        //debug($challenge);exit;
        
    }


    public function display_project($idx) {
        $this->loadModel('Project');
        $this->Project->contain('User','User.City','Projectcategory','Projectcategory.Challengescategory','Projectparticipant','Projectparticipant.User');
        $singlepost = $this->Project->find('first',array(
            'conditions'=>array(
                'Project.idx' => $idx
            ),
            'contain' => array(
                'Challenge',
                'User' => array(
                    'City' => array(
                        'fields' => array('id','ville_nom_reel')
                    )
                ),
                'Projectparticipant' => array(
                    'conditions'=>array(
                        'validated' => true
                    ),
                )
            )
            
        ));
        if (!$singlepost) {
            $this->redirect('/');
        }
        if (!$this->isCorrectWords($singlepost['Project']['name'])) {
            $singlepost['Post']['titre'] = $this->fixIncorrectword($singlepost['Project']['name']);
        }
        if (!$this->isCorrectWords($singlepost['Project']['description'])) {
            $singlepost['Project']['description'] = $this->fixIncorrectword($singlepost['Project']['description']);
        }
        $this->set('title_for_layout', $singlepost['Project']['name']);
        $this->set('curproject', $singlepost);
        $this->set('frompage', $this->referer());
        $this->set('bodyclass', '');
        $this->set('page', 'display_project');
        $this->set('challenge',$singlepost);//For logo display
        $this->set('singlepost', 'yes');
        $this->set('currentpageurl',$this->referer());
        $this->set('homepage_challenge',$singlepost['Challenge']);
    }

    
    public function wantparticipate($pidx=null) {
        $this->set('page', __("Participer"));
        if ($pidx!=null) {
            $this->set('pidx',$pidx);
            $this->loadModel('Project');
            $chkpart = $this->Project->find('first',array(
                'conditions' => array(
                    'Project.idx' => $pidx
                ),
                'contain' => array(
                    'Challenge' => array(
                        'fields' => array(
                            'Challenge.logo','Challenge.idx','Challenge.rules_pdf', 'Challenge.rules_activated','Challenge.name'
                        )
                    )
                )
            ));
            $this->set('homepage_challenge',$chkpart['Challenge']);

        } else {
            $this->redirect('/');
        }
    }

    public function wantparticipate_go() {
        if ($this->request->is('post')) {
            $data = $this->data['Project'];
            //debug($data);//exit;
            $this->loadModel('Project');
            $this->Project->contain('User','Challenge');
            $chk = $this->Project->findByIdx($data['pidx']);
            if ($chk) {
                $this->set('projectmode',$chk['Project']['openmode']);
                // check if user is participant already
                $pid = $chk['Project']['id'];
                $this->loadModel('Projectparticipant');
                //$chkpart = $this->Projectparticipant->findByProjectIdAndUserId($pid,$this->Userinfo['id']);
                $chkpart = $this->Project->find('first',array(
                    'conditions' => array(
                        'Project.idx' => $data['pidx']
                    ),
                    'contain' => array(
                        'Challenge' => array('fields'=>array('Challenge.logo','Challenge.idx','Challenge.name')), // For logo home page
                        'Projectparticipant' => array(
                            'conditions' => array(
                                'user_id' => $this->Userinfo['id'],
                                'project_id' => $pid
                            )
                        )
                    )
                ));

                $this->set('homepage_challenge',$chkpart['Challenge']);
                //debug($chkpart);exit;
                if (empty($chkpart['Projectparticipant'])) {
                    //debug($chk);
                    $this->Projectparticipant->create();
                    $validated = true;
                    if ($chk['Project']['openmode']=="CLOSED") {
                        $validated = false;
                    }
                    $this->Projectparticipant->save(array('Projectparticipant'=>array('user_id'=>$this->Userinfo['id'],'project_id'=>$pid,'validated'=>$validated)));
                    $sender_prenom_nom = $this->Userinfo['prenom'] . " " . $this->Userinfo['nom'];
                    $this->set('project_owner',$chk['User']['prenom']." ".$chk['User']['nom']);
                    $sujet = __("Demande de participation au projet ").$chk['Project']['name'];
                    $message = __("Vous avez reçu ce message parce que") . " " . $sender_prenom_nom ." ". __("vous demande de participer à votre projet sur")." "."<a href='" . Configure::read('Common.topurl') . "'>" . Configure::read('Common.sitename') . "</a>";
                    if ($chkpart['Project']['openmode']=="CLOSED") {
                        $message .= "<br><font color='red'><b>".__("Pour accepter la candidature de")." ".$sender_prenom_nom." "."dans votre équipe, merci de cliquer sur"." ";
                        $valid = $this->Userinfo['id'] . "/" .$chk['Project']['idx'];
                        $message .= "<a href='" . Configure::read('Common.topurl') . "/ValidateParticipant/$valid'>" . __("ce lien") . "</a></b></font>";
                    }
                    if (!empty($data['message'])) {
                        $message .= "<br>" . __("Son message") . ":<br>";
                        $message .= $data['titre']."<br>" . $data['message'];
                    }
                    $message .= "<br>".__("Challenge")." : " . $chkpart['Challenge']['name']. "<br>";
                    $message .= "<br>".__("Projet")." : " . $chk['Project']['name'] . "<br>";
                    $arraymailto = array('email' => $chk['User']['email']);
                    $this->send_global_email($sujet, $message, $arraymailto);
                } else {
                    // redirect to message
                    if ($chkpart['Project']['openmode']=="OPEN") {
                        $this->Session->setFlash(__("Vous etes déjà membre du projet !"), 'msg_alert');
                        $this->redirect(array('controller'=>'challenges','action'=>'display_project','idx'=>$chk['Project']['idx']));
                    } else {
                        // On réaffiche le message de validation
                        // C'est la vue par défaut
                        $this->set('project_owner',$chk['User']['prenom']." ".$chk['User']['nom']);
                    }
                    
                }     
                           
            } else {
                $this->redirect($this->referer());
            }
        }
    }

    public function validateparticipant($userid,$pidx) {
        $this->loadModel('Project');
        $this->Project->contain('Challenge');
        $pp1 = $this->Project->find('first',array(
            'conditions' => array(
                'Project.idx' =>$pidx,
            ), 
            'fields' => array(
                'Project.id','Challenge.name'
            )           
        ));
        if (!$pp1) {
            $this->Session->setFlash(__("Identification de validation inconnue"), 'msg_alert');
            $this->redirect(array('controller'=>'challenges','action'=>'listmyprojects'));
        }
        // Verify if userid is in projectparticipant
        $pp=$this->Project->find('first',array(
            'conditions' => array(
                'Project.idx' =>$pidx,
                'Project.user_id' => $this->Userinfo['id']
            ),
            'contain' => array(
                'Projectparticipant' => array(
                    'conditions' => array(
                        'project_id' => $pp1['Project']['id'],
                        'user_id' => $userid
                    )
                )
            )
        ));
        //debug($pp1);exit;
        if ($pp) {
            //$this->Projectparticipant->id = $pp['Projectparticipant'][0]['id'];
            $this->Project->Projectparticipant->save(array('id'=>$pp['Projectparticipant'][0]['id'],'validated'=>true));
            // Send mail to particpant
            $project_owner = $this->Userinfo['prenom'] . " " . $this->Userinfo['nom'];
            $candidat = $this->User->findById($userid,array('email'));
            $sujet = __("Demande de participation validée pour le projet ").$pp['Project']['name'];
            $message = __("Le porteur") . " " . $project_owner ." ". __("du projet")." ".$pp['Project']['name'];
            $message .=" (".__("challenge")." : ".$pp1['Challenge']['name'].") ".__("vous a accepté dans son équipe.");
            $arraymailto = array('email' => $candidat['User']['email']);
            $this->send_global_email($sujet, $message, $arraymailto);
            $this->Session->setFlash(__("Un message de confirmation d'acceptation vient d'être envoyé par email au candidat."), 'msg_success');
            $this->redirect(array('controller'=>'challenges','action'=>'listmyprojects'));
        } else {
            $this->Session->setFlash(__("Identification de validation inconnue"), 'msg_alert');
            $this->redirect(array('controller'=>'challenges','action'=>'listmyprojects'));
        }
    }


    public function invite($idx=null) {
        $this->set('page', __("Invitations"));
        if ($idx!=null) {
            $this->loadModel('Project');
            $pp=$this->Project->find('first',array(
                'conditions' => array(
                    'Project.idx' =>$idx 
                )
            ));
            $this->set('project',$pp);
            $this->set('invite_title',__("Partage ce projet par email !"));
            $this->set('invite_subtitle',__("Tu peux partager ce projet avec tes ami(e)s et les inviter à participer. Il te suffit de remplir les champs ci-dessous :"));
            $this->set('invite_placeholder',__("Ton message"));
            $this->set('homepage_challenge',$pp['Challenge']);
        }
    }

    public function invite_go($chidx=null) {
        if ($this->request->is('post')) {
            // Gerer les adresses mails multiples.
            $data = $this->data['User'];
            //debug($data);exit;
            $this->loadModel('Invitation');
            //$mails_array = explode(',', $data['liste_email']);
            $mails_array = $this->multiexplode(array(",",";"," "),$data['liste_email']);
            //debug($mails_array);exit;
            $message_welcome = $data['message'];
            // personne qui invite
            $sender_prenom_nom = $this->Userinfo['prenom'] . " " . $this->Userinfo['nom'];
            $project_name = $data['project_name'];
            $challidx = $data['challidx'];
            $this->loadModel('Project');
            $chkpart = $this->Project->find('first',array(
                'conditions' => array(
                    'Project.idx' => $data['projidx']
                ),
                'contain' => array(
                    'Challenge' => array('fields'=>array('Challenge.logo','Challenge.name')), // For logo home page
                )
            ));
            $challenge_name = $chkpart['Challenge']['name'];
            $challenge_logo = $chkpart['Challenge']['logo'];
            $this->set('homepage_challenge',$chkpart['Challenge']);

            // -----
            foreach ($mails_array as $mailad) {
                $mail_to = trim($mailad);
                if (!empty($mail_to)) {
                    // On verifie si l'email est correct
                    if (filter_var($mail_to, FILTER_VALIDATE_EMAIL)) {

                        $this->Invitation->create();
                        $array2save = array(
                            'Invitation' => array(
                                'user_id' => $this->Userinfo['id'],
                                'email' => $mail_to,
                            ),
                        );
                        $this->Invitation->save($array2save);
                        // envoi de l'email
                        $sujet = __("Invitation de")." ".$sender_prenom_nom." ".__("pour le projet")." ".$project_name." ".__("du challenge d'innovation")." ".$challenge_name; 
                        $message = __("Vous avez reçu ce message parce que") . " " . $sender_prenom_nom ." ". __("vous a invité pour son projet")." ".$project_name." ".__("dans le cadre du challenge d'innovation")." ".$challenge_name; 
                        $message .="<br>";
                        if (!empty($message_welcome)) {
                            $message .= "<br>" . __("Son message") . ":<br>" . $message_welcome;
                        }
                        //debug($message);exit;
                        $arraymailto = array('email' => $mail_to,'challenge'=>$challenge_name,'image'=>$challenge_logo);
                        $this->send_global_email($sujet, $message, $arraymailto,'general_email','challenge');
                    }
                }
            }
            $this->Session->setFlash(__("Vos invitations ont été envoyées, merci !"), 'msg_success');
            $this->redirect(array('controller' => 'challenges', 'action' => 'invite_go',$challidx));
        } else {
            $this->Challenge->contain();
            $chall = $this->Challenge->findByIdx($chidx);
            $this->set('homepage_challenge',$chall['Challenge']);
        }
    }

    public function removemeparticipant($project_idx) {
        $this->loadModel('Projectparticipant');
        $this->loadModel('Project');
        $this->Project->contain('User','Challenge');
        $chk = $this->Project->findByIdx($project_idx);
        if ($chk) {
            $this->set('project_owner',$chk['User']['prenom']." ".$chk['User']['nom']);
            $this->Projectparticipant->deleteAll(array('project_id'=>$chk['Project']['id'],'user_id'=>$this->Userinfo['id']), false);
            // Send mail to user
            // envoi de l'email
            $sujet = __("Desinscription sur un de vos projet");
            $message = __("Un utilisateur s'est désinscrit de votre projet") . " " . $chk['Project']['name']. " : ".$this->Userinfo['prenom']." ".$this->Userinfo['nom'];
            $arraymailto = array('email' => $chk['User']['email']);
            $this->send_global_email($sujet, $message, $arraymailto);
            $this->set('homepage_challenge',$chk['Challenge']);
        }
        //$this->redirect($this->referer());
    }

    public function listmyprojects()
    {
        $this->set('bodyclass', '');
        $this->set('controller2load', 'accueil');
        $this->set('title_for_layout', __("Mes projets"));
        $this->set('page', 'listmyprojects');
        $this->loadModel('Project');
        $this->Project->contain('Challenge','Projectparticipant');
        $allprojects = $this->Project->find('all',array(
            'conditions' => array(
                'user_id' => $this->Userinfo['id']
            ),
            'fields' => array('id','user_id','idx','name','description','image','logo'),
            'contain' => array(
                'Challenge' => array(
                    'fields' => array('id','idx','name','image','hasprojects')
                ),
                'Projectparticipant' => array(
                   'fields' => array('count(id) as NumberOfParticipant'),
                    'conditions'=>array(
                        'validated' => true
                    ),
                ),
            )
        ));
        //debug($allprojects);//exit;
        $this->set('count_projects',count($allprojects));
        $this->set('allprojects',$allprojects);
    }

    public function seeprojects($user_id64=null) {
        $chk = $this->User->findById(base64_decode($user_id64));
        if (!$chk) $this->redirect($this->referer());
        // User projects
        $this->loadModel('Project');
        $this->Project->contain('Challenge','Projectparticipant');
        $allprojects = $this->Project->find('all',array(
            'conditions' => array(
                'user_id' => base64_decode($user_id64)
            ),
            'fields' => array('id','user_id','idx','name','description','image','logo'),
            'contain' => array(
                'Challenge' => array(
                    'fields' => array('id','idx','name','image')
                ),
                'Projectparticipant' => array(
                    'fields' => array('count(id) as NumberOfParticipant'),
                    'conditions'=>array(
                        'validated' => true
                    ),
                ),
            )
        ));
        $this->set('title_for_layout', __('Projets'));
        $this->set('page', 'seeprojects');
        $this->set('allprojects',$allprojects);
        $this->set('theuser',$chk);
        $this->set('display_challenge_name',true);
    }

    public function remove_project($pidx) {
        // Verification
        $this->loadModel('Project');
        $this->Project->contain();
        $chk = $this->check_get_project_owner($pidx);
        $pid = $chk['Project']['id'];
        $this->Session->setFlash(__("Le projet a été supprimé"), 'msg_success');
        $this->Project->contain('Challenge');
        $curproject = $this->Project->findById($pid,array('Project.name','Challenge.*'));
        if ((!$curproject['Challenge']['hasprojects']) && ($this->Userinfo['role'] != "admin") && ($this->Userinfo['role'] != "adminentreprise")) {
            $this->Session->setFlash(__("La phase de dépôt de projet est terminée. Pour supprimer votre projet, merci d'envoyer une demande par email à notre adresse de contact."), 'msg_alert');
            $this->redirect(array('controller' => 'challenges', 'action' => 'listmyprojects'));
        }
        $ret = $this->Project->delete($pid, false);  
        $this->loadModel('Projectcategory');
        $this->Projectcategory->deleteAll(array('project_id' => $pid), false);

        $sujet = __("Un projet a été supprimé sur le réseau ") . Configure::read('Common.sitename');
        $this->loadModel('User');
        $this->User->contain('City');
        $chkuser = $this->User->findById($this->Userinfo['id'],array('User.prenom','User.nom','City.ville_nom_reel'));
        $msgmail = __("Un projet a été supprimé") . ' : <br>';
        $msgmail .= __("Par")." : " . $chkuser['User']['prenom'] . " " . $chkuser['User']['nom'] . "<br>";
        $msgmail .= __("Ville")." : " . $chkuser['City']['ville_nom_reel'] . "<br>";
        $msgmail .= __("Plateforme")." : " . Configure::read('Common.client.name') . "<br>";
        $msgmail .= __("Challenge")." : " . $curproject['Challenge']['name']. "<br>";
        $msgmail .= __("Projet")." : " . $curproject['Project']['name'] . "<br>";
        //debug($msgmail);exit;
        $this->send_global_email($sujet, $msgmail);
        $this->redirect($this->referer());
    }

    public function select_project($pidx,$selected=false) {
        // Verification
        $this->loadModel('Project');
        $this->Project->contain();
        $chk = $this->check_get_project_owner($pidx);
        $pid = $chk['Project']['id'];
        
        $this->Project->id = $pid;
        // Selected has the current value
        //debug($selected);exit;
        if ($selected == true) {$ret = $this->Project->saveField('selected', false);  $this->Session->setFlash(__("Le projet a été désélectionné"), 'msg_success'); }
        if ($selected == false) {$ret = $this->Project->saveField('selected', true);  $this->Session->setFlash(__("Le projet a été sélectionné"), 'msg_success'); }
        $this->redirect($this->referer());
    }


    public function contact($pidx=null) {
        $this->set('page', 'display_project'); // hack For bandeau menu haut de page
        $this->loadModel('Project');
        if ($this->request->is('post')) {
            $pidx = $this->data['Project']['pidx'];
        }
        $project = $this->Project->find('first',array(
            'conditions' => array(
                'Project.idx' => $pidx
            ),
            'fields' => array('id','user_id','idx','name','description','image','logo'),
            'contain' => array(
                'Challenge' => array(
                    'fields' => array('Challenge.logo','Challenge.idx')
                ),
                'User' => array(
                    'fields' => array('id','nom','prenom','email')
                )
            )
        ));
        if ($this->request->is('post')) {
            $data = $this->data;  
            //debug($project);          
            //debug($data);exit;
            $sender_prenom_nom = $this->Userinfo['prenom'] . " " . $this->Userinfo['nom'];
            // envoi de l'email
            $sujet = __("Demande d'information sur le projet ") . $project['Project']['name'];
            $message = __("Vous avez recu ce message parce que") . " " . $sender_prenom_nom . __(" vous a contacté sur") . " <a href='" . Configure::read('Common.topurl') . "'>" . Configure::read('Common.sitename') . "</a>";
            if (!empty($data['Project']['message'])) {
                $message .= "<br>" . __("Son message") . ":<br>" . $data['Project']['titre'].'<br>'.$data['Project']['message'];
                //debug($message);exit;
                $arraymailto = array('email' => $project['User']['email']);
                $this->send_global_email($sujet, $message, $arraymailto);
                $this->Session->setFlash(__("Ton message a été envoyé, merci !"), 'msg_success');
            } else {
                $this->Session->setFlash(__("Erreur. Message non envoyé !"), 'msg_alert');
            }
            
            $this->redirect(array('controller' => 'challenges', 'action' => 'display_project',$project['Project']['idx']));
        }
        $this->set('pidx',$pidx);
        $this->set('project_owner',$project['User']['prenom']." ".$project['User']['nom']);
        $this->set('project_prenom',$project['User']['prenom']);
        $this->set('homepage_challenge',$project['Challenge']);
    }

    public function search_projects($challidx=null) {
        $this->set('bodyclass', '');
        //$this->set('controller2load', 'accueil');
        $this->set('title_for_layout', __("Recherche"));
        $this->set('page', 'searchprojects');
        $this->loadModel('Project');
        //$this->Project->contain('Challenge');

        if ($this->request->is('post')) {
            //debug($this->data);//exit;
            $challidx = $this->data['Challenge']['challidx'];
            //$this->Challenge->contain('Challenge','Projectcategory');
            $project_conditions = "";
            if (!empty($this->data['Challenge']['recherche_user'])) {
                $rechercheuser = $this->data['Challenge']['recherche_user'];
                $project_conditions = array(
                    'OR' => array(
                        array('Project.name LIKE' => "%$rechercheuser%"),
                        array('Project.description LIKE' => "%$rechercheuser%")
                    )
                );
            }     
            $category_conditions = "";
            if (!empty($this->data['Challenge']['Projectcategory'])) {
                $category_conditions = array(
                    'challengescategory_id' => $this->data['Challenge']['Projectcategory']
                );
            }
            $country_conditions = "";
            if (!empty($this->data['Challenge']['selectedCountry'])) {
                $country_conditions = array(
                    'country_id' => $this->data['Challenge']['selectedCountry']
                );
            }
            //debug($conditions);
            $allprojects = $this->Challenge->find('first',array(
                'conditions' => array(
                    'Challenge.idx' => $challidx,
                ),
                //'fields' => array('id','user_id','idx','name','description','image','logo','created'),
                'contain' => array(
                    'Challengescategory' => array('fields'=>array('id','name')),
                    'Project' => array(
                        //'fields' => array('id',','name'),
                        'conditions' => $project_conditions,                       
                        'User'=> array(
                            'City' =>array(
                                'fields'=>array('ville_nom_reel','country_id'),
                                'conditions' => $country_conditions,          
                            )
                        ),
                        'Projectparticipant' => array(
                            'conditions'=>array(
                                'validated' => true
                            ),
                        ),
                        'Projectcategory' => array(
                            'conditions' => $category_conditions
                        )
                    )
                )
            ));
            //debug($allprojects);//exit;
            //debug($country_conditions);
            if (!empty($category_conditions)) {
                foreach ($allprojects['Project'] as $idx => $curr) {
                    if (empty($curr['Projectcategory'])) {
                        unset($allprojects['Project'][$idx]);
                    }
                }
            }
            //debug($allprojects);//exit;
            if (!empty($country_conditions)) {
                foreach ($allprojects['Project'] as $idx2 => $curr) {
                    if (empty($curr['User']['City'])) {
                        unset($allprojects['Project'][$idx2]);
                    }
                }
            }
            //debug($allprojects);exit;
        } else {            
            // No search, so display all projects
            $allprojects = $this->Challenge->find('first',array(
                'conditions' => array(
                    'Challenge.idx'=>$challidx
                ),
                //'fields' => array('id','user_id','idx','name','description','image','logo','created'),
                'contain' => array(
                    'Challengescategory' => array('fields'=>array('id','name'),'order'=>array('id asc')),
                    'Project' => array(
                        //'fields' => array('id',','name'),
                        'User'=> array(
                            'City' =>array('fields'=>array('ville_nom_reel'))
                        ),
                        'Projectparticipant' => array(
                            'conditions'=>array(
                                'validated' => true
                            ),
                        )
                    )
                )
            ));
            if (!$allprojects) {
                $this->redirect('/');
            }
            //$this->Paginator->settings = $posts_paginate;
            //$all_posts = $this->Paginator->paginate('Post');

            //debug($allprojects);exit;
        }
        $this->set('challenge',$allprojects);
        $this->set('homepage_challenge',$allprojects['Challenge']);

    }

}
