<?php
/**
 * Static content controller.
 *
 * This file will render views from views/pages/
 *
 * CakePHP(tm) : Rapid Development Framework (http://cakephp.org)
 * Copyright (c) Cake Software Foundation, Inc. (http://cakefoundation.org)
 *
 * Licensed under The MIT License
 * For full copyright and license information, please see the LICENSE.txt
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright     Copyright (c) Cake Software Foundation, Inc. (http://cakefoundation.org)
 * @link          http://cakephp.org CakePHP(tm) Project
 * @package       app.Controller
 * @since         CakePHP(tm) v 0.2.9
 * @license       http://www.opensource.org/licenses/mit-license.php MIT License
 */

App::uses('AppController', 'Controller');

/**
 * Static content controller
 *
 * Override this controller by placing a copy in controllers directory of an application
 *
 * @package       app.Controller
 * @link http://book.cakephp.org/2.0/en/controllers/pages-controller.html
 */
class PagesController extends AppController
{

    public $uses = array();
    public $components = array('Session', 'Cookie');

    public function beforeFilter()
    {
        parent::beforeFilter();
        $this->Auth->allow('ldp','ldp2','brochure', 'display', 'get_all_cities', 'get_all_departements', 'contact_msg','language','team');
    }

    public function brochure()
    {
        $this->redirect('/files/brochure.pdf');
    }



    private function loadSinglePost($post_id)
    {
        $this->loadModel('Post');
        //$this->Post->contain('User','Transaction');
        //$chkuser = $this->Post->findById($post_id,array('User.id'));
        //debug($chkuser);exit;
        $posts_cond = array(
            'conditions' => array('Post.id' => $post_id),
            'contain' => array(
                'Category','Tag',
                'User','City','City.Country',
                'Transaction' => array(
                    'limit' => 20,
                    'order' => array('Transaction.id desc'),
                ),
                'Transaction.User' => array(),
                'Transaction.Post' => array(),
            ),
            //'fields' => array('*')
        );
        $all_posts = $this->Post->find('first', $posts_cond);
        //debug($all_posts);exit;
        if (empty($all_posts)) {
            $this->Session->setFlash(__("Pas de messages trouvés pour votre critère de recherche"), 'msg_alert');
        }
        return $all_posts;
    }

    public function ldp2() {
        $this->layout = "landing_page2";
    }
    public function ldp() {
        $this->layout = "landing_page";
    }
    public function index($post_id = null)
    {

        if ($post_id == null) {
            $this->redirect('/');
        }

        $this->set('controller2load', 'accueil');
        //$this->set('controller2load_bis','posts');
        $this->set('page', 'display_single_post');
        $singlepost = $this->loadSinglePost($post_id); //debug($singlepost);exit;
        if (!$this->isCorrectWords($singlepost['Post']['titre'])) {
            $singlepost['Post']['titre'] = $this->fixIncorrectword($singlepost['Post']['titre']);
        }
        if (!$this->isCorrectWords($singlepost['Post']['message'])) {
            $singlepost['Post']['message'] = $this->fixIncorrectword($singlepost['Post']['message']);
        }
        $this->set('title_for_layout', $singlepost['Post']['titre']);
        $this->set('curpost', $singlepost);
        $this->set('frompage', $this->referer());
        $this->set('bodyclass', '');
        $this->set('singlepost', 'yes');
        $this->set('currentpageurl',$this->referer());

        // Find the transaction for the post user
        $this->loadModel('Transaction');
        //debug($singlepost['Post']['user_id']);
        $allavis = $this->Transaction->find('all',array(
            'conditions'=> array(
                'to_userid' => $singlepost['Post']['user_id'] 
            ),
            'order' => array('Transaction.id DESC'),
            'limit' => 10
        ));
        $this->set('allavis',$allavis);
        //debug($singlepost);
        //debug($allavis);exit;
        $this->render('/Pages/display_posts_user');
    }


    public function language($lang) {
        //$this->Session->write('Config.language',$lang);
        $this->Cookie->write('Config.language',$lang);
        $this->redirect('/');
    }   

    public function team() {
        $this->layout = "common";
    }

    public function display()
    {
        //debug(Configure::read('Common'));

        $path = func_get_args();
        $count = count($path);
        if (!$count) {
            return $this->redirect('/');
        }
        $page = $subpage = $title_for_layout = null;

        if (!empty($path[0])) {
            $page = $path[0];
            // chargement du controller correspondant
            $this->set('controller2load', $page);
        }
        if (!empty($path[1])) {
            $subpage = $path[1];
        }
        if (!empty($path[$count - 1])) {
            $title_for_layout = Inflector::humanize($path[$count - 1]);
        }

        if ($page == "accueil") {$title_for_layout = "Trockee";}
        if ($page == "cgu") {$title_for_layout = __("CGU");}
        if ($page == "ccm") {$title_for_layout = __("Comment troquer ses vêtements ?");}
        if ($page == "msgactivation") {$title_for_layout = __("Pb de connexion");}
        if ($page == "contact") {$this->set('pageactive', 'contact');}
        $bodyclass = "";
        if ($page == "accueil") {
            $this->set('pageactive', 'accueil');
            $this->clearUserCityLocation();
            //$this->layout = "default_old";
            $bodyclass = "body_accueil";
            $this->loadModel('Post');
            $CL = $this->getClientData();
            $PR = $CL['priority'];
            if ($PR=="O") {
                $retOffres = $this->getPosts('O', 5); //debug($page);debug($retOffres);exit;
                $retDemandes = $this->getPosts('D', 2);
            } else {
                $retOffres = $this->getPosts('O', 2); //debug($page);debug($retOffres);exit;
                $retDemandes = $this->getPosts('D', 5);
            }
            //debug($retOffres);
            $retAll = $this->getPosts('all', 25);           
            $this->set('last_messages', array('all' => $retAll['all_posts'], __("demandes") => $retDemandes['all_posts'], __("offres") => $retOffres['all_posts']));

            //$this->set('all_criteres',$this->getAllCriteres());

        }
        // Demarrage de l'appli

        $this->set(compact('bodyclass', 'page', 'subpage', 'title_for_layout', 'villes', 'Userinfo'));

        try {
            $this->render(implode('/', $path));
        } catch (MissingViewException $e) {
            if (Configure::read('debug')) {
                throw $e;
            }
            throw new NotFoundException();
        }
        //debug($villes);
    }

    public function cleancookie()
    {
        $this->clearUserCityLocation();
        $this->redirect($this->referer());
    }

    public function getfile($file) {
        $filepath = APP."/Clients/${file}";
        $this->response->file(
            $filepath,
            array('download' => true, 'name' => "${file}")
        );
        return $this->response;
    }

    public function recherche()
    {
        $this->set('bodyclass', '');
        $this->set('controller2load', 'accueil');
        if ($this->request->is('post')) {
            //debug($this->data);exit;
            $section = $this->data['Page']['section'];
            $category_recherche = $this->data['Page']['Category'];
            $rechercheuser = $this->data['Page']['recherche_user'];
            $this->set('followflag', 'unknown');
            if ($section == "echanges") {
                $cfg = Configure::read('PostConfig');
                // Save in session to retrieve in pages next,prev
                $this->Session->write(
                    array('rechercheFromUser' => array(
                        'category_recherche' => $category_recherche,
                        'rechercheuser' => $rechercheuser,
                    ),
                    )
                );
            }
        }

        if ($this->Session->check('rechercheFromUser')) {
            $rechercheuser = $this->Session->read('rechercheFromUser.rechercheuser');
            $category_recherche = $this->Session->read('rechercheFromUser.category_recherche');
            $cfg = Configure::read('PostConfig');
        }

        if ($this->request->is('post') or $this->Session->check('rechercheFromUser')) { // common parts
            $all_posts = $this->loadPosts($rechercheuser, $category_recherche); // in Appcontroller.php
            $this->set('all_posts', $all_posts);
            $this->set('all_posts', $all_posts);
            // On vérifie si le user est abonne, variable ci dessous non vide
            if (isset($all_posts[0]['City']['Follow'][0])) {
                if (!empty($all_posts[0]['City']['Follow'][0])) {
                    $this->set('followflag', 'yes');
                }
            }
            $this->set_post_pages_variables($cfg);
            $allcats = $this->get_all_categories_as_list();
            $this->set('rech_cat', $allcats);
            $this->render('display_posts');
        }
    }

    public function message()
    {
        $this->set('page', "message");
    }

    public function get_all_categories()
    {
        // Type cat = 1 pour échanges
        $allcats = $this->get_all_categories_as_list("echanges");
        $this->set('jsondata', $allcats);
        $this->layout = 'empty';
        $this->render('/Elements/jsonoutput');
    }

    public function get_all_departements()
    {
        $this->loadModel('Departement');
        $ret_dep = $this->Departement->find('all', array(
            'conditions' => array(),
            'fields' => array('id', 'code', 'nom', 'slug'),
        ));
        $array_dep_final = array();
        foreach ($ret_dep as $curdep) {
            array_push($array_dep_final, array(
                'id' => $curdep['Departement']['id'],
                'code' => $curdep['Departement']['code'],
                'slug' => $curdep['Departement']['slug'],
                'name' => $curdep['Departement']['nom'],
            ));
        }
        $this->set('jsondata', $array_dep_final);
        $this->layout = 'empty';
        $this->render('/Elements/jsonoutput');
    }

    public function get_all_cities($userInput = null)
    {
        $this->loadModel('City');
        $this->loadModel('Departement');
        $conditions = array();
        if ($userInput != null) {
            $conditions = array(
                'City.ville_nom_reel LIKE' => "%$userInput%",
            );
        }

        $ret = $this->City->find('all', array(
            'conditions' => $conditions,
            'fields' => array('City.id', 'ville_nom_reel', 'ville_code_postal'),
        ));
        $array_villes_final = array();
        foreach ($ret as $curcity) {
            array_push($array_villes_final, array(
                'name' => $curcity['City']['ville_nom_reel'],
                'cp' => $curcity['City']['ville_code_postal'],
                'id' => $curcity['City']['id'],
            ));
        }
        $this->set('jsondata', $array_villes_final);
        $this->layout = 'empty';
        $this->render('/Elements/jsonoutput');
    }

    public function contact_msg()
    {
        if ($this->request->is('post')) {
            //Configure::write('debug',2);
            //debug($this->data);//exit;
            // check the captcha
            $gcaptcha = $this->data['g-recaptcha-response'];
            $secretKey = Configure::read('Common.captchasecretkey');
            $url = 'https://www.google.com/recaptcha/api/siteverify?secret=' . urlencode($secretKey) .  '&response=' . urlencode($gcaptcha);
            $response = file_get_contents($url);
            $responseKeys = json_decode($response,true);
            // should return JSON with success as true
            //debug($response);exit;
            if($responseKeys["success"]) {
                $data = $this->data['Pages'];
                $sujet = Configure::read('Common.sitename') . ' : ' . __("Message de contact !");
                $msgmail = __("Un message de contact a été envoyè à partir de ") . Configure::read('Common.sitename') . ' : ';
                $msgmail .= "<br>De : " . $data['email']." (". $data['email'] . " )<br>";
                $msgmail .= __("Message") . " : <br>" . nl2br($data['message']) . "<br>";
                if (isset($data['maillbdp'])) {
                    $arraymailto = array('email' => Configure::read('lbdp.email'));
                    $this->send_global_email($sujet, $msgmail,$arraymailto);
                } else {
                    $this->send_global_email($sujet, $msgmail);
                }
                $this->Session->setFlash(__("Merci ! Votre message a été envoyé. Nous y répondrons rapidement."), 'msg_success');
            } else {
                
            }
            $this->redirect(array('controller' => 'pages', 'action' => 'display', 'accueil'));
        }
    }

    public function partage_page() {
        if ($this->request->is('post')) {
            //debug(Configure::read('Common.client'));exit;
            $data = $this->data['Pages'];
            $sujet = $data['titre_message'];
            $msgmail = __("Une annonce vous est partagée à partir de la plateforme ") . Configure::read('Common.client.subdomain').".".strtolower(Configure::read('Common.sitename')) . ' : ';
            $msgmail .= "<br>De " . $this->Userinfo['prenom']." ".$this->Userinfo['nom']." (". $this->Userinfo['email'] . " )<br>";
            $msgmail .= __("Annonce partagée") . " : " . $data['page2share'] . "<br><br>";
            //$msgmail .= __("Titre") . " : " . nl2br($data['titre_message']) . "<br>";
            $msgmail .= __("Message") . " : <br>" . nl2br($data['message']) . "<br>";
            $this->send_global_email($sujet, $msgmail,array('email'=>$data['email']));
            $this->Session->setFlash(__("Votre email a été envoyé."), 'msg_success');
            $this->redirect($data['page2share']);
        }
	}

    // Pages de ventes
    public function vente() {
        $this->set('page', '');
        $this->set('bodyclass', '');
        $this->set('page', 'vente');
        $this->set('controller2load', 'vente');
    }

    public function bordereau() {
        if (!strstr($this->referer(),'Vente')) {                
            $this->redirect(array('controller' => 'pages', 'action' => 'vente'));
        }
        $this->set('page', '');
        $this->set('bodyclass', '');
        $this->set('page', 'vente');
        $user_id = $this->Userinfo['id'];

        //debug($this->data);exit;
        $vente_name = "entrée_".$user_id."_".time();

        $tosave = array(
            'name' => $vente_name,
            'user_id' => $user_id,
            'poids_id' => $this->data['poidsselected']
        );
        $this->loadModel('Vente');
        $this->Vente->create();
        $vente = $this->Vente->save(array('Vente' => $tosave));
  

        $vref = $vente['Vente']['name'];
        $vdstr = date("d/m/Y", strtotime($vente['Vente']['created']));

        $sujet = __('Votre envoi de vêtements');
        $msgmail = __("Nous avons bien reçu votre demande de bordereau d'envoi pour nous expédier vos vêtements.");
        $msgmail .= "<br>Date : $vdstr<br>La référence de votre envoi est : $vref";
        $msgmail .= "<br><strong>Vous recevrez votre bordereau d'envoi par e-mail sous 48 heures.<strong>";
        $this->send_global_email($sujet, $msgmail,array('email'=>$this->Userinfo['email']));
        $sessmsg = "Merci c'est fait !<br>Un premier mail de confirmation vous a été envoyé, puis un second mail contenant votre bordereau vous sera envoyé prochainement.";
        $this->Session->setFlash($sessmsg, 'msg_success');
    }
   

}
