<?php
App::uses('SimpleImage', 'Lib');
// app/Controller/PostsController.php
class PostsController extends AppController
{

    public function beforeFilter()
    {
        parent::beforeFilter();
        $this->Auth->allow('catalogue');
        $this->set('controller2load', "posts");
    }

    public function index()
    {
        $this->redirect('/');
    }


    public function modify_post($typeannonce = null, $post_id = null)
    {
        $this->set('bodyclass', '');
        $this->set('page', 'annonces');
        // On verifie que le post à changer appartient au user
        if (($this->Userinfo['role'] == "admin") || ($this->Userinfo['role'] == "adminentreprise")) {
            $chkpost = $this->Post->findById($post_id);
            $this->set('admin', 'yes');
            $this->set('admin_user_id', $chkpost['User']['id']);
            $this->set('admin_city_id', $chkpost['User']['city_id']);
            //debug($chkpost);
        } else {
            $chkpost = $this->Post->findByIdAndUserId($post_id, $this->Userinfo['id']);
        }
        //debug($post_id);debug($chkpost);exit;

        if (!$chkpost) {
            $this->redirect($this->referer());
        }
        // On continue
        //debug($chkpost);
        $chkpost['Post']['message'] = html_entity_decode($chkpost['Post']['message'], ENT_QUOTES);
        $chkpost['Post']['titre'] = html_entity_decode($chkpost['Post']['titre'], ENT_QUOTES);
        $this->data = $chkpost; // Pour remplir le formulaire
        //debug($this->data);
        $this->set('post_id_a_modifier', $post_id);
        $this->set('action', 'change');
        $this->set('title_for_layout', Configure::read('PostConfig.section_titre_bouton_ecrire'));
        $this->set('configTxt', Configure::read('PostConfig'));
        $this->set('typeannonce', $typeannonce);
        $this->loadModel('Category');
        $all_categories = $this->Category->find('list', array(
            'conditions' => array(),
            'order' => 'Category.name',
        ));
        $this->set('all_categories', $all_categories);
        $this->set('from_page', $this->referer());
        if ($this->monnaie_temps_activated) {
            $this->set('all_monnaie_values', Configure::read('Common.monnaie.values.'.$typeannonce));
        } else {
            $this->set('all_monnaie_values', Configure::read('Common.monnaie.classique'));
        }
        $this->loadModel('Critere');
        $ret = $this->Critere->find('all',array('order'=>array('Critere.name')));
        $this->set('all_criteres', $ret);
        $this->set('selected_tags', Hash::extract($this->data['Tag'], '{n}[].id'));
        $this->render('ajout_annonce');
    }

    public function ajout_annonce($typeannonce = null)
    {
        $this->verif_admin(); // Only admin LBDP could create post
        $this->set('bodyclass', '');
        $this->set('page', 'annonces');
        $this->set('action', '');
        $this->set('from_page', $this->referer());
        if ($this->monnaie_temps_activated) {
            $monnaies = Configure::read('Common.monnaie.values.'.$typeannonce);
        } else {
            $monnaies = Configure::read('Common.monnaie.classique');
        }

        // -------------------------------------------------------------------------------------
        //if ($this->request->is('post')) {
        if ($this->data) {
            $full_data = $this->data;
            //debug($full_data);exit;
            // Les champs ont été renseignés
            $data = $this->data['Post'];
            $post_id=null;
            if (isset($data['id'])) {
                $post_id=$data['id'];
            };
            //debug($typeannonce);
            //debug($data);exit;
            //$full_data['Post']['titre'] = ucfirst(strtolower($full_data['Post']['titre']));

            // On verifie la valeur du champ monnaie_value
            $this->loadModel('User');
            // Autorisé donc on rajoute 1 au compteur de posts monnaie
            $ret = $this->User->updateAll(
                array('User.nb_monnaie_posts' => 'User.nb_monnaie_posts+1'),
                array('User.id' => $this->Userinfo['id'])
            );

            //debug($data);exit;
            if ($this->Userinfo['id'] == Configure::read('Reseau.user_id')) {
                if (trim($data['villeReseau']) != "") {
                    //debug($data['villeReseau']);exit;
                    $Reseaucity = $this->check_google_city($data['villeReseau']);
                    if ($Reseaucity) {
                        $reseau_city_id = $Reseaucity['City']['id'];
                        $full_data['Post']['city_id'] = $reseau_city_id;
                    } else {
                        $this->Session->setFlash(__("!! Erreur : Ville non trouvée dans la database !"), 'msg_alert');
                        $this->redirect($this->referer());
                    }
                }
            }
            // On vérifie si le user Id est valide
            if ($data['user_id'] > 0 and $data['city_id'] > 0) {
                // On vérifie  le lien vidéo
                $chkyout = 0;
                if (isset($full_data['Post']['youtube'])) {
                    if (
                        strstr($full_data['Post']['youtube'], "https://www.youtube.com") or
                        strstr($full_data['Post']['youtube'], "https://youtu.be") or
                        strstr($full_data['Post']['youtube'], "https://vimeo.com")
                    ) {
                        $chkyout = 1;
                    }
                }
                if ($chkyout == 0) {
                    $full_data['Post']['youtube'] = "";
                }
                //debug($full_data);    exit;

                $this->Post->create();
                //debug($full_data);exit;
                //debug($this->HV($full_data));exit;
                if ($this->Post->save($this->HV($full_data))) {
                    $idm = $this->Post->id;
                    // Save the tags
                    if (isset($full_data['Post']['Tags'])) {
                        $this->loadModel('PostTag');
                        // Clear before setting
                        $this->PostTag->deleteAll(array('PostTag.post_id' => $idm), false);
                        // Save now                    
                        foreach ($full_data['Post']['Tags'] as $tagid=>$value) {
                            $varadd = array('post_id'=>$idm,'tag_id'=>$tagid);
                            $this->PostTag->create();
                            $this->PostTag->save($varadd);
                        }
                    }

                    // Vérifier si un fichier image est associé
                    if ($data['image_info']['name'] != '') {
                        // Copie de l'umage en lieu sur..
                        //debug($data);
                        $ext = pathinfo($data['image_info']['name'], PATHINFO_EXTENSION);
                        //debug($ext);
                        $authexts = Configure::read('Common.postExt');
                        if (isset($authexts[strtolower($ext)])) {
                            //if ($ext!="") {
                            // Un nom d'image en timestamp
                            $img = time();
                            $source = WWW_ROOT . DIRECTORY_SEPARATOR . 'img/post/' . $img;
                            $filename = $source . '.' . $ext;
                            $filename_webp = $source . '.webp'; 
                            //debug($source);
                            move_uploaded_file($data['image_info']['tmp_name'], $filename);
                            $this->smart_resize_image($filename, null, 600, 450, false, $filename, false, false, 100);
                            $this->Post->saveField('image', 'post/' . $img . '.' . $ext);
                            // Save Webp
                            //exec("/usr/bin/convert $filename $filename_webp",$output);
                            //debug("/usr/bin/convert $filename $filename_webp");
                            //debug($output);exit;
                        }
                    }
                    //$msg_city_id = $this->data['Post']['city_id'];
                    //$this->loadModel('City');
                    // Récupération du département de la ville
                    //$this->City->contain();
                    //$city_info = $this->City->find('first', array('conditions' => array('City.id' => $msg_city_id), 'fields' => array('ville_nom_reel', 'ville_departement')));

                    // Send email to admins
                    //$sujet = __("Nouvelle annonce postée sur le réseau") ." ". Configure::read('Common.sitename');
                    //if (isset($full_data['Post']['post_update'])) {
                    //    $sujet = __("Une annonce a été modifiée sur le réseau") ." ". Configure::read('Common.sitename');
                    //}

                    // Get user id infos
                    //$this->loadModel('User');
                    //$this->User->contain();
                    //$chkuser = $this->User->findById($data['user_id']);
                    //$tt = Configure::read('Common.echangestype');
                    //$msgmail = __("Une nouvelle annonce a été postée sur la plateforme : ");
                    //if (isset($full_data['Post']['post_update'])) {
                    //    $msgmail = __("Une annonce a été modifiée sur le site ");
                    //}
                    //$msgmail .= "<br>De : " . $chkuser['User']['prenom'] . " " . $chkuser['User']['nom'] . "<br>";
                    //$msgmail .= "Ville : " . $city_info['City']['ville_nom_reel'] . "<br>";
                    //$msgmail .= "Type : " . $tt[$full_data['Post']['type']] . "<br>";
                    //$msgmail .= "Plateforme : " . Configure::read('Common.client.name') . "<br>";
                    //$msgmail .= __("Titre") . " : " . $full_data['Post']['titre'] . "<br>";
                    //$msgmail .= __("Annonce") . " : <br>" . nl2br($full_data['Post']['message']) . "<br>";
                    //if ($data['image_info']['name'] != '') {
                    //    $msgmail .= "<br>Image : https://" . strtolower(Configure::read('Common.sitename')) . "/img/post/" . $img . '.' . $ext . "<br>";
                    //    $msgmail .= "<img src=\"https://" . strtolower(Configure::read('Common.sitename')) . "/img/post/" . $img . '.' . $ext . "\">";
                    //}
                    //debug($full_data);
                    //debug(nl2br($msgmail));exit;
                    //debug($this->Userinfo['role']);exit;
                    //$this->send_global_email($sujet, $msgmail);

                    if ((($this->Userinfo['role'] == "admin") || ($this->Userinfo['role'] == "adminentreprise")) && $post_id!=null) {
                        $this->Session->setFlash(__("Votre correction a bien été prise en compte."), 'msg_success');
                    } else {
                        $this->Session->setFlash(__("Votre annonce a été enregistrée, merci !") . '<br><br>' . __("Note : Vous pouvez désormais modifier une annonce en cliquant sur votre Prénom dans le menu, puis en cliquant sur 'Mes offres/demandes'"), 'msg_success');
                    }
                } else {
                    $this->Session->setFlash(__("Erreur lors de la création de votre annonce, merci de nous contacter"), 'msg_alert');
                }
                if (isset($data['from_page'])) {
                    $this->redirect($data['from_page']);
                } else {
                    if ((($this->Userinfo['role'] == "admin") || ($this->Userinfo['role'] == "adminentreprise")) && $post_id!=null) {
                        $this->redirect(array('controller' => 'admins', 'action' => 'admin_posts'));
                    } else {
                        $this->redirect(array('controller' => 'posts', 'action' => 'listmyposts',$data['type']));
                    }
                } 
                
            } else {
                $this->redirect(array('controller' => 'users', 'action' => 'login'));
                $this->Session->setFlash(__("!! Erreur : Problème d'identification de votre session..."), 'msg_alert');
            }
        }
        $this->set('title_for_layout', Configure::read('PostConfig.section_titre_bouton_ecrire'));
        $this->set('configTxt', Configure::read('PostConfig'));
        $this->set('typeannonce', $typeannonce);
        $this->loadModel('Category');
        $all_categories = $this->Category->find('list', array(
            'conditions' => array(),
            'order' => 'Category.name',
        ));
        $this->set('all_categories', $all_categories);
        //debug(Configure::read('Common.monnaie.values.'.$typeannonce));exit;
        $this->set('all_monnaie_values', $monnaies);
        $this->set('all_criteres',$this->getAllCriteres());

    }

    public function remove($post_id)
    {
        // Verification
        $this->Post->contain();
        // Verification
        if (($this->Userinfo['role'] == 'admin') || ($this->Userinfo['role'] == "adminentreprise")) {
            $chk = $this->Post->findById($post_id);
        } else {
            $chk = $this->Post->findByUserIdAndId($this->Userinfo['id'], $post_id);
        }
        // Action
        if ($chk) {
            // Delete the image file
            $filepath = APP."webroot/img/post/".$chk['Post']['image'];
            if (file_exists($filepath)) unlink($filepath);
            $ret = $this->Post->delete($post_id, false);
            $this->Session->setFlash(__("L'annonce a été supprimée"), 'msg_success');
        } else {
            $this->Session->setFlash(__("Erreur lors de la suppression"), 'msg_alert');
        }
        $this->redirect($this->referer());
    }

    public function setPausedReserved($post_id,$reserved=false)
    {
        // Verification
        $this->Post->contain();
        // Verification
        $chk = $this->Post->findByUserIdAndId($this->Userinfo['id'], $post_id);
        // Action
        if ($chk) {
            $this->Post->contain();
            $pinfo = $this->Post->findById($post_id,array('*'));
            if ($reserved) {
                $pp = $pinfo['Post']['reserved'];
            } else {
                $pp = $pinfo['Post']['paused'];
            }
            
            $this->Post->id = $post_id;
            if ($pp) {
                if ($reserved) {
                    $this->Post->saveField('reserved',false);
                    $this->Session->setFlash(__("Votre annonce a été dé-reservée"), 'msg_success');
                } else {
                    $this->Post->saveField('paused',false);
                    $this->Session->setFlash(__("Votre annonce a été réactivée"), 'msg_success');
                }
            } else {
                if ($reserved) {
                    $this->Post->saveField('reserved',true);
                    $this->Session->setFlash(__("Votre annonce a été reservée"), 'msg_success');
                } else {
                    $this->Post->saveField('paused',true);
                    $this->Session->setFlash(__("Votre annonce a été mise en pause"), 'msg_success');
                }
            }
        } else {
            $this->Session->setFlash(__("Erreur lors de la suppression"), 'msg_alert');
        }
        $this->redirect($this->referer());
    }


    public function catalogue($type = 'O',$category_name=null)
    {
        $this->set('all_criteres', $this->getAllCriteres());
        $this->set('category_name',$category_name);
        $allcats = $this->get_all_categories_as_list("echanges");
        $this->set('AllCategories', $allcats);      
        //debug($this->Cookie->read('choixUser'));exit;
        if ((!strstr($this->referer(), "Catalogue-" . $type)) and (!strstr($this->referer(), "catalogue/" . $type))) {
            //debug($this->referer());
            //debug(strstr($this->referer(),"catalogue/".$type));exit;
            $this->clearUserCityLocation();
        }
        //debug($this->referer());//exit;
        //debug($this->Paginator->numbers);exit;
        //$this->clearUserCityLocation();

        $this->setUserCookieRecherche();
        $this->set('selected_tags',array());
        // Est-ce une recherche ?
        if ($this->request->is('post')) {
            $userdata = $this->data;  
            //debug($category_name);          
            //debug($userdata);exit;
            if (isset($userdata['resettags']) && $userdata['resettags']=='true') {
                unset($userdata['Post']['Tags']);
                $userdata['recherche_user'] = null; // pour getposts
                $this->data = null; // pour le formulaire
            }
            if (isset($userdata['tag2reset']) && $userdata['tag2reset']!=0) {
                unset($userdata['Post']['Tags'][$userdata['tag2reset']]);
            }
            if (isset($userdata['Post']['Tags'])) {
                $this->set('selected_tags', array_keys($userdata['Post']['Tags']));
                $this->set('selected_tags_names', $userdata['Post']['Tags']);
            } 
            if ($category_name!=null) {
                $catchk = $this->Category->findByName($category_name);
                //$ret = $this->getPosts($type, 17, array('filter_page_critere'=>$pagefilter));
                if ($catchk) {
                    $userdata['cat_id'] = $catchk['Category']['id'];
                }
            }
            //debug($userdata);//exit;
            // On charge les post correspondants à la recherche
            //$ret = $this->getPosts($type, 17, $this->data['Pages']['category_id'], $this->data['recherche_user']);
            $ret = $this->getPosts($type, 17, $userdata);
            //debug($ret);exit;
            //debug($this->data['Pages']['category_id']);exit;
        } else {
            //exit;
            $chkcategory_id = null;
            if ($category_name!=null) {
                $catchk = $this->Category->findByName($category_name);
                //$ret = $this->getPosts($type, 17, array('filter_page_critere'=>$pagefilter));
                if ($catchk) $chkcategory_id = $catchk['Category']['id'];
            }
            //$chkcategory_id = $this->getCurrentCategory('id');
            //debug($chkcategory);exit;
            if ($chkcategory_id) {
                $ret = $this->getPosts($type, 17, array('cat_id'=>$chkcategory_id));
                //debug($ret);exit;
            } else {
                $ret = $this->getPosts($type, 17);
            }
            //debug($ret);exit;
        }
        //debug($ret);exit;        
        $typestr = __("offre");
        $typestrplural = __("offre"); 

        $this->set('title_for_layout', __("Les offres ").strtolower($category_name));

        if ($ret['count']>1) {
            //$typestr .= "s"; // PB allemand,,  ne pas rajoutés de 's' !!
            if ($type == 'D') {
                $typestrplural = __("demandes");
            } else {
                $typestrplural = __("offres"); 
            }
        }

        $this->set('typestr', $typestr);
        $this->set('typestrplural', $typestrplural);
        $this->set('last_messages', array($typestr => $ret['all_posts'], 'count' => $ret['count']));
        $this->set('userInput', $this->Cookie->read('choixUser'));
        $infosloc = $this->getCurrentlocation();
        $this->set('current_location', $infosloc);
        $currentCategory = $this->getCurrentCategory();
        //debug($infosloc);exit;

        $this->set('current_category', $currentCategory);
        //debug($ret);exit;

        $this->set('page', 'catalogue');
        $this->set('pageactive', 'catalogue-' . $type);
        $this->set('type', $type);
        $this->set('controller2load', 'accueil');
        $this->set('bodyclass', '');
        if (!$ret) {
            $tpstr = "demande";
            if ($type == "O") {
                $tpstr = "offre";
            }

            $this->Session->setFlash("Désolé, aucune " . $tpstr . " ne correspond à ces critères précis pour l'instant.", 'msg_glaz');
        }             
        $this->render('catalogue_new');
    }

    public function catalogue_category($catid, $posttype)
    {
        $this->set('bodyclass', '');
        $this->set('controller2load', 'accueil');
        $cfg = Configure::read('PostConfig');
        $all_posts = $this->loadPosts(null, $catid, $posttype); // in Appcontroller.php
        //debug($all_posts);
        $this->set('all_posts', $all_posts);
        $this->set_post_pages_variables($cfg);
        $this->set('catalogue', 'yes');
        $this->set('titre_section', $cfg['title_for_layout'] . "<br>" . __("Vous consultez les") . " " . Configure::read('Common.echangestype_str.' . $posttype));
        $this->render('/Pages/display_posts');
    }

    public function listmyposts($type = 'O')
    {
        $this->set('bodyclass', '');
        $this->set('page', 'listpost');
        $this->set('controller2load', 'accueil');
        $this->set('title_for_layout', __("Mes annonces"));
        $this->set('page', 'listmyposts');

        //$theuser = $this->User->findById($this->Userinfo['id']);
        //debug($type);exit;
        $allposts = $this->loadPostsUser($this->Userinfo['id'], $type, 'NOMESSAGEDISPLAY');
        $this->loadModel('Post');
        $nb = $this->Post->getPostsCount($this->Userinfo['id'], $type);
        if ($type == 'O') {
            $strtype = __("offres");
            $strtype2 = __("d'offres");
            $this->set('last_messages', array(__("offres") => $allposts));
        } else {
            $strtype = __("demandes");
            $strtype2 = __("de demandes");
            $this->set('last_messages', array(__("demandes") => $allposts));
        }
        $this->set('count_posts', $nb);
        $this->set('strtype', $strtype);
        $this->set('strtype2', $strtype2);
    }


    private function loadUserFavorites()
    {
        $this->loadModel('Favorite');

        $posts_paginate = array(
            'limit' => 9,
            'conditions' => array(
                'Post.id !=' => null,
                'Post.paused' => false,
                'User.vacation' => false
            ),
            'joins' => array(
                array(
                    'table' => 'favorites',
                    'alias' => 'Favoritejoin',
                    'type' => 'INNER',
                    'conditions' => array(
                        'Favoritejoin.user_id' => $this->Userinfo['id'],
                        'Favoritejoin.post_id = Post.id',
                    ),
                ),
                array(
                    'table' => 'cities',
                    'alias' => 'CityJoin',
                    'type' => 'INNER',
                    'conditions' => array(
                        'CityJoin.id = User.city_id'
                    )
                )
            ),
            'contain' => array(
                'Category' => array('fields' => array('name', 'image')),
                'User' => array('fields' => array('id', 'nom', 'prenom', 'photo', 'city_id', 'type')),
                'User.TransactionDebit' => array(
                    'fields' => array('Sum(amount) as amount_debit'),
                ),
                'Transaction.User' => array(),
                'Transaction.Post' => array(),
                'City' => array('fields' => array('ville_nom_reel', 'id')),
            ),
            'order' => array('Post.id' => 'DESC'),
            'fields' => array('Post.*', 'Favoritejoin.*','CityJoin.ville_nom_reel'),
        );
        $this->Paginator->settings = $posts_paginate;
        $all_posts = $this->Paginator->paginate('Post');

        return $all_posts;
    }


    public function listmyfavorites()
    {
        $this->set('bodyclass', '');
        $this->set('page', 'listmyfavorites');
        $this->set('controller2load', 'accueil');
        $this->set('title_for_layout', __("Mes favoris"));

        //$theuser = $this->User->findById($this->Userinfo['id']);
        //debug($type);exit;
        $allposts = $this->loadUserFavorites();
        //debug($allposts);
        $nb = count($allposts);
        //debug($nb);exit;
        $strtype = __("favoris");
        $strtype2 = __("de favoris");
        $this->set('last_messages', array(__("favoris") => $allposts));
        $this->set('count_posts', $nb);
        $this->set('strtype', $strtype);
        $this->set('strtype2', $strtype2);
    }


    private function get_all_favorites()
    {
        $allfavorites = array();
        if (isset($this->Userinfo['id'])) {
            $this->loadModel('Favorite');
            $curuser_id = $this->Userinfo['id'];
            $this->Favorite->contain('Post','User');
            $allfavorites = $this->Favorite->find('list', array(
                'conditions' => array(
                    'Favorite.user_id' => $curuser_id,
                    'Post.id !=' => null,
                    'Post.paused' => false,
                    //'User.vacation' => false
                ),
                'fields' => array('Favorite.post_id', 'Favorite.post_id'),
            ));
        }
        return $allfavorites;
    }

    public function get_favorites()
    {
        $ret = $this->get_all_favorites();
        $this->autoRender = false;
        return json_encode($ret);
    }

    public function togglefavorite($postid)
    {
        $this->loadModel('Favorite');
        $this->autoRender = false;
        $this->Favorite->contain();
        $res = $this->Favorite->find('first', array(
            'conditions' => array(
                'Favorite.user_id' => $this->Userinfo['id'],
                'Favorite.post_id' => $postid,
            ),
        ));
        if ($res) {
            $this->Favorite->delete($res['Favorite']['id']);
            return "no";
        } else {
            $this->Favorite->create();
            $this->Favorite->save(array('user_id' => $this->Userinfo['id'], 'post_id' => $postid));
            return "yes";
        }
        return "done";
    }

    public function togglesold($postid)
    {
        $this->loadModel('Post');
        $this->autoRender = false;
        $this->Post->contain();
        $res = $this->Post->findById($postid);
        if ($res) {
            $this->Post->id = $res['Post']['id'];
            $this->Post->saveField('sold',false);
            return "no";
        } 
        return "done";
    }
}
