<?php


// app/Controller/StripeController.php
class StripeController extends AppController
{
    public $components = array('Stripe');

    public function beforeFilter()
    {
        parent::beforeFilter();
        $this->set('page', '');
        $this->set('bodyclass', '');
        $this->set('controller2load', 'stripe');
        //$this->Auth->allow('index');

    }

		private function createStripeClient() {
			$customer = $this->Stripe->createCustomer([
				'description' => $this->Userinfo['prenom'].' '.$this->Userinfo['nom'],
				'email' => $this->Userinfo['email'],
				//'payment_method' => 'pm_card_visa',
			]);
			if ($customer['status']=='success') {
        $this->loadModel('User');
        $this->User->id = $this->Userinfo['id'];
        $this->User->saveField('stripe_id', $customer['response']['id']);
			}
		}

    public function buypoints() {
      $pricebypoint_stripe = $this->Stripe->getPrice([
        'price_id' => Configure::read('Stripe.pointPrice')
      ]);
      $priceperpoints = $pricebypoint_stripe['response']['unit_amount']/100;
      $this->set('priceperpoints',$priceperpoints);
    }

    public function checkout() {
      //debug($this->data);exit;
      $customer_id = $this->Userinfo['stripe_id'];
      if (!$customer_id) {
        $ret = $this->createStripeClient();
        $customer_id = $ret['response']['id'];
      }
      // Now create the session with all items
      // See https://stripe.com/docs/checkout/quickstart
      
      $cancel_url = Configure::read('Common.topurl').'/Panier';

      $data64 = base64_encode(json_encode($this->data['nbpoints']));

      $success_url = Configure::read('Common.topurl').'/PaiementValide/'.$data64;     

      $checkout_session = $this->Stripe->createSession([
        'line_items' => [['price'=>Configure::read('Stripe.pointPrice'),'quantity' => $this->data['nbpoints']]],
        'mode' => 'payment',
        'success_url' => $success_url,
        'cancel_url' => $cancel_url,
        //'metadata' => $posts_ids,
        'customer' => $customer_id,
      ]);
      $this->redirect($checkout_session['response']['url']);
    }

    public function goBuyPoints($pID,$quantitypoints,$quantity=1) {
      //debug($this->data);exit;
      $customer_id = $this->Userinfo['stripe_id'];
      if (!$customer_id) {
        $ret = $this->createStripeClient();
        $customer_id = $ret['response']['id'];
      }
      // Now create the session with all items
      // See https://stripe.com/docs/checkout/quickstart
      
      $cancel_url = Configure::read('Common.topurl').'/Panier';

      if ($pID==Configure::read('Stripe.pointPrice')) {
        $quantity=$quantitypoints;
      }

      $data64 = base64_encode(json_encode($quantitypoints));

      $success_url = Configure::read('Common.topurl').'/PaiementValide/'.$data64;     

      $checkout_session = $this->Stripe->createSession([
        'line_items' => [['price'=>$pID,'quantity' => $quantity]],
        'mode' => 'payment',
        'success_url' => $success_url,
        'cancel_url' => $cancel_url,
        //'metadata' => $posts_ids,
        'customer' => $customer_id,
      ]);
      $this->redirect($checkout_session['response']['url']);
    }

    // PaiementValide
    public function validatecart($data64) {
      $nbpoints = json_decode(base64_decode($data64));
      // Create a new transaction
      $tosave = array(
          'user_id' => 0,
          'to_userid' => $this->Userinfo['id'],
          'amount' => $nbpoints,
          'message' =>  __('Achat de'.' '.$this->ClientData['monnaie_name']."s"),
      );
      $this->loadModel('Transaction');
      $this->Transaction->create();
      $this->Transaction->save(array('Transaction' => $tosave));

      $this->redirect(array('controller' => 'carts', 'action' => 'view'));

    }   

}
