<?php
App::uses('SimpleImage', 'Lib');
// app/Controller/UsersController.php
class UsersController extends AppController
{

    public function beforeFilter()
    {
        parent::beforeFilter();
        //$this->Auth->allow('add_client','add', 'logout', 'login', 'change_password', 'verify_code', 'getAuthEmails');
        $this->Auth->allow('add', 'logout', 'login', 'change_password', 'verify_code', 'getAuthEmails');
        //$this->set('controller2load',"users");
        $this->set('bodyclass', '');

    }

    public function add_client($name, $subdomain, $pass)
    {
        $this->autoRender = false;
        if ($pass == Configure::read('Admin.passadclient')) {
            $this->loadModel('Client');
            $this->Client->create();
            $arr = array(
                'Client' => array(
                    'name' => $name,
                    'subdomain' => $subdomain,
                    'description' => $subdomain,
                ),
            );
            $retclient = $this->Client->save($arr);
            $this->loadModel('User');
            $adminusers = Configure::read('Admin.users');
            //debug($adminusers);exit;
            foreach ($adminusers as $curuser) {
                $this->User->create();
                Configure::write('Common.client.id', $retclient['Client']['id']);
                $this->User->save(array('User' => $curuser));
            }
            // Add la braderie user
            $lbdp = Configure::read('Admin.lbdp');
            $this->User->create();
            Configure::write('Common.client.id', $retclient['Client']['id']);
            $this->User->save(array('User' => $lbdp));

            
            $this->loadModel('Category');
            $admincat = Configure::read('Admin.categories');
            //debug($adminusers);exit;
            foreach ($admincat as $curcat) {
                $this->Category->create();
                $catar = array(
                    'client_id' => $retclient['Client']['id'],
                    'name' => $curcat[0],
                    'image' => $curcat[1],
                    'monnaie_minimum' => 0,
                    'monnaie_valeuros' => 1,
                    'monnaie_default' => 15,
                );
                Configure::write('Common.client.id', $retclient['Client']['id']);
                $this->Category->save(array('Category' => $catar));
            }
        }
        return "done";
    }

    public function login()
    {
        $this->set('page', 'login');
        $this->set('title_for_layout', __("Connexion"));
        if ($this->request->is('post')) {
            //debug($this->data);exit;
            $this->User->contain();
            //debug($this->data['User']['password']);
            //debug(AuthComponent::password($this->data['User']['password']));
            $chk = $this->User->findByEmailAndActivated($this->data['User']['email'], 1);
            //debug(AuthComponent::password($chk['User']['password']));
            //debug(AuthComponent::password($chk['User']['password']));
            //debug(AuthComponent::password($this->Auth->user('password')));
            //debug($this->Auth->user());
            //debug($chk['User']['password']);
            //exit;
            if ($chk) {
                //debug($chk);
                //$cookie = array();
                //$cookie['username'] = $this->data['User']['email'];
                //$cookie['password'] = $this->data['User']['password'];
                //$this->Cookie->write('Auth.User', $cookie, true, '+2 weeks');
                //debug($this->request->data['User']['password']);
                //debug($this->Auth->login());

                if ($this->Auth->login()) {
                    // hash the user's password
                    $this->request->data['User']['password'] = $this->Auth->password($this->request->data['User']['password']);

                    // write the cookie
                    $this->Cookie->write('remember_me_cookie', $this->request->data['User'], true, '2 weeks');

                    //$this->request->data['User']['password'] = $this->Auth->password($this->request->data['User']['password']);
                    //debug($this->request->data['User']);//exit;
                    //exit;
                    //$cookie = array();
                    //$cookie['email'] = $this->data['User']['email'];
                    //$cookie['password'] = $this->data['User']['password'];
                    //$this->Cookie->write('Usersession', $cookie, true, '+2 weeks');
                    //debug($this->Auth->redirectUrl());exit;
                    //return $this->redirect($this->Auth->redirectUrl());
                    //debug("YES");
                    $this->redirect($this->Auth->redirectUrl());
                } else {
                    //debug($this->Auth->login());exit;
                    $this->Cookie->delete('Auth');
                    $this->Flash->error(__("Nom d'utilisateur ou mot de passe invalide, veuillez vérifier"));
                }
            } else {
                $this->Cookie->delete('Auth.User');
                $this->redirect(array('controller' => 'pages', 'action' => 'display', 'msgactivation'));
            }
        } 
    }

    public function logout()
    {
        $this->Session->delete('User');
        $this->Cookie->delete('Auth');
        $this->Cookie->delete('remember_me_cookie');
        $this->Session->delete('Auth');
        unset($_SESSION["Auth"]);
        session_destroy();
        $this->Auth->logout();
        //$this->redirect(array('controller' => 'pages', 'action' => 'display', 'accueil'));
        return $this->redirect($this->Auth->logout());
    }

    private function __rand_string($length)
    {
        $chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        return substr(str_shuffle($chars), 0, $length);
    }

    public function change_password()
    {
        $this->set('page', 'password');
        $this->set('title_for_layout', __("Changement de mot de passe"));
        if ($this->request->is('post')) {
            //debug($this->data);exit;
            $email = $this->data['User']['email'];
            $newpwd = $this->__rand_string(10);
            $this->User->contain();
            $user = $this->User->findByEmail($email);
            //debug($user);
            if ($user) {
                $uid = $user['User']['id'];
                $this->User->id = $uid;
                $this->User->saveField('password', AuthComponent::password($newpwd));

                // --------------------------------------------------
                // -------- Message à l'utilisateur ---------------------
                $ret = array('message' => "Le mot de passe a été envoyé sur la messagerie : " . $email);

                $sujetuser = __("Nouveau mot de passe pour " . Configure::read('Common.sitename') . ' ! ');
                $msgmailuser = __("Voici votre nouveau mot de passe : ") . $newpwd;
                $msgmailuser .= '<br>' . __("Merci de vous connecter sur la page") . ' <a href="' . Configure::read('Common.topurl') . '/Identification">' . __("Me connecter") . '</a><br>';
                //debug($msgmailuser);exit;
                $this->send_global_email($sujetuser, $msgmailuser, $this->data['User']);
                $this->Session->setFlash(__("Le mot de passe a été envoyé sur la messagerie : ") . $email, 'msg_success');
                $this->redirect(array('controller' => 'pages', 'action' => 'display', 'message'));
            } else {
                $this->Session->setFlash(__("Erreur : pas de compte enregistré avec cet adresse mail : ") . $email, 'msg_alert');
                $this->redirect(array('controller' => 'users', 'action' => 'change_password'));
            }
        }
    }

    public function resend_email()
    {
        Configure::write('debug', 0);
        $this->User->contain();
        $users = $this->User->find('all', array(
            "conditions" => array('activated' => 0),
            "order" => array('User.id DESC'),
            "limit" => 19,
            //"fields" => array('email','activated','codeactivation','username')
        ));
        //debug($users);
        foreach ($users as $curuser) {
            $sujetuser = __("Bienvenue sur ") . Configure::read('Common.sitename') . ' ! ';
            $msgmailuser = "Vous vous etes inscrit sur Timebankpro récemment, un problème technique n'a pas permis de vous envoyer le mail d'activation. Nous en sommes désolés.";
            $msgmailuser .= '<br>' . __("Afin donc de valider votre adresse email et votre compte, merci de vous connecter sur la page") . ' <a href="' . Configure::read('Common.topurl') . '/verificationCode/' . $curuser['User']['codeactivation'] . '">' . __("Activer mon compte") . '</a><br>';
            $msgmailuser .= '<br>' . "Si vous avez déjà recu ce mail d'activation, vous pouvez l'ignorer";
            debug($sujetuser);
            debug($msgmailuser);
            debug($curuser['User']['email']);
            $this->send_global_email($sujetuser, $msgmailuser, $curuser['User']);
        }

    }

    public function add()
    {
        $this->set('page', 'adduser');
        $this->set('controller2load', 'main');
        $this->loadModel('Mail');
        $this->Mail->contain();
        $allEmails = $this->Mail->find('list', array('conditions'=>array('Mail.emailperso'=>0),'fields' => array('subdomain')));

        $this->set('title_for_layout', __("Inscription"));
        if ($this->request->is('post')) {
            $resuser = $this->request->data;
            //debug($resuser);exit;
            // Check if user is authorized
            $email_authorized = false;
            foreach ($allEmails as $cur) {
                if (strstr($resuser['User']['email'],$cur)) {
                    $email_authorized = true;
                }
            }
            if (!$email_authorized) {
                $allEmailsPerso = $this->Mail->find('list', array('conditions'=>array('Mail.emailperso'=>1),'fields' => array('subdomain')));
                foreach ($allEmailsPerso as $cur) {
                    if ($resuser['User']['email'] == $cur) {
                        $email_authorized = true;
                    }
                }
            }
            if ($email_authorized==false) {
                $this->Flash->error(__("Erreur d'enregistrement de votre compte (email non valide)"));
                $this->redirect($this->referer());
            }
            if ($email_authorized==true) {
                //debug($this->request->data);exit;
                // Check if city exists
                $this->loadModel('City');
                $this->loadModel('Country');
                $this->City->contain('Country');
                $chkcity = $this->City->findByVilleNomReel($resuser['User']['city']);
                
                if (!$chkcity) {
                    // Check if City country exists
                    $chkcountry = $this->Country->findByShortname($resuser['User']['country_shortname']);
                    if (!$chkcountry) {
                        $this->Country->create();
                        $newcountrydb = $this->Country->save(array('Country'=>array('name'=>$resuser['User']['country'],'shortname'=>$resuser['User']['country_shortname'])));
                        $country_id = $newcountrydb['Country']['id'];
                    } else {
                        $country_id = $chkcountry['Country']['id'];
                    }
                    $this->City->create();
                    $newcitydb = $this->City->save(
                        array(
                            'City'=>array(
                                'ville_nom_reel' => $resuser['User']['city'],
                                'country_id'=>$country_id
                            )
                        )
                    );
                    $user_city_id = $newcitydb['City']['id'];
                } else {
                    $chkcountry = $this->Country->findByShortname($resuser['User']['country_shortname']);
                    if (!$chkcountry) {
                        $this->Country->create();
                        $newcountrydb = $this->Country->save(array('Country'=>array('name'=>$resuser['User']['country'],'shortname'=>$resuser['User']['country_shortname'])));
                        $country_id = $newcountrydb['Country']['id'];
                    }
                    $user_city_id = $chkcity['City']['id'];
                }
                $resuser['User']['city_id'] = $user_city_id;
                $this->User->create();
                 //debug($infoscity);exit;
                $resuser['User']['codeactivation'] = hash('sha256', $resuser['User']['nom'] . $resuser['User']['prenom'] . ' activation code ' . $resuser['User']['email']);
                $resuser['User']['activated'] = 0;
                $resuser['User']['nom'] = $resuser['User']['nom'];
                $resuser['User']['prenom'] = $resuser['User']['prenom'];
                $resuser['User']['password'] = AuthComponent::password($resuser['User']['password']);
                $incmonnaie = 0;
                //debug($resuser);//exit;
                if (isset($resuser['User']['image_form']) && isset($resuser['User']['image_form']['name']) && $resuser['User']['image_form']['name']!="") {
                    $profil_image = $this->create_file($this->genidx('user_profile_img'.time()),$resuser['User'],'profiles','image_form');
                    //debug($profil_image);exit;
                    //resize the image
                    $imagesource = WWW_ROOT . DIRECTORY_SEPARATOR . 'img/profiles/' . $profil_image;
                    //debug($imagesource);exit;
                    $image = new SimpleImage();
                    $image->load($imagesource);
                    $image->resizeToWidth(96);
                    $image->save($imagesource);
                    $incmonnaie = 1;
                    $resuser['User']['photo'] = "profiles/${profil_image}";
                }
                // Check if code de parrainage (sponsor)
                if (isset($resuser['User']['sponsor']) && trim($resuser['User']['sponsor'])!="") {
                    $this->loadModel('Sponsor');
                    $this->Sponsor->contain();
                    $chkspon = $this->Sponsor->findByCode($resuser['User']['sponsor']);
                    if ($chkspon) {
                        // Add credit to new user
                        $incmonnaie += 5;
                        // Ad for parrainer , create new transaction
                        $this->loadModel('Transaction');
                        $this->Transaction->create();
                        $array2save = array(
                            'Transaction' => array(
                                'user_id' => -1,
                                'to_userid' => $chkspon['Sponsor']['user_id'],
                                'amount' => 5,
                                'post_titre' => __("Parrainage de")." ".$resuser['User']['prenom']." ".$resuser['User']['nom']
                            ),
                        );
                        $this->Transaction->save($array2save);
                    }
                   
                }

                $resuser['User']['monnaiestart'] = Configure::read('Common.client.monnaie_default')+$incmonnaie;
                //debug($resuser);
                //exit;
                if ($this->User->save($this->HV($resuser))) {
                    // -------- Message aux admins ---------------------
                    //$sujet = Configure::read('Common.client.name') . ' : ' . __("nouvelle inscription sur le site !");
                    //$msgmail = __("Une personne vient de s'inscrire sur ") . Configure::read('Common.client.name') . ' : ';
                    //$msgmail .= $resuser['User']['nom'] . " " . $resuser['User']['prenom'] . " (" . $resuser['User']['email'] . ") de " . $resuser['User']['city']."(".$resuser['User']['country'].")";
                    //$msgmail .= "<br>Plateforme : " . Configure::read('Common.client.name');
                    //$this->send_global_email($sujet, $msgmail);
                    // -------- Message à l'utilisateur ---------------------
                    $sujetuser = __("Bienvenue sur la plateforme") ." ".Configure::read('Common.client.name') . ' ! ';
                    $msgmailuser = '<br>' . __("Afin de pouvoir activer votre compte sur la plateforme")." ".Configure::read('Common.client.name').", ".__("merci de bien vouloir cliquer sur ce lien qui va vous renvoyer vers la plateforme: ") . ' <a href="' . Configure::read('Common.topurl') . '/verificationCode/' . $resuser['User']['codeactivation'] . '">' . __("Activer mon compte") . '</a><br>';
                    $this->send_global_email($sujetuser, $msgmailuser, $resuser['User']);
                    // --------------------------------------------------
                    $this->redirect(array('controller' => 'pages', 'action' => 'display', 'user_created'));
                } else {
                    $this->Flash->error(__("Erreur d'enregistrement de votre compte, veuillez nous contacter"));
                }
            }            
        }
        
        $str = "";
        $idx = 0;
        $allemailsallowed=false;
        foreach ($allEmails as $cur) {
            $str .= '*' . $cur;
            if ($idx < count($allEmails) - 1) {$str .= ' ou ';}
            $idx++;
            if ($cur=="@") $allemailsallowed=true;
        }
        $this->set('emailsvalide', $str);
        $this->set('allemailsallowed', $allemailsallowed);
    }

    public function verify_code($code = null)
    {
        $this->theme = "vdmv";
        $this->set('bodyclass', '');
        $this->set('title_for_layout', __("Vérification du code recu"));
        $this->set('page', 'activecode');

        if ($code != null) {
            $this->set('code', $code);
        } else {
            $this->set('code', "");
        }
        if ($this->request->is('post')) {
            $code_user = $this->data['User']['code'];
            $chk = $this->User->find('first', array('conditions' => array('codeactivation' => $code)));
            if ($chk) {
                $user_id = $chk['User']['id'];
                $this->User->id = $user_id;
                $this->User->saveField('activated', 1);
                $this->User->saveField('codeactivation', null);
                $this->Session->setFlash(__("Votre compte a été activé, vous pouvez maintenant vous connecter !"), 'msg_info');
                $this->redirect(array('controller' => 'users', 'action' => 'login'));
            } else {
                $this->Session->setFlash(__("Code de vérification incorrect. Veuillez vérifier !"), 'msg_alert');
                $this->redirect(array('controller' => 'users', 'action' => 'verify_code'));
            }
        }
    }

    private function generateRandomString($length = 8) {
        return substr(str_shuffle(str_repeat($x='0123456789abcdefghijklmnopqrstuvwxyz', ceil($length/strlen($x)) )),1,$length);
    }

    public function invitations()
    {
        $this->loadModel('Invitation');
        $this->loadModel('Sponsor');
        if ($this->request->is('post')) {
            // Gerer les adresses mails multiples.
            $data = $this->data['User'];
            $this->loadModel('Invitation');
            //$mails_array = explode(',', $data['liste_email']);
            $mails_array = $this->multiexplode(array(",",";"," "),$data['liste_email']);
            //debug($mails_array);exit;
            $message_welcome = $data['message'];
            // personne qui invite
            $userinfo = $this->isConnected();
            $user_id = $userinfo['id'];
            $sender_prenom_nom = $userinfo['prenom'] . " " . $userinfo['nom'];
            $sponsorcode = $this->generateRandomString(); 
            //debug($sponsorcode);exit;
            // -----
            foreach ($mails_array as $mailad) {
                $mail_to = trim($mailad);
                if (!empty($mail_to)) {
                    // On verifie si l'email est correct
                    if (filter_var($mail_to, FILTER_VALIDATE_EMAIL)) {

                        $this->Invitation->create();
                        $array2save = array(
                            'Invitation' => array(
                                'user_id' => $user_id,
                                'email' => $mail_to,
                            ),
                        );
                        $this->Invitation->save($array2save);
                        // envoi de l'email
                        $sujet = __("Invitation sur ") ." ".Configure::read('Common.client.name');
                        $message = __("Vous avez reçu ce message parce que") . " " . $sender_prenom_nom . __(" vous a invité sur") . " <a href='" . Configure::read('Common.topurl') . "'>" . Configure::read('Common.client.name') . "</a>";
                        $message .= "<br>" . __("Lors de votre inscription, pensez à entrer le code parrainage suivant pour recevoir")." 5 ".$this->ClientData['monnaie_name']. "s en plus !" .  " : ".$sponsorcode;                       
                        if (!empty($message_welcome)) {
                            $message .= "<br>" . __("Son message") . ":<br>" . $message_welcome;
                        }

                        //debug($message);exit;
                        $arraymailto = array('email' => $mail_to);
                        $this->send_global_email($sujet, $message, $arraymailto);
                    }
                }
            }
            // Generate invitation code 
                    
            $this->Sponsor->create();
            $array2save = array(
                'Sponsor' => array(
                    'user_id' => $user_id,
                    'code' => $sponsorcode
                ),
            );
            $this->Sponsor->save($array2save);
            $this->Session->setFlash(__("Vos invitations ont été envoyées, merci !"), 'msg_success');
            $this->redirect(array('controller' => 'pages', 'action' => 'message'));
        }
    }

    public function repertoire($recherche_lettre = null)
    {

        $this->set('title_for_layout', __("Repertoire"));
        $this->set('section', 'repertoire');
        $this->set('page', 'repertoire');
        $this->set('pageactive', 'repertoire');
        $this->set('current_menu', 'repertoire');
        $this->set('controller2load_bis', 'accueil');
        $currentClient = $this->getClientData();
        $this->set('monnaie_minimum', $currentClient['monnaie_minimum']);

        $userinfo = $this->isConnected();
        $user_id = $userinfo['id'];
        $ma_reserve = $this->getUserReserveMonnaie($user_id);
        $this->set('ma_reserve', $ma_reserve);
        $this->setUserCookieRecherche();
        $this->set('userInput', $this->Cookie->read('choixUser'));
        //debug($this->Cookie->read('choixUser'));
        $conditions = $this->get_users_conditions();
        if ($conditions!=null) {
            array_push($conditions,Configure::read('Admin.userstofilter'));
        } else {
            $conditions = Configure::read('Admin.userstofilter');
        }
        $infosloc = $this->getCurrentlocation();
        $this->set('current_location', $infosloc);
        //debug($this->data);exit;
        //debug($conditions);exit;
        if (($this->data) and isset($this->data['User']['recherche'])) {
            $recherche = $this->data['User']['recherche'];
            $conditions['OR'] = array(
                'nom LIKE ' => "%$recherche%",
                'prenom LIKE ' => "%$recherche%",
            );
            $this->set('critere', __(" avec ce critère"));
        }
        if ($recherche_lettre != null) {
            $conditions['OR'] = array(
                'nom LIKE ' => "$recherche_lettre%",
                //'prenom LIKE '=>"$recherche_lettre%"
            );
            $this->set('critere', __(" avec ce critère"));
        }
        $conditions['activated'] = 1;
        $conditions['vacation'] = 0;
        if (isset($this->data['Pages']['country_id'])) {
            if (!empty($this->data['Pages']['country_id'])) {
                $conditions['City.country_id'] = $this->data['Pages']['country_id'];
            }
        }
        //debug($conditions);exit;
        //if ($conditions != null) {
            $users_paginate = array(
                'limit' => 20,
                'conditions' => $conditions,
                'order' => 'User.id DESC',
                'contain' => array('City','City.Country','TransactionDebit','TransactionCredit'),
            );
            $this->Paginator->settings = $users_paginate;
            $all_users = $this->Paginator->paginate('User');
            //debug($all_users);exit;
            $countusers = $this->User->find('count', array(
                'conditions' => $conditions,
                'contain' => array(
                    'City',
                    'TransactionDebit',
                    'TransactionCredit',
                ),
            ));
            //debug($all_users);
            $this->set('countusers', $countusers);

            if (!$all_users) {
                $this->Session->setFlash(__("Pas d'utilisateurs trouvés pour votre critère de recherche"), 'msg_alert');
                $this->clearUserCityLocation();
                //$this->redirect(array('controller'=>'pages','action'=>'display','accueil'));
                //$this->redirect(array('controller'=>'pages','action'=>'display2','echanges'));
                //$this->redirect(array('controller'=>'users','action'=>'repertoire'));
            }
            $this->set('all_users', $all_users);
        //} 
    }

    public function contactmember($idmember,$post_b64=null)
    {
        $messagerie_activated = $this->getClientData('messagerie_activated');
        if ($messagerie_activated) {
            $this->set('title_for_layout', __("Contacter un membre"));
            $this->set('page', __("contactmember"));
            if ($this->isConnected()) {
                $mb = $this->User->findById($idmember);
                if ($post_b64!=null) {
                    $this->set('membreacontacter_posttitre', __("Offre :")." ".base64_decode($post_b64));
                } else {
                    $this->set('membreacontacter_posttitre', "");
                }
                $membreacontacter = $mb['User']['prenom'] . " " . $mb['User']['nom'];
                $this->set('membreacontacter', $membreacontacter);
                $this->set('membreacontacter_id', $mb['User']['id']);
                $this->set('membreacontacter_photo', $mb['User']['photo']);
            } else {
                $this->Session->setFlash(__("Vous devez etre membre du site et connecté pour pouvoir contacter un membre"), 'msg_alert');
                $this->redirect(array('controller' => 'users', 'action' => 'login'));
            }
        } else {
            $this->Session->setFlash(__("La messagerie personnelle est désactivée sur votre plateforme, aussi nous vous suggérons de contacter cette personne par les moyens de communication de votre entreprise ou établissement"), 'msg_alert');
            $this->redirect($this->referer());
        }
        
    }

    public function seemessages($userid, $type)
    {
        $this->set('bodyclass', '');
        $this->set('page', 'listpost');
        //$this->set('controller2load','accueil');
        $this->set('title_for_layout', __("Annonces"));
        $this->set('page', 'seemessages');
        $this->User->contain();
        $theuser = $this->User->findById($userid, array('User.prenom'));
        //debug($theuser);exit;
        $allposts = $this->loadPostsUser($userid, $type, 'NOMESSAGEDISPLAY', 9);
        //debug($allposts);exit;
        $this->loadModel('Post');
        $nb = $this->Post->getPostsCount($userid, $type);
        if ($type == 'O') {
            $strtype = __("offres");
            $strtype2 = __("d'offres");
            $this->set('last_messages', array(__("offres") => $allposts));
            $message = __("Les offres de").' ' . $theuser['User']['prenom'];
        } else {
            $strtype = __("demandes");
            $strtype2 = __("de demandes");
            $this->set('last_messages', array(__("demandes") => $allposts));
            $message = __("Les demandes de").' ' . $theuser['User']['prenom'];
        }
        $this->set('msg', $message);
        $this->set('prenom', $theuser['User']['prenom']);
        $this->set('count_posts', $nb);
        $this->set('strtype', $strtype);
        $this->set('strtype2', $strtype2);
    }

    public function viewprofil($user_id)
    {
        $this->set('page', 'viewprofil');
        $this->set('title_for_layout', __("Vue profil utilisateur"));
        $this->loadModel('User');
        $theuser = $this->User->find('first', array(
            'conditions' => array('User.id' => $user_id),
            //'recursive' => 2
            'contain' => array(
                'City','City.Country',
                'TransactionCredit' => array(
                    //'limit' => 20
                ),
                'TransactionDebit' => array(
                    //'limit' => 20
                ),
                'TransactionCredit.User',
                'TransactionCredit.Post'
            ),
            'fields' => array('*')
        ));
        //debug($theuser);//exit;
        $this->set('frompage', $this->referer());
        $this->set('bodyclass', '');
        $this->set('theuser', $theuser);        
    }

    public function profil()
    {
        //Configure::write('debug', 2 );debug($this->Userinfo);exit;
        $this->set('page', 'profil');
        $this->set('title_for_layout', __('Gérer ma confidentialité'));
        $this->set('section', 'profil');
        if ($this->request->is('post')) {
            //debug($this -> request -> data);exit;
            $reqdata = $this->data;
            //$reqdata['Profile']['photo_file_name'] = $reqdata['Profile']['photo_file'];
            $this->User->id = $this->Userinfo['id'];
            //debug($reqdata);exit;
            //debug($this->HV($reqdata));exit;
            $ret = $this->User->save($this->HV($reqdata), false, array('hobbies', 'bibliographie'));
            //debug($ret);exit;
            if ($reqdata['User']['password'] != "") {
                if ($reqdata['User']['password'] == $reqdata['User']['confirmPassword']) {
                    $this->Session->setFlash(__("Les informations de votre profil ont été enregistrées"), 'msg_success');
                    //$this -> data[$this -> alias]['password'] = AuthComponent::password($this -> data[$this -> alias]['password']);
                    $this->User->saveField('password', AuthComponent::password($reqdata['User']['password']));
                } else {
                    $this->Session->setFlash(__("!! Les mots de passe ne sont pas identiques !!"), 'msg_alert');
                }
            } else {
                $this->Session->setFlash(__("Les informations de votre profil ont été enregistrées"), 'msg_success');
            }
            if ($reqdata['User']['photo_file']['name'] != '') {
                // Copie de l'umage en lieu sur..
                $ext = pathinfo($reqdata['User']['photo_file']['name'], PATHINFO_EXTENSION);
                //debug($reqdata);exit;
                if ($ext != "") {
                    // Un nom d'image en timestamp
                    $img = $this->User->id;
                    $source = WWW_ROOT . DIRECTORY_SEPARATOR . 'img/profiles/' . $img;
                    $filename = $source . '.' . $ext;
                    $error = $reqdata['User']['photo_file']['error'];

                    //debug($error);exit;
                    if (($error == 1)) {
                        //debug($error);
                        //debug($reqdata);
                        //exit;
                        $this->Session->setFlash(__("Erreur. L'image est trop grosse, veuillez la réduire"), 'msg_alert');
                        $this->redirect(array('controller' => 'users', 'action' => 'profil'));
                    }
                    //debug($source);
                    move_uploaded_file($reqdata['User']['photo_file']['tmp_name'], $filename);
                    //debug($filename);
                    $image = new SimpleImage();
                    $image->load($filename);
                    $image->resizeToWidth(96);
                    $image->save($filename);
                    //debug($image);
                    $this->User->saveField('photo', 'profiles/' . $img . '.' . $ext);

                    //exit;
                }
            }

            $this->redirect(array('controller' => 'users', 'action' => 'profil'));
        } //else {
        //$this->Userinfo = $this->User->findById($this->Userinfo['id']);
        //$this->set('Userinfo',$this->Userinfo['User']);
        //}
        // Pour afficher les avis
        $theuser = $this->User->find('first', array(
            'conditions' => array('User.id' => $this->Userinfo['id']),
            //'recursive' => 2
            'contain' => array(
                'City',
                'TransactionCredit' => array(
                    //'limit' => 20
                ),
                'TransactionDebit' => array(
                    //'limit' => 20
                ),
                'TransactionCredit.User',
                'TransactionCredit.Post',
            ),
            'fields' => array('*')
        ));
        $this->set('theuser', $theuser);
        //debug($theuser);

        // On regard si la monnaie est active dans la ville user
        $this->set('reservemonnaie', 0);
        // On calcul les transaction
        $this->loadModel('Transaction');
        $reserve = $this->getUserReserveMonnaie($this->Userinfo['id']);
        $this->set('reservemonnaie', $reserve);

        //$this -> redirect(array('controller'=>'users','action' => 'index'));
    }

    public function confirm_suppressioncompte()
    {
        if ($this->Userinfo['role']=='admin') {
            $this->redirect(array('controller' => 'pages', 'action' => 'display', 'accueil'));
        }
        $this->set('page', "supressioncompte");
        $this->set('title_for_layout', 'Supprimer mon compte');

    }

    public function suppressioncompte()
    {
        if ($this->Userinfo['role']=='admin') {
            $this->redirect(array('controller' => 'pages', 'action' => 'display', 'accueil'));
        }
        if ($this->Userinfo['id'] != Configure::read('Reseau.user_id')) { // On ne peut pas supprimer ce compte
            $this->loadModel('Pm');
            $this->loadModel('Post');
            $this->loadModel('User');
            $this->loadModel('City');

            $user = $this->User->findById($this->Userinfo['id']);
            if ($user) {

                // --------------------------------------------------
                $uid = $user['User']['id'];
                $this->Pm->deleteAll(array('Pm.id_expediteur' => $uid), false);
                $this->Pm->deleteAll(array('Pm.id_destinataire' => $uid), false);
                $this->Post->deleteAll(array('Post.user_id' => $uid), false);
                $this->User->delete($uid);
                $this->Cookie->delete('Auth');
                $this->Session->delete('Auth');
                $this->Cookie->delete('remember_me_cookie');
                // -------- Message aux admins ---------------------
                //$sujet = Configure::read('Common.sitename') . ' : ' . __("suppression d'un compte sur le site !");
                //$msgmail = __("Un compte utilisateur a été supprimé sur ") . Configure::read('Common.sitename') . ' : ';
                //$msgmail .= $user['User']['nom'] . " " . $user['User']['prenom'] . " (" . $user['User']['email'] . ") de " . $user['City']['ville_nom_reel'];
                //$msgmail .= "\nPlateforme : " . Configure::read('Common.client.name');
                //$this->send_global_email($sujet, $msgmail);
                // --------------------------------------------------
                $this->Auth->logout();                
                $this->redirect(array('controller' => 'pages', 'action' => 'display', 'accueil'));
            } else {
                $this->Session->setFlash(__("Erreur lors de la suppression de votre compte. Veuillez nous contacter"), 'msg_alert');
                $this->redirect(array('controller' => 'users', 'action' => 'profil'));
            }
        } else {
            $this->Session->setFlash(__("Oulà, ce compte ne peut pas etre supprimé ! Compte réseau"), 'msg_alert');
            $this->redirect(array('controller' => 'users', 'action' => 'profil'));
        }
    }

    public function regler_echange($to_userid = null, $user_post_id = null)
    {
        $this->set('page', "regler_echange");
        $this->set('title_for_layout', 'Régler une offre');
        
        if ($this->monnaie_temps_activated) {
            $this->set('all_monnaie_values', Configure::read('Common.monnaie.values.D'));
        } else {
            $this->set('all_monnaie_values', Configure::read('Common.monnaie.classique'));
        }
        if ($to_userid == $this->Userinfo['id']) {
            $this->Session->setFlash(__("Vous ne pouvez pas vous régler une offre à vous-même !"), 'msg_alert');
            $this->redirect(array('controller'=>'pages','action' => 'message'));
        }

        $ma_reserve = $this->getUserReserveMonnaie($this->Userinfo['id']);
        $this->set('ma_reserve', $ma_reserve);
        $currentClient = $this->getClientData();
        $monnaie_minimum = $currentClient['monnaie_minimum'];
        if ($ma_reserve <= $monnaie_minimum) {
            $this->Session->setFlash(__("Votre compte à atteint le seuil minimum… <br>pour pouvoir recevoir de nouvelles offres, c'est à vous maintenant d'en rendre aux autres !"), 'msg_alert');
            $this->redirect(array('controller' => 'pages', 'action' => 'message'));
        }

        // On vérifie si possible
        if ($this->request->is('post')) {
            $to_userid = $this->data['User']['to_user_id'];
        }

        $touser = $this->User->findById($to_userid);
        if (!$touser) {
            $this->Session->setFlash(__("Erreur sur l'utilisateur"), 'msg_alert');
            $this->redirect(array('controller' => 'pages', 'action' => 'message'));
        }
        //if ($touser['User']['nb_monnaie_posts']==0) {
        //    $this->Session->setFlash(__("Cet utilisateur n'a pas émis d'annonce avec une valeur heure sur le réseau !"),'msg_alert');
        //    $this->redirect(array('controller'=>'pages','action' => 'message'));
        //}

        if ($this->request->is('post')) {
            //debug($this->data);//exit;
            // tout est ok on valide la transaction
            if ($this->Userinfo['id'] != $this->data['User']['to_user_id']) {
                $this->loadModel('Transaction');
                $this->Transaction->create();
                $this->loadModel('Post');
                $this->Post->contain('Category');
                $thepostid = $this->data['User']['post_id'];                
                $curpost = $this->Post->findById($thepostid,array('Post.titre','Category.name','Post.id','Post.monnaievalue'));
                $trans_montant = $curpost['Post']['monnaievalue'];
                if ($thepostid == "MY") {
                    $thepostid = $this->data['User']['mypost_id'];
                }
                if ((($trans_montant >= 0) or ($trans_montant <= -99)) and ($trans_montant <= 10)) {
                    if ($trans_montant < 0) {
                        $trans_montant = 0;
                    }
                    if (!$curpost) {
                        $post_titre = "";
                        $post_category = "";
                    } else {
                        $post_titre = $curpost['Post']['titre'];
                        $post_category = $curpost['Category']['name'];
                        $post_category = trim(preg_replace('/&#.*;/', '', $post_category));
                        // Passage du flag vendue : sold
                        $this->Post->id = $curpost['Post']['id'];
                        $this->Post->savefield('sold',true);
                        $this->Post->savefield('reserved',false);
                    }
                    $message = "";
                    $tosave = array(
                        'Transaction' => array(
                            'user_id' => $this->Userinfo['id'],
                            'to_userid' => $this->data['User']['to_user_id'],
                            'post_id' => $thepostid,
                            'post_titre' => $post_titre,
                            'post_category' => $post_category,
                            'amount' => $trans_montant,
                            //'message' => $this->data['User']['message'],
                            'message' => $message,
                            'closed' => 0,
                        ),
                    );
                    //debug($tosave);exit;
                    $this->Transaction->save($this->HV($tosave));
                    // Send Email notification to user who received the transaction
                    $this->loadModel('User');

                    if (($trans_montant > 0) and (trim($message) != "")) {
                        $Subject = "Vous avez reçu un règlement en " . Configure::read('Common.monnaie.name') . " et un avis de " . $this->Userinfo['prenom'] . " " . $this->Userinfo['nom']. " sur " . Configure::read('Common.client.name');
                        $Msgmail = "Vous avez reçu un règlement en " . Configure::read('Common.monnaie.name') . " et un avis de " . $this->Userinfo['prenom'] . " " . $this->Userinfo['nom'] . " sur " . Configure::read('Common.client.name');
                    }
                    if (($trans_montant > 0) and (trim($message) == "")) {
                        $Subject = "Vous avez reçu un règlement en " . Configure::read('Common.monnaie.name') . " de " . $this->Userinfo['prenom'] . " " . $this->Userinfo['nom']. " sur " . Configure::read('Common.client.name');
                        $Msgmail = "Vous avez reçu un règlement en " . Configure::read('Common.monnaie.name') . " de " . $this->Userinfo['prenom'] . " " . $this->Userinfo['nom'] . " sur " . Configure::read('Common.client.name');
                    }
                    if (($trans_montant == 0) and (trim($message) != "")) {
                        $Subject = "Vous avez reçu un avis de " . $this->Userinfo['prenom'] . " " . $this->Userinfo['nom']. " sur " . Configure::read('Common.client.name');
                        $Msgmail = "Vous avez reçu un avis de " . $this->Userinfo['prenom'] . " " . $this->Userinfo['nom'] . " sur " . Configure::read('Common.client.name');
                    }
                    //debug($Subject);debug($Msgmail);exit;
                    $this->send_global_email($Subject, $Msgmail, $touser['User']);
                    // Email aux admins
                    //$sujet = __("Nouvelle transaction sur")." ". Configure::read('Common.sitename');

                    //$msgmail = __("Une nouvelle transaction a eu lieu sur la plateforme") . ' : ';
                    //$msgmail .= "<br>Plateforme : " . Configure::read('Common.client.name');
                    //$msgmail .= "<br>De : " . $this->Userinfo['prenom'] . " " . $this->Userinfo['nom'];
                    //$msgmail .= "<br>Pour : " . $touser['User']['prenom'] . " " . $touser['User']['nom'];
                    //if ($trans_montant<0) {
                    //    $msgmail .= "<br>Montant : 0";
                    //} else {
                    //    $msgmail .= "<br>Montant : " . $trans_montant;
                    //}
                    //$msgmail .= "Ville : ".$city_info['City']['ville_nom_reel']."<br>";
                    //$msgmail .= __("Titre")." : ".$full_data['Post']['titre']."<br>";
                    //$msgmail .= "<br>" . __("Avis") . " : <br>" . nl2br($message) . "<br>";
                    //debug($msgmail);exit;
                    //$this->send_global_email($sujet, $msgmail);



                    $this->Session->setFlash(__("La transaction a été enregistrée !"), 'msg_success');
                } else {
                    $msgerror = __("Désolé, votre solde en")." \"".$this->ClientData['monnaie_name']."\" ".__("ne vous permet pas de régler cet échange");
                    $this->Session->setFlash($msgerror, 'msg_alert');
                }
                // In case of autre demande
                if ($thepostid == 0) {
                    $this->redirect(array('controller' => 'pages', 'action' => 'message'));
                }

                $this->redirect(array('controller' => 'pages', 'action' => 'index', 'id' => $thepostid));
                //$this->redirect(array('controller'=>'users','action' => 'repertoire'));
            } else {
                $this->Session->setFlash(__("Vous ne pouvez pas régler cet échange!"), 'msg_alert');
                $this->redirect(array('controller' => 'pages', 'action' => 'message'));
            }
        }
        // find the post of the user to display them
        $this->loadModel('Post');
        $userposts = $this->Post->find('list', array(
            'conditions' => array(
                'Post.user_id' => $to_userid,
                'Post.type' => 'O',
            ), 'fields' => array('titre'), 'order' => array('Post.id desc'),
        ));
        //if ($user_post_idii!=null) {
        //    $this->Post->contain();
        //    $userposts = $this->Post->find('first',array(
        //        'conditions'=>array(
        //            'Post.id'=>$user_post_id,
        //        ),'fields'=>array('titre','id'),'order'=>array('Post.id desc')
        //    ));
        //    $this->set('post_id',$user_post_id);
        //} else {

        /*$myposts = $this->Post->find('list', array(
            'conditions' => array(
                'Post.user_id' => $this->Userinfo['id'],
                'Post.type' => 'D',
            ), 'fields' => array('titre'), 'order' => array('Post.id desc'),
        ));*/
        if ($user_post_id != null) {
            $this->Post->contain();
            $postinfo = $this->Post->find('first',array(
                'conditions'=>array(
                        'Post.id'=>$user_post_id,
                ),'fields'=>array('monnaievalue')
            ));
            $this->set('post_price', $postinfo['Post']['monnaievalue']);
            $this->set('post_id', $user_post_id);
        }
        $userposts['MY'] = "Autre échange";
        //$myposts[0] = 'Autre demande';
        //$this->set('myposts', $myposts);
        //}

        //debug($userposts);exit;
        $this->set('userposts', $userposts);

        $this->set('to_user', $touser);

    }

    public function deactivate()
    {
        if ($this->Userinfo) {
            $this->set('page', 'deactivate');
            $this->loadModel('User');
            $this->User->id = $this->Userinfo['id'];
            $this->User->saveField('activated', 0);
            $this->Cookie->delete('Auth');
            $this->Session->delete('User');
            $this->Cookie->delete('Auth.User');
            unset($_COOKIE['Auth.User']);
            $cookie = $this->Cookie->read('Auth.User');
            $this->Cookie->delete('Auth');
            $this->Session->delete('Auth');
            $this->Auth->logout();
        }
    }

    public function myaccount()
    {
        $this->set('page', 'myaccount');
        $this->set('title_for_layout', 'Mon compte');
        if ($this->Userinfo) {           
            $totaux = $this->getUserMonnaieTransaction();
            $this->set('totaux', $totaux);
        }

    }

    public function getAuthEmails()
    {
        $this->autoRender = false;
        $this->loadModel('Mail');
        $this->Mail->contain();
        $allEmails = $this->Mail->find('all', array('fields' => array('subdomain')));
        return json_encode($allEmails);
    }

    public function error_email()
    {

    }

    public function toggleVacation($vacation) {
        $this->autoRender = false;
        $this->User->id = $this->Userinfo['id'];
        $vacval = 0;
        if ($vacation=='true') $vacval = 1;
        $this->User->saveField('vacation', $vacval);
        return "ok";
    }
    public function toggleShowMonnaie($showmonnaie) {
        $this->autoRender = false;
        $this->User->id = $this->Userinfo['id'];
        $showval = 0;
        if ($showmonnaie=='true') $showval = 1;
        $this->User->saveField('showmonnaie', $showval);
        return "ok";
    }
    public function toggleNotif($notifmp) {
        $this->autoRender = false;
        $this->User->id = $this->Userinfo['id'];
        $notifval = 0;
        if ($notifmp=='true') $notifval = 1;
        $this->User->saveField('notif_mp', $notifval);
        return "ok";
    }

    public function error_password() {
        $this->set('bodyclass', '');
        $this->set('page', 'ErreurPassword');
        $this->set('title_for_layout', __("Erreur email"));
    }

    private function gstr($str1,$str2) {
        return "$str1 : $str2\r\n";
    }


    public function getdata() {
        if (!$this->request->is('post')) {
            $this->redirect($this->referer());
        }

        $ClientData = $this->getClientData();

        $this->loadModel('Post');
        $this->loadModel('Pm');

        //configure::write('debug',2);
        //debug($currentClient);exit;
        //debug(AuthComponent::password($this->data['User']['dlpassword']));
        //debug($this->Userinfo['password']);
        if (AuthComponent::password($this->data['User']['dlpassword'])!=$this->Userinfo['password']) {
            $this->redirect(array('controller'=>'users','action'=>'error_password'));
        }
        //debug('ok');
        //exit;
        $AD = array();
        $AD['user'] = $this->Userinfo;
        $this->Post->contain('Category','Transaction');
        $AD['posts'] = $this->Post->find('all',array(
            'conditions' => array(
                'user_id' => $this->Userinfo['id']
            )
        ));
        $this->loadModel('Favorite');
        $this->Favorite->contain('Post');
        $allfavorites = $this->Favorite->find('all', array(
            'conditions' => array(
                'Favorite.user_id' => $this->Userinfo['id'],
                'Post.id !=' => null,
                'Post.paused' => false,
            ),
            'fields' => array('Post.titre'),
        ));
        $AD['favorites'] = $allfavorites;
        $this->loadModel('Post');
        $this->Post->contain('Category','City');
        $alloffres = $this->Post->find('all', array(
            'conditions' => array(
                'Post.user_id' => $this->Userinfo['id'],
                'Post.type' => 'O',
            ),
            //'fields' => array('Post.titre'),
        ));
        $this->Post->contain('Category','City');

        $alldemandes = $this->Post->find('all', array(
            'conditions' => array(
                'Post.user_id' => $this->Userinfo['id'],
                'Post.type' => 'D',
            ),
            //'fields' => array('Post.titre'),
        ));
        $AD['offres'] = $alloffres;
        $AD['demandes'] = $alldemandes;

        $this->loadModel('Transaction');
        /*$allavis = $this->Transaction->find('all', array(
            'conditions' => array(
                'to_userid' => $this->Userinfo['id'],
                'amount' => 0,
            ),
        ));
        $AD['avis'] = $allavis;
        $allavis = $this->Transaction->find('all', array(
            'conditions' => array(
                'Transaction.user_id' => $this->Userinfo['id'],
                'amount' => 0,
            ),
        ));
        $AD['avisdonnes'] = $allavis;*/

        $allechanges_to_me = $this->Transaction->find('all', array(
            'conditions' => array(
                'Transaction.to_userid' => $this->Userinfo['id'],
                'amount !=' => 0,
            ),
        ));
        $allechanges_from_me = $this->Transaction->find('all', array(
            'conditions' => array(
                'Transaction.user_id' => $this->Userinfo['id'],
                'amount !=' => 0,
            ),
        ));
        $AD['echanges_to_me'] = $allechanges_to_me;
        $AD['echanges_from_me'] = $allechanges_from_me;

        $all_messages_received = $this->Pm->find('all', array(
            'conditions' => array(
                'Pm.id_destinataire' => $this->Userinfo['id']
            ),
        ));
        $AD['all_messages_received'] = $all_messages_received;

        $all_messages_sent = $this->Pm->find('all', array(
            'conditions' => array(
                'Pm.id_expediteur' => $this->Userinfo['id']
            ),
        ));
        $AD['all_messages_sent'] = $all_messages_sent;
        //debug($AD['user']);
        $zipname = md5($AD['user']['email'].$AD['user']['created']);
        $zip = new ZipArchive;
        $res = $zip->open(APP.'Clients'."/$zipname.zip", ZipArchive::CREATE);
        $str1 = $this->gstr(__("Nom"),$AD['user']['nom']);
        $str1 .= $this->gstr(__("Prénom"),$AD['user']['prenom']);
        $str1 .= $this->gstr(__("Ville"),$AD['user']['City']['ville_nom_reel']);
        //$str1 .= $this->gstr(__("Pays"),$AD['user']['City']['Country']['name']);
        $str1 .= $this->gstr(__("Email"),$AD['user']['email']);
        $str1 .= $this->gstr(__("Création du compte"),$AD['user']['created']);
        $str1 .= $this->gstr(__("Nom de votre activité ou service"),$AD['user']['bibliographie']);
        $str1 .= $this->gstr(__("Centres d'intérêts"),$AD['user']['hobbies']);
        if ($ClientData['monnaie_activated']) { 
            $str1 .= $this->gstr(__("Réserve monnaie"),$this->getUserReserveMonnaie($this->Userinfo['id']));
        }
        $str1 .= "\r\n".__("Vos annonces favorites")." : \r\n";
        foreach ($AD['favorites'] as $cad) {
            $str1 .= " - ".$cad['Post']['titre']."\r\n";
        }
        $str2="";
        foreach ($AD['demandes'] as $cad) {
            if ($cad['Post']['monnaievalue']==-99) $cad['Post']['monnaievalue']="0";
            $f="";
            $f = __("Date")." : ".$cad['Post']['created']."\r\n".
            $f .= __("Ville")." : ".$cad['City']['ville_nom_reel']."\r\n";
            $f .= __("Valeur")." : ".$cad['Post']['monnaievalue']."\r\n";
            $f .= __("Titre")." : ".$cad['Post']['titre']."\r\n";
            $f .= __("Messsage")." : ".trim(html_entity_decode($cad['Post']['message']))."\r\n";
            $f .= "\r\n\r\n";
            $str2.=$f;
        }

        $str3="";
        foreach ($AD['offres'] as $cad) {
            if ($cad['Post']['monnaievalue']==-99) $cad['Post']['monnaievalue']="0";

            $f="";
            $f = __("Date")." :".$cad['Post']['created']."\r\n".
            $f .= __("Ville")." : ".$cad['City']['ville_nom_reel']."\r\n";
            $f .= __("Valeur")." : ".$cad['Post']['monnaievalue']."\r\n";
            $f .= __("Titre")." : ".$cad['Post']['titre']."\r\n";
            $f .= __("Messsage")." : ".trim(html_entity_decode($cad['Post']['message']))."\r\n";
            $f .= "\r\n\r\n";
            $str3.=$f;
        }
        //$str4="Date création;Annonce;De;message\r\n";
        //foreach ($AD['avis'] as $cad) {
        //    $str4 .= $cad['Transaction']['created'].";".$cad['Post']['titre'].";".$cad['User']['prenom'].' '.$cad['User']['nom'].";".$cad['Transaction']['message'];
        //    $str4 .= "\r\n";
        //}

        //$str5="Date création;Annonce;A;message\r\n";
        //foreach ($AD['avisdonnes'] as $cad) {
        //    $str5 .= $cad['Transaction']['created'].";".$cad['Post']['titre'].";".$cad['UserTo']['prenom'].' '.$cad['UserTo']['nom'].";".$cad['Transaction']['message'];
        //    $str5 .= "\r\n";
        //}

        $str6="";
        foreach ($AD['echanges_to_me'] as $cad) {
            $f="";
            $f = __("Date")." :".$cad['Transaction']['created']."\r\n".
            $f .= __("Annonce")." : ".$cad['Post']['titre']."\r\n";
            $f .= __("De")." : ".$cad['User']['prenom'].' '.$cad['User']['nom']."\r\n";
            $f .= __("Avis")." : ".trim(html_entity_decode($cad['Transaction']['message']))."\r\n";
            $f .= "\r\n\r\n";
            $str6.=$f;
        }

        $str7="";
        foreach ($AD['echanges_from_me'] as $cad) {
            $f="";
            $f = __("Date")." :".$cad['Transaction']['created']."\r\n".
            $f .= __("Annonce")." : ".$cad['Post']['titre']."\r\n";
            $f .= __("Vers")." : ".$cad['UserTo']['prenom'].' '.$cad['UserTo']['nom']."\r\n";
            $f .= __("Avis")." : ".trim(html_entity_decode($cad['Transaction']['message']))."\r\n";
            $f .= "\r\n\r\n";
            $str7.=$f;
        }

        $str8="";
        foreach ($AD['all_messages_received'] as $cad) {
            $f="";
            $f = __("Date message").":".$cad['Pm']['created']."\r\n".
            $f .= __("De")." : ".$cad['Expediteur']['prenom'].' '.$cad['Expediteur']['nom']."\r\n";
            $f .= __("Titre")." : ".$cad['Pm']['titre']."\r\n";
            $f .= __("Message")." : ".trim($cad['Pm']['message'])."\r\n";
            $f .= "\r\n\r\n";
            $str8.=$f;
        }

        $str9="";
        foreach ($AD['all_messages_sent'] as $cad) {
            $f="";
            $f = __("Date message").":".$cad['Pm']['created']."\r\n".
            $f .= __("Vers")." : ".$cad['Destinataire']['prenom'].' '.$cad['Destinataire']['nom']."\r\n";
            $f .= __("Titre")." : ".$cad['Pm']['titre']."\r\n";
            $f .= __("Message")." : ".trim($cad['Pm']['message'])."\r\n";
            $f .= "\r\n\r\n";
            $str9.=$f;
        }

        $compte_monnaie = $this->getUserMonnaieTransaction();
        $str10=__("Solde actuel")." : ".$compte_monnaie['solde']." ".Configure::read('Common.monnaie.name')."s (soit ".$compte_monnaie['solde']." heures)";
        $str10.="\r\n".__("Solde de départ")." : ".$compte_monnaie['userstart']." ".Configure::read('Common.monnaie.name')."s";
        $str10.="\r\n".__("Nombre de ").Configure::read('Common.monnaie.name')."s gagnés : ".$compte_monnaie['gains']." , ".__("Nombre de")." ".Configure::read('Common.monnaie.name')."s ".__("dépensés")." : ".$compte_monnaie['depenses']."\r\n";
        $curtot=$compte_monnaie['solde'];
        foreach ($compte_monnaie['alltr'] as $curtr) {
            $f="";
            $f.= __("Date")." : ".date("d/m/Y", strtotime($curtr['Transaction']['created']))."\r\n";
            $f.= "\r\n".__("Titre")." : ";
            if ($curtr['Post']['titre'] == "" ) {
                if ($curtr['Transaction']['message']!="") {
                    $f.= $curtr['Transaction']['message'];
                } else $f.= __("Autre demande"); 
            } else $f.= $curtr['Post']['titre'];
            if ($curtr['User']['id']==$this->Userinfo['id']) {
                if ($curtr['UserTo']['id']==0) {
                    $f.=  "\r\n".__("De vous vers Admin");
                } else {
                    $f.=  "\r\n".__("De vous vers")." ".$curtr['UserTo']['prenom'].' '.$curtr['UserTo']['nom'];
                }
            } else {
                if ($curtr['User']['id']==0) {
                    $f.=  "\r\n".__("D'un admin vers vous");
                } else {
                    $f.=  "\r\n".__("De ").$curtr['User']['prenom'].' '.$curtr['User']['nom']." ".__("vers vous");
                }
            }
            $f.= "\r\n".__("Montant")." : ".$curtr['Transaction']['amount'];
            $f.= "\r\n".__("Solde")." : ".$curtot;
            if ($curtr['User']['id']==$this->Userinfo['id']) {
                $curtot+=$curtr['Transaction']['amount']; 
            } else {
                $curtot-=$curtr['Transaction']['amount']; 
            } 
            $str10.=$f."\r\n";
        }
        $str10.="\r\n".date("d/m/Y", strtotime($this->Userinfo['created']));
        $str10.="\r\n".__("Solde de départ")." :".$compte_monnaie['userstart'];

        // Mes projets
        configure::write('debug',2);
        $this->loadModel('Project');
        $MP = $this->Project->find('all',array(
            'conditions' => array(
                'Project.user_id' => $this->Userinfo['id']
            ),
            'contain' => array(
                'User' => array(
                    'City' => array('fields'=>array('ville_nom_reel'))
                ),
                'Challenge' => array('fields'=>array('name')),
                'Projectparticipant' => array(
                    'User' => array('fields'=>array('nom','prenom'))
                ),
                'Projectcategory' => array(
                    'Challengescategory' => array('fields'=>array('name'))
                )

            )
        ));
        $str11 = "";
        foreach ($MP as $CP) {
            $str11 .= $this->gstr(__("Date"),$CP['Project']['created']);
            $str11 .= $this->gstr(__("Ville"),$CP['User']['City']['ville_nom_reel']);
            $str11 .= $this->gstr(__("Titre"),$CP['Project']['name']);
            $strcat = "\n";
            foreach ($CP['Projectcategory'] as $curcat) {
                $strcat .= " - ".$curcat['Challengescategory']['name'] ."\n";
            }
            $str11 .= $this->gstr(__("Catégorie(s)"),$strcat);

            $str11 .= $this->gstr(__("Type de projet"),$this->projectType[$CP['Project']['type']]);
            $str11 .= $this->gstr(__("Mode"),$this->projectOpenmode[$CP['Project']['openmode']]);
            $str11 .= $this->gstr(__("Description du projet"),$CP['Project']['description']);
            $str11 .= $this->gstr(__("Mes compétences"),$CP['Project']['userskills']);
            $str11 .= $this->gstr(__("Compétences recherchées"),$CP['Project']['requestedskills']);
            $strcat = "\n";
            foreach ($CP['Projectparticipant'] as $curcat) {
                if (isset($curcat['User']) && isset($curcat['User']['prenom'])) {
                    $strcat .= " - ".$curcat['User']['prenom']." ".$curcat['User']['nom'] ."\n";
                }
            }
            $str11 .= $this->gstr(__("Liste des personnes souhaitant participer au projet"),$strcat);
            $str11 .= $this->gstr(__("Lien vers l'espace de communication"),$CP['Project']['chatlink']);
            $str11 .= $this->gstr(__("Lien vers le site web"),$CP['Project']['weblink']);
            $str11 .= $this->gstr(__("Lien vers la vidéo"),$CP['Project']['videolink']);
            $str11 .= "\n-----------------------------------\n";
            if ($CP['Project']['image']!="") {
                //debug(WEBROOT_DIR . 'challenges/'.$CP['Project']['image']);
                $zip->addFile(IMAGES.'challenges/'.$CP['Project']['image'], "image_".$CP['Project']['image']);
            }
            if (!empty($CP['Project']['fileaddon'])) {
                //debug(WEBROOT_DIR .  '../../Clients//'.$CP['Project']['fileaddon']);
                $zip->addFile(IMAGES.'../../Clients/'.$CP['Project']['fileaddon'], "pdf_".$CP['Project']['fileaddon']);
            }
        }
        $zip->addFromString(__("Mes_Projets").'.txt', $str11);
        
        //debug($MP);
        //debug($str11);exit;



        if ($res === TRUE) {
            $zip->addFromString(__("Mes_Infos_Personnelles").'.txt', $str1);
            $zip->addFromString(__("Mes_Demandes").'.txt', $str2);
            $zip->addFromString(__("Mes_Offres").'.txt', $str3);
            //$zip->addFromString('Avis_Recus.csv', $str4);
            //$zip->addFromString('Avis_Donnes.csv', $str5);
            $zip->addFromString(__("Echanges_Vers_Moi").'.txt', $str6);
            $zip->addFromString(__("Echanges_Vers_Autres").'.txt', $str7);
            $zip->addFromString(__("Messages_recus").'.txt', $str8);
            $zip->addFromString(__("Messages_envoyes").'.txt', $str9);
            if ($ClientData['monnaie_activated']) { 
                $zip->addFromString(__("Mon_compte_monnaie").'.txt', $str10);
            }
            if ($this->Userinfo['photo']!="") $zip->addFile(IMAGES.$this->Userinfo['photo'], "photoprofil_".basename($this->Userinfo['photo']));
            foreach ($AD['offres'] as $cad) {
                if ($cad['Post']['image']!="") {
                    $zip->addFile(IMAGES.$cad['Post']['image'], "post_".basename($cad['Post']['image']));
                }
            }
            $zip->close();
            //echo 'ok';
            //echo "File is $zipname";
        } else {
            echo 'échec';
        }
        $filepath = APP."Clients/${zipname}.zip";
        //debug($filepath);exit;
        //configure::write('debug',2);debug($str10);exit;
        if(file_exists($filepath)) {
            header('Content-Type: application/zip');
            header('Content-disposition: attachment; filename='.__("vos_donnees.zip"));
            header('Content-Length: ' . filesize($filepath));
            readfile($filepath);
            unlink($filepath);
            exit;
        }
        
    }

}
