<?php
// app/Model/Pm.php

class Pm extends AppModel {
		
	//public $useTable = 'pms';
	//public $tablePrefix = '';
	
	public $actsAs = array('Containable');
	
	var $belongsTo = array(
		'Expediteur' => array(
			'className' => 'User',
			'foreignKey' => 'id_expediteur'
		),
		'Destinataire' => array(
			'className' => 'User',
			'foreignKey' => 'id_destinataire'
		),
	);

	/**
	 * Récupération des messages envoyé pour un utilisateur
	 *
	 * @param integer $uid user ID
	 * @return array 
	 * @author David Guillerm <dguillerm@gmail.com>
	 */
	public function get_messages_received_for_user($uid) {
		$res = $this -> find('all', array(
			'joins' => array(
		        array(
		            'table' => 'users',
		            'alias' => 'UserExpediteur',
		            'type' => 'INNER',
		            'conditions' => array(
		                'UserExpediteur.id = Pm.id_expediteur'
		            )
		        )
		    ),
			'conditions' => array(
				'id_destinataire' => $uid
			),
			'order' => 'Pm.id DESC',
			'fields' => array('UserExpediteur.nom','UserExpediteur.prenom', 'Pm.id','Pm.lu','Pm.titre','Pm.message','Pm.created','Pm.id_expediteur','Pm.id_destinataire'),
		));
		return ($res);
	}
	
	/**
	 * Récupération des messages envoyé pour un utilisateur
	 *
	 * @param integer $uid user ID
	 * @return array 
	 * @author David Guillerm <dguillerm@gmail.com>
	 */
	public function get_messages_sent_for_user($uid) {
		$res = $this -> find('all', array(
			'joins' => array(
		        array(
		            'table' => 'users',
		            'alias' => 'UserDestinataire',
		            'type' => 'INNER',
		            'conditions' => array(
		                'UserDestinataire.id = Pm.id_destinataire'
		            )
		        )
		    ),
			'conditions' => array(
				'id_expediteur' => $uid
			),
			'order' => 'Pm.id DESC',
			'fields' => array('UserDestinataire.nom','UserDestinataire.prenom', 'Pm.id','Pm.lu','Pm.titre','Pm.message','Pm.created','Pm.id_expediteur','Pm.id_destinataire'),
		));
		return ($res);
	}
	
}
?>
