<?php
// app/Model/City.php
App::uses('AppModel', 'Model');
App::uses('SimplePasswordHasher', 'Controller/Component/Auth');

class User extends AppModel {
	public $name = 'User';
	public $actsAs = array('Containable');
	var $belongsTo = array('City');
	var $hasOne = array();
	var $hasMany = array(
		'TransactionDebit' => array(
			'className' => 'Transaction',
			'foreignKey' => 'user_id',
			'order' => 'id desc'
		),
		'TransactionCredit' => array(
			'className' => 'Transaction',
			'foreignKey' => 'to_userid',
			'order' => 'id desc'
		),
		//'Project'
	);


	public $validate = array(
		//'username' => array(
		//	'required' => array(
		//		'rule' => 'notBlank',
		//		'message' => 'Un nom d\'utilisateur est requis'
		//		)
		//	),
		'password' => array(
			'required' => array(
				'rule' => 'notBlank',
				'message' => "Un mot de passe est requis"
				)
			),
		'nom' => array(
			'required' => array(
				'rule' => 'notBlank',
				'message' => "Veuillez entre votre nom"
				)
			),
		'prenom' => array(
			'required' => array(
				'rule' => 'notBlank',
				'message' => "Veuillez entre votre prénom"
				)
			),
		'email' => array(
	        'email-chk1' => array(
	        	'rule'    => 'isUnique',
	        	'message' => "Désolé, mais vous êtes déjà inscrit sur notre réseau avec cet email ... Si vous avez perdu votre mot de passe, vous pouvez en demandez un autre en cliquant sur <a href=\"/MotDePasse\">ce lien</a>...."
	        ),
	        'email-chk2' => array(
		        'rule' => array('email', true),
		        'message' => "Merci de soumettre une adresse email valide."
		    )
	    ),
	    'city_id' => array(
	        'rule'    => array('numeric'),
	        'message' => "Erreur sur votre ville, veuillez vérifier ou nous contacter"
	    ),
	    //'photo' => array(
	    //    'rule' => array('fileSize', '<=', '1MB'),
	    //    'message' => "La taille de l'image doit être inférieure à 1MB"
	    //)


		// 'role' => array(
		// 	'valid' => array(
		// 		'rule' => array('inList', array('admin', 'auteur')),
		// 		'message' => 'Merci de rentrer un rôle valide',
		// 		'allowEmpty' => false
		// 		)
		// 	)
		);



}
?>
