<!DOCTYPE html>
<html lang="fr">

  <head>

    <meta charset="utf-8">
		<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <?php echo $this->Html->charset(); ?>
	<?php
		echo $this->Html->meta('keywords',"TROCKEE, troc, troc d’objets, échange d’objets, barter, bartering, RSE, CSR");
	?>
	<?php
		echo $this->Html->meta('description',__("TROCKEE est la plateforme pour échanger des objets : favoriser l'environnement, le pouvoir d’achat, et la communauté !"));
	?>
	<title>
		<?php echo $this->fetch('title'); ?>
	</title>
	<link rel="apple-touch-icon" sizes="180x180" href="/apple-touch-icon.png">
	<link rel="icon" type="image/png" sizes="32x32" href="/favicon-32x32.png">
	<link rel="icon" type="image/png" sizes="16x16" href="/favicon-16x16.png">
	<link rel="manifest" href="/site.webmanifest">
	<link rel="mask-icon" href="/safari-pinned-tab.svg" color="#5bbad5">
	<meta name="msapplication-TileColor" content="#da532c">
	<meta name="theme-color" content="#ffffff">


    <!-- Custom fonts for this template -->
		<link href="https://fonts.googleapis.com/css?family=Lato:300,400,700,300italic,400italic,700italic" rel="stylesheet" type="text/css">
		<link href="https://fonts.googleapis.com/css?family=Alegreya+Sans|PT+Serif" rel="stylesheet">

		<link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.8.1/css/all.css" integrity="sha384-50oBUHEmvpQ+1lW4y57PTFmhCaXp0ML5d60M1M7uH2+nqUivzIebhndOJK28anvf" crossorigin="anonymous">

	<?php
		echo $this->Html->meta('icon');
		
		// to keep pull-right available for icons
		echo $this->Html->css('../vendor/font-awesome/css/font-awesome.min');


		echo $this->Html->css('../vendor/bootstrap/css/bootstrap.min');
		echo $this->Html->css('../bower_components/ng-dialog/css/ngDialog.min');
		echo $this->Html->css('../bower_components/ng-dialog/css/ngDialog-theme-default.min');
		echo $this->Html->css('../bower_components/ng-dialog/css/ngDialog-theme-plain.min');
		echo $this->Html->css('../bower_components/ngQuickDate/dist/ng-quick-date');
		echo $this->Html->css('../bower_components/ngQuickDate/dist/ng-quick-date-default-theme');
		echo $this->Html->css('../bower_components/fullcalendar/dist/fullcalendar.min');
		echo $this->Html->css('animate.min.css');
		echo $this->Html->css('rotator.css');

		echo $this->Html->css('landing-page.css?t='.time());
		echo $this->Html->css('tbp.css?t='.time());
		echo $this->Html->css('common');
		echo $this->Html->css('tbpro.footer');

		//echo $this->Html->css('flatty');
		echo $this->Html->css('tbpro.user'); // Pour répertoire
		echo $this->Html->css('../bower_components/angucomplete-alt/angucomplete-alt');

		// Client Template CSS file
		echo $this->Html->css('tbpro.client');
		// Client Custom cSS file
		echo $this->Html->css('clients/'.Configure::read('Common.client.subdomain').'.css');
		echo $this->Html->css('awesome-bootstrap-checkbox.css');
	

		echo $this->fetch('meta');
		echo $this->fetch('css');
		echo $this->fetch('script');
	?>



	<meta property="og:type" content="website" />
	<meta property="og:title" content="<?= $title_for_layout;?>" />
	<meta property="og:description" content=<?= __("TROCKEE est la plateforme pour échanger des objets : favoriser l'environnement, le pouvoir d’achat, et la communauté !")?> />

  </head>

  <body ng-app="tbproApp" class="<?=$bodyclass;?>">

		<?php
			if (!isset($pageactive)) $pageactive="";
			if (!function_exists('chkactive')) {
				echo $this->element('utils_functions');
			}
			$infospage="";
			if ($page=="ccm") {
				$infospage="active activemenudropdown";
			}
		?>

    <!-- Navigation -->
    <nav class="navbar navbar-light navbar-expand-lg navbar-light bg-light fixed-top bg-white">
		<div class="container-fluid">
        <a class="navbar-brand" href="#">
			<?php 
				echo $this->Html->image($ClientDefaults['logo'],array('id'=>'logo','url'=>'/','height'=>'48'));
				//echo "<span class='clientTitle'>".Configure::read('Common.client.name')."</span>";
			?>
		</a>
        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarResponsive" aria-controls="navbarResponsive" aria-expanded="false" aria-label="Toggle navigation">
          <span class="navbar-toggler-icon"></span>
        </button>

        <div class="collapse navbar-collapse" id="navbarResponsive">
          <ul class="navbar-nav ml-auto">
						<?php if($Userinfo) { ?>
							<?php echo $this->element('menu_user_connected',array('pageactive'=>$pageactive)); ?>
          	<?php } else { ?>

							<?php foreach ($global_categories as $curcat) { ?>
								<li class="nav-item <?= chkactive($pageactive,'catalogue-O-'.$curcat['Category']['id'])?>">
									<?php echo $this->Html->link(__($curcat['Category']['name']), array('controller' => 'posts', 'action' => 'catalogue','O',$curcat['Category']['name']), array('class' => "nav-link ".chkactive($pageactive,'catalogue-O-'.$curcat['Category']['id']))); ?>
								</li>
							<?php } ?>
							<li class="nav-item <?= chkactive($pageactive,'catalogue-O')?>"><?php echo $this->Html->link(__("Voir tout"), array('controller' => 'posts', 'action' => 'catalogue','catid'=>'O'), array('class' => 'nav-link')); ?></li>

							<li class="nav-item"><?php echo $this->Html->link(__("Se connecter"), array('controller' => 'users', 'action' => 'login'), array('class' => 'nav-link')); ?></li>
          		<li class="nav-item"><?php echo $this->Html->link(__("S'inscrire"), array('controller' => 'users', 'action' => 'add'), array('class' => 'nav-link')); ?></li>
						<?php } ?>
						<!--<li class="nav-item dropdown">
							<a class="nav-link dropdown-toggle <?=$infospage?>" href="#" id="navbarDropdownMenuLinkUser" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
								<?= __("Informations")?>
								</a>
							<div class="dropdown-menu dropdown-fix" aria-labelledby="navbarDropdownMenuLinkUser">
								<?php //echo $this->Html->link(__("Comment ça marche ?"), array('controller' => 'pages', 'action' => 'display','ccm'), array('class' => 'dropdown-item')); ?>
							</div>
						</li>-->


						


						<?php //echo $this->element('flags');?>
						<div class="d-flex d-inline mx-auto">
								<button type="button" class="btn btn-panier">
								<?php echo $this->Html->link(__("Panier"), array('controller' => 'carts', 'action' => 'view'), array('class' => 'panier-text')); ?>
									<span class="badge badge-light"><?= $cartCountProduct ?></span>
								</button>
						</div>
          </ul>
				</div>
		</div>
    </nav>

    <!-- Page Content -->
    <?php if ($page != "accueil") { ?>
    <header class="content-header">
        <div class="container">
    <?php } ?>
		<?php if (($Userinfo['vacation']) and ($page != "accueil")) { ?>
				<?php echo $this->element('vacation');?>
		<?php } ?>

		<div class="row text-center">
			<div class="col">
					<?php
						$ua = htmlentities($_SERVER['HTTP_USER_AGENT'], ENT_QUOTES, 'UTF-8');
						if (preg_match('~MSIE|Internet Explorer~i', $ua) || (strpos($ua, 'Trident/7.0; rv:11.0') !== false)) {
					?>
							<div class="row mt-5">
							<div class="col mt-5 "><div class="alert alert-glaz" role="alert">
							<?= __("Pour information, vous utilisez un navigateur web qui n'est pas compatible avec notre plateforme. Merci d'utiliser Chrome, Firefox ou Safari.")?>
							</div>
							</div>
						</div>
					<?php }  ?>
					<?php echo $this->Flash->render(); ?>
					<?php echo $this->Session->flash('auth'); ?>
			</div>
		</div>
		
        <?php echo $this->fetch('content'); ?>
	
	<?php if ($page != "accueil") { ?>
        </div>
    </header>
    <?php } ?>



    <aside class="tbprofooter">

      <div class="container">

        <div class="row">
          <div class="col-lg-12 my-auto">
						<center>
							<a href="" target="_blank">
								<?php
									echo $this->Html->image(Configure::read('Common.logoBL'),array('width'=>Configure::read('Common.logoBL_size'),'id'=>'logoft','class'=>''));
								?>
							</a>
							<br><br><span class="title p_tbprofooter"><?= __("Solution développée avec")?>
								<i class='fa fa-heart mr-1 ml-1' style="color:#FF8989"></i>
								<?=__("par la SAS")?> 
								<a href="http://www.local4people.com" target="_blank">Local4People</a>,<br>Maison des Entreprises, 4 rue Ampère, BP 30255, 22302 Lannion Cedex</span>
							<br><br><a href="http://www.local4people.com" target="_blank"><?php echo $this->Html->image('logol4p.png',array('width'=>'200','id'=>'logoft','class'=>''));?></a>
						</center>
          </div>          
        </div>

      </div>
      <!-- /.container -->

    </aside>
    <!-- /.banner -->



<?php
if ($page=="accueil" && $bottomimage) {
?>
<div class="row">
<div class="col-sm-12">
	<?php
		if ($img_footer_url!="") {
			echo "<a href='$img_footer_url' target='_blank'>";
			echo $this->Html->image('clients/'.$ClientDefaults['bottomimage'],array('class'=>'img-fluid imglanding'));
			echo "</a>";
		} else {
			echo $this->Html->image('clients/'.$ClientDefaults['bottomimage'],array('class'=>'img-fluid imglanding'));
		}
	?>
</div>
</div>
<?php } ?>

<!--   Footer   -->
<footer class="myfooter">
		<div class="container">
			<div class="row">
				<div class="col">
					<h4 class="title-widget"><?= __("Informations")?></h4>
					<ul>
						<!-- <li class="lnkbottom"><?php //echo $this->Html->link(__("Comment ça marche ?"), array('controller' => 'pages', 'action' => 'display','ccm'), array('class' => '')); ?></li>-->
						<?php if ($Userinfo) {?>
							<li class="lnkbottom"><a target="_blank" href="/files/<?=$ClientDefaults['notice_pdf_'.$lang].'?t='.time()?>"><?= __("Notice utilisateur")?></a></li>
						<?php } ?>
						<?php if ($charte_activated && $ClientDefaults['charte_pdf_'.$lang]!="") echo '<li class="lnkbottom"><a target="_blank" href="/files/'.$ClientDefaults['charte_pdf_'.$lang].'?t='.time().'">'.__("Charte de qualité de").' '.strtoupper($ClientData['name']).'</a></li>';?>
						<?php if ($ClientDefaults['cgu_pdf_'.$lang]!="") echo '<li class="lnkbottom"><a target="_blank" href="/files/'.$ClientDefaults['cgu_pdf_'.$lang].'?t='.time().'">'.__("CGU (Conditions Générales d'Utilisation)").'</a></li>';?>
						<?php if ($ClientDefaults['pdc_pdf_'.$lang]!="") echo '<li class="lnkbottom"><a target="_blank" href="/files/'.$ClientDefaults['pdc_pdf_'.$lang].'?t='.time().'">'.__("Politique de Confidentialité").'</a></li>';?>
						<?php if ($ClientDefaults['cgv_pdf_'.$lang]!="") echo '<li class="lnkbottom"><a target="_blank" href="/files/'.$ClientDefaults['cgv_pdf_'.$lang].'?t='.time().'">'.__("Conditions Générales de Ventes et politique de retours").'</a></li>';?>

					</ul>
				</div>				
				<div class="col">
					<h4 class="title-widget"><?= __("Contact")?></h4>
					<div class="lnkbottom">
						<?php echo $this->Html->link(__("Nous contacter"), array('controller' => 'pages', 'action' => 'display','contact'), array('class' => '')); ?>
					
						<br>
							SAS Local4People,<br> Maison des Entreprises,<br>
							4 rue Ampère, BP 30255<br>
							22302 Lannion Cedex
					</div>
					<div class="d-flex mt-2">
						<a class="mr-2" target="_blank" href="https://www.facebook.com/profile.php?id=100083989504201"><h5><span class="badge badge-secondary"><i class="fab fa-facebook-f mr-1"></i>Facebook</span></h5></a>
						<a class="" target="_blank" href="https://www.instagram.com/labraderiedespetits/"><h5><span class="badge badge-secondary"><i class="fab fa-instagram mr-1"></i>Instagram</span></h5></a>
					</div>
				</div>
			</div>
			<hr>

			<p class="text-center"> © 2018-<?= date("Y"); ?>. <?= strtoupper(Configure::read('Common.sitename'));?></p>
		</div> <!-- ./container -->

    </footer>
	<script type="text/javascript" src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCakTpHBty9xlLrCHfCdx7apujIk5loD48&libraries=places&language=<?= Configure::read('Config.lang_code') ?>"></script>

    <!-- Bootstrap core JavaScript -->
    <?php echo $this->Html->script("../vendor/jquery/jquery.min.js"); ?>
		<?php echo $this->Html->script("../vendor/bootstrap/js/bootstrap.bundle.min.js"); ?>
    <!-- jQuery -->
    <?php echo $this->Html->script('../bower_components/moment/min/moment.min.js'); ?>
    <?php echo $this->Html->script('date-fr-FR'); ?>

    <!-- Bootstrap Core JavaScript -->
    <?php echo $this->Html->script('../bower_components/angular/angular.min.js'); ?>
    <?php echo $this->Html->script('../bower_components/angular-sanitize/angular-sanitize.min.js'); ?>
    <?php echo $this->Html->script('../bower_components/ng-dialog/js/ngDialog.min.js'); ?>
    <?php echo $this->Html->script('../bower_components/ngQuickDate/dist/ng-quick-date.min.js'); ?>
    <?php echo $this->Html->script('../bower_components/angular-ui-calendar/src/calendar.js'); ?>
    <?php echo $this->Html->script('../bower_components/fullcalendar/dist/fullcalendar.min.js'); ?>
		<?php echo $this->Html->script('../bower_components/fullcalendar/dist/lang/fr.js'); ?>
		<?php //echo $this->Html->script('../bower_components/ngAutocomplete/src/ngAutocomplete.js'); ?>
		<?php echo $this->Html->script('../bower_components/angucomplete-alt/angucomplete-alt.min.js'); ?>

		<?= $this->Html->script('Chart.min.js') ?>
    <?= $this->Html->script('angular-chart.min.js') ?>
    <?php echo $this->Html->script('tbpro.js') ?>
    <?php if (isset($controller2load)) {echo $this->Html->script("controllers/$controller2load.js");} ?>
    <?php if (isset($controller2load_bis)) echo $this->Html->script("controllers/$controller2load_bis.js"); ?>
    <?php if ($page=="profil") echo $this->Html->script("controllers/profil.js"); ?>
    <script src="https://www.google.com/recaptcha/api.js" async defer></script>

    <script src="https://www.google.com/recaptcha/api.js" async defer></script>
	
<script>
$(document).ready(function() {
	$('.submitSafari').keydown(function(e) {
		if (e.keyCode == 13) {
			$('#MenuRechercheForm').submit();
		}
	});

	$('.carousel').carousel({
		interval: 4000
	})

});
</script>

  </body>

</html>