<!DOCTYPE html>
<html lang="fr">

  <head>
    <?php echo $this->element('landingpage/head_part'); ?>
  </head>

  <body  ng-app="tbproLandingApp" id="page-top">
    <?php echo $this->element('landingpage/navbar_part'); ?>
    
    <!-- Header -->
    <header class="masthead">
      <div class="container">
        <div class="intro-text">
          <div class="intro-lead-in"></div>
          <div class="intro-heading">
            <?= __("Echange tes compétences professionnelles ou tes hobbies avec tes collègues !")?>
            <br><?= __("Propose ou participe à des projets innovants !")?>
          </div>
          <a class="btn btn-primary btn-xl btn-round text-uppercase js-scroll-trigger" target="_blank" href="https://www.youtube.com/embed/<?= $VideoYoutubeId ?>?rel=0"><?= __("Voir la vidéo")?></a>
        </div>
      </div>
    </header>

    <!-- Services -->
    <section id="services">
      <div class="container">

        <div class="row mb-0">
          <div class="col-lg-8 mx-auto text-center">
            <div class="embed-responsive embed-responsive-16by9">
              <iframe class="embed-responsive-item" src="https://www.youtube.com/embed/<?= $VideoYoutubeId ?>?rel=0" allowfullscreen></iframe>
            </div>
          </div>
        </div>

        <div class="row mb-lg-4 mt-5 mb-0">
          <div class="col-lg-12 text-center">
            <h2 class="section-heading text-uppercase"><?= __("Comment ça marche ?")?></h2>
            <h4 class="text-center mb-4"><?= __("Bénéficie d'une offre de compétence d'un de tes collègues, ou réponds à une demande ponctuelle !")?></h4>
          </div>
        </div>
        <div class="card-deck">
            <div class="card">
                <?php echo $this->Html->image('landingpage/img1'.$lang.'.png',array('class'=>'card-img-top')); ?>
            </div>
            <div class="card">
                <?php echo $this->Html->image('landingpage/img2'.$lang.'.png',array('class'=>'card-img-top')); ?>
            </div>
            <div class="card">
                <?php echo $this->Html->image('landingpage/img3'.$lang.'.png',array('class'=>'card-img-top')); ?>
            </div>
        </div>    
        <div class="card-deck mt-4">
            <div class="card">
                <?php echo $this->Html->image('landingpage/img4'.$lang.'.png',array('class'=>'card-img-top')); ?>
            </div>
            <div class="card">
                <?php echo $this->Html->image('landingpage/img5'.$lang.'.png',array('class'=>'card-img-top')); ?>
            </div>
            <div class="card">
                <?php echo $this->Html->image('landingpage/img6'.$lang.'.png',array('class'=>'card-img-top')); ?>
            </div>
        </div>
        <div class="card-deck mt-4">
            <div class="card">
                <?php echo $this->Html->image('landingpage/img7'.$lang.'.png',array('class'=>'card-img-top')); ?>
            </div>
            <div class="card">
                <?php echo $this->Html->image('landingpage/img8'.$lang.'.png',array('class'=>'card-img-top')); ?>
            </div>
            <div class="card">
                <?php echo $this->Html->image('landingpage/img9'.$lang.'.png',array('class'=>'card-img-top')); ?>
            </div>
        </div>
        <section class="" id="portfolio2">
        <div class="container">
            <div class="row mt-5 mb-5">
                <div class="col-md-6 col-sm-6 portfolio-item-notused">
                    <div class="portfolio-link">
                      <h4 class="text-center mb-5"><?= __("Ou bien, propose toi-même une offre de compétence ou un de tes hobbies !")?></h4>
                    </div>
                    <div class="portfolio-caption">
                    </div>
                </div>

                <div class="col-md-6 col-sm-6">
                    <div class="portfolio-link">
                        <h4 class="text-center mb-5"><?= __("A l'issu de l'échange, celui qui a bénéficié de la compétence règle l'offreur avec la monnaie virtuelle, en fonction du temps que vous avez passé ensemble.<br><small>(Cette monnaie virtuelle est optionnelle et peut être désactivée)</small>")?></h4>
                    </div>
                    <div class="portfolio-caption">
                    
                    </div>
                </div>          
            </div>

            <div class="row mb-lg-4 mt-5 mb-0">
              <div class="col-lg-12 text-center">
                <h4 class="text-center mb-4"><?= __("Participe à des challenges collaboratifs d'innovation en proposant ou en contribuant à des projets !")?></h4>
              </div>
            </div>

            <div class="card-deck">
              <div class="card">
                  <?php echo $this->Html->image('landingpage/prj1'.$lang.'.png',array('class'=>'card-img-top')); ?>
              </div>
              <div class="card">
                  <?php echo $this->Html->image('landingpage/prj2'.$lang.'.png',array('class'=>'card-img-top')); ?>
              </div>
              <div class="card">
                  <?php echo $this->Html->image('landingpage/prj3'.$lang.'.png',array('class'=>'card-img-top')); ?>
              </div>
            </div>  

            <div class="row mt-5">
                <div class="col-sm-10 mx-auto">
                    <h4 class="text-center">
                    <?= __("TIMEBANKPRO n'existe pas encore dans ton entreprise ? N'hésite pas à en parler autour de toi et à demander à ton entreprise de nous contacter !")?>
                    </h4>
                </div>
            </div>
            <div class="row mt-4">
                <div class="col-sm-10 mx-auto text-center">
                  <?php echo $this->Html->image('landingpage/megaphone.png',array('class'=>'img-fluid')); ?>
                </div>
            </div>
        </div>
        </section>

      </div>
    </section>

    <!-- Portfolio Grid -->
    <section class="" id="portfolio">
        <div class="row">
          <div class="col-lg-12 text-center mb-3">
            <h2 class="section-heading text-uppercase"><?= __("Vous êtes une entreprise ?")?></h2>
          </div>
        </div>
        <header class="masthead2">
            <div class="container">
                <div class="intro-text">
                <div class="intro-lead-in"></div>
                <div class="intro-heading">
                  <?= __("Devenez une entreprise apprenante en favorisant le partage de connaissances entre salarié(e)s")?>.
                  <br><?= __("Lancez des challenges collaboratifs d’innovation !")?>
                  </div>
                <a class="btn btn-primary btn-xl btn-round text-uppercase js-scroll-trigger" target="_blank" href="files/brochure_<?= $lang ?>.pdf"><?= __("Voir notre brochure")?></a>
                </div>
            </div>
        </header> 
        <div class="container">
        <div class="row mt-5 mb-3">
          <div class="col-lg-12">
            <div class="row mt-4 mx-auto">
              <div class="col-md-4 text-center">
                  <?php echo $this->Html->image('landingpage/l2.png',array('class'=>'img-fluid')); ?><br>
                  <h5 class="mt-4 text-center"><u><?= __("L’entreprise apprenante");?></u> : <br>
                  <?= __("facilitez l’échange de compétences, la formation de pair à pair, avec le côté ludique d’une monnaie virtuelle permettant le don et le contre-don !")?>
                  </h5>
              </div>
              <div class="col-md-4 text-center">
                  <?php echo $this->Html->image('landingpage/l3.png',array('class'=>'img-fluid')); ?><br>
                  <h5 class="mt-4 text-center"><u><?= __("L’innovation collective");?></u> : <br>
                  <?= __("favorisez des propositions de projets dans le cadre de challenges collaboratifs d'innovation.")?>
                  </h5>
              </div>
              <div class="col-md-4 text-center">
                  <?php echo $this->Html->image('landingpage/l1.png',array('class'=>'img-fluid')); ?><br>
                  <h5 class="mt-4 text-center"><u><?= __("La qualité de vie au travail");?></u> : <br>
                  <?= __("favorisez les liens sociaux par la découverte de hobbies entre salarié(e)s.")?>
                  </h5>
              </div>
            </div>
          </div>
        </div>
        </div>

        

        <div class="row mt-5">
          <div class="col-md-8 mx-auto">
            <h2 class="text-center mt-5">
            <?= __("Donnez dès maintenant l'avantage à votre entreprise <br>en la dotant de sa propre plateforme d'échanges entre salarié(e)s !")?>
            </h2>
            <div class="text-center"><?= __("(exemples fictifs ci-dessous)")?></div>
          </div>
        </div>
        <div class="container">
        <div class="row mt-5">
          <div class="col-md-6 mx-auto">
            <div class="card">
              <?php echo $this->Html->image('landingpage/ent1'.$lang.'.png',array('class'=>'card-img-top')); ?>
            </div>
          </div>
          <div class="col-md-6">
            <div class="card">
              <?php echo $this->Html->image('landingpage/ent2'.$lang.'.png',array('class'=>'card-img-top')); ?>
            </div>
          </div>
        </div>
        </div>
    </section>

    <!-- Portfolio Grid -->
    <section class="" id="assoc">
        <div class="row">
          <div class="col-lg-12 text-center mb-3">
            <h2 class="section-heading text-uppercase"><?= __("Vous êtes une association ou une collectivité ?")?></h2>
          </div>
        </div>
        <header class="masthead3">
            <div class="container">
                <div class="intro-text">
                <div class="intro-lead-in"></div>
                <div class="intro-heading">
                  <?= __("Facilitez l'entraide et le lien social entre citoyen(ne)s, dynamisez l'activité de votre territoire !")?>
                  </div>
                <a class="btn btn-primary btn-xl btn-round text-uppercase js-scroll-trigger" target="_blank" href="https://lillauxsoleils.trockee.com"><?= __("Voir un exemple")?></a>
                </div>
            </div>
        </header> 
        
    </section>    

    <!-- Portfolio Grid -->
    <section class="" id="portfolio">
        <div class="row mt-5">
          <div class="col-md-8 mx-auto">
            <h2 class="text-center mt-5">
            <?= __("Votre plateforme est accessible aussi bien depuis un mobile qu'un ordinateur")?> 
            </h2>
          </div>
        </div>
    </section>    


    <!-- portfolio Grid -->
    <section class="mb-5" id="portfolio">
        <div class="row mt-5">
          <div class="col-md-8 mx-auto">
            <h2 class="text-center mt-5">
            <?= __("Tarifs des solutions TIMEBANKPRO")?> 
            </h2>
          </div>
        </div>
        <div class="container">
        <div class="row mt-5">
          <div class="col-sm-12">
            <div class="card-deck">
              <div class="card border-info">
                <div class="card-header text-center pricetitle"><h5><?= __("Basique")?></h5><h4>1 €</h4><?= __("par utilisateur éligible, par mois")?><br>
                <?= __("Mise en œuvre (une fois) : 3000 €")?>
                </div>
                <div class="card-body">
                  <p class="card-text">
                      <div class="text-center pricetxt">
                      <?= __("Echanger ses compétences")?><i class="priceicon ml-2 fas fa-check"></i>
                      <br><?= __("Répertoire")?><i class="priceicon ml-2 fas fa-check"></i>
                      <br><?= __("Banque du temps")?><i class="priceicon ml-2 fas fa-check"></i>
                      </div>
                  </p>
                </div>
              </div>
              <div class="card border-info">
                <div class="card-header text-center pricetitle"><h5><?= __("Pro")?></h5><h4>3 €</h4><?= __("par utilisateur éligible, par mois")?><br>
                <?= __("Mise en œuvre (une fois) : 4000 €")?>
                </div>
                <div class="card-body">
                  <p class="card-text">
                      <div class="text-center pricetxt">
                        <?= __("Echanger ses compétences")?><i class="priceicon ml-2 fas fa-check"></i>
                        <br><?= __("Répertoire")?><i class="priceicon ml-2 fas fa-check"></i>
                        <br><?= __("Banque du temps")?><i class="priceicon ml-2 fas fa-check"></i>
                        <br><?= __("Proposer des formations")?><i class="priceicon ml-2 fas fa-check"></i>
                        <br><?= __("Lancer des challenges d'innovation")?><i class="priceicon ml-2 fas fa-check"></i>
                      </div>
                  </p>
                </div>
              </div>
              <div class="card border-info">
                <div class="card-header text-center pricetitle"><h5><?= __("Premium")?></h5><h4>4 €</h4><?= __("par utilisateur éligible, par mois")?><br>
                <?= __("Mise en œuvre (une fois) : 6000 €")?>
                </div>
                <div class="card-body">
                  <p class="card-text">
                      <div class="text-center pricetxt">
                        <?= __("Echanger ses compétences")?><i class="priceicon ml-2 fas fa-check"></i>
                        <br><?= __("Répertoire")?><i class="priceicon ml-2 fas fa-check"></i>
                        <br><?= __("Banque du temps")?><i class="priceicon ml-2 fas fa-check"></i>
                        <br><?= __("Proposer des formations")?><i class="priceicon ml-2 fas fa-check"></i>
                        <br><?= __("Lancer des challenges d'innovation")?><i class="priceicon ml-2 fas fa-check"></i>
                        <br><?= __("Gamification")?><i class="priceicon ml-2 fas fa-check"></i>
                        <br><?= __("Multilingue")?><i class="priceicon ml-2 fas fa-check"></i>
                      </div>
                  </p>
                </div>
              </div>
            </div>
          </div>
        </div>
        </div>
    </section>  
    
    <!-- Contact -->
    <section id="contact" ng-controller="LandingCtrl">
      <div class="container">
        <div class="row">
          <div class="col-lg-12 text-center mb-5">
            <h2 class="section-heading text-uppercase txtexp"><?= __("Demandez nous dès-maintenant une démo gratuite !")?> </h2>
          </div>
        </div>
        <div class="row">
          <div class="col-lg-12">
          <?php echo $this->Form->create('Pages', array('url'=>'contact_msg','class' => '','ng-submit'=>'checkClickCaptcha()')); ?>
              <div class="row">
                <div class="col-md-6">
                  <div class="form-group">
                    <?php echo $this -> Form -> input('nomprenom', array('class'=>'form-control tareamax','label' => false, 'ng-required'=>true, 'placeholder' => __("Vos nom/prénom"))); ?>
                    <p class="help-block text-danger"></p>
                  </div>
                  <div class="form-group">
                    <?php echo $this -> Form -> input('email', array('class'=>'form-control tareamax','label' => false, 'ng-required'=>true, 'placeholder' => __("Votre email"))); ?>
                    <p class="help-block text-danger"></p>
                  </div> 
                  <div class="form-group">
                    <div class="g-recaptcha" data-sitekey="<?= Configure::read('Common.captchasitekey')?>"></div>
                  </div>   
                </div>
                <div class="col-md-6">
                  <div class="form-group">
                  <?php echo $this -> Form -> textarea('message', array('class'=>'form-control','rows' => '5', 'cols' => '5', 'label' => false, 'required'=>true,'placeholder' => __("Entrez ici votre message"))); ?>
                    <p class="help-block text-danger"></p>
                  </div>
                </div>
                <div class="clearfix"></div>
                <div class="col-lg-12 text-center">
                  <div id="success"></div>
                  <h6 ng-if="!displaySubmitButton"><?= __("Merci de saisir les informations ci-dessus, puis cocher la case de validation pour pouvoir envoyer votre message")?></h6>
                  <button ng-if="displaySubmitButton" id="sendMessageButton" class="btn btn-primary btn-xl text-uppercase" type="submit"><?= __("Envoyer")?></button>
                </div>

                
              </div>
          <?php echo $this -> Form -> end(); ?>
          </div>
        </div>
      </div>
    </section>

    <!-- Footer -->
    <footer class="presse">
      <div class="container">
        <div class="row mt-5">
          <div class="col-md-6 offset-md-3">
            <h3 class="text-center mb-4"><?= __("Ils nous accompagnent")?></h3>
            <div class="row mt-5">
              <div class="col align-self-center"><?php echo $this->Html->link($this->Html->image('landingpage/logo_orange.png',array('height'=>72)),'https://www.orange.com/fr/accueil ', array('class'=>'img-fluid','target'=>'_blank','escape'=>false)); ?></div>
              <div class="col align-self-center mt-4 mt-md-0"><?php echo $this->Html->link($this->Html->image('landingpage/logo_anticipa.png',array('height'=>72)),'http://www.technopole-anticipa.com', array('class'=>'img-fluid','target'=>'_blank','escape'=>false)); ?></div>
            </div>
          </div>
        </div>
      </div>
    </footer>
    <footer class="presse">
      <div class="container">
        <div class="row mt-5">
          <div class="col-md-10 offset-md-1">
            <h3 class="text-center mb-3"><?= __("Ils utilisent TIMEBANKPRO pour favoriser les échanges et l'innovation")?></h3>
            <div class="row mt-5">
              <div class="col align-self-center mt-4 mt-md-0"><?php echo $this->Html->link($this->Html->image('landingpage/logo_orange.png',array('height'=>72)),'https://www.orange.com/fr/accueil', array('class'=>'img-fluid','target'=>'_blank','escape'=>false)); ?></div>
              <div class="col align-self-center mt-4 mt-md-0"><?php echo $this->Html->link($this->Html->image('landingpage/logo_ft.png',array('height'=>72)),'https://frenchtech-brestplus.bzh', array('class'=>'img-fluid','target'=>'_blank','escape'=>false)); ?></div>
              <div class="col align-self-center mt-4 mt-md-0"><?php echo $this->Html->link($this->Html->image('landingpage/s4g.svg',array('height'=>72)),'https://summit4good.bzh', array('class'=>'img-fluid','target'=>'_blank','escape'=>false)); ?></div>
            </div>
          </div>
        </div>
      </div>
    </footer>
    <footer class="presse">
      <div class="container">
        <div class="row mt-4">
          <div class="col">
            <h3 class="text-center"><?= __("Ils parlent de nous")?></h3>
            <div class="row mt-5">
              <div class="col align-self-center"><?php echo $this->Html->link($this->Html->image('landingpage/logo_anticipa.png',array('height'=>72)),'http://www.technopole-anticipa.com/TIMEBANKPRO-la-banque-du-temps-des-entreprises-boostee-de-bien-etre-et-d.html', array('class'=>'img-fluid','target'=>'_blank','escape'=>false)); ?></div>
              <div class="col align-self-center mt-4 mt-md-0"><?php echo $this->Html->link($this->Html->image('logos/Telegramme2.jpg',array('height'=>40)),'https://www.letelegramme.fr/cotes-darmor/lannion/timebankpro-un-outil-pour-augmenter-le-capital-bien-etre-au-travail-10-12-2018-12157060.php?fbclid=IwAR3LT03w7oM45dlvGJPWCd_HS5Oz-o7qjPutslK_ZSgw4-OA77k0LY91dps', array('class'=>'img-fluid','target'=>'_blank','escape'=>false)); ?></div>
              <div class="col align-self-center mt-4 mt-md-0"><?php echo $this->Html->link($this->Html->image('landingpage/api.png',array('height'=>72)),'https://www.agence-api.fr/article/local4people-mise-sur-timebankpro?security_key=993b21f0f98320eecb7bf98f768fbbd3', array('class'=>'img-fluid','target'=>'_blank','escape'=>false)); ?></div>
            </div>
          </div>
        </div>
      </div>
    </footer>

    <footer>
      <div class="container">
        <div class="row">
          <div class="col-lg-12 text-center mb-3">
            <h2 class="section-heading txtbottom"><?= __("Notre mission : impacter positivement le bien-être en entreprise !")?></h2>
          </div>
        </div>
        <div class="row">
          <div class="col-md-12">
            <span class="copyright text-center"><?= __("Copyright")?> &copy; TIMEBANKPRO.COM 2018-<?= date("Y"); ?></span>
            <span class="ml-5">
            <?php echo $this->Html->image('landingpage/linkedin.png',array('url'=>"https://www.linkedin.com/company/timebankpro/",'width'=>'32','class'=>'img-thumbnail'));?>
            </span>
          </div>
        </div>
      </div>
    </footer>

    <!-- Modal -->
    <div class="modal fade" id="MLegales" tabindex="-1" role="dialog" aria-labelledby="MLegalesLabel" aria-hidden="true">
      <div class="modal-dialog" role="document">
          <div class="modal-content">
          <div class="modal-header">
              <h5 class="modal-title" id="MLegalesLabel"><?= __("Mentions légales")?></h5>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
              </button>
          </div>
          <div class="modal-body">
              <ul class="mltxt">
                <li><?= __("Le site internet www.timebankpro.com est édité par la SAS Local4People, société par actions simplifiée au capital de 30.000 euros, immatriculée au RCS de Saint Brieuc sous le numéro 811 691 377 et dont le siège est situé Maison des Entreprises – Technopole Anticipa – 4 rue Ampère – 22300 Lannion – France.")?>
                <li><?= __("Directeur de la publication : Monsieur Philippe Bouillé")?>
                <li><?= __("Contact : e-mail : philippe.bouille@local4people.com")?>
                <li><?= __("Hébergeur du site internet : SAS OVH au capital de 10.069.020 euros dont le siège social est situé 2 rue Kellermann - 59100 Roubaix – France")?>
              </ul>
          </div>
          <div class="modal-footer">
              <button type="button" class="btn btn-secondary" data-dismiss="modal"><?= __("Fermer")?></button>
          </div>
          </div>
      </div>
    </div>

    <?php echo $this->element('landingpage/scripts_part'); ?>

  </body>

</html>
