<script type="text/ng-template" id="setTag">
    <h5><?= __("Utilisateur")?> : {{userTag.User.prenom}} {{userTag.User.nom}}</h5>
    <h6><?= __("Ville")?> : {{userTag.City.ville_nom_reel}}</h6>
    <!--Sélectionner le TAG :
    <select ng-model="selectedTag">
		  <option ng-repeat="curtag in allTags" value="{{curtag.value}}">{{curtag.name}}</option>
	  </select>-->
		<p><?= __("Reserve monnaie") ?> : <b>{{UserReserve}}</b></p>
		<p><?= __("Ajouter/retrancher un montant (positif /negatif)") ?> : <input placeholder="Montant" type="text" ng-model="userTag.monnaieaddremove"><p>
		<p><?= __("Message") ?> : <input type="text" placeholder='<?= __("Message pour memo")?>' ng-model="userTag.monnaiemessage"><p>
    <br><span class="btn btn-info" ng-click="validateTag(userTag,selectedTag,userIndex);"><?= __("Valider")?></span>
</script>


<?php echo $this->element('admin_card_header',array('title'=>__("Utilisateurs"),'subtitle'=>"")); ?>


<div class="row">
	<div class="col-md-12">
		<section class="panel">
			<header class="panel-heading">
				<?php echo $this->Html->link(__('Préparation Mail de relance'), array('action' => 'prepare_mail_relance')); ?> (<?= __("pour relancer les utilisateurs qui n'ont pas activé leur compte")?>)
			</header>
			<div class="panel-body">
				<div class="row">
					<div class="col-md-12">
						<h4><?= __("Voici les derniers inscrits")?> : </h4>
						<table class="table table-condensed">
							<tr>
								<th><?= __("Prenom/nom")?></th>
								<!--<th>Tag</th>-->
								<th><?= __("Date Membre")?></th>
								<th><?= __("Email")?></th>
								<th><?= __("Ville")?></th>
								<th><?= __("Pays")?></th>
								<!--<th>Role</th>-->
								<th><?= __("Activé")?></th>
								<th><?= __("Actions")?></th>
							</tr>
							<?php foreach ($last_users as $curinv) {
								$cid = $curinv['User']['id'];
								echo "<tr>";
								echo "<td>";echo $curinv['User']['prenom'].' '.$curinv['User']['nom'];
								if ($curinv['User']['vacation']==1) {
									echo '<span class="ml-2 badge badge-success">'.__("en vacances").'</span>';
								}
								//echo "<td>";echo $allTags[$curinv['User']['type']]['name'];
								echo "<td>";echo $curinv['User']['created'];
								echo "<td>";echo $curinv['User']['email'];
								echo "<td>";echo $curinv['City']['ville_nom_reel'];
								echo "<td>";echo $curinv['Country']['name'];
								echo "<td>";
								if ($curinv['User']['activated'] == true) {echo "oui";} else {echo "non";}
								//echo "<td>";echo $this->Html->link('Voir ses messages',array('controller'=>'wallmessages','action'=>'voirtmessagecompteessai',$cid));
								echo "<td>";echo $this->Html->link(__('Supprimer ce compte'),array('controller'=>'admins','action'=>'supprimercompte',$cid),array(),__("Vraiment supprimer ce compte et tous les messages/commentaires associés ?"));
								echo "</tr>";
							}
							?>
						</table>
					</div>
				</div>

				<div class="row">
					<div class="col-md-12">
					<?= __("Recherche (Prénom OU nom OU email)")?> <input type="text" ng-model="user2search">
						<span class="btn btn-xs btn-info" ng-click="rechercheUser()"><?= __("Rechercher")?></span>
					</div>
				</div>
				<div class="row" ng-show="displayRecherche">
					<div class="col-md-12">
						<!--<h3>Résultat de la recherche</h3><span class="badge badge-info hand">Clic sur un nom/prenom pour changer le TAG</span>-->
						<table class="table table-condensed">
							<tr>
								<th><?= __("Prenom/nom")?></th>
								<!--<th>Tag</th>-->
								<th><?= __("Date Membre")?></th>
								<th><?= __("Email")?></th>
								<th><?= __("Ville")?></th>
								<th><?= __("Role")?></th>
								<th><?= __("Activé")?></th>
							</tr>
							<tr ng-repeat="user in foundUsers">
								<td class="hand" ng-click="setUserTag(user,$index)">{{user.User.prenom}} {{user.User.nom}}
									<span ng-show="user.User.vacation" class="ml-2 badge badge-success"><?= __("mode vacances")?></span>
								</td>
								<!--<td>{{allTags[user.User.type].name}}</td>-->
								<td>{{user.User.created}}</td>
								<td>{{user.User.email}}</td>
								<td>{{user.City.ville_nom_reel}}</td>
								<td ng-if="user.User.role=='admin'"><img src="../img/admin2.png"></td>
								<td ng-if="user.User.role=='adminentreprise'">
									<img class="hand" src="../img/admin2.png" ng-click="toggle_administrator_entreprise($index);">
								</td>
								<td ng-if="user.User.role==undefined">
									<img class="hand" src="../img/utilisateur2.png" ng-click="toggle_administrator_entreprise($index);">
								</td>
								<td ng-if="user.User.activated==true"><?= __("oui")?></td>
								<td ng-if="user.User.activated==false"><?= __("non")?></td>
							</tr>
							<tr ng-if="foundUsers.length==0">
								<td colspan=6 class="">
									<h5 class="alert alert-danger"><?= __("Pas d'utilisateurs trouvés pour votre critère de recherche")?></h5>
								</td>
							</tr>
						</table>
					</div>
				</div>
			</div>
		</section>
	</div>
</div>

<div class="row">
	<div class="col-md-12">
		<?php echo $this->Html->link(__("Extraction de la liste de vos inscrits"),array('controller'=>'admins','action'=>'admin_extract_go'),array('class'=>'btn btn-info')); ?>
	</div>
</div>
<div class="row">
	<div class="col-md-6">
	<?= __("Un fichier .CSV sera envoyé dans l'espace de téléchargement de votre ordinateur")?>
	</div>
</div>


<div class="row" ng-init="loadStats()">
	<div class="col-md-12">
		<section class="panel">
			<header class="panel-heading">
				<h4><?= __("Nombre de membres par ville")?> : </h4>
			</header>
			<div class="panel-body">
				<div class="row">
					<div class="col-md-12">
				      <?= __("Total")?> : {{countTotal}}
					</div>
				</div>
				<div class="row">
					<div class="col-md-12">
						<ul>
							<li ng-repeat="curVille in Stats.stats_ville track by $index">{{curVille.city}} : {{curVille.nb}} - <a href="adminMembresVilles/{{curVille.city_id}}" class="btn btn-sm btn-default"><?= __("Liste des membres")?></a></li>
						</ul>
					</div>
				</div>
			</div>
		</section>
	</div>

	<div class="col-md-12">
		<section class="panel">
			<header class="panel-heading">
				<h4><?= __("Nombre de membres par pays")?> : </h4>
			</header>
			<div class="panel-body">
				<div class="row">
					<div class="col-md-12">
						<ul>
							<li ng-repeat="curCountry in Stats.userscountries track by $index">{{curCountry.Country.name}} : {{curCountry[0].nb_users}} <!--- <a href="adminMembresCountry/{{curCountry.City.id}}" class="btn btn-sm btn-default"><?= __("Liste des membres")?></a></li>-->
						</ul>
					</div>
				</div>
			</div>
		</section>
	</div>

</div>





<?php echo $this->element('admin_card_footer',array('footertxt'=>"")); ?>