<?php 
	$what = __("Création");$creation=true;
    if (isset($Challenge['name'])) {$what = __("Modification");$creation=false;}
	echo $this->element('admin_card_header',array('title'=> $what." ".__("d'un challenge"),'subtitle'=>""));
	if ($Challenge['rules_activated']) {
		$specificrules="true";
	} else {
		$specificrules="false";
	}
    //debug($Challenge);exit;
?>


<div class="row">
	<div class="col-md-12">
		<div class="card-header">
            <h5 class="card-title">
			<?php if (!$creation) { ?>
				<?php echo $this->Html->link(
						__("Editer les catégories de ce challenge"),
						'admin_challenge_categories/'.$Challenge['idx'],
						array('class' => '', 'target' => '')
					);
				?>
			</h5>
			<?php } ?>
        </div>
		<div class="card-body">
			<div class="row">
				<div class="col-md-8 col-sm-12">
				<?php echo $this->Form->create('Admin', array('url'=>'CreateEditChallenge','class' => 'form-horizontal','role'=>'role','type' => 'file')); ?>
					<div class="form-group">
						<label class="col-sm-4 control-label"><b><?= __("Nom du challenge")?></b></label>
						<?php 
							$valchall = "";
							if (isset($Challenge['name'])) $valchall = $Challenge['name'] ;
							echo $this->Form->input('name', array('class'=>'form-control','value'=>$valchall,'label' => false, 'required'=>true, 'placeholder' => __('Nom du challenge'))); ?>
						<?php if (isset($Challenge['id'])) echo $this->Form->hidden('challenge_idx', array('value'=>$Challenge['idx'])); ?>
						<?php echo $this->Form->hidden('creation_mode', array('value'=>$creation)); ?>

					</div>
					<div class="form-group">
                        <label class="col-sm-4 control-label"><b><?= __("Résumé du challenge");?></b></label>
						<?php 
						$valchall = "";
						if (isset($Challenge['description'])) $valchall = $Challenge['description'] ;
						echo $this->Form->textarea('description', array('value'=>$valchall,'class'=>'form-control tareamax','rows' => '3', 'cols' => '5','maxlength'=>'250','label' => false,'placeholder' => __("Résumé du challenge (Peut être laissé vide, 250 caractères maxi avec espaces)"))); ?>
                    </div>
				
					
					

					<div class="alert alert-info text-center">
						<b><?= __("Pour la vidéo, il faut le lien d'integration (pas le lien de votre navigateur), par exemple : https://www.youtube.com/embed/a4r6dWkcSJU")?></b>
					</div>
					
					<div class="form-group">
						<label for="contact-message"><b><?= __("Lien Vidéo")?></b></label>
						<?php $videochall = "";
						if (isset($Challenge['videolink'])) $videochall = $Challenge['videolink'] ;
						?>
						<?php echo $this->Form->input('videolink', array('value'=>$videochall,'class'=>'form-control', 'label' => false)); ?>						
					</div>

					<div class="row mt-4">
						<div class="col-md-12">
							<div class="alert alert-info text-center">
								<b><?= __("Pour éviter le redimensionnement des images, le format conseillé est (4:3), par exemple 800*600.")?><br><?= __("Les fichiers doivent être au format .JPG ou .PNG")?></b>
							</div>
						</div>
					</div>

					<?php if (!$creation) { ?>
					<div class="row">
						<div class="form-group row">
							<label class="col-sm-4 col-form-label"><b><?php echo __('Logo actuel')?></b></label>
							<div class="col-sm-8">
								<?php echo $this->Html->image('challenges/'.$Challenge['logo'],array('class'=>'card-img-top imgchallenge'));?>
							</div>
						</div>
					</div>
					<?php } ?>

					<div class="row">
						<div class="form-group row">
							<label class="col-sm-4 col-form-label"><b><?php echo __('Nouveau logo')?></b></label>
							<div class="col-sm-8">
								<?php echo $this->Form->input('image2upload_form', array('class'=>'alert','label' => false,'type' => 'file')); ?>
							</div>
						</div>
					</div>

					<?php if (!$creation) { ?>
					<div class="row">
						<div class="form-group row">
							<label class="col-sm-4 col-form-label"><b><?php echo __('Image actuelle')?></b></label>
							<div class="col-sm-8">
								<?php echo $this->Html->image('challenges/'.$Challenge['image'],array('class'=>'card-img-top imgchallenge'));?>
							</div>
						</div>
					</div>
					<?php } ?>

					<div class="row">
						<div class="form-group row">
							<label class="col-sm-4 col-form-label"><b><?php echo __('Nouvelle image')?></b></label>
							<div class="col-sm-8">
								<?php echo $this->Form->input('image2upload_image_form', array('class'=>'alert','label' => false,'type' => 'file')); ?>
							</div>
						</div>
					</div>

					<div class="form-group">
						<?= __("Affichage du challenge en page d'accueil et en onglet")?><br>
						<div class="row">						
							<div class="col-md-10">
								<label for="category-message" class="">
									<b><?= __("Souhaitez vous que ce challenge soit affiché en page d'accueil de votre plateforme et en onglet ?")?></b>
								</label>
							</div>
							<div class="col">
								<label class="switch">
									<?php echo $this->Form->checkbox('homepage', array('label' => false,'checked'=>$Challenge['homepage'])); ?>
									<span class="slider round"></span>
								</label>
							</div>
						</div>
					</div>

					<div class="form-group">
						<?= __("Activation du dépôt de projet")?><br>
						<div class="row">						
							<div class="col-md-10">
								<label for="category-message" class="">
									<b><?= __("Souhaitez vous que le dépôt de projet soit ouvert actuellement sur votre challenge ?")?></b>
								</label>
							</div>
							<div class="col">
								<label class="switch">
									<?php echo $this->Form->checkbox('hasprojects', array('label' => false,'checked'=>$Challenge['hasprojects'])); ?>
									<span class="slider round"></span>
								</label>
							</div>
						</div>
					</div>

					<div class="form-group">
						<?= __("Utilisation d'un règlement spécifique au challenge")?><br>
						<div class="row">						
							<div class="col-md-10">
								<label for="category-message" class="">
									<b><?= __("Souhaitez vous un règlement spécifique au challenge ?")?></b>
								</label>
							</div>
							<div class="col">
								<label class="switch" ng-init="specficirules=<?= $specificrules?>">
									<?php echo $this->Form->checkbox('rules_activated', array('label' => false,'ng-model'=>'specficirules','ng-checked'=>'specficirules==1')); ?>
									<span class="slider round"></span>
								</label>
							</div>
						</div>
					</div>
					
					<div class="form-group row" ng-show="specficirules">
						<label class="col-sm-4 col-form-label"><b><?php echo __('Fichier PDF du règlement du challenge')?></b></label>
						<div class="col-sm-8">
							<?php echo $this->Form->input('rules_pdf_form', array('class'=>'alert','label' => false,'type' => 'file')); ?>
						</div>
					</div>

					<div class="form-group row" ng-show="specficirules">
						<div class="col-sm-12">
							<?php if ($Challenge['rules_activated'] && $Challenge['rules_pdf']!='') { ?>
								<?php echo $this->Html->link(__("Revoir le fichier de règlement"),array('controller'=>'challenges','action'=>'downloadpdf',$Challenge['rules_pdf']),array('class'=>'')); ?>
							<?php } ?>
						</div>
					</div>

					<div class="form-group">
                        <label class="col-sm-4 control-label"><b><?= __("Texte personnalisé conditionnel à la création d'un projet");?></b></label>
						<?php 
						$valchall = "";
						if (isset($Challenge['participate_condition_text'])) $valchall = $Challenge['participate_condition_text'] ;
						echo $this->Form->textarea('participate_condition_text', array('value'=>$valchall,'class'=>'form-control tareamax','rows' => '3', 'cols' => '5','maxlength'=>'500','label' => false,'placeholder' => __("Texte personnalisé qui proposera une case à cocher à la création du projet"))); ?>
                    </div>
					<div class="form-group">
                        <label class="col-sm-4 control-label"><b><?= __("Texte affiché conditionné sur la page d'un projet");?></b></label>
						<?php 
						$valchall = "";
						if (isset($Challenge['participate_display_text'])) $valchall = $Challenge['participate_display_text'] ;
						echo $this->Form->textarea('participate_display_text', array('value'=>$valchall,'class'=>'form-control tareamax','rows' => '3', 'cols' => '5','maxlength'=>'500','label' => false,'placeholder' => __("Texte affiché conditionné sur la page d'un projet"))); ?>
                    </div>

					<hr>
					<div class="row">
						<div class="col-md-12">
							<?= __("Il ne vous reste plus qu'à créer les catégories de votre challenge, c'est à dire les domaines de projets concernés");?>
						</div>
					</div>					
					<div class="row ml-3">
						<div class="col-md-12">
							<button type="submit" class="btn btn-danger btn-sm"><?= __("Enregistrer")?></button>
						</div>
					</div>
				<?php echo $this->Form->end(); ?>
				</div>
            </div>
        </div>
    </div>
</div>