tbproApp.controller('AdminCtrl',function ($scope,$http,$filter,ngDialog) {

  //console.log("Admin ok");
  $scope.type_mail = "newsletter";

  //$scope.ShowPanelAllBassins = false;
  $scope.VilleOptions = {
    types: '(cities)',
    country: ['fr']
  }
  $http.get("getAllTags").success(function(response) {
      //console.log(response);
      $scope.allTags = response;
  });

  $scope.yearuser = new Date().getFullYear();
  $scope.getCounters = function() {
    $scope.chartoptions = {
        scales: {
            yAxes: [{
                display: true,
                ticks: {
                    //suggestedMin: 0,    // minimum will be 0, unless there is a lower value.
                    // OR //
                    beginAtZero: true   // minimum value will be 0.
                }
            }]
        }
    };


    $http.get("getCounters/"+$scope.yearuser).then(function(response) {
      $scope.allcounters = response.data;
      //console.log($scope.allcounters);
      $scope.od={
        'series':['Offres','Demandes'],
        'data': [$scope.allcounters.posts_O,$scope.allcounters.posts_D]
      }
    });
  }

  $scope.getClientData = function() {
    $http.get("getClientDataJson").then(function(response) {
      $scope.ClientDataJson = response.data;
      //console.log(response.data);
    });
  }

  $scope.setCreditDefaut = function() {
  	$http.get("setCreditDefaut/"+$scope.ClientDataJson.monnaie_default).then(function(response) {
  		ngDialog.open({
		    template: "<p>Valeur mise à jour</p>",
		    plain: true,
		    scope: $scope
		});
  	});
  }

  $scope.setValEuros = function() {
  	$http.get("setValEuros/"+$scope.ClientDataJson.monnaie_valeuros).then(function(response) {
  		ngDialog.open({
		    template: "<p>Valeur euros mise à jour</p>",
		    plain: true,
		    scope: $scope
		});
  	});
  }

  $scope.setMiniMonnaie = function() {
  	$http.get("setMinimumDefalut/"+$scope.ClientDataJson.monnaie_minimum).then(function(response) {
  		ngDialog.open({
		    template: "<p>Valeur mini mise à jour</p>",
		    plain: true,
		    scope: $scope
		});
  	});
  }

  $scope.setMonnaieName = function() {
  	$http.get("setMonnaieName/"+$scope.ClientDataJson.monnaie_name).then(function(response) {
  		ngDialog.open({
		    template: "<p>Nom monnaie mis à jour</p>",
		    plain: true,
		    scope: $scope
		});
  	});
  }

  $scope.setGameDefault = function(what,newvalue) {
  	$http.get("setGameDefault/"+what+"/"+newvalue).then(function(response) {
  		ngDialog.open({
		    template: "<p>Valeur mini mise à jour</p>",
		    plain: true,
		    scope: $scope
		});
  	});
  }
  

  function reloadCities(id_db) {
    $http.get("get_bassin_cities/"+id_db).then(function(response) {
    });
  }

  $scope.addVille = function(selected) {
    if (selected != undefined) {
      $scope.selectedVille = selected;
      //console.log(selected);
      //$("#MenuRechercheForm").submit();
      $http.get("checkAndAddCityBv/"+selected.originalObject.id+"/"+$scope.currentBassinIdDb).then(function(response) {
        reloadCities($scope.currentBassinIdDb);
      });
    }
  }
  $scope.search_keyword = "";
  $scope.loadLastPosts = function(pagenumber) {
    //console.log($scope.search_keyword)
    $http.get("load_last_posts"+"/"+pagenumber+"/"+$scope.search_keyword).then(function(response) {
      $scope.AllPosts = response.data.allposts;
      $scope.paginator = response.data.paginator;
      //console.log($scope.AllPosts);
    });    
  }

  $scope.loadLastMsgs = function(pagenumber) {
    $http.get("load_last_msgs"+"/"+pagenumber).then(function(response) {
      $scope.AllMsgs = response.data.allmsgs;
      $scope.paginator = response.data.paginator;
      //console.log($scope.AllMsgs);
    });
  }

  $scope.popupClose = function() {
  	ngDialog.close();
  }

  $scope.loadLastAvis = function() {
    $http.get("load_last_avis").then(function(response) {
      $scope.AllAvis = response.data;
      //console.log($scope.AllAvis);
    });
  }

  $scope.really_remove =function(post2remove,index2remove) {
  		console.log(post2remove);
  		$scope.AllPosts.splice(index2remove, 1);
  		$http.get("remove_post/"+post2remove).then(function(response) {
	      	ngDialog.close();
	  		ngDialog.open({
			    template: "<p>Message supprimé</p>",
			    plain: true,
			    scope: $scope
			});
	    });
  }

  $scope.removePost = function(post_id,titre,index) {
  	$scope.titre2remove = titre;
  	$scope.post_id = post_id;
  	$scope.index2remove = index;
  	ngDialog.open({
	    template: "<p>Vraiment supprimer ce post ? <br><b><i>{{titre2remove}}</i></b></p><span class='btn btn-info' ng-click='popupClose()'>Annuler</span><span class='btn btn-danger pull-right' ng-click='really_remove(post_id,index2remove)'>Supprimer</span>",
	    plain: true,
	    scope: $scope
	});
  }

  $scope.removeOnlyAvis = function(avis_id,index) {
  	$scope.avis_id = avis_id;
  	$scope.index2remove = index;
  	ngDialog.open({
        template: "<p>Vraiment supprimer cet avis ? <br><b></b></p><span class='btn btn-info' ng-click='popupClose()'>Annuler</span><span class='btn btn-danger pull-right' ng-click='really_remove_only_avis(avis_id,index2remove)'>Supprimer</span>",
        plain: true,
        scope: $scope
    });
  }

  $scope.really_remove_only_avis = function(avis_id,index2remove) {
  		$scope.AllAvis.splice(index2remove, 1);
  		$http.get("remove_avis/"+avis_id).then(function(response) {
	      	ngDialog.close();
          ngDialog.open({
            template: "<p>Avis supprimé</p>",
            plain: true,
            scope: $scope
        });
	    });
  }

  $scope.cancelAvis = function(index) {
    $scope.AllAvis[index].Transaction.message = $scope.PreviousAvis;
  	ngDialog.close();
  }

  $scope.editAvis = function(transaction,valindex) {
    $scope.CurrentTransaction = transaction;
    $scope.PreviousAvis = $scope.CurrentTransaction.message
    console.log($scope.CurrentTransaction);
    $scope.indexCurrentTransction = valindex;
    console.log($scope.indexCurrentTransction);
  	ngDialog.open({
        template: "editAvisId",
        className: 'ngdialog-theme-default custom-width-80',
        scope: $scope
    });
  }

  $scope.editAvisConfirm = function(index) {
    var theData = $.param({msg:$scope.AllAvis[index].Transaction.message,idx: $scope.AllAvis[index].Transaction.id});
    $http({
        method: 'POST',
        url: 'modify_avis',
        data: theData,
        headers: {'Content-Type': 'application/x-www-form-urlencoded'}
    });
    ngDialog.close();
}

  $scope.InitAdminNewsLetters = function() {
  		$http.get("get_countries").then(function(response) {
        	$scope.AllCountries = response.data;
        });        
  }

  $scope.checkValidFields_NOTUSED = function() {
  	if  ($scope.theMessage!=undefined &&
  		$scope.theMessageTitle!=undefined &&
  		$scope.theMessage!='' &&
  		$scope.theMessageTitle!='' &&
  		$scope.userVille!='' && $scope.userVille!=undefined) return true;
  	return false;
  }

  function popup_nl_ok() {
  	ngDialog.open({
	    template: "<p>Newsletter envoyée !</p>",
	    plain: true,
	    scope: $scope
	});
  }

  $scope.NewsLetterForVille_NOTUSED = function() {
  	console.log($scope.userVille);
  	//console.log($scope.theMessageTitle);
  	//console.log($scope.theMessage);
  	$http.defaults.headers.post['Content-Type'] = 'application/x-www-form-urlencoded; charset=UTF-8';
    return $http({url: "animationSendMessageVille",method: "POST",
		    data: $.param({city_name: $scope.userVille,messagetitle:$scope.theMessageTitle,message:$scope.theMessage})
		}).then(function(webreturn){
			$scope.userVille="";$scope.theMessageTitle="";$scope.theMessage="";
			popup_nl_ok();
          	return webreturn.data;
        });
  }

  $scope.NewsLetterForBassin_NOTUSED = function(bassin_id) {
  	//console.log(bassin_id);
  	$http.defaults.headers.post['Content-Type'] = 'application/x-www-form-urlencoded; charset=UTF-8';
    return $http({url: "animationSendMessageBassin",method: "POST",
		    data: $.param({bassin_id: bassin_id,messagetitle:$scope.theMessageTitle,message:$scope.theMessage})
		}).then(function(webreturn){
			$scope.theMessageTitle="";$scope.theMessage="";
			popup_nl_ok();
          	return webreturn.data;
        });
  }

  $scope.NewsLetterForDepartement_NOTUSED = function(userDepSel) {
  	$http.defaults.headers.post['Content-Type'] = 'application/x-www-form-urlencoded; charset=UTF-8';
    return $http({url: "animationSendMessageDepartement",method: "POST",
		    data: $.param({departement_code: userDepSel.originalObject.code,messagetitle:$scope.theMessageTitle,message:$scope.theMessage})
		}).then(function(webreturn){
			$scope.userDepSel="";$scope.theMessageTitle="";$scope.theMessage="";
			popup_nl_ok();
          	return webreturn.data;
        });
  }

  $scope.loadStats = function() {
  	$http.get("load_stats").then(function(response) {
  		$scope.FullStats = JSON.parse(JSON.stringify(response.data.jsonData));
  		$scope.Stats = JSON.parse(JSON.stringify(response.data.jsonData));
  		$scope.countTotal = response.data.jsonData.totalCount;
  		$scope.selectedDep = undefined;
    });
  }

  $scope.resetDep = function() {
  	$scope.selectedDep = undefined;
  }

  $scope.$watch('selectedDep', function() {
  	var VilleArray = [];
  	$scope.countTotal = 0;
  	if ($scope.selectedDep!=undefined) {
  		$scope.FullStats.stats_ville.forEach(function(curCity) {
	  		if (parseInt(curCity.dep)==parseInt($scope.selectedDep)) {
	  			VilleArray.push(curCity);
	  			$scope.countTotal += parseInt(curCity.nb);
	  		}
	  	});
	  	$scope.Stats.stats_ville = VilleArray;
  	} else {
  		if ($scope.FullStats!=undefined) {
  			$scope.Stats = JSON.parse(JSON.stringify($scope.FullStats));
  			$scope.countTotal = $scope.Stats.totalCount;
  		}

  	};
  });

  $scope.displayRecherche = false;
  $scope.rechercheUser = function() {
  	$scope.displayRecherche = true;
    $http.get("rechercheUser/"+$scope.user2search).success(function(response) {
		$scope.foundUsers = response;
	});
  }

  $scope.toggle_administrator_entreprise = function(index) {
  	var user_id = $scope.foundUsers[index].User.id;
  	$http.get("toggle_administrator_entreprise/"+user_id).success(function(response) {
		if (response=="null") {
			$scope.foundUsers[index].User.role = undefined;
		} else {
			$scope.foundUsers[index].User.role = "adminentreprise";
		}
	});
  }


  $scope.setUserTag = function(userdb,index) {
  	//console.log(userdb);
    $http.get("getMonnaieUser/"+userdb.User.id).success(function(response) {
      console.log(response);
      $scope.UserReserve = response;
    });
		$scope.userTag = userdb;
		$scope.selectedTag = userdb.User.type;
		$scope.userIndex = index; // pour rafraichissement live
	  	ngDialog.open({
		    template: 'setTag',
		    scope: $scope
		});
  }

  $scope.validateTag = function(userTag,selTag,userIndex) {
    //console.log(userTag);
    var user_id = userTag.User.id;
    var user_tag_value = selTag;
    $http.get("setUserTag/"+user_id+"/"+user_tag_value).success(function(response) {
      ngDialog.close();
      $scope.foundUsers[userIndex].User.type = selTag;
    });
    // Verification si ajout monnaie
    var valmonnaie = parseInt(userTag.monnaieaddremove);
    if (!isNaN(valmonnaie)) {
      console.log(valmonnaie);

      var xsrf = $.param({userid: user_id,valmonnaie:valmonnaie,message:userTag.monnaiemessage});
      $http({
          method: 'POST',
          url: "addTransaction",
          data: xsrf,
          headers: {'Content-Type': 'application/x-www-form-urlencoded'}
      })

      //$http.get("addTransaction/"+user_id+"/"+valmonnaie).success(function(response) {

      //});
    }
  }

  
  $scope.changePriority = function() {
    $http.get("setPriority/"+$scope.priority).success(function(response) {});
  }
  
  $scope.toggleActivated = function(what,value) {
    $http.get("toggleActivated/"+what+'/'+value).success(function(response) {});
  }

  $scope.toggleOrderDone = function(tid) {
    $http.get("toggleOrderDone/"+tid).success(function(response) {	});
  } 

  $scope.toggleField = function(field,vid) {
    $http.get("toggleField/"+field+"/"+vid).success(function(response) {	});
  } 

});
