<?php
/**
 * Application level Controller
 *
 * This file is application-wide controller file. You can put all
 * application-wide controller-related methods here.
 *
 * CakePHP(tm) : Rapid Development Framework (http://cakephp.org)
 * Copyright (c) Cake Software Foundation, Inc. (http://cakefoundation.org)
 *
 * Licensed under The MIT License
 * For full copyright and license information, please see the LICENSE.txt
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright     Copyright (c) Cake Software Foundation, Inc. (http://cakefoundation.org)
 * @link          http://cakephp.org CakePHP(tm) Project
 * @package       app.Controller
 * @since         CakePHP(tm) v 0.2.9
 * @license       http://www.opensource.org/licenses/mit-license.php MIT License
 */

App::uses('Controller', 'Controller');
App::uses('CakeEmail', 'Network/Email');
/**
 * Application Controller
 *
 * Add your application-wide methods in the class below, your controllers
 * will inherit them.
 *
 * @package        app.Controller
 * @link        http://book.cakephp.org/2.0/en/controllers.html#the-app-controller
 */
class AppController extends Controller
{

    public $components = array(
        'Flash', 'Session', 'Cookie', 'Paginator','RequestHandler',
        'Auth' => array(
            'loginRedirect' => array('controller' => 'pages', 'action' => 'display', 'accueil'),
            //'loginRedirect' => array('controller' => 'users', 'action' => 'index'),
            'logoutRedirect' => array('controller' => 'pages', 'action' => 'display', 'accueil'),
            'authError' => '',
            'authenticate' => array(
                'Form' => array(
                    'fields' => array('username' => 'email'),
                    //'passwordHasher' => 'Blowfish'
                    //'passwordHasher' => array(
                    //        'className' => 'Simple',
                    //        'hashType' => 'sha256'
                    //    )
                ),
            ),
            //'authorize' => array('Controller')
        ),
    );

	public function beforeRender() {
		parent::beforeRender();
		$this->is_mobile = false;
		if ($this->RequestHandler->isMobile()) {
			$this->is_mobile = true;
        }
        $this->set('is_mobile',$this->is_mobile);
	}

    public function h($text, $double = true, $charset = null)
    {
        if (is_string($text)) {
            //optimize for strings
        } elseif (is_array($text)) {
            $texts = array();
            foreach ($text as $k => $t) {
                $texts[$k] = $this->h($t, $double, $charset);
            }
            return $texts;
        } elseif (is_object($text)) {
            if (method_exists($text, '__toString')) {
                $text = (string) $text;
            } else {
                $text = '(object)' . get_class($text);
            }
        } elseif (is_bool($text)) {
            return $text;
        }

        static $defaultCharset = false;
        if ($defaultCharset === false) {
            $defaultCharset = Configure::read('App.encoding');
            if ($defaultCharset === null) {
                $defaultCharset = 'UTF-8';
            }
        }
        if (is_string($double)) {
            $charset = $double;
        }
        //return htmlspecialchars($text, ENT_QUOTES, ($charset) ? $charset : $defaultCharset, $double);
        return htmlspecialchars($text, ENT_NOQUOTES, 'UTF-8');
    }

    public function HV($thedata)
    {
        $tmp = $thedata;
        foreach ($tmp as $k => $v) {
            //$tmp[$k] = h($v);
            //debug($v);
            //debug(h($v));
            //debug($this->h($v));
            //$tmp[$k] = htmlentities($v, ENT_QUOTES, 'UTF-8');
            $tmp[$k] = $this->h($v);
        }
        return $tmp;
    }

    public function getClientData($field2get=null)
    {
        if ($field2get == null) return Configure::read('Common.client');
        return Configure::read('Common.client.'.$field2get);
    }


    function check_language_browser($langues) {
        
        // Langue accepted
        if (isset($_SERVER['HTTP_ACCEPT_LANGUAGE'])) {
            $languageaccept = explode(',',$_SERVER['HTTP_ACCEPT_LANGUAGE']);
            //debug($languageaccept);
            $langue_code_full = $languageaccept[0];
            $langue_code_separate = explode('-',$langue_code_full);
            // debug($langue_code_separate);
            $langue_code = $langue_code_separate[0];
            //debug($langue_code);
            //debug($langues);
            if (!isset($langues[$langue_code])) {
                $langue_code = 'fr';
            }
            //debug("Init langue : ".$langue_code);
            return($langue_code);
       } else {
            return('fr');
       }
    }
    

    public function beforeFilter()
    {
        $this->Cookie->time = 3600*24*30;

        if ($this->Cookie->check('Config.language')) {
            $curlang = $this->Cookie->read('Config.language');
            Configure::write('Config.language',$curlang);
        } else {
            $langue_code = $this->check_language_browser(Configure::read('Config.languages'));
            $curlang = $this->langues[$langue_code];
            //debug($langue_code);debug($curlang);exit;
            Configure::write('Config.language',$curlang);
        }
    
        if ($curlang=="") $curlang="fra";

        //$this->set('lng','Lang='.$curlang);
        $this->set('lang',$curlang);
        $this->lang = $curlang;
        foreach (Configure::read('Config.languages') as $curcode => $value) {
            if ($value==$curlang) {
                Configure::write('Config.lang_code',$curcode);
            }
        }

        $this->set('VideoYoutubeId',Configure::read('Common.VideoUrlId.'.$curlang));

        $this->AllCountriesList = $this->get_all_countries_as_list();
        $this->set('AllCountries', $this->AllCountriesList);

        $action = $this->request->params['action'];
        if ($action != "add_client") {
            //Configure::write('debug',2);
            // Get URL and check if it is a client
            $url = Router::fullbaseUrl();
            if (strstr($_SERVER['REQUEST_URI'],'phcompany')) {
                $url =  $_SERVER['REQUEST_URI']; // Env sur C9.io
            }
            if (strstr($_SERVER['REQUEST_URI'],'davcompany')) {
                $url =  $_SERVER['REQUEST_URI']; // Env sur C9.io
            }
            //debug($_SERVER['REQUEST_URI']);exit;
            //debug($_SERVER['REQUEST_URI']);
            //$subdomainarr = explode('/',$_SERVER['REQUEST_URI']);
            //$subdomain = $subdomainarr[1];
            //Configure::write('Common.subdomain',$subdomain);
            //debug(Configure::read('Common.ClientDefaults'));exit;
            $ClientDefaults = Configure::read('Common.ClientDefaults');//debug($ClientDefaults);
            $this->loadModel('Client');
            $allClients = $this->Client->find('all');
            $clientfound = false; //debug($url);exit;
            foreach ($allClients as $curClient) {
                $cldomain = $curClient['Client']['subdomain'];
                //debug($curClient);
                if (strstr($url, $cldomain)) {
                    $clientfound = true;
                    Configure::write('Common.topurl', 'https://' . $cldomain . '.timebankpro.com');
                    Configure::write('Common.client', $curClient['Client']);
                    Configure::write('Reseau', array(
                        'city_id' => 100000,
                        'user_id' => 0,
                        )
                    );
                    
                    // For requests
                    $this->CID = $curClient['Client']['id'];
                    $alllang = Configure::read('Config.languages.home');
                    $uniquestr = md5($curClient['Client']['id']);
                    // check defaults
                    //debug(Configure::read('Common.ClientfieldsToCheck'));
                    foreach (Configure::read('Common.ClientfieldsToCheck') as $value) {
                        //debug($value);
                        //debug(Configure::read('Common.client.'.$value));
                        //if (!empty(Configure::read('Common.client.'.$value))) {
                            $ClientDefaults[$value]=Configure::read('Common.client.'.$value);
                            $ClientDefaults[$value.'_fra']=Configure::read('Common.client.'.$value);
                            if (strstr($value,'pdf')) {
                                $filen = $value.'.'. $uniquestr . '.pdf';
                                $pdfpath = WWW_ROOT . DIRECTORY_SEPARATOR . 'files/'.$filen;
                                if(file_exists($pdfpath)) {
                                    $ClientDefaults[$value.'_fra'] = $filen;
                                }
                            }
                            // Scan lang files                            
                            foreach ($alllang as $key => $lgname) {
                                $lfield = "${value}_".$lgname;
                                //debug($lfield);
                                // for pdf files
                                if (strstr($lfield,'pdf')) {
                                    $filen = $lfield.'.'. $uniquestr . '.pdf';
                                    //$pdfpath = WWW_ROOT . DIRECTORY_SEPARATOR .$filen;
                                    $pdfpath = WWW_ROOT . DIRECTORY_SEPARATOR . 'files/'.$filen;
                                    //debug($pdfpath);
                                    if(!file_exists($pdfpath)) {
                                        // If not present take french one (with files dir mentionned)
                                        $filen = $ClientDefaults[$value];
                                    }
                                    $ClientDefaults[$lfield]=$filen;
                                } else {
                                    // For custom title, videos, etc..
                                    $filepath = APP."Clients/home_".$this->CID."_${value}.${lgname}.lang";
                                    if(file_exists($filepath)) {
                                        $tmp = file_get_contents($filepath);
                                        if (trim($tmp)!="") $ClientDefaults[$lfield]=$tmp;
                                    } else {
                                        //$ClientDefaults[$lfield]=$ClientDefaults[$value.'_fra'];
                                        $ClientDefaults[$lfield]="";
                                    }
                                }
                            }
                        /*} else {
                            if (isset($ClientDefaults[$value])) {
                                //debug($value);
                                foreach (Configure::read('Config.languages') as $key => $lgname) {
                                    if (is_string($lgname)) {
                                        $ClientDefaults[$value.'_'.$lgname]=$ClientDefaults[$value];
                                    }
                                }
                            }
                        }*/
                    }
                    //exit;
                    //debug("Client is ".$curClient['Client']['name']);
                }
            }
            $this->set('ClientDefaults', $ClientDefaults);
            $this->ClientDefaults = $ClientDefaults;
            //debug($ClientDefaults);exit;
            if (!$clientfound) {
                Configure::write('Common.topurl', 'https://www.timebankpro.com');
                if ((!strstr($url, "files")) && (!strstr($url, "tbprodev"))) {
                    // redirect to demo website
                    //$this->redirect("https://demo.timebankpro.com");
                    //$this->redirect(array('controller'=>'pages','action'=>'landingpage'));
                    $this->layout = "landing_page";
                }
            } else {
                        
                //$this->disableCache();
                //debug($this->Auth);exit;
                // Definition User info pour chaque controller
                $this->set('Userinfo', $this->isConnected());
                $this->Userinfo = $this->isConnected();
                $this->set('ClientData',$this->getClientData());
                //Configure::write('debug', 2 );
                //debug($this->Userinfo);
                if ($this->Userinfo) {
                    // Verification is message non lue dans msg privée
                    $nbmsgnotread = "";
                    $messagerie_activated = $this->getClientData('messagerie_activated');
                    if ($messagerie_activated) {
                        $this->loadModel('Pm');
                        $nbnotread = $this->Pm->findAllByIdDestinataireAndLu($this->Userinfo['id'], 0);
                        if (count($nbnotread) > 0) {
                            $nbnotreadval = count($nbnotread);
                            $nbmsgnotread = "&nbsp;<span class='badge alert-danger'>$nbnotreadval</span>";
                        }
                    }
                    $this->set('nbmsgnotread', $nbmsgnotread);

                }
                $this->infosloc = $this->getCurrentlocation();
                $this->set('current_location', $this->infosloc);


                //$this->session = $this->Session->read('choixUser');//exit;
            }
        }
        
    }

    public function isAuthorized($user)
    {
        // Admin peut accéder à toute action
        if (isset($user['role']) && (($user['role'] === 'admin') || ($user['role'] === 'adminentreprise'))) {
            return true;
        }
        // Refus par défaut
        return false;
    }

    public function isConnected()
    {
        $cookie = $this->Cookie->read('Usersession');
        //debug($this->Auth->user());
        //debug($cookie);
        if (!is_null($cookie)) {
            //debug($cookie);
            //debug($this->Auth->user());//exit;
            if ($this->Auth->login($cookie)) {
                $this->loadModel('User');
                $this->User->contain('City','City.Country');
                $userarray = $this->User->findByEmail($this->Auth->user('email'),array('*'));
                //debug($this->Auth->user());exit;
                //debug($userarray);debug($cookie);exit;
                $thearray = $userarray['User'];
                $thearray['City'] = $userarray['City'];
                //debug($this->Auth->user());
                //debug($thearray);exit;

                return $thearray;
            } else { // Delete invalid Cookie
                $this->Cookie->delete('Usersession');
                $this->Cookie->delete('Auth');
                return false;
            }
        } else {
            //debug($this->Auth->user());
            if ($this->Auth->user()) {
                if ($this->Auth->login($this->Auth->user())) {
                    //debug("login ok");exit;
                    // To load last update in user info
                    $this->loadModel('User');
                    $this->User->contain('City');
                    //debug($this->Auth->user());
                    if ($this->Auth->user('email') === null) {
                        $this->Session->delete('User');
                        $this->Cookie->delete('Auth.User');
                        unset($_COOKIE['Auth.User']);
                        $cookie = $this->Cookie->read('Auth.User');
                        $this->Cookie->delete('Auth');
                        $this->Session->delete('Auth');
                        $this->Auth->logout();
                        $this->redirect(array('controller' => 'pages', 'action' => 'display', 'accueil'));
                    }
                    $userarray = $this->User->findByEmail($this->Auth->user('email'),array('*'));
                    if ($userarray) {
                        $thearray = $userarray['User'];
                        $thearray['City'] = $userarray['City'];
                        //debug($this->Auth->user());
                        //debug($thearray);exit;

                        return $thearray;
                    } else {
                        $this->Cookie->delete('Auth');
                        $this->Session->delete('Auth');
                        $this->Auth->logout();
                        $this->redirect(array('controller' => 'pages', 'action' => 'display', 'accueil'));
                    }

                }
            }
        }
    }

    public function verif_admin()
    {
        if ($this->Userinfo['role'] == 'admin') {return true;}
        if ($this->Userinfo['role'] == 'adminentreprise') {return true;}
        $this->redirect(array('controller' => 'pages', 'action' => 'display', 'accueil'));
    }

    public function isCorrectWords($text)
    {
        $bad = Configure::read('badWords');
        //debug($bad_words);
        //$bad = explode(" | ",$bad_words);
        //debug($bad);
        $b = '/\b' . implode('[sx]*\b|\b', $bad) . '\b[sx]*/i';
        //debug($b);
        //debug(preg_match($b, $text));
        if (preg_match($b, $text)) {
            //debug($text);
            //echo $text ." - Contain Bad words!";
            // - other function here
            return false;
        } else {
            //echo $text ." - Not containing bad words :D";
            # - other function here
            //debug("OK $text");
            return true;
        }

    }

    public function fixIncorrectword($text)
    {
        $bad = Configure::read('badWords');
        $b = '/\b' . implode('[sx]*\b|\b', $bad) . '\b[sx]*/i';
        //debug($b);
        //debug(preg_replace($b,"****",$text));
        return preg_replace($b, "****", $text);
    }

    public function setUserCookieRecherche()
    {
        //$this->Session->delete('rechercheFromUser'); // Clear previous search
        if ($this->data) {
            //debug($this->data);
            // recherche des data
            $sess_data = $this->Cookie->read('choixUser');
            //debug($sess_data);
            if ($sess_data != null) {
                $result = $sess_data;
                //debug($result);
                //$result = array_uintersect($sess_data, $this->data);
                // parse all keys

                foreach ($this->data as $curkey => $curdata) {
                    //debug($curkey);
                    //debug($curdata);
                    if (is_array($curdata)) {
                        foreach ($curdata as $key => $value) {
                            if ($value != '') {
                                $result[$curkey][$key] = $value;
                                if ($key == 'ville') {
                                    // clear Departement and Bassin
                                    $result['Pages']['departement_id'] = '';
                                    $result['Pages']['departement_code'] = '';
                                    $result['Pages']['departement'] = '';
                                    $result['Pages']['bassinvie'] = '';
                                    $result['Pages']['bassinvie_id'] = '';
                                }
                                if ($key == 'departement_id') {
                                    // clear Departement and Bassin
                                    $result['Pages']['ville_id'] = '';
                                    $result['Pages']['ville'] = '';
                                    $result['Pages']['villeReseau'] = '';
                                    $result['Pages']['bassinvie'] = '';
                                    $result['Pages']['bassinvie_id'] = '';
                                }
                                if ($key == 'bassinvie') {
                                    // clear Departement and Bassin
                                    $result['Pages']['departement_id'] = '';
                                    $result['Pages']['departement_code'] = '';
                                    $result['Pages']['departement'] = '';
                                    $result['Pages']['ville_id'] = '';
                                    $result['Pages']['ville'] = '';
                                }
                            }
                        }
                    } else {
                        //if ($value!='') $result[$curkey][$key] = $value;
                    }
                }
                //debug($result);
            } else {
                $result = $this->data;
            }
            if (isset($this->data['recherche_user'])) {
                $result['recherche_user'] = $this->data['recherche_user'];
            }
            if (isset($this->data['User']['recherche'])) {
                $result['recherche_user'] = $this->data['User']['recherche'];
            }
            if (isset($this->data['Pages']['category_id'])) {
                $result['Pages']['category_id'] = $this->data['Pages']['category_id'];
            }
            if (isset($this->data['Pages']['country_id'])) {
                $result['Pages']['country_id'] = $this->data['Pages']['country_id'];
            }
            //debug($result);
            // Sauver en session
            $this->Cookie->write('choixUser', $result);
        }
    }

    public function clearUserCityLocation()
    {
        $this->Cookie->delete('choixUser');
    }

    public function get_users_conditions()
    {
        // Recupérer le choix user : ville, departement, bassin de vie
        $infoskeep = $this->Cookie->read('choixUser');
        //debug($infoskeep);exit;
        if (!isset($infoskeep['Pages'])) {
            return null;
        }
        $infos = $infoskeep['Pages'];
        //debug($infos);exit;
        if (isset($infos['ville_id']) && $infos['ville_id'] != '') {
            // Récupération des users de cette ville
            $this->loadModel('User');
            $allusers = $this->User->find('list', array(
                'conditions' => array('city_id' => $infos['ville_id']),
            ));
            $conditions = array('User.id' => $allusers);
        } else {
            $conditions = null;
        }
        if (isset($infos['country_id']) && $infos['country_id'] != '') {
            // Récupération des users de ce pays
            $conditions['City.country_id'] = $infos['country_id'];            
        }
        // Cas de recherche de nom dans le répertoire
        if (isset($infoskeep['User'])) {
            if (isset($infoskeep['User']['recherche'])) {
                $cr = $infoskeep['User']['recherche'];
                // Recherche non vide
                $condrecherche = array(
                    'OR' => array(
                        'User.nom LIKE' => "%$cr%",
                        'User.prenom LIKE' => "%$cr%",
                    ),
                );
                $newcondition = array(
                    'AND' => array(
                        $conditions,
                        $condrecherche,

                    ),
                );
                $conditions = $newcondition;
            }
        }
        //debug($newcondition);
        //debug($conditions);
        //exit;

        return $conditions;
    }

    public function get_conditions_city_reseau()
    {
        $infos = $this->Cookie->read('choixUser');
        if (!isset($infos['Pages'])) {
            return null;
        }
        $infos = $infos['Pages']; //debug($infos);exit;
        if (isset($infos['ville_id']) && $infos['ville_id'] != '') {
            $conditions = array('all_cities' => $infos['ville_id']);
        } else {
            $conditions = null;
        }
        return $conditions;

    }

    public function get_conditions($table = null)
    {
        // Recupérer le choix user : ville, departement, bassin de vie
        $infos = $this->Cookie->read('choixUser');
        //debug($infos);
        if (!isset($infos['Pages'])) {
            return null;
        }
        $infos = $infos['Pages']; //debug($infos);
        if (isset($infos['ville_id']) && $infos['ville_id'] != '') {
            // Récupération des users de cette ville
            $this->loadModel('User');
            $allusers = $this->User->find('list', array(
                'conditions' => array('User.city_id' => $infos['ville_id']),
            ));
            $conditions = array('user_id' => $allusers);
        }  else {
            $conditions = null;
        }
        //debug($conditions);exit;
        return $conditions;
    }

    public function loadPostsUser($user_id, $post_type = null, $nodisplaymessage = null, $nb = 8)
    {
        $this->loadModel('Post');
        $conditions = array('Post.user_id' => $user_id);
        if ($post_type != null) {
            $conditions = array('Post.user_id' => $user_id, 'Post.type' => $post_type);
        }
        $posts_paginate = array(
            'limit' => $nb,
            'conditions' => $conditions,
            'contain' => array(
                'Category' => array('fields' => array('name', 'image')),
                'User' => array('fields' => array('id', 'nom', 'prenom', 'photo', 'city_id', 'type')),
                'User.TransactionDebit' => array(
                    'fields' => array('Sum(amount) as amount_debit'),
                ),
                'Transaction.User' => array(),
                'Transaction.Post' => array(),
                'City' => array('fields' => array('ville_nom_reel', 'id')),
            ),
            'joins' => array(
				array(
					'table' => 'cities',
					'alias' => 'CityJoin',
					'type' => 'INNER',
					'conditions' => array(
						'CityJoin.id = User.city_id'
					)
				)
			),
            'order' => array('Post.id' => 'DESC'),
            'fields' => array('Post.*','CityJoin.ville_nom_reel'),
        );
        //debug($posts_paginate);
        $this->Paginator->settings = $posts_paginate;
        $all_posts = $this->Paginator->paginate('Post');
        //debug($all_posts);exit;
        if (empty($all_posts) and ($nodisplaymessage == null)) {
            $this->Session->setFlash(__("Pas de messages trouvés pour votre critère de recherche"), 'msg_alert');
        }

        return $all_posts;
    }

    public function set_post_pages_variables($cfg, $flagbis = null)
    {

        $this->set('titre_section', $cfg['title_for_layout']);

        $this->set('title_for_layout', $cfg['title_for_layout']);
        $this->set('section_titre_bouton_ecrire', $cfg['section_titre_bouton_ecrire']);
        $this->set('section_controller', $cfg['section_controller']);
        $this->set('section_action', $cfg['section_action']);

        $this->set('section_titre_bouton_recherche', $cfg['section_titre_bouton_recherche']);
        $this->set('section_controller_recherche', $cfg['section_controller_recherche']);
        $this->set('section_action_recherche', $cfg['section_action_recherche']);

        $this->set('section_titre_bouton_abonnement', $cfg['section_titre_bouton_abonnement']);
        $this->set('section_titre_bouton_desabonnement', $cfg['section_titre_bouton_desabonnement']);
        $this->set('section_controller_abonnement', $cfg['section_controller_abonnement']);
        if ($flagbis == null) {
            $this->set('controller2load_bis', 'posts');
        }
    }

    //public function getPosts($type, $limit = 5, $catid = '', $recherche_user = null)
    public function getPosts($type, $limit = 5, $datasearch=null)
    {
        //debug($datasearch);
        $catid = null;
        if (isset($datasearch['cat_id'])) {
            $catid = $datasearch['cat_id'];
        }
        if (isset($datasearch['Pages']['category_id'])) {
            $catid = $datasearch['Pages']['category_id'];
        }
        $recherche_user = null;
        if (isset($datasearch['recherche_user'])) {
            $recherche_user = $datasearch['recherche_user'];
        }
        $countryid = null;
        if (isset($datasearch['Pages']['country_id'])) {
            $countryid = $datasearch['Pages']['country_id'];
        }

        $this->loadModel('Post');
        $cnt_posts = 0;
        //debug($type);exit;
        //debug($catid);
        // --------------------------------------------
        // Selection par ville/ Bassin de vie etc..
        // --------------------------------------------
        if ($type != 'all') {
            $conditions = $this->get_conditions('Post');
            $condition_reseau = $this->get_conditions_city_reseau();
            //debug($condition_reseau);exit;
            $condrecherche = array();
            if ($recherche_user != null) {
                $condrecherche = array(
                    'titre LIKE' => "%$recherche_user%",
                    'message LIKE' => "%$recherche_user%",
                );
            }
            if ($conditions != null) {
                $curuser_id = 0; // for like search
                if (isset($this->Userinfo['id'])) {
                    $curuser_id = $this->Userinfo['id'];
                }

                $newconditions = array(
                    'OR' => array(
                        array('Post.city_id' => Configure::read('Reseau.city_id')),
                        array(
                            'AND' => array(
                                'Post.user_id' => Configure::read('Reseau.user_id'),
                                'Post.city_id' => $condition_reseau['all_cities'],
                            ),
                        ),
                        $conditions,
                    ),
                );
                // Ne pas changer de place
                if ($recherche_user != null) {
                    $newconditions = array(
                        'AND' => array(
                            $newconditions,
                            'OR' => $condrecherche,
                        ),
                    );
                }
                //debug($category_recherche_id);//exit;
                $newconditions['Post.type'] = $type;                
                if ($catid != '') {
                    $newconditions['Category.id'] = $catid;
                }
                // Do not display user post in vacation
                $newconditions['User.vacation']=0;
                $newconditions['Post.paused']=false;
                if ($countryid!=null) {
                    $newconditions['City.country_id'] = $countryid;
                }
                //$newconditions['Post.cnt_flag <'] = Configure::read('Common.max_moderate_flags');
                //debug($newconditions);
                $posts_paginate = array(
                    'conditions' => array($newconditions),
                    'limit' => $limit,
                    'order' => array('Post.id DESC'),
                    'fields' => array(
                        'City.country_id','User.id', 'User.nom', 'User.prenom', 'CityJoin.ville_nom_reel','City.ville_nom_reel', 'Post.titre', 'Post.type', 'Post.created', 'Post.monnaievalue', 'Post.message', 'Post.image','Post.paused', 'Category.name', 'Category.id', 'Category.image',
                    ),
					'joins' => array(
						array(
							'table' => 'cities',
							'alias' => 'CityJoin',
							'type' => 'INNER',
							'conditions' => array(
								'CityJoin.id = User.city_id'
							)
						)
					)
                );
                //debug($posts_paginate);
                $this->Paginator->settings = $posts_paginate;
                $all_posts = $this->Paginator->paginate('Post');
                //debug($all_posts);exit;
                // Check number of posts
                $post_req = array('conditions' => array($newconditions));
                $cnt_posts = $this->Post->find('count', $post_req);
            } else {
                // Rien trouvé, donc pas de sélection utilisateur dans le menu de recherche
                // donc on affiche ce qui est demandé
                //debug($conditions);
                $conditions = array(
                    'Post.type' => $type,
                );
                if ($catid != null) {
                    $conditions = array(
                        'Post.type' => $type,
                        'Post.category_id' => $catid,
                    );
                }
                if ($recherche_user != null) {
                    $conditions['OR'] = $condrecherche;
                }
                // Do not display user post in vacation
                $conditions['User.vacation']=0;
                $conditions['Post.paused']=false;
                if ($countryid!=null) {
                    $conditions['City.country_id'] = $countryid;
                }
                //debug($conditions);
                //debug($conditions);exit;
                $posts_paginate = array(
                    'conditions' => $conditions,
                    'limit' => $limit,
                    'order' => array('Post.id' => 'desc'),
                    'fields' => array(
                        'City.country_id','User.id', 'User.nom', 'User.prenom', 'CityJoin.ville_nom_reel','City.ville_nom_reel', 'Post.titre', 'Post.created', 'Post.monnaievalue', 'Post.message', 'Post.image','Post.paused', 'Category.id', 'Category.name', 'Category.image',
                    ),
					'joins' => array(
						array(
							'table' => 'cities',
							'alias' => 'CityJoin',
							'type' => 'INNER',
							'conditions' => array(
								'CityJoin.id = User.city_id'
							)
                        )

					)
                );
                //debug($posts_paginate);
                $this->Paginator->settings = $posts_paginate;
                $all_posts = $this->Paginator->paginate('Post');
                //debug($all_posts);exit;
                $post_req = array('conditions' => array($conditions));
                $cnt_posts = $this->Post->find('count', $post_req);
            }
        } else {
            // Affichage dans la page d'accueil (scrolling des annonces melangées
            $conditions = array(
                'category_id != ' => null,
                'Post.titre NOT IN' => Configure::read('badWords'),
                'User.vacation' => 0,
                'Post.paused' => false
            );            
            $this->Post->contain('User', 'City', 'Category', 'Transaction');
            $all_posts = $this->Post->find('all', array(
                'conditions' => $conditions,
                'limit' => $limit,
                'order' => array('Post.id DESC'),
                'fields' => array(
                    'User.id', 'User.nom', 'User.prenom','CityJoin.ville_nom_reel', 'City.ville_nom_reel', 'Post.titre', 'Post.created', 'Post.monnaievalue', 'Post.message','Post.paused', 'Category.id', 'Category.image',
                ),
				'joins' => array(
					array(
						'table' => 'cities',
						'alias' => 'CityJoin',
						'type' => 'INNER',
						'conditions' => array(
							'CityJoin.id = User.city_id'
						)
					)
				)

            ));
            //debug($all_posts);exit;
            //$post_req = array('conditions' => array($newconditions)));
            //$cnt_posts = $this->Post->find('count',$post_req);

        }

        //debug($catid);
        //debug($conditions);
        $inc = 0;
        foreach ($all_posts as $curmsg) {
            if (!$this->isCorrectWords($curmsg['Post']['titre'])) {
                //unset($all_posts[$inc]);
                $all_posts[$inc]['Post']['titre'] = $this->fixIncorrectword($curmsg['Post']['titre']);
            }
            if (!$this->isCorrectWords($curmsg['Post']['message'])) {
                //unset($all_posts[$inc]);
                $all_posts[$inc]['Post']['message'] = $this->fixIncorrectword($curmsg['Post']['message']);
            }
            $inc++;
        }
        return array('all_posts' => $all_posts, 'count' => $cnt_posts);
    }

    public function loadPosts($rechercheuser = null, $category_recherche_id = null, $post_type = null)
    {
        $this->loadModel('Post');
        // Get the conditions for the search
        $conditions = $this->get_conditions('Post');
        $condition_reseau = $this->get_conditions_city_reseau();
        if (!$condition_reseau) {
            //$condition_reseau['all_cities']=0;
        }
        //debug($condition_reseau);
        //debug($conditions);exit;
        //debug($category_recherche_id);
        if ($conditions != null) {
            $curuser_id = 0; // for like search
            if (isset($this->Userinfo['id'])) {
                $curuser_id = $this->Userinfo['id'];
            }
            $newconditions = array(
                'OR' => array(
                    array('Post.city_id' => Configure::read('Reseau.city_id')),
                    array(
                        'AND' => array(
                            'Post.user_id' => Configure::read('Reseau.user_id'),
                            'Post.city_id' => $condition_reseau['all_cities'],
                        ),
                    ),
                    $conditions,
                ),
            );
            $newconditions['Post.cnt_flag <'] = Configure::read('Common.max_moderate_flags');
            if ($rechercheuser != null) {
                $newconditions['OR'] = array(
                    'titre LIKE' => "%$rechercheuser%",
                    'message LIKE' => "%$rechercheuser%",
                );
                if ($category_recherche_id != '') {
                    $newconditions['Category.id'] = $category_recherche_id;
                }
            }
            if (trim($rechercheuser) == "" and ($category_recherche_id != "")) {
                $newconditions['Category.id'] = $category_recherche_id;
            }
            if ($post_type != null) {
                $newconditions['Post.type'] = $post_type;
            }
            //debug($conditions);exit;
            //debug($newconditions);
            //$conditions_moderate = array('Moderate.city_id'=>$conditions['Post.city_id']);
            //debug($conditions_moderate);
            $posts_paginate = array(
                'limit' => 8,
                'conditions' => $newconditions,
                'contain' => array(
                    'Category' => array('fields' => array('name')),
                    'User' => array('fields' => array('id', 'nom', 'prenom', 'photo', 'city_id', 'type')),
                    'User.TransactionDebit' => array(
                        'fields' => array('Sum(amount) as amount_debit'),
                    ),
                    'User.TransactionCredit' => array(
                        'fields' => array('Sum(amount) as amount_credit'),
                    ),
                    'Comment.User' => array('fields' => array('User.id', 'User.nom', 'User.prenom', 'User.photo', 'User.type')),
                    'Comment.City' => array('fields' => array('ville_nom_reel')),
                    'Comment' => array('conditions' => array('Comment.cnt_flag <' => Configure::read('Common.max_moderate_flags'))),
                    'City' => array('fields' => array('ville_nom_reel')),
                    'City.Follow' => array(
                        'conditions' => array(
                            'user_id' => $curuser_id, // Si non vide => Le user est abonné
                        ),
                    ),
                    'Like' => array( // non vide si like déjà fait par le user.
                        'conditions' => array('user_id' => $curuser_id),
                        'fields' => array('id', 'user_id', 'post_id', 'comment_id'),
                    ),
                ),
                'order' => array('Post.id' => 'DESC'),
            );
            //debug($posts_paginate);
            $this->Paginator->settings = $posts_paginate;
            $all_posts = $this->Paginator->paginate('Post');
            //debug($all_posts);exit;
            if (empty($all_posts)) {
                $this->Session->setFlash(__("Pas de messages trouvés pour votre critère de recherche"), 'msg_alert');
            }
            //debug($all_posts);exit;
            return $all_posts;
        } else {
            $this->Session->setFlash(__("Pas de messages trouvés pour votre critère de recherche"), 'msg_alert');
            $this->redirect(array('controller' => 'pages', 'action' => 'display2'));
        }
    }

    public function getCurrentlocation()
    {
        $infos = $this->Cookie->read('choixUser');
        if (isset($infos['Pages'])) {
            $infos = $infos['Pages'];
            if (isset($infos['country_id']) and $infos['country_id']) {
                return $this->AllCountriesList[$infos['country_id']];
            }
            if (isset($infos['ville']) and $infos['ville']) {return $infos['ville'];}
            if (isset($infos['departement']) and $infos['departement']) {return $infos['departement'];}
            if (isset($infos['bassinvie']) and $infos['bassinvie']) {return $infos['bassinvie'];}
            // Si on arrive ici, la session est perdue
        }
        return false;
    }
    public function getCurrentCategory($what = null)
    {
        $infos = $this->Cookie->read('choixUser');
        //debug($infos);exit;
        if (!isset($infos['Pages'])) {return "";}
        $infos = $infos['Pages'];
        if (isset($infos['category_id']) and $infos['category_id'] == '') {return "";}
        if (isset($infos['category_id']) and $infos['category_id'] == 9999) {return "";}
        if (isset($infos['category_id']) and $infos['category_id'] != '') {
            $this->loadModel('Category');
            $rt = $this->Category->findById($infos['category_id'], array('name', 'id'));
            if ($what != null) {return $rt['Category'][$what];}
            return $rt['Category']['name'];
        }
        // Si on arrive ici, la session est perdue
        return false;
    }

    public function get_all_categories_as_list()
    {
        $this->loadModel('Category');
        $allcats = $this->Category->find('all', array(
            'conditions' => array(),
            'order' => array('Category.name'),
            'fields' => array('Category.id', 'Category.name'),
        ));
        $arrcat = array();
        foreach ($allcats as $curcat) {
            $arrcat[$curcat['Category']['id']] = $curcat['Category']['name'];
        }
        return $arrcat;
    }
    public function get_all_countries_as_list()
    {
        $this->loadModel('Country');
        $allcats = $this->Country->find('all', array(
            'conditions' => array(),
            'order' => array('Country.name'),
            'fields' => array('Country.id', 'Country.name'),
        ));
        $arrcat = array();
        foreach ($allcats as $curcat) {
            $arrcat[$curcat['Country']['id']] = __($curcat['Country']['name']);
        }
        return $arrcat;
    }
    

    public function send_global_email($sujet, $message, $userArray = null, $template = null, $layout = null)
    {

        if (strstr($_SERVER['SERVER_ADDR'], "172.17.0")) {
            return true;
        }
        // for local development, do not send mail
        //debug($message);debug($sujet);debug($layout);exit;
        //Configure::write('debug', 02);
        $destinataire = $userArray['email'];
        //$destinataire = "dguillerm@gmail.com";
        //debug($userArray);
        //debug($message);debug($sujet);
        //debug($destinataire);exit;
        if (trim($sujet) != "") {
            $Email = new CakeEmail();
            $Email->from(array('contact@' . Configure::read('Common.sitename') => Configure::read('Common.sitename')));
            if ($destinataire == null) {
                $Email->to(Configure::read('Admin.emails'));
            } else {
                $Email->to($destinataire);
            }
            $Email->emailFormat('html');
            $Email->subject($sujet);
            $the_layout = 'vdmv_header';
            if ($layout != null) {$the_layout = $layout;}
            if ($template == null) {
                $Email->template('general_email', $the_layout);
            } else {
                $Email->template($template, $the_layout);
            }
            //debug($userArray);
            if (!isset($userArray['prenom'])) $userArray['prenom'] ="";
            $Email->viewVars(array('message' => $message, 'prenom' => $userArray['prenom']));
            //debug($Email);exit;
            //debug("Envoi à $destinataire");
            $Email->send(); //exit;
        }
    }


    public function getUserReserveMonnaie($user_id)
    {
        $ret = $this->User->find('first', array(
            'conditions' => array('id' => $user_id),
            'contain' => array(
                'TransactionDebit' => array(
                    'fields' => array('Sum(amount) as amount_debit'),
                ),
                'TransactionCredit' => array(
                    'fields' => array('Sum(amount) as amount_credit'),
                ),
            ),
        ));
        $credit = 0;
        $debit = 0;
        if (!empty($ret['TransactionCredit'])) {
            foreach ($ret['TransactionCredit'] as $curcredit) {$credit += $curcredit['TransactionCredit'][0]['amount_credit'];}
        }
        if (!empty($ret['TransactionDebit'])) {
            foreach ($ret['TransactionDebit'] as $curdebit) {$debit += $curdebit['TransactionDebit'][0]['amount_debit'];}
        }
        $reserve = $credit - $debit + $ret['User']['monnaiestart'];
        return $reserve;
    }

    public function nicetime($date)
    {
        if (empty($date)) {
            return "No date provided";
        }
        $periods = array("seconde", "minute", "heure", "jour", "semaine", "mois", "année", "decennie");
        $lengths = array("60", "60", "24", "7", "4.35", "12", "10");
        $now = time();
        $unix_date = strtotime($date);

        // check validity of date
        if (empty($unix_date)) {
            return "Bad date";
        }

        // is it future date or past date
        if ($now > $unix_date) {
            $difference = $now - $unix_date;
            $tense = "ago";

        } else {
            $difference = $unix_date - $now;
            $tense = "from now";
        }

        for ($j = 0; $difference >= $lengths[$j] && $j < count($lengths) - 1; $j++) {
            $difference /= $lengths[$j];
        }

        $difference = round($difference);

        if ($difference != 1) {
            if ($periods[$j] != "mois") {$periods[$j] .= "s";}
        }

        return __("il y a")." $difference $periods[$j]";
    }
    public function getUserMonnaieTransaction() {
        $this->loadModel('Transaction');
        $uid = $this->Userinfo['id'];
        $tr = $this->Transaction->find('all', array(
            'conditions' => array(
                'OR' => array(
                    array('Transaction.user_id' => $uid),
                    array('Transaction.to_userid' => $uid),
                ),
                'Transaction.amount != ' => 0,
            ),
            'order' => array('Transaction.id DESC'),
        ));
        Configure::write('debug', 0);
        $depenses = $this->Transaction->find('first', array(
            'conditions' => array(
                array('Transaction.user_id' => $uid),
            ),
            'fields' => array('SUM(Transaction.amount) as depenses'),
        ));
        $gains = $this->Transaction->find('first', array(
            'conditions' => array(
                array('Transaction.to_userid' => $uid),
            ),
            'fields' => array('SUM(Transaction.amount) as gains'),
        ));
        $userstart = $this->Userinfo['monnaiestart'];
        //$solde = intval($userstart)+intval($gains[0]['gains'])-intval($depenses[0]['depenses']);
        $solde = $this->getUserReserveMonnaie($uid);
        $totaux = array(
            'alltr' => $tr,
            'userstart' => $userstart,
            'solde' => $solde,
            'gains' => round($gains[0]['gains']),
            'depenses' => round($depenses[0]['depenses']),
        );
        return $totaux;
    }
    
}
