<?php

// app/Controller/FollowsController.php
class BvsController extends AppController
{

    public function beforeFilter()
    {
        parent::beforeFilter();
        $this->Auth->allow('search', 'get_all_bassins', 'cities_search');
        $this->set('controller2load', "bv");
    }

    public function search($search)
    {
        $this->Bv->contain();
        $ret_dep = $this->Bv->find('all', array(
            'conditions' => array(
                'OR' => array(
                    array('nom LIKE ' => "%$search%"),
                    array('infos LIKE ' => "%$search%"),
                ),
            ),
        ));
        $array_bv_final = array();
        foreach ($ret_dep as $curbv) {
            array_push($array_bv_final, array(
                'id' => $curbv['Bv']['id'],
                'nom' => $curbv['Bv']['nom'],
                'infos' => $curbv['Bv']['infos'],
            ));
        }
        $this->autoRender = false;
        return json_encode($array_bv_final);
    }

    public function get_city_id($id)
    {
        $this->loadModel('City');
        $this->City->contain();
        $ret_city = $this->City->find('first', array(
            'conditions' => array(
                'City.id' => $id,
            ),
            'fields' => array('id', 'ville_nom_reel', 'ville_nom', 'ville_code_postal'),
        ));
        $array_cities_final = array();
        array_push($array_cities_final, array(
            'id' => $ret_city['City']['id'],
            'nom' => $ret_city['City']['ville_nom_reel'],
            'cp' => $ret_city['City']['ville_code_postal'],
        ));
        $this->autoRender = false;
        return json_encode($array_cities_final);
    }

    public function cities_search($search)
    {
        $this->loadModel('City');
        $this->City->contain();
        $ret_city = $this->City->find('all', array(
            'conditions' => array(
                'OR' => array(
                    array('ville_nom LIKE ' => "$search%"),
                    array('ville_nom_reel LIKE ' => "$search%"),
                    array('ville_code_postal LIKE ' => "$search%"),
                ),
            ),
            'order' => array('ville_nom_reel ASC'),
            'limit' => 12,
            'fields' => array('City.id', 'ville_nom_reel', 'ville_nom', 'ville_code_postal'),
        ));
        $array_cities_final = array();
        foreach ($ret_city as $curcity) {
            array_push($array_cities_final, array(
                'id' => $curcity['City']['id'],
                'nom' => $curcity['City']['ville_nom_reel'],
                'cp' => $curcity['City']['ville_code_postal'],
            ));
        }
        $this->autoRender = false;
        return json_encode($array_cities_final);
    }

    public function get_all_bassins()
    {
        $this->Bv->contain();
        $ret = $this->Bv->find('all');
        $this->autoRender = false;
        return json_encode($ret);
    }

}
