<?php

// app/Controller/UsersController.php
class PmsController extends AppController
{

    public function beforeFilter()
    {
        parent::beforeFilter();
        $this->set('controller2load', "pms");
        $sess_data = $this->Session->read('User.sectionInfo');
        $messagerie_activated = $this->getClientData('messagerie_activated');
        if (!$messagerie_activated) {
            $this->redirect('/');
        }
    }

    public function index()
    {
        $this->set('section', 'messagerie');
        $this->set('page', 'messagerie');
        $this->set('title_for_layout', __("Messagerie privée"));
        $all_messages_received = $this->Pm->get_messages_received_for_user($this->Userinfo['id']);
        $this->set('all_messages_received', $all_messages_received);
        $all_messages_sent = $this->Pm->get_messages_sent_for_user($this->Userinfo['id']);
        $this->set('all_messages_sent', $all_messages_sent);
        //debug($all_messages_sent);
    }

    public function setRead($mid)
    {
        $ret = $this->Pm->findByIdAndIdDestinataire($mid, $this->Userinfo['id']);
        if ($ret) {
            $this->Pm->id = $mid;
            $this->Pm->saveField('lu', 1);
            $this->set('jsonData', 'ok');
            $this->layout = "empty";
            $this->render('/Elements/json_output');
        }
    }

    public function repondre($mid)
    {
        $this->set('page', 'messagerie_repondre');
        $this->set('title_for_layout', __("Messagerie privée : Répondre"));
        $msg = $this->Pm->findByIdAndIdDestinataire($mid, $this->Userinfo['id']);
        if ($msg) {
            $this->loadModel('User');
            $this->User->contain();
            $this->set('messageinfo', $msg);
            $this->set('destinataire', $this->User->findById($msg['Pm']['id_expediteur']));
        } else {
            $this->Session->setFlash(__("Erreur identification message, veuillez nous contacter"), 'msg_alert');
            $this->redirect(array('controller' => 'pages', 'action' => 'display', 'accueil'));
        }
    }

    public function sendmessagemember()
    {
        if ($this->request->is('post')) {
            $this->Pm->create();

            if ($this->Pm->save($this->HV($this->data))) {
                $this->loadModel('User');
                $this->User->contain()
                ;
                $toinfo = $this->User->find('first', array(
                    'conditions' => array('User.id' => $this->data['Pm']['id_destinataire']),
                    'fields' => array('User.email','User.prenom','User.notif_mp'),
                ));
                $sender_prenom_nom = $this->Userinfo['prenom'] . " " . $this->Userinfo['nom'];
                // On envoie un mail à l'utilisateur contacté ssi notif_mp = 1
                //debug($toinfo['User']);exit;
                if ($toinfo['User']['notif_mp'])  {
                    $sujet = __("Vous avez reçu un message privé sur ") . Configure::read('Common.sitename');
                    $message = __("Vous avez recu un message privé de") . " " . $sender_prenom_nom . " " . __("sur") . "  <a href='" . Configure::read('Common.topurl') . "'>" . Configure::read('Common.sitename') . "</a>";
                    $message .= "<br>" . __("Pour lire ce message, vous pouvez vous connecter sur") . " <a href='" . Configure::read('Common.topurl') . "'>" . Configure::read('Common.sitename') . "</a> " . __("et consulter votre messagerie privée.");
                    $this->send_global_email($sujet, $message, $toinfo['User']);
                }
                $this->Session->setFlash(__("Votre message a été envoyé. Merci !"), 'msg_success');
                $this->redirect(array('controller' => 'pms', 'action' => 'index'));
            } else {
                $this->Session->setFlash(__("Erreur lors de l'envoi du message, veuillez nous contacter"), 'msg_alert');
                $this->redirect(array('controller' => 'pages', 'action' => 'display', 'accueil'));
            }
        }
    }

    public function supprimer($mid, $isenvoi = null)
    {
        // On verifie ssi le user est owner du message
        if ($isenvoi == null) { // boit de réception
            $chk = $this->Pm->findByIdAndIdDestinataire($mid, $this->Userinfo['id']);
        } else { // boit d'envoi'
            $chk = $this->Pm->findByIdAndIdExpediteur($mid, $this->Userinfo['id']);
        }

        if ($chk) {
            $this->Pm->delete($chk['Pm']['id']);
            $this->Session->setFlash(__("Votre message a été supprimé."), 'msg_success');
        } else {
            $this->Session->setFlash(__("Erreur d'identification."), 'msg_alert');
        }
        $this->redirect(array('controller' => 'pms', 'action' => 'index'));
    }
}
