<?php
App::uses('SimpleImage', 'Lib');
// app/Controller/PostsController.php
class PostsController extends AppController
{

    public function beforeFilter()
    {
        parent::beforeFilter();
        $this->set('controller2load', "posts");
    }

    public function index()
    {
        $this->redirect('/');
    }

/**
 * easy image resize function
 * @param  $file - file name to resize
 * @param  $string - The image data, as a string
 * @param  $width - new image width
 * @param  $height - new image height
 * @param  $proportional - keep image proportional, default is no
 * @param  $output - name of the new file (include path if needed)
 * @param  $delete_original - if true the original image will be deleted
 * @param  $use_linux_commands - if set to true will use "rm" to delete the image, if false will use PHP unlink
 * @param  $quality - enter 1-100 (100 is best quality) default is 100
 * @param  $grayscale - if true, image will be grayscale (default is false)
 * @return boolean|resource
 */
    public function smart_resize_image($file,
        $string = null,
        $width = 0,
        $height = 0,
        $proportional = false,
        $output = 'file',
        $delete_original = true,
        $use_linux_commands = false,
        $quality = 100,
        $grayscale = false
    ) {

        if ($height <= 0 && $width <= 0) {
            return false;
        }

        if ($file === null && $string === null) {
            return false;
        }

# Setting defaults and meta
        $info = $file !== null ? getimagesize($file) : getimagesizefromstring($string);
        $image = '';
        $final_width = 0;
        $final_height = 0;
        list($width_old, $height_old) = $info;
        $cropHeight = $cropWidth = 0;

# Calculating proportionality
        if ($proportional) {
            if ($width == 0) {
                $factor = $height / $height_old;
            } elseif ($height == 0) {
                $factor = $width / $width_old;
            } else {
                $factor = min($width / $width_old, $height / $height_old);
            }

            $final_width = round($width_old * $factor);
            $final_height = round($height_old * $factor);
        } else {
            $final_width = ($width <= 0) ? $width_old : $width;
            $final_height = ($height <= 0) ? $height_old : $height;
            $widthX = $width_old / $width;
            $heightX = $height_old / $height;

            $x = min($widthX, $heightX);
            $cropWidth = ($width_old - $width * $x) / 2;
            $cropHeight = ($height_old - $height * $x) / 2;
        }

# Loading image to memory according to type
        switch ($info[2]) {
            case IMAGETYPE_JPEG:$file !== null ? $image = imagecreatefromjpeg($file) : $image = imagecreatefromstring($string);
                break;
            case IMAGETYPE_GIF:$file !== null ? $image = imagecreatefromgif($file) : $image = imagecreatefromstring($string);
                break;
            case IMAGETYPE_PNG:$file !== null ? $image = imagecreatefrompng($file) : $image = imagecreatefromstring($string);
                break;
            default:return false;
        }

# Making the image grayscale, if needed
        if ($grayscale) {
            imagefilter($image, IMG_FILTER_GRAYSCALE);
        }

# This is the resizing/resampling/transparency-preserving magic
        $image_resized = imagecreatetruecolor($final_width, $final_height);
        if (($info[2] == IMAGETYPE_GIF) || ($info[2] == IMAGETYPE_PNG)) {
            $transparency = imagecolortransparent($image);
            $palletsize = imagecolorstotal($image);

            if ($transparency >= 0 && $transparency < $palletsize) {
                $transparent_color = imagecolorsforindex($image, $transparency);
                $transparency = imagecolorallocate($image_resized, $transparent_color['red'], $transparent_color['green'], $transparent_color['blue']);
                imagefill($image_resized, 0, 0, $transparency);
                imagecolortransparent($image_resized, $transparency);
            } elseif ($info[2] == IMAGETYPE_PNG) {
                imagealphablending($image_resized, false);
                $color = imagecolorallocatealpha($image_resized, 0, 0, 0, 127);
                imagefill($image_resized, 0, 0, $color);
                imagesavealpha($image_resized, true);
            }
        }
        imagecopyresampled($image_resized, $image, 0, 0, $cropWidth, $cropHeight, $final_width, $final_height, $width_old - 2 * $cropWidth, $height_old - 2 * $cropHeight);

# Taking care of original, if needed
        if ($delete_original) {
            if ($use_linux_commands) {
                exec('rm ' . $file);
            } else {
                @unlink($file);
            }

        }

# Preparing a method of providing result
        switch (strtolower($output)) {
            case 'browser':
                $mime = image_type_to_mime_type($info[2]);
                header("Content-type: $mime");
                $output = null;
                break;
            case 'file':
                $output = $file;
                break;
            case 'return':
                return $image_resized;
                break;
            default:
                break;
        }

# Writing image according to type to the output destination and image quality
        switch ($info[2]) {
            case IMAGETYPE_GIF:imagegif($image_resized, $output);
                break;
            case IMAGETYPE_JPEG:imagejpeg($image_resized, $output, $quality);
                break;
            case IMAGETYPE_PNG:
                $quality = 9 - (int) ((0.9 * $quality) / 10.0);
                imagepng($image_resized, $output, $quality);
                break;
            default:return false;
        }

        return true;
    }

    public function modify_post($typeannonce = null, $post_id = null)
    {
        $this->set('bodyclass', '');
        $this->set('page', 'annonces');
        // On verifie que le post à changer appartient au user
        if (($this->Userinfo['role'] == "admin") || ($this->Userinfo['role'] == "adminentreprise")) {
            $chkpost = $this->Post->findById($post_id);
            $this->set('admin', 'yes');
            $this->set('admin_user_id', $chkpost['User']['id']);
            $this->set('admin_city_id', $chkpost['User']['city_id']);
            //debug($chkpost);
        } else {
            $chkpost = $this->Post->findByIdAndUserId($post_id, $this->Userinfo['id']);
        }
        //debug($post_id);debug($chkpost);exit;

        if (!$chkpost) {
            $this->redirect($this->referer());
        }
        // On continue
        //debug($chkpost);
        $chkpost['Post']['message'] = html_entity_decode($chkpost['Post']['message'], ENT_QUOTES);
        $chkpost['Post']['titre'] = html_entity_decode($chkpost['Post']['titre'], ENT_QUOTES);
        $this->data = $chkpost; // Pour remplir le formulaire
        $this->set('post_id_a_modifier', $post_id);
        $this->set('action', 'change');
        $this->set('title_for_layout', Configure::read('PostConfig.section_titre_bouton_ecrire'));
        $this->set('configTxt', Configure::read('PostConfig'));
        $this->set('typeannonce', $typeannonce);
        $this->loadModel('Category');
        $all_categories = $this->Category->find('list', array(
            'conditions' => array(),
            'order' => 'Category.name',
        ));
        $this->set('all_categories', $all_categories);
        $this->set('all_monnaie_values', Configure::read('Common.monnaie.values.'.$typeannonce));
		$this->render('ajout_annonce');
    }

    public function ajout_annonce($typeannonce = null)
    {
        $this->set('bodyclass', '');
        $this->set('page', 'annonces');
        $this->set('action', '');

        // -------------------------------------------------------------------------------------
        //if ($this->request->is('post')) {
        if ($this->data) {
            $full_data = $this->data;
            //debug($full_data);exit;
            // Les champs ont été renseignés
            $data = $this->data['Post'];
            $post_id=null;
            if (isset($data['id'])) {
                $post_id=$data['id'];
            };
            //debug($typeannonce);
            //debug($data);exit;
            //$full_data['Post']['titre'] = ucfirst(strtolower($full_data['Post']['titre']));

            // On verifie la valeur du champ monnaie_value
            if (isset($data['monnaievalue'])) {
                if (($data['monnaievalue'] != 0)) {
                    // Monnaie autorisé dans la ville
                    // On verifie la valeur
                    $monnaies = Configure::read('Common.monnaie.values.'.$typeannonce);
                    if (!isset($monnaies[$data['monnaievalue']])) {
                        // La valeur n'existe pas, on supprime
                        $data['monnaievalue'] = 0; // On met à 0 , interdit
                    } else {
                        $this->loadModel('User');
                        // Autorisé donc on rajoute 1 au compteur de posts monnaie
                        $ret = $this->User->updateAll(
                            array('User.nb_monnaie_posts' => 'User.nb_monnaie_posts+1'),
                            array('User.id' => $this->Userinfo['id'])
                        );
                    }
                } else {
                    $data['monnaievalue'] = 0; // On met à 0 , interdit
                }
            }

            //debug($data);exit;
            if ($this->Userinfo['id'] == Configure::read('Reseau.user_id')) {
                if (trim($data['villeReseau']) != "") {
                    //debug($data['villeReseau']);exit;
                    $Reseaucity = $this->check_google_city($data['villeReseau']);
                    if ($Reseaucity) {
                        $reseau_city_id = $Reseaucity['City']['id'];
                        $full_data['Post']['city_id'] = $reseau_city_id;
                    } else {
                        $this->Session->setFlash(__("!! Erreur : Ville non trouvée dans la database !"), 'msg_alert');
                        $this->redirect($this->referer());
                    }
                }
            }
            // On vérifie si le user Id est valide
            if ($data['user_id'] > 0 and $data['city_id'] > 0) {
                // On vérifie  le lien vidéo
                $chkyout = 0;
                if (isset($full_data['Post']['youtube'])) {
                    if (
                        strstr($full_data['Post']['youtube'], "https://www.youtube.com") or
                        strstr($full_data['Post']['youtube'], "https://youtu.be") or
                        strstr($full_data['Post']['youtube'], "https://vimeo.com")
                    ) {
                        $chkyout = 1;
                    }
                }
                if ($chkyout == 0) {
                    $full_data['Post']['youtube'] = "";
                }
                //debug($full_data);    exit;

                $this->Post->create();
                //debug($full_data);exit;
                //debug($this->HV($full_data));exit;
                if ($this->Post->save($this->HV($full_data))) {
                    $idm = $this->Post->id;
                    // Vérifier si un fichier image est associé
                    if ($data['image_info']['name'] != '') {
                        // Copie de l'umage en lieu sur..
                        //debug($data);
                        $ext = pathinfo($data['image_info']['name'], PATHINFO_EXTENSION);
                        //debug($ext);
                        $authexts = Configure::read('Common.postExt');
                        if (isset($authexts[strtolower($ext)])) {
                            //if ($ext!="") {
                            // Un nom d'image en timestamp
                            $img = time();
                            $source = WWW_ROOT . DIRECTORY_SEPARATOR . 'img/post/' . $img;
                            $filename = $source . '.' . $ext;
                            //debug($source);
                            move_uploaded_file($data['image_info']['tmp_name'], $filename);
                            $this->smart_resize_image($filename, null, 600, 450, false, $filename, false, false, 100);
                            $this->Post->saveField('image', 'post/' . $img . '.' . $ext);
                        }
                    }
                    $msg_city_id = $this->data['Post']['city_id'];
                    $this->loadModel('City');
                    // Récupération du département de la ville
                    $this->City->contain();
                    $city_info = $this->City->find('first', array('conditions' => array('City.id' => $msg_city_id), 'fields' => array('ville_nom_reel', 'ville_departement')));

                    // Send email to admins
                    $sujet = __("Nouveau message posté sur le réseau ") . Configure::read('Common.sitename');
                    if (isset($full_data['Post']['post_update'])) {
                        $sujet = __("Un message a été modifié sur le réseau ") . Configure::read('Common.sitename');
                    }

                    // Get user id infos
                    $this->loadModel('User');
                    $this->User->contain();
                    $chkuser = $this->User->findById($data['user_id']);
                    $tt = Configure::read('Common.echangestype');
                    $msgmail = __("Un nouveau message a été posté sur le site : ") . ' : ';
                    if (isset($full_data['Post']['post_update'])) {
                        $msgmail = __("Un message a été modifié sur le site ");
                    }
                    $msgmail .= "<br>De : " . $chkuser['User']['prenom'] . " " . $chkuser['User']['nom'] . "<br>";
                    $msgmail .= "Ville : " . $city_info['City']['ville_nom_reel'] . "<br>";
                    $msgmail .= "Type : " . $tt[$full_data['Post']['type']] . "<br>";
                    $msgmail .= "Entreprise : " . Configure::read('Common.client.name') . "<br>";
                    $msgmail .= __("Titre") . " : " . $full_data['Post']['titre'] . "<br>";
                    $msgmail .= __("Message") . " : <br>" . nl2br($full_data['Post']['message']) . "<br>";
                    if ($data['image_info']['name'] != '') {
                        $msgmail .= "<br>Image : https://" . Configure::read('Common.sitename') . "/img/post/" . $img . '.' . $ext . "<br>";
                        $msgmail .= "<img src=\"https://" . Configure::read('Common.sitename') . "/img/post/" . $img . '.' . $ext . "\">";
                    }
                    //debug($full_data);
                    //debug(nl2br($msgmail));exit;
                    //debug($this->Userinfo['role']);exit;
                    $this->send_global_email($sujet, $msgmail);
                    if ((($this->Userinfo['role'] == "admin") || ($this->Userinfo['role'] == "adminentreprise")) && $post_id!=null) {
                        $this->Session->setFlash(__("Votre correction a bien été prise en compte."), 'msg_success');
                    } else {
                        $this->Session->setFlash(__("Votre annonce a été enregistrée, merci !") . '<br><br>' . __("Note : Vous pouvez désormais modifier une annonce en cliquant sur votre Prénom dans le menu, puis en cliquant sur 'Mes offres/demandes'"), 'msg_success');
                    }
                } else {
                    $this->Session->setFlash(__("Erreur lors de la création de votre annonce, merci de nous contacter"), 'msg_alert');
                }
                //debug($post_id);exit;
                if ((($this->Userinfo['role'] == "admin") || ($this->Userinfo['role'] == "adminentreprise")) && $post_id!=null) {
                    $this->redirect(array('controller' => 'admins', 'action' => 'admin_posts'));
                } else {
                    $this->redirect(array('controller' => 'posts', 'action' => 'listmyposts',$data['type']));
                }
            } else {
                $this->redirect(array('controller' => 'users', 'action' => 'login'));
                $this->Session->setFlash(__("!! Erreur : Problème d'identification de votre session..."), 'msg_alert');
            }
        }
        $this->set('title_for_layout', Configure::read('PostConfig.section_titre_bouton_ecrire'));
        $this->set('configTxt', Configure::read('PostConfig'));
        $this->set('typeannonce', $typeannonce);
        $this->loadModel('Category');
        $all_categories = $this->Category->find('list', array(
            'conditions' => array(),
            'order' => 'Category.name',
        ));
        $this->set('all_categories', $all_categories);
        //debug(Configure::read('Common.monnaie.values.'.$typeannonce));exit;
        $this->set('all_monnaie_values', Configure::read('Common.monnaie.values.'.$typeannonce));
    }

    public function remove($post_id)
    {
        // Verification
        $this->Post->contain();
        // Verification
        if (($this->Userinfo['role'] == 'admin') || ($this->Userinfo['role'] == "adminentreprise")) {
            $chk = $this->Post->findById($post_id);
        } else {
            $chk = $this->Post->findByUserIdAndId($this->Userinfo['id'], $post_id);
        }
        // Action
        if ($chk) {
            $ret = $this->Post->delete($post_id, false);
            $this->Session->setFlash(__("L'annonce a été supprimée"), 'msg_success');
        } else {
            $this->Session->setFlash(__("Erreur lors de la suppression"), 'msg_alert');
        }
        $this->redirect($this->referer());
    }

    public function setPaused($post_id)
    {
        // Verification
        $this->Post->contain();
        // Verification
        $chk = $this->Post->findByUserIdAndId($this->Userinfo['id'], $post_id);
        // Action
        if ($chk) {
            $this->Post->contain();
            $pinfo = $this->Post->findById($post_id,array('*'));
            $pp = $pinfo['Post']['paused'];
            
            $this->Post->id = $post_id;
            //debug($pinfo);
            if ($pp) {
                $this->Post->saveField('paused',false);
                $this->Session->setFlash(__("Votre annonce a été réactivée"), 'msg_success');
            } else {
                $this->Post->saveField('paused',true);
                $this->Session->setFlash(__("Votre annonce a été mise en pause"), 'msg_success');
            }
        } else {
            $this->Session->setFlash(__("Erreur lors de la suppression"), 'msg_alert');
        }
        $this->redirect($this->referer());
    }


    public function catalogue($type = 'O')
    {
        $allcats = $this->get_all_categories_as_list("echanges");
        $this->set('AllCategories', $allcats);
        $this->set('title_for_layout', __("Les offres de services"));

        //debug($this->Cookie->read('choixUser'));exit;
        if ((!strstr($this->referer(), "Catalogue-" . $type)) and (!strstr($this->referer(), "catalogue/" . $type))) {
            //debug($this->referer());
            //debug(strstr($this->referer(),"catalogue/".$type));exit;
            $this->clearUserCityLocation();
        }
        //debug($this->referer());//exit;
        //debug($this->Paginator->numbers);exit;
        //$this->clearUserCityLocation();

        $this->setUserCookieRecherche();
        // Est-ce une recherche ?
        if ($this->request->is('post')) {
            //debug($this->data);//exit;
            // On charge les post correspondants à la recherche
            //$ret = $this->getPosts($type, 17, $this->data['Pages']['category_id'], $this->data['recherche_user']);
            $ret = $this->getPosts($type, 17, $this->data);
            //debug($ret);exit;
            //debug($this->data['Pages']['category_id']);exit;
        } else {
            //exit;
            $chkcategory_id = $this->getCurrentCategory('id');
            //debug($chkcategory);exit;
            if ($chkcategory_id) {
                $ret = $this->getPosts($type, 17, array('cat_id'=>$chkcategory_id));
            } else {
                $ret = $this->getPosts($type, 17);
            }
            //debug($ret);exit;
        }
        //debug($ret);exit;

        $typestr = __("offre");
        if ($type == 'D') {
            $this->set('title_for_layout', __("Les demandes de services"));
            $typestr = __("demande");
        }
        if ($ret['count']>1) {
            $typestr .= "s";
        }

        $this->set('typestr', $typestr);
        $this->set('last_messages', array($typestr => $ret['all_posts'], 'count' => $ret['count']));
        $this->set('userInput', $this->Cookie->read('choixUser'));

        $infosloc = $this->getCurrentlocation();
        $this->set('current_location', $infosloc);
        $currentCategory = $this->getCurrentCategory();
        //debug($infosloc);exit;

        $this->set('current_category', $currentCategory);
        //debug($ret);exit;

        $this->set('page', 'catalogue');
        $this->set('pageactive', 'catalogue-' . $type);
        $this->set('type', $type);
        $this->set('controller2load', 'accueil');
        $this->set('bodyclass', '');
        if (!$ret) {
            $tpstr = "demande";
            if ($type == "O") {
                $tpstr = "offre";
            }

            $this->Session->setFlash("Désolé, aucune " . $tpstr . " ne correspond à ces critères précis pour l'instant.", 'msg_glaz');
        }
        $this->render('catalogue_new');
    }

    public function catalogue_category($catid, $posttype)
    {
        $this->set('bodyclass', '');
        $this->set('controller2load', 'accueil');
        $cfg = Configure::read('PostConfig');
        $all_posts = $this->loadPosts(null, $catid, $posttype); // in Appcontroller.php
        //debug($all_posts);
        $this->set('all_posts', $all_posts);
        $this->set_post_pages_variables($cfg);
        $this->set('catalogue', 'yes');
        $this->set('titre_section', $cfg['title_for_layout'] . "<br>" . __("Vous consultez les") . " " . Configure::read('Common.echangestype_str.' . $posttype));
        $this->render('/Pages/display_posts');
    }

    public function listmyposts($type = 'O')
    {
        $this->set('bodyclass', '');
        $this->set('page', 'listpost');
        $this->set('controller2load', 'accueil');
        $this->set('title_for_layout', __("Mes annonces"));
        $this->set('page', 'listmyposts');

        //$theuser = $this->User->findById($this->Userinfo['id']);
        //debug($type);exit;
        $allposts = $this->loadPostsUser($this->Userinfo['id'], $type, 'NOMESSAGEDISPLAY');
        $this->loadModel('Post');
        $nb = $this->Post->getPostsCount($this->Userinfo['id'], $type);
        if ($type == 'O') {
            $strtype = __("offres");
            $strtype2 = __("d'offres");
            $this->set('last_messages', array(__("offres") => $allposts));
        } else {
            $strtype = __("demandes");
            $strtype2 = __("de demandes");
            $this->set('last_messages', array(__("demandes") => $allposts));
        }
        $this->set('count_posts', $nb);
        $this->set('strtype', $strtype);
        $this->set('strtype2', $strtype2);
    }


    private function loadUserFavorites()
    {
        $this->loadModel('Favorite');

        $posts_paginate = array(
            'limit' => 9,
            'conditions' => array(
                'Post.id !=' => null,
                'Post.paused' => false,
                'User.vacation' => false
            ),
            'joins' => array(
                array(
                    'table' => 'favorites',
                    'alias' => 'Favoritejoin',
                    'type' => 'INNER',
                    'conditions' => array(
                        'Favoritejoin.user_id' => $this->Userinfo['id'],
                        'Favoritejoin.post_id = Post.id',
                    ),
                ),
                array(
                    'table' => 'cities',
                    'alias' => 'CityJoin',
                    'type' => 'INNER',
                    'conditions' => array(
                        'CityJoin.id = User.city_id'
                    )
                )
            ),
            'contain' => array(
                'Category' => array('fields' => array('name', 'image')),
                'User' => array('fields' => array('id', 'nom', 'prenom', 'photo', 'city_id', 'type')),
                'User.TransactionDebit' => array(
                    'fields' => array('Sum(amount) as amount_debit'),
                ),
                'Transaction.User' => array(),
                'Transaction.Post' => array(),
                'City' => array('fields' => array('ville_nom_reel', 'id')),
            ),
            'order' => array('Post.id' => 'DESC'),
            'fields' => array('Post.*', 'Favoritejoin.*','CityJoin.ville_nom_reel'),
        );
        $this->Paginator->settings = $posts_paginate;
        $all_posts = $this->Paginator->paginate('Post');

        return $all_posts;
    }


    public function listmyfavorites()
    {
        $this->set('bodyclass', '');
        $this->set('page', 'listmyfavorites');
        $this->set('controller2load', 'accueil');
        $this->set('title_for_layout', __("Mes favoris"));

        //$theuser = $this->User->findById($this->Userinfo['id']);
        //debug($type);exit;
        $allposts = $this->loadUserFavorites();
        //debug($allposts);
        $nb = count($allposts);
        //debug($nb);exit;
        $strtype = __("favoris");
        $strtype2 = __("de favoris");
        $this->set('last_messages', array(__("favoris") => $allposts));
        $this->set('count_posts', $nb);
        $this->set('strtype', $strtype);
        $this->set('strtype2', $strtype2);
    }


    private function get_all_favorites()
    {
        $allfavorites = array();
        if (isset($this->Userinfo['id'])) {
            $this->loadModel('Favorite');
            $curuser_id = $this->Userinfo['id'];
            $this->Favorite->contain('Post','User');
            $allfavorites = $this->Favorite->find('list', array(
                'conditions' => array(
                    'Favorite.user_id' => $curuser_id,
                    'Post.id !=' => null,
                    'Post.paused' => false,
                    //'User.vacation' => false
                ),
                'fields' => array('Favorite.post_id', 'Favorite.post_id'),
            ));
        }
        return $allfavorites;
    }

    public function get_favorites()
    {
        $ret = $this->get_all_favorites();
        $this->autoRender = false;
        return json_encode($ret);
    }

    public function togglefavorite($postid)
    {
        $this->loadModel('Favorite');
        $this->autoRender = false;
        $this->Favorite->contain();
        $res = $this->Favorite->find('first', array(
            'conditions' => array(
                'Favorite.user_id' => $this->Userinfo['id'],
                'Favorite.post_id' => $postid,
            ),
        ));
        if ($res) {
            $this->Favorite->delete($res['Favorite']['id']);
            return "no";
        } else {
            $this->Favorite->create();
            $this->Favorite->save(array('user_id' => $this->Userinfo['id'], 'post_id' => $postid));
            return "yes";
        }
        return "done";
    }

}
