<!DOCTYPE html>
<html lang="fr">

  <head>

    <meta charset="utf-8">
		<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <?php echo $this->Html->charset(); ?>
	<?php
		echo $this->Html->meta('keywords',
	    	"TIMEBANKPRO, banque du temps, timebanking, réseau social d'entreprise,ville, agglomeration,plateforme d'échange,fil d'infos,vie locale,proximité,entraide,services,communiquer,échanger,voisinage,voisins");
	?>
	<?php
		echo $this->Html->meta('description',__("TIMEBANKPRO est une plateforme d'échange de services qui fonctionne comme une banque du temps. Pour faire ce que vous aimez et recevoir ce dont vous avez besoin."));
	?>
	<title>
		<?php echo $this->fetch('title'); ?>
	</title>
    <link href="favicon.ico" rel="shortcut icon" type="image/x-icon" />
		<link rel="apple-touch-icon" href="<?=Configure::read('Common.topurl');?>/img/<?=$ClientDefaults['logo']?>" />

		<link rel="apple-touch-icon" href="<?=Configure::read('Common.topurl');?>/img/touch-icon-iphone.png" />
		<link rel="apple-touch-icon" sizes="72x72" href="<?=Configure::read('Common.topurl');?>/img/touch-icon-ipad.png" />
		<link rel="apple-touch-icon" sizes="114x114" href="<?=Configure::read('Common.topurl');?>/img/touch-icon-iphone4.png" />

    <!-- Custom fonts for this template -->
		<link href="https://fonts.googleapis.com/css?family=Lato:300,400,700,300italic,400italic,700italic" rel="stylesheet" type="text/css">
		<link href="https://fonts.googleapis.com/css?family=Alegreya+Sans|PT+Serif" rel="stylesheet">

		<link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.8.1/css/all.css" integrity="sha384-50oBUHEmvpQ+1lW4y57PTFmhCaXp0ML5d60M1M7uH2+nqUivzIebhndOJK28anvf" crossorigin="anonymous">


	<?php
		echo $this->Html->meta('icon');
		
		// to keep pull-right available for icons
		echo $this->Html->css('../vendor/font-awesome/css/font-awesome.min');


		echo $this->Html->css('../vendor/bootstrap/css/bootstrap.min');
		echo $this->Html->css('../bower_components/ng-dialog/css/ngDialog');
		echo $this->Html->css('../bower_components/ng-dialog/css/ngDialog-theme-default');
		echo $this->Html->css('../bower_components/ng-dialog/css/ngDialog-theme-plain');
		echo $this->Html->css('../bower_components/ngQuickDate/dist/ng-quick-date');
		echo $this->Html->css('../bower_components/ngQuickDate/dist/ng-quick-date-default-theme');
		echo $this->Html->css('../bower_components/fullcalendar/dist/fullcalendar');
		echo $this->Html->css('animate.min.css');
		echo $this->Html->css('rotator.css');

		echo $this->Html->css('landing-page');
		echo $this->Html->css('tbp');
		echo $this->Html->css('common');
		echo $this->Html->css('tbpro.footer');

		//echo $this->Html->css('flatty');
		echo $this->Html->css('tbpro.user'); // Pour répertoire
		echo $this->Html->css('../bower_components/angucomplete-alt/angucomplete-alt');

		// Client Template CSS file
		echo $this->Html->css('tbpro.client');
		// Client Custom cSS file
		echo $this->Html->css('clients/'.Configure::read('Common.client.subdomain').'.css');


		echo $this->fetch('meta');
		echo $this->fetch('css');
		echo $this->fetch('script');
	?>
	<meta property="og:type" content="website" />
	<meta property="og:title" content="<?= $title_for_layout;?>" />
	<meta property="og:description" content=<?= __("TIMEBANKPRO est une plateforme d'échange de services qui fonctionne comme une banque du temps. Pour faire ce que vous aimez et recevoir ce dont vous avez besoin")?> />

  </head>

  <body ng-app="tbproApp" class="<?=$bodyclass;?>">

		<?php
			if (!isset($pageactive)) $pageactive="";
			if (!function_exists('chkactive')) {
				echo $this->element('utils_functions');
			}
			$infospage="";
			if (($page=="ccm") or ($page=="faq")) {
				$infospage="active activemenudropdown";
			}
		?>

    <!-- Navigation -->
    <nav class="navbar navbar-light navbar-expand-lg navbar-light bg-light fixed-top bg-white">
		<div class="container-fluid">
        <a class="navbar-brand" href="#">
			<?php echo $this->Html->image($ClientDefaults['logo'],array('id'=>'logo','url'=>'/','height'=>'48'));?>
			<span class="clientTitle"><?php echo Configure::read('Common.client.name');?></span>
		</a>
        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarResponsive" aria-controls="navbarResponsive" aria-expanded="false" aria-label="Toggle navigation">
          <span class="navbar-toggler-icon"></span>
        </button>

        <div class="collapse navbar-collapse" id="navbarResponsive">
          <ul class="navbar-nav ml-auto">
						<?php if($Userinfo) { ?>
							<?php echo $this->element('menu_user_connected',array('pageactive'=>$pageactive)); ?>
          	<?php } else { ?>
						<li class="nav-item"><?php echo $this->Html->link(__("Se connecter"), array('controller' => 'users', 'action' => 'login'), array('class' => 'nav-link')); ?></li>
          	<li class="nav-item"><?php echo $this->Html->link(__("S'inscrire"), array('controller' => 'users', 'action' => 'add'), array('class' => 'nav-link')); ?></li>
						<?php } ?>
						<li class="nav-item dropdown">
							<a class="nav-link dropdown-toggle <?=$infospage?>" href="#" id="navbarDropdownMenuLinkUser" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
								<?= __("Informations")?>
								</a>
							<div class="dropdown-menu dropdown-fix" aria-labelledby="navbarDropdownMenuLinkUser">
								<?php echo $this->Html->link(__("Comment ça marche ?"), array('controller' => 'pages', 'action' => 'display','ccm'), array('class' => 'dropdown-item')); ?>
							</div>
						</li>

						<li class="nav-item <?= chkactive($pageactive,'contact')?>"><?php echo $this->Html->link(__("Contact"), array('controller' => 'pages', 'action' => 'display','contact'), array('class' => 'nav-link')); ?></li>

          	<li class="nav-item <?= chkactive($pageactive,'accueil')?>"><?php echo $this->Html->link(__("Accueil"), array('controller' => 'pages', 'action' => 'display','accueil'), array('class' => 'nav-link')); ?></li>
			<?php echo $this->element('flags');?>
          </ul>
				</div>
		</div>
    </nav>

    <!-- Page Content -->
    <?php if ($page != "accueil") { ?>
    <header class="content-header">
        <div class="container">
    <?php } ?>
		<?php if (($Userinfo['vacation']) and ($page != "accueil")) { ?>
				<?php echo $this->element('vacation');?>
		<?php } ?>

								<div class="row text-center">
									<div class="col">
											<?php
												$ua = htmlentities($_SERVER['HTTP_USER_AGENT'], ENT_QUOTES, 'UTF-8');
												if (preg_match('~MSIE|Internet Explorer~i', $ua) || (strpos($ua, 'Trident/7.0; rv:11.0') !== false)) {
											?>
													<div class="row mt-5">
													<div class="col mt-5 "><div class="alert alert-glaz" role="alert">
													<?= __("Pour information, vous utilisez un navigateur web qui n'est pas compatible avec notre plateforme. Merci d'utiliser Chrome, Firefox ou Safari.")?>
													</div>
													</div>
												</div>
											<?php }  ?>
											<?php echo $this->Flash->render(); ?>
											<?php echo $this->Session->flash('auth'); ?>
									</div>
								</div>
                <?php echo $this->fetch('content'); ?>
    <?php if ($page != "accueil") { ?>
        </div>
    </header>
    <?php } ?>



    <aside class="tbprofooter">

      <div class="container">

        <div class="row">
          <div class="col-lg-12 my-auto">
						<center><h2 class="tbprofooter"><a href="https://timebankpro.com" target="_blank">TIMEBANKPRO</a></h2>
						<br><span class="title"><?= __("Service développé par la SAS")?> <a href="http://www.local4people.com" target="_blank">Local4People</a>,<br>Maison des Entreprises, 4 rue Ampère, BP 30255, 22302 Lannion Cedex</span>
						<br><a href="http://www.local4people.com" target="_blank"><?php echo $this->Html->image('logol4p.png',array('width'=>'200','id'=>'logoft','class'=>''));?></a>
						</center>
          </div>          
        </div>

      </div>
      <!-- /.container -->

    </aside>
    <!-- /.banner -->

<!--   Footer   -->
<footer class="myfooter">
		<div class="container">
			<div class="row">
				<div class="col">
					<h4 class="title-widget"><?= __("Informations")?></h4>
					<ul>
						<li class="lnkbottom"><?php echo $this->Html->link(__("Comment ça marche ?"), array('controller' => 'pages', 'action' => 'display','ccm'), array('class' => '')); ?></li>
						<?php if ($Userinfo) {?>
							<li class="lnkbottom"><a target="_blank" href="/files/<?=$ClientDefaults['notice_pdf_'.$lang].'?t='.time()?>"><?= __("Notice utilisateur")?></a></li>
						<?php } ?>
						<?php if ($ClientDefaults['charte_pdf_'.$lang]!="") echo '<li class="lnkbottom"><a target="_blank" href="/files/'.$ClientDefaults['charte_pdf_'.$lang].'?t='.time().'">'.__("Charte d'usage spécifique à").' '.strtoupper($ClientData['name']).'</a></li>';?>
						<?php if ($ClientDefaults['cgu_pdf_'.$lang]!="") echo '<li class="lnkbottom"><a target="_blank" href="/files/'.$ClientDefaults['cgu_pdf_'.$lang].'?t='.time().'">'.__("CGU (Conditions Générales d'Utilisation).").'</a></li>';?>
						<?php if ($ClientDefaults['pdc_pdf_'.$lang]!="") echo '<li class="lnkbottom"><a target="_blank" href="/files/'.$ClientDefaults['pdc_pdf_'.$lang].'?t='.time().'">'.__("Confidentialité des données").'</a></li>';?>
					</ul>
				</div>				
				<div class="col">
					<h4 class="title-widget"><?= __("Contact")?></h4>
					<div class="lnkbottom">
						<?php echo $this->Html->link(__("Nous contacter"), array('controller' => 'pages', 'action' => 'display','contact'), array('class' => '')); ?>
					
						<br>
							SAS Local4People,<br> Maison des Entreprises,<br>
							4 rue Ampère, BP 30255<br>
							22302 Lannion Cedex
					</div>
				</div>
			</div>
			<hr>

			<p class="text-center"> © 2018-2019. <?= strtoupper(Configure::read('Common.sitename'));?></p>
		</div> <!-- ./container -->

    </footer>
	<script type="text/javascript" src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCakTpHBty9xlLrCHfCdx7apujIk5loD48&libraries=places&language=<?= Configure::read('Config.lang_code') ?>"></script>

    <!-- Bootstrap core JavaScript -->
    <?php echo $this->Html->script("../vendor/jquery/jquery.min.js"); ?>
		<?php echo $this->Html->script("../vendor/bootstrap/js/bootstrap.bundle.min.js"); ?>
    <!-- jQuery -->
    <?php echo $this->Html->script('../bower_components/moment/moment.js'); ?>
    <?php echo $this->Html->script('date-fr-FR'); ?>

    <!-- Bootstrap Core JavaScript -->
    <?php echo $this->Html->script('../bower_components/angular/angular.min.js'); ?>
    <?php echo $this->Html->script('../bower_components/angular-sanitize/angular-sanitize.min.js'); ?>
    <?php echo $this->Html->script('../bower_components/ng-dialog/js/ngDialog.js'); ?>
    <?php echo $this->Html->script('../bower_components/ngQuickDate/dist/ng-quick-date.js'); ?>
    <?php echo $this->Html->script('../bower_components/angular-ui-calendar/src/calendar.js'); ?>
    <?php echo $this->Html->script('../bower_components/fullcalendar/dist/fullcalendar.min.js'); ?>
		<?php echo $this->Html->script('../bower_components/fullcalendar/dist/lang/fr.js'); ?>
		<?php //echo $this->Html->script('../bower_components/ngAutocomplete/src/ngAutocomplete.js'); ?>
		<?php echo $this->Html->script('../bower_components/angucomplete-alt/angucomplete-alt.js'); ?>

		<?= $this->Html->script('Chart.min.js') ?>
    <?= $this->Html->script('angular-chart.min.js') ?>
    <?php echo $this->Html->script('tbpro.js') ?>
    <?php if (isset($controller2load)) {echo $this->Html->script("controllers/$controller2load.js");} ?>
    <?php if (isset($controller2load_bis)) echo $this->Html->script("controllers/$controller2load_bis.js"); ?>
    <?php if ($page=="profil") echo $this->Html->script("controllers/profil.js"); ?>
    <script src="https://www.google.com/recaptcha/api.js" async defer></script>

    <script src="https://www.google.com/recaptcha/api.js" async defer></script>
	
<script>
$(document).ready(function() {
	$('.submitSafari').keydown(function(e) {
		if (e.keyCode == 13) {
			$('#MenuRechercheForm').submit();
		}
	});

	$('.carousel').carousel({
		interval: 4000
	})

});
</script>

  </body>

</html>
