<?php echo $this->element('admin_card_header',array('title'=>"Gestion des bassins de vie",'subtitle'=>"Un bassin de vie est un ensemble de communes")); ?>

<div class="row">
	<div class="update ml-auto mr-auto">
		<button class="btn btn-primary btn-round" ng-click="ShowAJouterBassin=!ShowAJouterBassin">Ajouter un bassin de vie</button>
		<button class="btn btn-primary btn-round" ng-click="ShowAllBassins()">Gérer un bassin de vie</button>
	</div>
</div>

<div class="row">
<!-- Ajout d'un bassin de vie -->
	<div class="col-md-10" ng-show="ShowAJouterBassin">
		<div class="card-header">
            <h5 class="card-title">Ajout d'un bassin de vie</h5>
        </div>
		<div class="card-body">
			<?php echo $this->Form->create('Admin', array('url'=>'CreateBassinVie','class' => 'form-horizontal','role'=>'role')); ?>
			<div class="row">
				<div class="col-md-5 pr-1">
					<div class="form-group">
						<label>Nom</label>
						<?php echo $this->Form->input('nom', array('class'=>'form-control','label' => false, 'required'=>true, 'placeholder' => __('Nom du bassin de vie'))); ?>
					</div>
				</div>
				<div class="col-md-5 px-1">
					<div class="form-group">
						<label>Description</label>
						<?php echo $this->Form->input('infos', array('class'=>'form-control','label' => false, 'required'=>true, 'placeholder' => __('Description brève'))); ?>
					</div>
				</div>
			</div>
			<div class="row">
				<div class="update ml-auto mr-auto">
					<button type="submit" class="btn btn-primary btn-round">Créer ce bassin</button>
				</div>
			</div>
			<?php echo $this->Form->end(); ?>
		</div>
	</div>
</div>
<!-- Fin Ajout d'un bassin de vie -->

<!-- Affichage des bassins de vie -->
<div class="row">
	<div class="col-md-6" ng-show="ShowPanelAllBassins">
		<div class="card-header">
            <h5 class="card-title">Liste des bassins de vie</h5>
        </div>
		<div class="card-body">
			<div class="row">
				<ul>
					<li class="hand" ng-click="manageBassin($index)" ng-repeat="bassin in AllBassins">
						{{bassin.Bv.nom}} - {{bassin.Bv.infos}}  - <i class="fa fa-trash-o hand" ng-click="removeBassin(bassin.Bv.id,$index)"></i>
					</li>
				</ul>
			</div>
		</div>		
	</div>
</div>

<div class="row">
	<div class="col-md-12" ng-show="AllBassinCities">

		<div class="card-header">
            <h5 class="card-title">Liste des villes pour le bassin de {{AllBassinCities.Bv.nom}}</h5>
        </div>
		<div class="card-body">
			<div class="row">
				<div class="col-md-7 pr-1">
					<div class="form-group">
						<label>Modifier le nom : </label>
						<input class="form-control" type="text" ng-model="AllBassinCities.Bv.nom">
					</div>
					<div class="form-group">
						<label>Modifier description : </label>
						<input class="form-control" type="text" size="30" ng-model="AllBassinCities.Bv.infos">
					</div>
					<div class="col-md-2">
						<button class="btn btn-sm btn-info" ng-click="changeBvNom(AllBassinCities.Bv.id,AllBassinCities.Bv.nom,AllBassinCities.Bv.infos)">changer</button>
					</div>
				</div>
				
			</div>
			<hr no shade>

			<div class="row">
				<div class="col-md-12 pr-1">
					<div class="form-group">
						<label><h5>Ajouter une ville : </h5></label>
						<?php $burl = "";if ($this->webroot!="/") $burl = $this->webroot; ?>
						<div class="row">
						<div class="col-md-5 pr-1">
							<div angucomplete-alt
								id="VILLE_user"
								placeholder="Ville"
								pause="500"
								selected-object="addVille"
								remote-url="<?=$burl;?>/bvs/cities_search/"
								title-field="nom,cp"
								description-field="ville_nom_reel"
								minlength="3"
								input-class="form-control"
								match-class="highlight"
								initial-value=""
								clear-selected="false"
								>
							</div>
						</div>
						</div>
					</div>
				</div>
			</div>
			<div class="row">
				<div class="col-md-12 pr-1">
					<ul>
						<li ng-repeat="ville in AllBassinCities.City">
							<span class="">{{ville.ville_nom_reel}}</span> - <i class="fa fa-trash-o hand" ng-click="removeCityBassin(ville.BvsCity.city_id)"></i>
						</li>
					</ul>
				</div>
			</div>
			<div class="row">
				<div class="col-md-12 pr-1">
					<?php //echo $this->element('liste_echanges_angular'); ?>
				</div>
			</div>

		</div>
	</div>
</div>


<?php echo $this->element('admin_card_footer',array('footertxt'=>"")); ?>