var tbproApp = angular.module('tbproApp',['ngSanitize','ngDialog','angucomplete-alt','chart.js']);

//var webServerMain = "https://www.timebankpro.com/";
var webServerMain = window.location.protocol + "//" + window.location.host+'/'
if (/https:\/\/www.timebankpro/.test(self.location.href)) {
	var webServerMain = "https://www.timebankpro.com/";
}
if (/orange\/tbpro/.test(self.location.href)) {
	var webServerMain = "http://orange/tbpro/";
}
if (/phcompany\/tbpro/.test(self.location.href)) {
	var webServerMain = "http://phcompany/tbpro/";
}
if (/davcompany\/tbpro/.test(self.location.href)) {
	var webServerMain = "http://davcompany/tbpro/";
}
if (/phcompany\/worldtbpro/.test(self.location.href)) {
	var webServerMain = "http://phcompany/worldtbpro/";
}
if (/davcompany\/worldtbpro/.test(self.location.href)) {
	var webServerMain = "http://davcompany/worldtbpro/";
}
tbproApp.filter('propsFilter', function() {
  return function(items, props) {
    var out = [];

    if (angular.isArray(items)) {
      items.forEach(function(item) {
        var itemMatches = false;

        var keys = Object.keys(props);
        for (var i = 0; i < keys.length; i++) {
          var prop = keys[i];
          var text = props[prop].toLowerCase();
          if (item[prop].toString().toLowerCase().indexOf(text) !== -1) {
            itemMatches = true;
            break;
          }
        }

        if (itemMatches) {
          out.push(item);
        }
      });
    } else {
      // Let the output be the input untouched
      out = items;
    }

    return out;
  }
});

//tbproApp.config(function(ngQuickDateDefaultsProvider) {
 // ngQuickDateDefaultsProvider.set('dayAbbreviations', ["Di","Lu", "Ma", "Mer", "Je", "Ve", "Sa"]);
//});

// Filters

tbproApp.filter('nl2br', function(){
	return function(text){
        return text?text.replace(/\n/g, "<br/>"):'';
    };
});
tbproApp.filter('badDateToISO', function() {
  return function(badTime) {
    var goodTime = badTime.replace(/(.+) (.+)/, "$1T$2Z");
    return goodTime;
  };
});
tbproApp.filter('brDateFilter', function() {
    return function(dateSTR) {
        var o = dateSTR.replace(/-/g, "/"); // Replaces hyphens with slashes
        return Date.parse(o + " +0200"); // No TZ subtraction on this sample
    };
});
tbproApp.filter('ucFirst', function() {
    return function(string) {
    	if (string) {
    		return string.substring(0, 1).toUpperCase() + string.substring(1).toLowerCase();
    	} else {return '';}

    };
});
tbproApp.filter('parseUrl', function() {
    var urls = /(\b(https?|ftp):\/\/[A-Z0-9+&@#\/%?=~_|!:,.;-]*[-A-Z0-9+&@#\/%=~_|])/gim;
    var emails = /(\w+@[a-zA-Z_]+?\.[a-zA-Z]{2,6})/gim;

    return function(text) {
        if(text.match(urls)) {
            text = text.replace(urls, "<a target=\"_blank\" href=\"$1\" target=\"_blank\">$1</a>");
        }
        if(text.match(emails)) {
            text = text.replace(emails, "<a target=\"_blank\" href=\"mailto:$1\">$1</a>");
        }
        return text;
    };
});

tbproApp.filter('htmldecode', function() {
	return function decodeHTMLEntities (html) {
		var txt = document.createElement("textarea");
    txt.innerHTML = html;
    return txt.value;
	}
});

var intervalFunc = function () {
  var res = $('#file-upload').val().replace("C:\\fakepath\\", "");
  $('#file-name').html(res);
};
$('#browse-click').on('click', function () { // use .live() for older versions of jQuery
    $('#file-upload').click();
    setInterval(intervalFunc, 2);
    return false;
});


